<?php
/**
 * Plugin Name:       Aardvark Plugin
 * Plugin URI:        http://themeforest.net/user/GhostPool/portfolio?ref=GhostPool
 * Description:		  A required plugin for the Aardvark theme you purchased from ThemeForest. It includes a number of features that you can still use if you switch to another theme.
 * Version:           2.8.2
 * Author:            GhostPool
 * Author URI:        http://ghostpool.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       aardvark-plugin
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Plugin definitions
define( 'GHOSTPOOL_AARDVARK_PLUGIN_VERSION', '2.9' );

if ( ! class_exists( 'GhostPool_Aardvark' ) ) {
	class GhostPool_Aardvark {

		public function __construct() {
		
			register_activation_hook( __FILE__, array( $this, 'activate' ) );
			register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
			add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );	
			add_action( 'init', array( $this, 'load_shortcode_functions' ) );
			add_action( 'vc_before_init', array( $this, 'wpb_functions' ), 9 );	
			add_filter( 'widget_text', 'do_shortcode' );
			add_action( 'init', array( $this, 'add_excerpts_to_pages' ) );
			add_action( 'pre_get_posts', array( $this, 'taxonomy_query' ) );			
			add_filter( 'user_contactmethods', array( $this, 'add_custom_profile_fields' ) );
			add_action( 'init', array( $this, 'load_wpb_options' ) );
			if ( function_exists( 'vc_set_as_theme' ) ) {
				vc_add_shortcode_param( 'gp_divider', 'ghostpool_wpb_divider_field' );
			}
			add_action( 'plugins_loaded', array( $this, 'load_files' ) );
			
		}
						
		public static function activate() {} 		
		
		public static function deactivate() {}

		public function load_textdomain() {
			load_plugin_textdomain( 'aardvark-plugin', false, trailingslashit( WP_LANG_DIR ) . 'plugins/' );
			load_plugin_textdomain( 'aardvark-plugin', false, plugin_basename( dirname( __FILE__ ) ) . '/languages/' );
		}
		
		// Load functions if plugin is activated without theme
		public function load_shortcode_functions() {
							
			if ( ! function_exists( 'ghostpool_option' ) ) {
				function ghostpool_option() {}
			}	
			if ( ! function_exists( 'ghostpool_image_data' ) ) {
				function ghostpool_image_data() {}
			}	
			if ( ! function_exists( 'ghostpool_excerpt' ) ) {
				function ghostpool_excerpt() {}
			}	
			if ( ! function_exists( 'ghostpool_pagination_arrows' ) ) {
				function ghostpool_pagination_arrows() {}
			}
			if ( ! function_exists( 'ghostpool_pagination' ) ) {
				function ghostpool_pagination() {}
			}
			if ( ! function_exists( 'ghostpool_cats' ) ) {
				function ghostpool_cats() {}
			}
			if ( ! function_exists( 'ghostpool_tax' ) ) {
				function ghostpool_tax() {}
			}				
			if ( ! function_exists( 'ghostpool_orderby' ) ) {
				function ghostpool_orderby() {}
			}
			if ( ! function_exists( 'ghostpool_paged' ) ) {
				function ghostpool_paged() {}
			}
			if ( ! function_exists( 'ghostpool_filter' ) ) {
				function ghostpool_filter() {}
			}
			if ( ! function_exists( 'ghostpool_fontawesome_icons' ) ) {
				function ghostpool_fontawesome_icons() {}
			}
			
		}

		public function load_files() {
		
			// Load post submission functions
			require_once( plugin_dir_path( __FILE__ ) . 'inc/class-post-submission.php' );
			require_once( plugin_dir_path( __FILE__ ) . 'inc/class-post-submission-2.php' );	
			
			// Load voting functions
			require_once( plugin_dir_path( __FILE__ ) . 'inc/class-voting.php' );	
			
			// Load share icons
			require_once( plugin_dir_path( __FILE__ ) . 'inc/share-icons.php' );

			// Load shortcodes inline CSS
			require_once( plugin_dir_path( __FILE__ ) . 'inc/shortcodes-inline-css.php' );
			
			// Load sidebars and widgets
			require_once( plugin_dir_path( __FILE__ ) . 'sidebars/sidebars.php' );
		
		}
						
		public function load_wpb_options() {
			if ( function_exists( 'vc_set_as_theme' ) ) {
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/bp-activity.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/bp-groups.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/bp-members.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/bp-profile-search.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/bp-whos-online.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/carousel-posts.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/carousel-images.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/events.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/events-calendar.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/featured-box.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/login-register-form.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/particles.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/pmp-register-form.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/posts.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/post-submission-form.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/post-submission-form-2.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/pricing-column.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/sensei-courses.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/showcase.php' );
				require_once( plugin_dir_path( __FILE__ ) . 'shortcodes/statistics.php' );
			}	
		}
						
		public function add_excerpts_to_pages() {
			add_post_type_support( 'page', 'excerpt' );
		}

		// Display pages in post category and tag queries
		public function taxonomy_query( $query ) {
			if ( ( $query->is_category() OR $query->is_tag() ) && ! is_admin() && $query->is_main_query() ) { 
				$query->set( 'post_type', 'any' );		
			}
		}
			
		// Add user profile fields to Profile backend page
		public function add_custom_profile_fields( $profile_fields ) {
			$profile_fields['twitter'] = esc_html__( 'Twitter URL', 'aardvark-plugin' );
			$profile_fields['facebook'] = esc_html__( 'Facebook URL', 'aardvark-plugin' );
			$profile_fields['googleplus'] = esc_html__( 'Google+ URL', 'aardvark-plugin' );
			$profile_fields['pinterest'] = esc_html__( 'Pinterest URL', 'aardvark-plugin' );
			$profile_fields['youtube'] = esc_html__( 'YouTube URL', 'aardvark-plugin' );
			$profile_fields['vimeo'] = esc_html__( 'Vimeo URL', 'aardvark-plugin' );
			$profile_fields['flickr'] = esc_html__( 'Flickr URL', 'aardvark-plugin' );
			$profile_fields['linkedin'] = esc_html__( 'LinkedIn URL', 'aardvark-plugin' );
			$profile_fields['instagram'] = esc_html__( 'Instagram URL', 'aardvark-plugin' );
			return $profile_fields;
		}
		
		public function wpb_functions() {
			if ( function_exists( 'vc_set_as_theme' ) ) {
				vc_set_shortcodes_templates_dir( dirname( __FILE__ ) . '/shortcodes' );
			}
		}

		public function ghostpool_wpb_divider_field() {
			return '<div class="gp-divider"></div>';
		}
		
	}
}
new GhostPool_Aardvark();

// WP mail function
if ( ! function_exists( 'ghostpool_wp_mail' ) ) {
	function ghostpool_wp_mail( $to = '', $subject = '', $message = '', $headers = '' ) {
		return wp_mail( $to, $subject, $message, $headers );				
	}
}

// User registration emails
$settings = get_option( 'ghostpool_aardvark_settings' );
if ( ! function_exists( 'wp_new_user_notification' ) && ! function_exists( 'bp_is_active' ) && isset( $settings['login_register_popup_redirect'] ) && 'enabled' === $settings['login_register_popup_redirect'] ) {
	function wp_new_user_notification( $user_id, $deprecated = null, $notify = 'both' ) {

		if ( $deprecated !== null ) {
			_deprecated_argument( __FUNCTION__, '4.3.1' );
		}
	
		global $wpdb;
		
		// Get the site name
		$blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
		
		// Get user data
		$user = get_userdata( $user_id );
		$user_login = stripslashes( $user->user_login );
		$user_email = stripslashes( $user->user_email );

		// Admin email
		$to = sanitize_email( apply_filters( 'ghostpool_email_registration_notice_to', get_option( 'admin_email' ) ) );
		do_action( 'wpml_switch_language_for_email', $to );
		$subject = sprintf( apply_filters( 'ghostpool_email_registration_notice_subject', esc_html__( '[%s] New User Registration', 'aardvark-plugin' ), $blogname ), $blogname );
		$message  = sprintf( esc_html__( 'New user registration on your blog %s:', 'aardvark-plugin' ), $blogname ) . "\r\n\r\n";
		$message .= sprintf( esc_html__( 'Username: %s', 'aardvark-plugin' ), $user_login ) . "\r\n\r\n";
		$message .= sprintf( esc_html__( 'Email: %s', 'aardvark-plugin' ), $user_email ) . "\r\n";
		$message = apply_filters( 'ghostpool_email_registration_notice_message', $message, $blogname, $user_login, $user_email );
		$headers[] = apply_filters( 'ghostpool_email_registration_notice_headers', 'From: ' . $blogname . ' <' . get_option( 'admin_email' ) . '>', $blogname );
		@wp_mail( $to, $subject, $message, $headers );
		do_action( 'wpml_restore_language_from_email' );
			
		if ( 'admin' === $notify || empty( $notify ) ) {
			return;
		}
		
		// User email
		$to = sanitize_email( apply_filters( 'ghostpool_email_registered_user_to', $user_email ) );
		do_action( 'wpml_switch_language_for_email', $to );	
		$subject = sprintf( apply_filters( 'ghostpool_registered_user_subject', esc_html__( '[%s] Your username and password', 'aardvark-plugin' ), $blogname ), $blogname );
		$message  = esc_html__( 'Hi there,', 'aardvark-plugin' ) . "\r\n\r\n";
		$message .= sprintf( esc_html__( 'Welcome to %s.', 'aardvark-plugin' ), $blogname ) . "\r\n\r\n";
		$message .= sprintf( esc_html__( 'Username: %s', 'aardvark-plugin' ), $user_login ) . "\r\n";
		$message .= esc_html__( 'Password: [use the password you entered when signing up]', 'aardvark-plugin' ) . "\r\n\r\n";
		$message .= esc_html__( 'Please login at', 'aardvark' ) . ' ' . wp_login_url() . "\r\n\r\n";
		$message = apply_filters( 'ghostpool_registered_user_message', $message, $blogname, $user_login );
		$headers[] = apply_filters( 'ghostpool_registered_user_headers', 'From: ' . $blogname . ' <' . get_option( 'admin_email' ) . '>', $blogname );
		wp_mail( $to, $subject, $message, $headers );
		do_action( 'wpml_restore_language_from_email' );

	}	
}