<?php if ( ! class_exists( 'GhostPool_Post_Submission_2' ) ) {
	class GhostPool_Post_Submission_2 {

		public function __construct() {

			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		
			add_action( 'wp_ajax_ghostpool_post_submission_2_action', array( $this, 'validation' ) );
	
			add_action( 'wp_ajax_nopriv_ghostpool_post_submission_2_action', array( $this, 'validation' ) );
		
		}

		public function enqueue_scripts() {			
			
			global $post;

			if ( ( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'gp_post_submission_form_2' ) ) OR isset( $_GET['post_edit'] ) ) {			
				
				wp_enqueue_script( 'ghostpool-post-submission-2', plugin_dir_url( __FILE__ ) . 'assets/jquery.post-submission-2.js', array( 'jquery' ), GHOSTPOOL_AARDVARK_PLUGIN_VERSION );
			
				wp_enqueue_script( 'plupload' );
			
				wp_localize_script( 'ghostpool-post-submission-2', 'ghostpool_post_submission_2_ajax', array( 
					'ajaxurl' => admin_url( 'admin-ajax.php' ), 
					'nonce' => wp_create_nonce( 'ghostpool_post_submission_2_action' ),
				));
				
			}
			
		}

		public function upload_attachments( $file_handler, $post_id ) {

			if ( $_FILES[$file_handler]['error'] !== UPLOAD_ERR_OK ) {
			
				return false;
	
			} else {	
	
				require_once( ABSPATH . 'wp-admin' . '/includes/image.php' );
				require_once( ABSPATH . 'wp-admin' . '/includes/file.php' );
				require_once( ABSPATH . 'wp-admin' . '/includes/media.php' );

				$overrides = array( 'test_form' => false );
				$attach_id = media_handle_upload( $file_handler, $post_id, array(), $overrides );
						
				if ( ! is_wp_error( $attach_id ) ) {
		
					$pi = pathinfo( $_FILES[$file_handler]['name'] );
					$ext = $pi['extension'];

					// Featured image
					if ( 'yes' === get_post_meta( $post_id, 'ghostpool_featured_image', true ) ) {
						if ( 'jpg' === $ext OR 'JPG' === $ext OR 'jpeg' === $ext OR 'png' === $ext OR 'gif' === $ext ) {
							update_post_meta( $post_id, '_thumbnail_id', $attach_id );	
						}	
					}
									
					// Gallery images
					if ( 'gallery' === get_post_format( $post_id ) ) {
					
						if ( 'jpg' === $ext OR 'JPG' === $ext OR 'jpeg' === $ext OR 'png' === $ext OR 'gif' === $ext ) {
							if ( get_post_meta( $post_id, 'gp_gallery_slider', $attach_id ) ) {
								$prev_attach_id = get_post_meta( $post_id, 'gp_gallery_slider', $attach_id ) . ',';
							} else {
								$prev_attach_id = '';
							}	
							$attach_ids = $prev_attach_id . $attach_id;
							if ( $thumbnail_id ) {
								$attach_ids = str_replace( $thumbnail_id . ',', '', $attach_ids );
							}
							update_post_meta( $post_id, 'gp_gallery_slider', $attach_ids );
						}	
				
					// Audio files
					} elseif ( 'audio' === get_post_format( $post_id ) ) {
					
						if ( 'mp3' === $ext ) {
							update_post_meta( $post_id, 'gp_audio_mp3_url', $attach_id );
						} elseif ( 'ogg' === $ext ) {
							update_post_meta( $post_id, 'gp_audio_ogg_url', $attach_id );
						}
					
					// Video files
					} elseif ( 'video' === get_post_format( $post_id ) ) {		
					
						if ( 'ogg' === $ext ) {
							update_post_meta( $post_id, 'gp_audio_ogg_url', $attach_id );
						} elseif ( 'm4v' === $ext ) {
							update_post_meta( $post_id, 'gp_video_m4v_url', $attach_id );
						} elseif ( 'mp4' === $ext ) {
							update_post_meta( $post_id, 'gp_video_mp4_url', $attach_id );
						} elseif ( 'webm' === $ext ) {
							update_post_meta( $post_id, 'gp_video_webm_url', $attach_id );
						} elseif ( 'ogv' === $ext ) {
							update_post_meta( $post_id, 'gp_video_ogv_url', $attach_id );
						}
					
					}	
				
				}
	
			}	
		}

		public function validation() {
	
			/* REMOVE - nonce not verified for non admin logged in users
			if ( isset( $_POST['nonce'] ) && wp_verify_nonce( $_POST['nonce'], 'ghostpool_post_submission_2_action' ) ) {
			*/

			if ( isset( $_POST['action'] ) && 'ghostpool_post_submission_2_action' === $_POST['action'] ) {
					
				$has_error = '';

				// We're passing the post ID, so the post has already been created.
				if ( isset( $_POST['post_id'] ) ) {
				
					$post_id = $_POST['post_id'];

					// Upload files as attachments 
					if ( ! empty( $_FILES ) ) {
						foreach( $_FILES as $file => $array ) {
							$uploaded_files = $this->upload_attachments( $file, $post_id );
						}
					}
					echo json_encode( array( 'status' => 'success' ) );

				// This is the first call to the server, so we need to create the post.
				} else {

					// Check all required fields are filled in
					
					// Post title
					if ( isset( $_POST['title'] ) && empty( $_POST['title'] ) && 'required' === $_POST['titleRequired'] ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['title'] ) ) {
						$_POST['title'] = esc_html__( 'No title', 'aardvark-plugin' );
					}

					// Post title
					if ( isset( $_POST['featuredImage'] ) && empty( $_POST['featuredImage'] ) && 'required' === $_POST['featuredImageRequired'] ) {
						$has_error = true;
					}
					
					// User's name
					if ( isset( $_POST['name'] ) && empty( $_POST['name'] ) && ! is_user_logged_in() && 'required' === $_POST['nameRequired'] ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['name'] ) ) {
						$_POST['name'] = '';
					}

					// User's email
					if ( isset( $_POST['email'] ) && empty( $_POST['email'] ) && ! is_email( $_POST['email'] ) && ! is_user_logged_in() && 'required' === $_POST['emailRequired']  ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['email'] ) ) {
						$_POST['email'] = '';
					}

					// Categories
					if ( ( ( isset( $_POST['userCats'] ) && empty( $_POST['userCats'] ) ) OR ! isset( $_POST['userCats'] ) ) && 'required' === $_POST['catsRequired'] ) {
						$has_error = true;
					} elseif ( ( isset( $_POST['adminCats'] ) && ! empty( $_POST['adminCats'] ) ) && ( isset( $_POST['userCats'] ) && ! empty( $_POST['userCats'] ) ) )  {
						$user_cats = is_array( $_POST['userCats'] ) ? implode( ',', $_POST['userCats'] ) : $_POST['userCats'];
						$cats = $user_cats . ',' . $_POST['adminCats'];
					} elseif ( isset( $_POST['adminCats'] ) && ! empty( $_POST['adminCats'] )  ) {
						$cats = $_POST['adminCats'];
					} else {
						$user_cats = is_array( $_POST['userCats'] ) ? implode( ',', $_POST['userCats'] ) : $_POST['userCats'];
						$cats = $user_cats;
					}
					if ( $cats ) {
						$cats = explode( ',', $cats );
					}

					// Tags
					if ( ( ( isset( $_POST['userTags'] ) && empty( $_POST['userTags'] ) ) OR ! isset( $_POST['userTags'] ) ) && 'required' === $_POST['tagsRequired'] ) {
						$has_error = true;
					} elseif ( ( isset( $_POST['adminTags'] ) && ! empty( $_POST['adminTags'] ) ) && ( isset( $_POST['userTags'] ) && ! empty( $_POST['userTags'] ) ) )  {					
						$user_tags = is_array( $_POST['userTags'] ) ? implode( ',', $_POST['userTags'] ) : $_POST['userTags'];
						$tags = $user_tags . ',' . $_POST['adminTags'];
					} elseif ( isset( $_POST['adminTags'] ) && ! empty( $_POST['adminTags'] )  ) {
						$tags = $_POST['adminTags'];
					} else {
						$user_tags = is_array( $_POST['userTags'] ) ? implode( ',', $_POST['userTags'] ) : $_POST['userTags'];
						$tags = $user_tags;
					}
					if ( $tags ) {
						$tags = explode( ',', $tags );
					}

					// Post format
					if ( isset( $_POST['userPostFormat'] ) && ! empty( $_POST['userPostFormat'] ) ) {
						$post_format = $_POST['userPostFormat'];
					} elseif ( isset( $_POST['defaultPostFormat'] ) && ! empty( $_POST['defaultPostFormat'] ) ) {
						$post_format = $_POST['defaultPostFormat'];
					} else {
						$post_formats = '0';	
					}
					if ( 'link' === $post_format && isset( $_POST['linkPostFormat'] ) && empty( $_POST['linkPostFormat'] ) ) {
						$has_error = true;
					}
					
					// Content				
					if ( isset( $_POST['content'] ) && empty( $_POST['content'] ) && 'required' === $_POST['contentRequired'] ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['content'] ) ) {
						$_POST['content'] = '';
					}
			
					// Terms of conditions
					if ( ! isset( $_POST['toc'] ) && 'required' === $_POST['tocRequired'] ) {
						$has_error = true;
					}
			
					// GDPR
					if ( ! isset( $_POST['gdpr'] ) && 'required' === $_POST['gdprRequired'] ) {
						$has_error = true;
					}
					
					// Edit post ID
					if ( 'edit' === $_POST['form'] ) {
						$id = $_POST['editID'];
					} else {
						$id = 0;
					}
					
					// Post status				
					if ( 'submission' === $_POST['form'] ) {
						$post_status = $_POST['postSubmissionStatus'];
					} else {
						$post_status = ghostpool_option( 'post_editing_status' );
						if ( 'publish' === $post_status && 'pending' === get_post_status( $id ) ) {
							$post_status = 'pending';
						}
					}
			
					// If all required fields are valid, submit form	
					if ( $has_error == false ) {

						// Create post
						$post_args = array(
							'ID'            => $id,
							'post_type'     => 'post',
							'post_status'   => $post_status,
							'post_title'    => $_POST['title'],
							'post_content'  => $_POST['content'],
							'post_category' => $cats,
							'tags_input'    => $tags,
						);
				
						if ( 'edit' === $_POST['form'] ) {
							wp_update_post( $post_args );
							$new_post_id = $id;
						} else {
							$new_post_id = intval( wp_insert_post( $post_args ) );
						}
						
						// Add featued image field
						if ( isset( $_POST['featuredImage'] ) && 'yes' === $_POST['featuredImage'] ) {
							update_post_meta( $new_post_id, 'ghostpool_featured_image', 'yes' );	
						}
						
						// Add name field
						if ( isset( $_POST['name'] ) && ! is_user_logged_in() ) {
							update_post_meta( $new_post_id, 'ghostpool_post_submission_username', $_POST['name'] );	
						}

						// Add email field
						if ( is_user_logged_in() ) {			
							$author_id = intval( get_post_field( 'post_author', $new_post_id ) );
							$_POST['email'] = get_the_author_meta( 'user_email', $author_id );
						}	
						if ( isset( $_POST['email'] ) ) {
							update_post_meta( $new_post_id, 'ghostpool_post_submission_email', $_POST['email'] );	
						}	
					
						// Set post format
						wp_set_post_terms( $new_post_id, $post_format, 'post_format' );
				
						// Add link field
						if ( isset( $_POST['linkPostFormat'] ) ) {
							update_post_meta( $new_post_id, 'gp_link', $_POST['linkPostFormat'] );
							update_post_meta( $new_post_id, 'gp_link_target', apply_filters( 'ghostpool_post_submission_link_target', '_blank' ) );	
						}
						
						// Add custom field to store submission page ID			
						update_post_meta( $new_post_id, 'ghostpool_post_submission_page_id', $_POST['submissionPageID'] );
												
						// Get the site name
						$blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
		
						// Send emails		
						if ( 'submission' === $_POST['form'] ) {
							
							// Post submission email
							if ( 'enabled' === $_POST['postSubmissionEmailNotification'] ) {
							
								if ( $_POST['name'] != '' ) {
									$author = $_POST['name'];
								} else {
									$author_id = intval( get_post_field( 'post_author', $new_post_id ) );
									$author = get_the_author_meta( 'display_name', $author_id );
								}
								
								$to = sanitize_email( apply_filters( 'ghostpool_email_post_submission_to', ( isset( $_POST['postSubmissionEmailAddress'] ) && $_POST['postSubmissionEmailAddress'] != '' ) ? $_POST['postSubmissionEmailAddress'] : get_option( 'admin_email' ) ) );
								
								do_action( 'wpml_switch_language_for_email', $to );
								
								$subject = isset( $_POST['postSubmissionSubject'] ) ? $_POST['postSubmissionSubject'] : '';
								
								$message = sprintf( esc_html__( 'A post was submitted on %s.', 'aardvark-plugin' ), $blogname ) . "\r\n\r\n";
								$message .= sprintf( esc_html__( 'Title: %s', 'aardvark-plugin' ), sanitize_text_field( $_POST['title'] ) ) . "\n";
								$message .= sprintf( esc_html__( 'Author: %s (%s)', 'aardvark-plugin' ), esc_attr( $author ), sanitize_email( $_POST['email'] ) ) . "\r\n\r\n";
								$message .= sprintf( esc_html__( 'You can view this post at %s', 'aardvark-plugin' ), esc_url( get_permalink( $new_post_id ) ) );
								$message = apply_filters( 'ghostpool_email_post_submission_message', $message, $blogname, $user_login, $author, $new_post_id );

								$headers[] = apply_filters( 'ghostpool_email_post_submission_headers', 'From: ' . $blogname . ' <' . $to . '>', $blogname, $to );
								
								if ( function_exists( 'ghostpool_wp_mail' ) ) { 
									ghostpool_wp_mail( $to, $subject, $message, $headers );
								}
								
								do_action( 'wpml_restore_language_from_email' );
								
							}
							
						} elseif ( 'edit' === $_POST['form'] ) {
						
							// Post editing email
							if ( 'enabled' === ghostpool_option( 'post_editing_email_notification' ) ) {
								
								$to = sanitize_email( apply_filters( 'ghostpool_email_post_editing_to', ( isset( $_POST['postSubmissionEmailAddress'] ) && $_POST['postSubmissionEmailAddress'] != '' ) ? $_POST['postSubmissionEmailAddress'] : get_option( 'admin_email' ) ) );
								
								do_action( 'wpml_switch_language_for_email', $to );
								
								$subject = isset( $_POST['postSubmissionSubject'] ) ? $_POST['postSubmissionSubject'] : '';
								
								$message = sprintf( esc_html__( 'A post was edited on %s.', 'aardvark-plugin' ), $blogname ) . "\r\n\r\n";
								$message .= sprintf( esc_html__( 'Title: %s', 'aardvark-plugin' ), stripslashes( $_POST['title'] ) ) . "\r\n\r\n";
								$message .= sprintf( esc_html__( 'You can view this post at %s', 'aardvark-plugin' ), esc_url( get_permalink( $new_post_id ) ) );
								$message = apply_filters( 'ghostpool_email_post_editing_message', $message, $blogname, $user_login, $new_post_id );
								
								$headers[] = apply_filters( 'ghostpool_email_post_editing_headers', 'From: ' . $blogname . ' <' . $to . '>', $blogname, $to );
								
								if ( function_exists( 'ghostpool_wp_mail' ) ) { 
									ghostpool_wp_mail( $to, $subject, $message, $headers );				
								}
								
								do_action( 'wpml_restore_language_from_email' );	
								 
							}	
		
						}
				
						echo json_encode( array( 'status' => 'success', 'post_id' => $new_post_id ) );

					} else {

						echo json_encode( array( 'status' => 'error', 'post_id' => '' ) );
						
					}
				}
				exit();
			}	
		}		
	} 
}
new GhostPool_Post_Submission_2();