<?php $this->sortform(); ?>

<table class="wp-list-table widefat">
	<thead>
		<tr>
			<th width="100px"><?php esc_html_e('Order', 'bestbug') ?></th>
			<th><?php esc_html_e('Title', 'bestbug') ?></th>
			<th><?php esc_html_e('Slug', 'bestbug') ?></th>
			<th width="150px"><?php esc_html_e('Media Features', 'bestbug') ?></th>
			<th width="150px"><?php esc_html_e('Breakpoint (px)', 'bestbug') ?></th>
            <th width="100px"><?php esc_html_e('Icon', 'bestbug') ?></th>
			<th width="150px"><?php esc_html_e('Action', 'bestbug') ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
			foreach ($this->devices as $id => $device) {
		?>
			<tr>
				<td><strong><?php echo esc_html(get_post_meta($device->ID, 'order', true)) ?></strong></td>
				<td><?php echo esc_html($device->post_title) ?></td>
				<td><?php echo esc_html($device->post_name) ?></td>
				<td><?php echo esc_html(get_post_meta($device->ID, 'mediafeature', true)) ?></td>
				<td><?php echo esc_html(get_post_meta($device->ID, 'breakpoint', true)) ?></td>
				<td>
					<?php
						if(get_post_meta($device->ID, 'use_font_icon', true) == 'yes') {
							echo '<span class="'.esc_attr(get_post_meta($device->ID, 'font_icon', true)).'"></span>';
						} else {
							echo wp_get_attachment_image( get_post_meta($device->ID, 'image_icon', true), array('30', '') );
						}
					?>
				<td>
                    <a class="button success" title="Edit" href="<?php echo admin_url('admin.php?page='.BESTBUG_RPPRO_PAGESLUG_DEVICE_DETAIL.'&ID=' . $device->ID) ?>">
						<span class="dashicons dashicons-edit"></span>
                    </a>

					<form class="bb_delete_form" action="" method="post">
						<input type="hidden" name="delID" id="delID" value="<?php echo esc_html($device->ID) ?>" />
						<button onclick="javascript: return confirm('<?php esc_html_e('Are you sure delete this device?', 'bestbug') ?>');" type="submit" class="button danger">
							<span class="dashicons dashicons-trash"></span></button>
					</form>
					
				</td>
			</tr>
		<?php
			}
		?>
	</tbody>
</table>

<?php $this->sortform(); ?>
