<?php 

// Set order of variables
$key_order = array(
	'font-family',
	'font-backup',
	'font-size',
	'line-height',
	'color',
	'font-weight',
	'subsets',
	'letter-spacing',
	'word-spacing',
	'text-transform',
	'text-align',
	'text-decoration',
);
$new_order = array();
foreach( $key_order as $key ) {
	if ( isset( $default[$key] ) ) {
		$new_order[$key] = $default[$key];
	}
}

if ( isset( $new_order ) ) {

	// Setting title
	$wp_customize->add_setting( 
		$id,
		array(
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);		
	$wp_customize->add_control(
		new GhostPool_Title_Control( 
		$wp_customize,
		$id,
		array(
			'label'      => $title,
			'section'    => $section,
			'settings'   => $id,
			'type'       => 'title',
		) )
	);
	
	$main_id = $id;
				
	// Settings						
	foreach( $new_order as $key => $default_value ) {	
			
		$new_value = isset( $this->value ) ? $this->value : $default_value;					

		if ( 'font-size' === $key ) {

			$wp_customize->add_setting( 
				$id . '[' . $key . '][value]',
				array(
					'default' => $default_value['value'],
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_dimensions',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . '][value]',
				array(
					'label'      => esc_html__( 'Font Size (px)', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . '][value]',
					'type'       => 'text',
				)
			);
			
		} elseif ( 'line-height' === $key ) {
			
			$wp_customize->add_setting( 
				$id . '[' . $key . '][value]',
				array(
					'default' => $default_value['value'],
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_dimensions',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . '][value]',
				array(
					'label'      => esc_html__( 'Line Height (px)', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . '][value]',
					'type'       => 'text',
				)
			);		

		} elseif ( 'font-family' === $key ) {

			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);

			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => esc_html__( 'Font Family', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type'       => 'select',
					'choices'    => ghostpool_google_fonts_array(),
				)
			);
			
		} elseif ( 'font-backup' === $key ) {
				
			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => esc_html__( 'Backup Font', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type'       => 'select',
					'choices'    => ghostpool_backup_fonts_array(),
				)
			);			

		} elseif ( 'font-weight' === $key ) {
		
			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => esc_html__( 'Font Variants', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type'       => 'select',
					'choices'    => ghostpool_google_font_variants_array( ghostpool_option( $setting['id'], 'font-family' ) ),
				)
			);		
		
		} elseif ( 'subsets' === $key ) {

			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => esc_html__( 'Font Subsets', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type'       => 'select',
					'choices'    => ghostpool_google_font_subsets_array( ghostpool_option( $setting['id'], 'font-family' ) ),
				)
			);		
							
		} elseif ( 'color' === $key ) {

			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_colors',
				) 
			);
			$wp_customize->add_control( 
				new WP_Customize_Color_Control( 
					$wp_customize,
					$id . '[' . $key . ']',
					array(
						'label'      => esc_html__( 'Color', 'aardvark' ),
						'description' => $desc,
						'section'    => $section,
						'settings' => $id . '[' . $key . ']',
					)
				) 
			);
			
		} elseif ( 'letter-spacing' === $key ) {

			$wp_customize->add_setting( 
				$id . '[' . $key . '][value]',
				array(
					'default' => $default_value['value'],
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_dimensions',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . '][value]',
				array(
					'label'      => esc_html__( 'Letter Spacing (px)', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . '][value]',
					'type'       => 'text',
				)
			);
			
		} elseif ( 'word-spacing' === $key ) {	
			
			$wp_customize->add_setting( 
				$id . '[' . $key . '][value]',
				array(
					'default' => $default_value['value'],
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_dimensions',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . '][value]',
				array(
					'label'      => esc_html__( 'Word Spacing (px)', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . '][value]',
					'type'       => 'text',
				)
			);
				
		} elseif ( 'text-transform' === $key ) {	
		
			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => esc_html__( 'Text Transform', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type'       => 'select',
					'choices'    => array(
						'none' => esc_html__( 'None', 'aardvark' ),
						'capitalize' => esc_html__( 'Capitalize', 'aardvark' ),
						'uppercase' => esc_html__( 'Uppercase', 'aardvark' ),
						'lowercase' => esc_html__( 'Lowercase', 'aardvark' ),
						'initial' => esc_html__( 'Initial', 'aardvark' ),
						'inherit' => esc_html__( 'Inherit', 'aardvark' ),
					),
				)
			);			
			
		} elseif ( 'text-align' === $key ) {	
		
			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => esc_html__( 'Text Align', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type'       => 'select',
					'choices'    => array(
						'inherit' => esc_html__( 'Inherit', 'aardvark' ),
						'left' => esc_html__( 'Left', 'aardvark' ),
						'right' => esc_html__( 'Right', 'aardvark' ),
						'center' => esc_html__( 'Center', 'aardvark' ),
						'justify' => esc_html__( 'Justify', 'aardvark' ),
						'initial' => esc_html__( 'Initial', 'aardvark' ),
					),
				)
			);		

		} elseif ( 'text-decoration' === $key ) {	
		
			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => esc_html__( 'Text Deocration', 'aardvark' ),
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type'       => 'select',
					'choices'    => array(
						'none' => esc_html__( 'None', 'aardvark' ),
						'inherit' => esc_html__( 'Inherit', 'aardvark' ),
						'underline' => esc_html__( 'Underline', 'aardvark' ),
						'overline' => esc_html__( 'Overline', 'aardvark' ),
						'line-through' => esc_html__( 'Line Through', 'aardvark' ),
						'blink' => esc_html__( 'Blink', 'aardvark' ),
					),
				)
			);	
			
		}			
						
					
	}
	
}