<?php

if ( isset( $default ) ) {

	$count = 1;

	if ( is_array( $default ) ) {
		
		$count = count( $default );

		$wp_customize->add_setting( 
			$id,
			array(
				'capability' => 'edit_theme_options',
				'type' => 'theme_mod',
			)
		);		
		$wp_customize->add_control(
			new GhostPool_Title_Control( 
			$wp_customize,
			$id,
			array(
				'label'      => $title. ' (' . $units . ')',
				'section'    => $section,
				'settings'   => $id,
				'type'       => 'title',
			) )
		);
			
		foreach( $default as $key => $default_value ) {

			if ( $count > 1 ) {
				if ( 'height' === $key ) {
					$title = esc_html__( 'Height', 'aardvark' );
				} elseif ( 'width' === $key ) {
					$title = esc_html__( 'Width', 'aardvark' );
				}
			} else {
				$title = '';
			}
			
			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_dimensions',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => $title,
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type'       => 'text',
				)
			);
			
		}	
		
	}
	
}