<?php  if ( ! function_exists( 'ghostpool_wpb_post_submission_form_2_options' ) ) {
	function ghostpool_wpb_post_submission_form_2_options() {
	
		$post_formats = array();
		if ( current_theme_supports( 'post-formats' ) ) {
			$post_formats = get_theme_support( 'post-formats' );
			$post_format_dropdown_values[ esc_html__( 'Standard', 'aardvark' ) ] = 0;		
			if ( is_array( $post_formats[0] ) ) {
				foreach ( $post_formats[0] as $post_format ) {
					$post_format_dropdown_values[ ucfirst( $post_format ) ] = $post_format;
				}
			}	
		}
		
		vc_map( array( 
			'name' => esc_html__( 'Post Submission Form 2', 'aardvark' ),
			'base' => 'gp_post_submission_form_2',
			'description' => esc_html__( 'Post submission form.', 'aardvark' ),
			'class' => 'wpb_vc_post_submission_form',
			'controls' => 'full',
			'icon' => 'gp-icon-post-submission-form',
			'category' => esc_html__( 'Theme', 'aardvark' ),
			'front_enqueue_css' => array( get_template_directory_uri() . '/lib/framework/page-builder/assets/page-builder.css' ),
			'params' => array( 	

				/*--------------------------------------------------------------
				General tab
				--------------------------------------------------------------*/

				/* Post Title */	
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Post Title', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12',
				),
								
					array(
						'param_name' => 'post_title_field',
						'heading' => esc_html__( 'Field', 'aardvark' ),
						'value' => array(
							esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'enabled',
						'type' => 'dropdown',
					),
					
					array(
						'param_name' => 'post_title_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'post_title_field', 
							'value' => 'enabled',
						),
					),	
					
					array(
						'param_name' => 'post_title_field_placeholder',
						'heading' => esc_html__( 'Field Placeholder', 'aardvark' ),
						'value' => esc_html__( 'Enter title', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'post_title_field', 
							'value' => 'enabled',
						),
					),			
					
					array(
						'param_name' => 'post_title_field_required',
						'heading' => esc_html__( 'Required', 'aardvark' ), 
						'value' => array( '' => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 
							'element' => 'post_title_field', 
							'value' => 'enabled', 
						),
					),	
					
				/* Featured Image */	
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Featured Image', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
								
					array(
						'param_name' => 'featured_image_field',
						'heading' => esc_html__( 'Field', 'aardvark' ),
						'value' => array(
							esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'enabled',
						'type' => 'dropdown',
					),
					
					array(
						'param_name' => 'featured_image_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 'element' => 'featured_image_field', 'value' => 'enabled' ),
					),			
					
					array(
						'param_name' => 'featured_image_field_button_text',
						'heading' => esc_html__( 'Button Text', 'aardvark' ),
						'value' => esc_html__( 'Add image', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 'element' => 'featured_image_field', 'value' => 'enabled' ),
					),		
					
					array(
						'param_name' => 'featured_image_field_required',
						'heading' => esc_html__( 'Required', 'aardvark' ), 
						'value' => array( '' => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'featured_image_field', 'value' => 'enabled' ),
					),	
					
				/* Name */	
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Name', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
								
					array(
						'param_name' => 'name_field',
						'heading' => esc_html__( 'Field', 'aardvark' ),
						'value' => array(
							esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'enabled',
						'type' => 'dropdown',
					),
					
					array(
						'param_name' => 'name_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 'element' => 'name_field', 'value' => 'enabled' ),
					),		
					
					array(
						'param_name' => 'name_field_placeholder',
						'heading' => esc_html__( 'Field Placeholder', 'aardvark' ),
						'value' => esc_html__( 'Name', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'name_field', 
							'value' => 'enabled',
						),
					),				
					
					array(
						'param_name' => 'name_field_required',
						'heading' => esc_html__( 'Required', 'aardvark' ), 
						'value' => array( '' => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'name_field', 'value' => 'enabled' ),
					),	
					
				/* Email */	
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Email', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
								
					array(
						'param_name' => 'email_field',
						'heading' => esc_html__( 'Field', 'aardvark' ),
						'value' => array(
							esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'enabled',
						'type' => 'dropdown',
					),
					
					array(
						'param_name' => 'email_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 'element' => 'email_field', 'value' => 'enabled' ),
					),			
					
					array(
						'param_name' => 'email_field_placeholder',
						'heading' => esc_html__( 'Field Placeholder', 'aardvark' ),
						'value' => esc_html__( 'Email', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'email_field', 
							'value' => 'enabled',
						),
					),	
					
					array(
						'param_name' => 'email_field_title_field_required',
						'heading' => esc_html__( 'Required', 'aardvark' ), 
						'value' => array( '' => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 
							'element' => 'email_field_title', 
							'value' => 'enabled', 
						),
					),	

				/* Categories */	
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Categories', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
				
					array(
						'param_name' => 'cats_field',
						'heading' => esc_html__( 'Field', 'aardvark' ),
						'description' => esc_html__( 'Choose the format in which users can select categories.', 'aardvark' ),
						'value' => array(
							esc_html__( 'Dropdown', 'aardvark' ) => 'dropdown',
							esc_html__( 'Multiple Dropdown', 'aardvark' ) => 'multi_dropdown',
							esc_html__( 'Checkboxes', 'aardvark' ) => 'checkboxes',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'dropdown',
						'type' => 'dropdown',
					),	
					
					array(
						'param_name' => 'cats_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'cats_field', 
							'value' => array( 'dropdown', 'multi_dropdown', 'checkboxes' ),
						),
					),						
					
					array(
						'param_name' => 'cats_field_placeholder',
						'heading' => esc_html__( 'Field Placeholder', 'aardvark' ),
						'value' => esc_html__( 'Select a category', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'cats_field', 
							'value' => array( 'dropdown', 'multi_dropdown', 'checkboxes' ),
						),
					),		
					
					array(
						'param_name' => 'cats_field_required',
						'heading' => esc_html__( 'Required', 'aardvark' ), 
						'value' => array( '' => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 
							'element' => 'cats_field', 
							'value' => array( 'dropdown', 'multi_dropdown', 'checkboxes' ),
						),
					),	
										
					array( 
						'param_name' => 'cats_user_available',
						'heading' => esc_html__( 'Available Categories', 'aardvark' ), 
						'description' => esc_html__( 'Enter the category IDs you want to allow the user to choose from - separate IDs with a comma e.g. 12, 34, 56 (leave empty to show all categories)', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'cats_field', 
							'value' => array( 'dropdown', 'multi_dropdown', 'checkboxes' ),
						),
					),
						
					array( 
						'heading' => esc_html__( 'Automatically Assigned Categories', 'aardvark' ), 
						'description' => esc_html__( 'Enter the category IDs you want to automatically assign the submitted posts to - separate IDs with a comma e.g. 12, 34, 56', 'aardvark' ),
						'param_name' => 'cats_auto',
						'value' => '',
						'type' => 'textfield',
					),
				
				/* Tags */	
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Tags', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
				
					array(
						'param_name' => 'tags_field',
						'heading' => esc_html__( 'Field', 'aardvark' ),
						'description' => esc_html__( 'Choose the format in which users can select tags.', 'aardvark' ),
						'value' => array(
							esc_html__( 'Dropdown', 'aardvark' ) => 'dropdown',
							esc_html__( 'Multiple Dropdown', 'aardvark' ) => 'multi_dropdown',
							esc_html__( 'Checkboxes', 'aardvark' ) => 'checkboxes',
							esc_html__( 'Textbox (Users create their own)', 'aardvark' ) => 'textbox',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'textbox',
						'type' => 'dropdown',
					),	
					
					array(
						'param_name' => 'tags_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'tags_field', 
							'value' => array( 'dropdown', 'multi_dropdown', 'checkboxes', 'textbox' ),
						),
					),								
					
					array(
						'param_name' => 'tags_field_placeholder',
						'heading' => esc_html__( 'Field Placeholder', 'aardvark' ),
						'value' => esc_html__( 'Separate tags with commas', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'tags_field', 
							'value' => array( 'dropdown', 'multi_dropdown', 'checkboxes', 'textbox' ),
						),
					),		
					
					array(
						'param_name' => 'tags_field_required',
						'heading' => esc_html__( 'Required', 'aardvark' ), 
						'value' => array( '' => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 
							'element' => 'tags_field', 
							'value' => array( 'dropdown', 'multi_dropdown', 'checkboxes', 'textbox' ),
						),
					),	
										
					array( 
						'heading' => esc_html__( 'Available Tags', 'aardvark' ), 
						'description' => esc_html__( 'Enter the tag IDs you want to allow the user to choose from - separate IDs with a comma e.g. 12, 34, 56 (leave empty to show all tags)', 'aardvark' ),
						'param_name' => 'tags_user_available',
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'tags_field', 
							'value' => array( 'dropdown', 'multi_dropdown', 'checkboxes' ) 
						),
					),
														
					array( 
						'heading' => esc_html__( 'Automatically Assigned Tags', 'aardvark' ), 
						'description' => esc_html__( 'Enter the tag slugs you want to automatically assign the submitted posts to - separate IDs with a comma e.g. tag-1, tag-2, tag-3', 'aardvark' ),
						'param_name' => 'tags_auto',
						'value' => '',
						'type' => 'textfield',
					),
								
				/* Post Formats */				
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Post Formats', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
					
					array( 
						'param_name' => 'post_format_default',
						'heading' => esc_html__( 'Default Post Format', 'aardvark' ), 
						'description' => esc_html__( 'Select the post format for submitted posts.', 'aardvark' ),
						'value' => $post_format_dropdown_values,
						'std' => '0',
						'type' => 'dropdown',
					),					
					
					array(
						'param_name' => 'post_formats_field',
						'heading' => esc_html__( 'Field', 'aardvark' ), 
						'description' => esc_html__( 'Allow users to select their own post format.', 'aardvark' ),
						'value' => array(
							esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'enabled',
						'type' => 'dropdown',
					),	
					
					array(
						'param_name' => 'post_formats_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),
					
					array(
						'param_name' => 'standard',
						'heading' => esc_html__( 'Available Post Formats', 'aardvark' ), 
						'value' => array( esc_html__( 'Standard', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),
						
					array(
						'param_name' => 'aside',
						'value' => array( esc_html__( 'Aside', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),	
					
					array(
						'param_name' => 'audio',
						'value' => array( esc_html__( 'Audio', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),
					array(
						'param_name' => 'audio_field_button_text',
						'heading' => esc_html__( 'Button Text', 'aardvark' ),
						'value' => esc_html__( 'Add audio', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'post_formats_field', 
							'value' => 'enabled' 
						),
					),	
					
					array(
						'param_name' => 'chat',
						'value' => array( esc_html__( 'Chat', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),
								
					array(
						'param_name' => 'gallery',
						'value' => array( esc_html__( 'Gallery', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),	
					array(
						'param_name' => 'gallery_field_button_text',
						'heading' => esc_html__( 'Button Text', 'aardvark' ),
						'value' => esc_html__( 'Add gallery images', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'post_formats_field', 
							'value' => 'enabled' 
						),
					),	
							
					array(
						'param_name' => 'image',
						'value' => array( esc_html__( 'Image', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),	
								
					array(
						'param_name' => 'link',
						'value' => array( esc_html__( 'Link', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),		
					array(
						'param_name' => 'link_field_placeholder',
						'heading' => esc_html__( 'Field Placeholder', 'aardvark' ),
						'value' => esc_html__( 'Link', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'post_formats_field', 
							'value' => 'enabled' 
						),
					),	
					
					array(
						'param_name' => 'quote',
						'value' => array( esc_html__( 'Quote', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),	
								
					array(
						'param_name' => 'status',
						'value' => array( esc_html__( 'Status', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),		
						
					array(
						'param_name' => 'video',
						'value' => array( esc_html__( 'Video', 'aardvark' ) => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 'element' => 'post_formats_field', 'value' => 'enabled' ),
					),
					array(
						'param_name' => 'video_field_button_text',
						'heading' => esc_html__( 'Button Text', 'aardvark' ),
						'value' => esc_html__( 'Add videos', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'post_formats_field', 
							'value' => 'enabled' 
						),
					),	
						
				
				/* Post Content */					
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Post Content', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
				
					array(
						'param_name' => 'post_content_field',
						'heading' => esc_html__( 'Field', 'aardvark' ),
						'value' => array(
							esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'enabled',
						'type' => 'dropdown',
					),

					array(
						'param_name' => 'post_content_editor',
						'heading' => esc_html__( 'Editor', 'aardvark' ),
						'value' => array(
							esc_html__( 'TinyMCE Advanced Editor', 'aardvark' ) => 'tinymce',
							esc_html__( 'Plain Textarea', 'aardvark' ) => 'textarea',
						),
						'std' => 'tinymce',
						'type' => 'dropdown',						
						'dependency' => array( 
							'element' => 'post_content_field', 
							'value' => 'enabled' 
						),
					),	
										
					array(
						'param_name' => 'post_content_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'post_content_field', 
							'value' => 'enabled' 
						),
					),								
					
					array(
						'param_name' => 'post_content_field_placeholder',
						'heading' => esc_html__( 'Field Placeholder', 'aardvark' ),
						'value' => esc_html__( 'Enter text', 'aardvark' ),
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'post_content_field', 
							'value' => 'enabled' 
						),
					),	
					
					array(
						'param_name' => 'post_content_field_required',
						'heading' => esc_html__( 'Required', 'aardvark' ), 
						'value' => array( '' => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 
							'element' => 'post_content_field', 
							'value' => 'enabled',
						),
					),	
		
				/* Terms of Use */
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Terms Of Use', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),	
									
					array( 
						'param_name' => 'toc_field',
						'heading' => esc_html__( 'Field', 'aardvark' ),
						'description' => esc_html__( 'Add a terms of use checkbox to the form.', 'aardvark' ),
						'value' => array(
							esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'disabled',
						'type' => 'dropdown',
					),	
					
					array(
						'param_name' => 'toc_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'toc_field', 
							'value' => 'enabled', 
						),
					),
					
					array(
						'param_name' => 'toc_field_text',
						'heading' => esc_html__( 'Field Text', 'aardvark' ),
						'description' => esc_html__( 'Add your own privacy policy text next to the checkbox. To add a link within your text use HTML tags e.g. This is my text and this is a <a href="http://domain.com/privacy-policy">link</a>.', 'aardvark' ),
						'value' => '',
						'type' => 'textarea_raw_html',
						'dependency' => array( 
							'element' => 'toc_field', 
							'value' => 'enabled', 
						),
					),	
					
					array(
						'param_name' => 'toc_field_required',
						'heading' => esc_html__( 'Required', 'aardvark' ), 
						'value' => array( '' => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 
							'element' => 'toc_field', 
							'value' => 'enabled', 
						),
					),
		
				/* GDPR */
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Privacy Policy (GDPR)', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
									
					array( 
						'param_name' => 'gdpr_field',
						'heading' => esc_html__( 'Field', 'aardvark' ),
						'description' => esc_html__( 'Add a privacy policy checkbox to the form.', 'aardvark' ),
						'value' => array(
							esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
							esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
						),
						'std' => 'disabled',
						'type' => 'dropdown',
					),	

					array(
						'param_name' => 'gdpr_field_title',
						'heading' => esc_html__( 'Field Title', 'aardvark' ),
						'value' => '',
						'type' => 'textfield',
						'dependency' => array( 
							'element' => 'gdpr_field', 
							'value' => 'enabled', 
						),
					),	
												
					array( 
						'param_name' => 'gdpr_field_text',
						'heading' => esc_html__( 'Field Text', 'aardvark' ), 
						'description' => esc_html__( 'Add your own privacy policy text next to the checkbox. To add a link within your text use HTML tags e.g. This is my text and this is a <a href="http://domain.com/privacy-policy">link</a>.', 'aardvark' ),
						'value' => '',
						'type' => 'textarea_raw_html',
						'dependency' => array( 
							'element' => 'gdpr_field', 
							'value' => 'enabled',
						),
					),	
					
					array(
						'param_name' => 'gdpr_field_required',
						'heading' => esc_html__( 'Required', 'aardvark' ), 
						'value' => array( '' => '1' ),
						'std' => '1',
						'type' => 'checkbox',
						'dependency' => array( 
							'element' => 'gdpr_field', 
							'value' => 'enabled',
						),
					),	

				/* Submit button */
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Submit Button', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
									
					array(
						'param_name' => 'submit_button_text',
						'heading' => esc_html__( 'Button Text', 'aardvark' ),
						'value' => esc_html__( 'Submit Post', 'aardvark' ),
						'type' => 'textfield',
					),		

				/* Other text */
				array( 
					'param_name' => 'header_show',
					'heading' => esc_html__( 'Other Text', 'aardvark' ),
					'type' => 'gp_header',
					'edit_field_class' => 'vc_col-xs-12 gp-wpb-field-border',
				),
								
					array(
						'param_name' => 'required_field_text',
						'heading' => esc_html__( 'Required Field Text', 'aardvark' ),
						'value' => esc_html__( 'This field is required.', 'aardvark' ),
						'type' => 'textfield',
					),	
								
					array(
						'param_name' => 'submit_button_text',
						'heading' => esc_html__( 'Button Text', 'aardvark' ),
						'value' => esc_html__( 'Submit Post', 'aardvark' ),
						'type' => 'textfield',
					),	
								
					array(
						'param_name' => 'login_text',
						'heading' => esc_html__( 'Login Text', 'aardvark' ),
						'description' => esc_html__( 'The text shown if a user cannot submit a post when loggout out.  To add a login link within your text use %LOGIN_LINK% e.g. This is my text and this is a <a href="%LOGIN_LINK%">link</a>.', 'aardvark-plugin' ),
						'value' => esc_html__( 'To login to submit a post please click <a href="%LOGIN_LINK%">here</a>.', 'aardvark-plugin' ),
						'type' => 'textarea_raw_html',
					),	
						
				
				/*--------------------------------------------------------------
				Permissions tab
				--------------------------------------------------------------*/
							
				array( 
					'param_name' => 'visitors_can_post',
					'heading' => esc_html__( 'Vistor Submissions', 'aardvark' ),
					'value' => array(
						esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
						esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
					),
					'type' => 'dropdown',
					'group' => esc_html__( 'Permissions', 'aardvark' ),
				),	
							
				array( 
					'param_name' => 'post_submission_status',
					'heading' => esc_html__( 'Post Submission Status', 'aardvark' ),
					'value' => array(
						esc_html__( 'Posts need to be approved before showing up on the site', 'aardvark' ) => 'pending',
						esc_html__( 'Posts are approved automatically', 'aardvark' ) => 'publish',
					),
					'type' => 'dropdown',
					'group' => esc_html__( 'Permissions', 'aardvark' ),
				),
															
				/*--------------------------------------------------------------
				Email tab
				--------------------------------------------------------------*/
					
				array( 
					'param_name' => 'post_submission_email_notification',
					'heading' => esc_html__( 'Post Submission Email Notification', 'aardvark' ),
					'description' => esc_html__( 'Choose to receive an email notification when a user submits a post.', 'aardvark' ),
					'value' => array(
						esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
						esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
					),
					'type' => 'dropdown',
					'group' => esc_html__( 'Email', 'aardvark' ),
				),
				
				array( 
					'heading' => esc_html__( 'Email Address', 'aardvark' ),
					'param_name' => 'post_submission_email_address',
					'description' => esc_html__( 'The email address the form is sent to (leave blank to use the admin email).', 'aardvark' ),
					'value' => '',
					'type' => 'textfield',	
					'group' => esc_html__( 'Email', 'aardvark' ),
				),
				
				array( 
					'param_name' => 'post_submission_subject',
					'heading' => esc_html__( 'Subject', 'aardvark' ),
					'description' => esc_html__( 'The subject line of the email.', 'aardvark' ),
					'value' => esc_html__( 'Post Submission', 'aardvark-plugin' ),
					'type' => 'textfield',
					'group' => esc_html__( 'Email', 'aardvark' ),
				),
																				
				/*--------------------------------------------------------------
				Design Options tab
				--------------------------------------------------------------*/
													
				array( 
					'heading' => esc_html__( 'Extra Class Name', 'aardvark' ),
					'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'aardvark' ),
					'param_name' => 'classes',
					'value' => '',
					'type' => 'textfield',
					'group' => esc_html__( 'Design Options', 'aardvark' ),
				),									

				array(
					'heading' => esc_html__( 'CSS', 'aardvark' ),
					'type' => 'css_editor',
					'param_name' => 'css',
					'group' => esc_html__( 'Design Options', 'aardvark' ),
				),
																																							
			 )
		 ) );
		 
	}		
} 
add_action( 'vc_before_init', 'ghostpool_wpb_post_submission_form_2_options' );