<?php get_header(); 

/**
 * Get settings
 *
 */
$settings = get_query_var( 'ghostpool_page_settings' );
if ( $settings && is_array( $settings ) ) {
	extract( $settings );
}

// Set header size
if ( bp_is_group_single() OR bp_is_user() ) {
	$header = 'gp-fullwidth-page-header';
}

// Get BP page ID
$bp_pages = get_option( 'bp-pages' );
if (  bp_is_activity_component() ) {
	$post_id = $bp_pages['activity'];
} elseif (  bp_is_members_component() ) {
	$post_id = $bp_pages['members'];
} elseif (  bp_is_groups_component() ) {
	$post_id = $bp_pages['groups'];
} elseif ( bp_is_register_page() ) {
	$post_id = $bp_pages['register'];
} elseif ( bp_is_activation_page() ) {	
	$post_id = $bp_pages['activate'];
} else {
	$post_id = '';
} ?>
		
<div id="gp-buddypress-header">

	<?php ghostpool_page_header( $post_id, $header, $header_bg, $header_height ); ?>
			
	<?php if ( 'gp-minimal-page-header' !== $header ) { ghostpool_page_title( $post_id, $header ); } ?>
	
</div>
		
<div id="gp-content-wrapper" class="gp-container">
	
	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
	
	<div id="gp-inner-container">

		<div id="gp-content">
		
			<?php if ( 'gp-minimal-page-header' === $header ) { ghostpool_page_title( $post_id, $header ); } ?>

			<?php if ( have_posts() ) : while ( have_posts() ) : the_post();
				the_content();
			endwhile;
			endif;?>
					
		</div>
		
		<?php get_sidebar( 'left' ); ?>

		<?php get_sidebar( 'right' ); ?>

	</div>
	
	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
	
	<div class="gp-clear"></div>

</div>

<?php get_footer();