<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'BESTBUG_RPPRO_POSTTYPES' ) ) {
	/**
	 * BESTBUG_RPPRO_POSTTYPES Class
	 *
	 * @since	1.0
	 */
	class BESTBUG_RPPRO_POSTTYPES {


		/**
		 * Constructor
		 *
		 * @return	void
		 * @since	1.0
		 */
		function __construct() {
			//$this->init();
			add_filter( 'bb_register_posttypes', array( $this, 'register_posttypes' ), 10, 1 );
		}

		public function init() {

			if(is_admin()) {
				add_action( 'admin_enqueue_scripts', array( $this, 'adminEnqueueScripts' ) );
			}
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ) );

        }

		public function adminEnqueueScripts() {
		
		}

		public function enqueueScripts() {
		
        }
        
		public function register_posttypes($posttypes) {

			if( empty($posttypes) ) {
				$posttypes = array();
			}

			$labels = array(
				'name'               => _x( 'Devices', 'Devices', 'bestbug' ),
				'singular_name'      => _x( 'Device', 'Device', 'bestbug' ),
				'menu_name'          => __( 'Device', 'bestbug' ),
				'name_admin_bar'     => __( 'Device', 'bestbug' ),
				'parent_item_colon'  => __( 'Parent Menu:', 'bestbug' ),
				'all_items'          => __( 'All Devices', 'bestbug' ),
				'add_new_item'       => __( 'Add New Device', 'bestbug' ),
				'add_new'            => __( 'Add New', 'bestbug' ),
				'new_item'           => __( 'New Device', 'bestbug' ),
				'edit_item'          => __( 'Edit Device', 'bestbug' ),
				'update_item'        => __( 'Update Device', 'bestbug' ),
				'view_item'          => __( 'View Device', 'bestbug' ),
				'search_items'       => __( 'Search Device', 'bestbug' ),
				'not_found'          => __( 'Not found', 'bestbug' ),
				'not_found_in_trash' => __( 'Not found in Trash', 'bestbug' ),
			);
			$args   = array(
				'label'               => __( 'Device', 'bestbug' ),
				'description'         => __( 'Responsive Device', 'bestbug' ),
				'labels'              => $labels,
				'supports'            => array( 'title', 'editor', ),
				'hierarchical'        => false,
				'public'              => false,
				'show_ui'             => false,
				'show_in_menu'        => false,
				// 'menu_position'       => 13,
				'menu_icon'           => 'dashicons-schedule',
				'show_in_admin_bar'   => false,
				'show_in_nav_menus'   => false,
				'can_export'          => true,
				'has_archive'         => false,
				'exclude_from_search' => false,
				'publicly_queryable'  => false,
				'rewrite'             => false,
				'capability_type'     => 'page',
			);
			$posttypes[BESTBUG_RPPRO_POSTTYPE_DEVICE] = $args;
			return $posttypes;
		}
        
    }
	
	new BESTBUG_RPPRO_POSTTYPES();
}

