<?php
			
/**
 * Load widgets
 *
 */
require_once( plugin_dir_path( __FILE__ ) . 'widgets/contact-details.php' );
require_once( plugin_dir_path( __FILE__ ) . 'widgets/login-register-form.php' );
require_once( plugin_dir_path( __FILE__ ) . 'widgets/recent-comments.php' );
require_once( plugin_dir_path( __FILE__ ) . 'widgets/posts.php' );
require_once( plugin_dir_path( __FILE__ ) . 'widgets/popular-posts.php' );
require_once( plugin_dir_path( __FILE__ ) . 'widgets/showcase-posts.php' );

/**
 * Register sidebars
 *
 */
if ( ! function_exists( 'ghostpool_widgets_init' ) ) {
	function ghostpool_widgets_init() {

		// Register custom sidebars
		$sidebars = get_option( 'ghostpool_sidebars' );
		if ( ! empty( $sidebars ) ) {
			foreach( $sidebars as $sidebar ) {
				register_sidebar( $sidebar );
			}
		}

		// Register default sidebars
		register_sidebar( array( 
			'name'          => esc_html__( 'Right Sidebar', 'aardvark-plugin' ),
			'id'            => 'gp-right-sidebar',
			'description'   => esc_html__( 'Displayed on posts, pages and post categories.', 'aardvark-plugin' ),
			'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title widgettitle">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array( 
			'name'          => esc_html__( 'Left Sidebar', 'aardvark-plugin' ),
			'id'            => 'gp-left-sidebar',
			'description'   => esc_html__( 'Displayed on posts, pages and post categories.', 'aardvark-plugin' ),
			'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title widgettitle">',
			'after_title'   => '</h3>',
		) ); 

		register_sidebar( array(
			'name'          => esc_html__( 'Side Menu', 'aardvark-plugin' ),
			'id'            => 'gp-side-menu',
			'description'   => esc_html__( 'Displayed in the side menu.', 'aardvark-plugin' ),
			'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title widgettitle">',
			'after_title'   => '</h3>',
		) );
			
		register_sidebar( array(
			'name'          => esc_html__( 'Footer 1', 'aardvark-plugin' ),
			'id'            => 'gp-footer-1',
			'description'   => esc_html__( 'Displayed as the first column in the footer.', 'aardvark-plugin' ),
			'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title widgettitle">',
			'after_title'   => '</h3>',
		) );        

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 2', 'aardvark-plugin' ),
			'id'            => 'gp-footer-2',
			'description'   => esc_html__( 'Displayed as the second column in the footer.', 'aardvark-plugin' ),
			'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title widgettitle">',
			'after_title'   => '</h3>',
		) );        
	
		register_sidebar( array(
			'name'          => esc_html__( 'Footer 3', 'aardvark-plugin' ),
			'id'            => 'gp-footer-3',
			'description'   => esc_html__( 'Displayed as the third column in the footer.', 'aardvark-plugin' ),
			'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title widgettitle">',
			'after_title'   => '</h3>',
		) );        
	
		register_sidebar( array(
			'name'          => esc_html__( 'Footer 4', 'aardvark-plugin' ),
			'id'            => 'gp-footer-4',
			'description'   => esc_html__( 'Displayed as the fourth column in the footer.', 'aardvark-plugin' ),
			'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title widgettitle">',
			'after_title'   => '</h3>',
		) );      

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 5', 'aardvark-plugin' ),
			'id'            => 'gp-footer-5',
			'description'   => esc_html__( 'Displayed as the fifth column in the footer.', 'aardvark-plugin' ),
			'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title widgettitle">',
			'after_title'   => '</h3>',
		) ); 
			
	}
}
add_action( 'widgets_init', 'ghostpool_widgets_init' );