function ghostpool_vote( postID, type ) {

	var parentContainer = jQuery( '.gp-voting-container' ),
		itemName = 'ghostpool_up_down_voting_' + postID,
		itemType = 'ghostpool_up_down_voting_type_' + postID;

	// Check if the LocalStorage value exists
	if ( ! localStorage.getItem( itemName ) ) {

		// Set HTML5 LocalStorage so the user can not vote again unless he clears it.							   
		localStorage.setItem( itemName, true );
		localStorage.setItem( itemType, type );

		// Data for the Ajax Request
		var data = {
			action: 'ghostpool_add_vote',
			postid: postID,
			type: type,
			nonce: ghostpool_voting.nonce
		};

		jQuery.post( ghostpool_voting.ajaxurl, data, function( response ) {			
			var count = 0;
			if ( type == 1 ) {
				count = parseInt( jQuery( '.gp-voting-up' ).html() ) + 1;
				jQuery( '.gp-voting-up' ).html( count );
				jQuery( '.gp-voting-up' ).addClass( 'gp-voted' );
			} else {
				count = parseInt( jQuery( '.gp-voting-down' ).html() ) + 1;
				jQuery( '.gp-voting-down' ).html( count );
				jQuery( '.gp-voting-down' ).addClass( 'gp-voted' );
			}	
		});
	
	} else {

		// Display message if we detect LocalStorage
		jQuery( '.gp-already-voted' ).fadeIn().css( 'display', 'block' );
	
	}
	
}

jQuery( document ).ready( function( $ ) {

	'use strict';

	// Get all voting containers
	$( '.gp-voting-container' ).each( function( index ) {

		// Get data attribute
		var postID = $( this ).data( 'content-id' ),
			itemName = 'ghostpool_up_down_voting_' + postID,
			itemType = 'ghostpool_up_down_voting_type_' + postID;

		// Check if this content has localstorage
		if ( localStorage.getItem( itemName ) ) {

			if ( localStorage.getItem( itemType ) == 1 ) {
				$( this ).find( '.gp-voting-up' ).addClass( 'gp-voted' );
			}
			if ( localStorage.getItem( itemType ) == 2 ) {
				$( this ).find( '.gp-voting-down' ).addClass( 'gp-voted' );
			}
		}
	
	});
	
});	