<?php if ( is_singular( 'lesson' ) ) {

	// Get course ID
	$course_id = intval( get_post_meta( get_the_ID(), '_lesson_course', true ) );

	?>

	<div class="gp-lesson-details-wrapper gp-course-wrapper">
	
		<div class="gp-lesson-title"><?php esc_html_e( 'Lesson Details', 'aardvark' ); ?></div>
	
		<div class="gp-course-stats">
		
			<?php if ( $course_id > 0 ) { ?>
				<div class="gp-course-stat">
					<div class="gp-course-stat-top"><?php esc_html_e( 'Course', 'aardvark' ); ?></div> 
					<div class="gp-course-stat-bottom gp-link"><a href="<?php echo get_permalink( $course_id ); ?>"><?php echo get_the_title( $course_id ); ?></a></div>
				</div>
			<?php } ?>
						
			<?php if ( get_post_meta( get_the_ID(), '_lesson_length', true ) ) { ?>
				<div class="gp-course-stat">	
					<div class="gp-course-stat-left"><?php esc_html_e( 'Length', 'aardvark' ); ?></div> 
					<div class="gp-course-stat-right"><?php echo esc_attr( get_post_meta( get_the_ID(), '_lesson_length', true ) ); ?> <?php esc_html_e( 'minutes', 'aardvark' ); ?></div>
				</div>
			<?php } ?>
			
			<?php if ( get_post_meta( get_the_ID(), '_lesson_complexity', true ) ) { ?>			
				<div class="gp-course-stat">	
					<div class="gp-course-stat-left"><?php esc_html_e( 'Complexity', 'aardvark' ); ?></div> 
					<div class="gp-course-stat-right">
						<?php if ( get_post_meta( get_the_ID(), '_lesson_complexity', true ) == 'easy' ) {
							esc_html_e( 'Easy', 'aardvark' );
						} elseif ( get_post_meta( get_the_ID(), '_lesson_complexity', true ) == 'std' ) {
							esc_html_e( 'Standard', 'aardvark' );
						} elseif ( get_post_meta( get_the_ID(), '_lesson_complexity', true ) == 'hard' ) {
							esc_html_e( 'Hard', 'aardvark' );
						} ?>	
					</div>
				</div>
			<?php } ?>
			
			<?php 
			
			// Get prev/next lessons
			$lesson_nav = sensei_get_prev_next_lessons( get_the_ID() );
			if ( isset( $lesson_nav['previous'] ) ) {
				$previous_lesson_name = $lesson_nav['previous']['name'];
				$previous_lesson_url = $lesson_nav['previous']['url'];
			} else {
				$previous_lesson_url = '';
			}
			if ( isset( $lesson_nav['next'] ) ) {
				$next_lesson_name = $lesson_nav['next']['name'];
				$next_lesson_url = $lesson_nav['next']['url'];
			} else {
				$next_lesson_url = '';
			}
			
			if ( $previous_lesson_url ) { ?>
				<div class="gp-course-stat">	
					<div class="gp-course-stat-top"><?php esc_html_e( 'Previous Lesson', 'aardvark' ); ?></div> 
					<div class="gp-course-stat-bottom gp-link"><a href="<?php echo esc_url( $previous_lesson_url ); ?>" rel="prev"><?php echo esc_attr( $previous_lesson_name ); ?></a></div>
				</div>
			<?php }
			
			if ( $next_lesson_url ) { ?>
				<div class="gp-course-stat">	
					<div class="gp-course-stat-top"><?php esc_html_e( 'Next Lesson', 'aardvark' ); ?></div> 
					<div class="gp-course-stat-bottom gp-link"><a href="<?php echo esc_url( $next_lesson_url ); ?>" rel="prev"><?php echo esc_attr( $next_lesson_name ); ?></a></div>
				</div>
			<?php } ?>
			

			<?php //do_action( 'sensei_single_lesson_content_inside_before', get_the_ID() ); ?>
			<?php do_action( 'sensei_single_lesson_content_inside_after', get_the_ID() ); ?>
	
		</div>

	</div>

<?php }