<?php 

$mobile_primary_nav = apply_filters( 'ghostpool_mobile_primary_nav', 'gp-mobile-primary-nav' );
$mobile_profile_nav = apply_filters( 'ghostpool_mobile_profile_nav', 'gp-mobile-profile-nav' );

if ( has_nav_menu( $mobile_primary_nav ) OR ( has_nav_menu( $mobile_profile_nav ) && is_user_logged_in() ) ) { ?>
	
	<div id="gp-mobile-nav-bg"></div>
	
	<div id="gp-close-mobile-nav-button"></div>

	<?php if ( has_nav_menu( $mobile_primary_nav ) ) { ?>
		<nav id="gp-mobile-primary-nav" class="gp-mobile-nav">
			<?php wp_nav_menu( array( 'theme_location' => $mobile_primary_nav, 'sort_column' => 'menu_order', 'container' => 'ul', 'menu_id' => 'gp-mobile-primary-menu', 'fallback_cb' => 'null', 'walker' => new Ghostpool_Custom_Menu ) ); ?>
		</nav>
	<?php } ?>

	<?php if ( has_nav_menu( $mobile_profile_nav ) && is_user_logged_in() ) { ?>
		<nav id="gp-mobile-profile-nav" class="gp-mobile-nav">
			<?php wp_nav_menu( array( 'theme_location' => $mobile_profile_nav, 'sort_column' => 'menu_order', 'container' => 'ul','menu_id' => 'gp-mobile-profile-menu', 'menu_class' => 'menu gp-profile-menu', 'fallback_cb' => 'null', 'walker' => new Ghostpool_Custom_Menu ) ); ?>
		</nav>
	<?php } ?>

<?php } ?>