GhostPoolScripts = {

	/*--------------------------------------------------------------
	Resize header upon scrolling
	--------------------------------------------------------------*/

	gpResizeHeader: function() {		
		if ( ! jQuery( 'body' ).hasClass( 'gp-relative-header' ) ) {
			if ( jQuery( window ).width() < 992 && jQuery( 'body' ).hasClass( 'gp-fixed-header-all' ) ) { 
				var mainHeaderHeight = jQuery( '#gp-mobile-header' ).innerHeight();
			} else {
				var mainHeaderHeight = jQuery( '#gp-standard-header' ).innerHeight();
			}	
			var topHeaderHeight = ( jQuery( '#gp-top-header' ).length > 0 ) ? jQuery( '#gp-top-header' ).innerHeight() : 0;
			
			if ( ghostpool_script.scroll_to_fixed_header > topHeaderHeight ) {
				headerHeight = mainHeaderHeight + topHeaderHeight;
			} else {
				headerHeight = mainHeaderHeight;
			}
			jQuery( '#gp-fixed-header-padding' ).height( headerHeight );
		}
	},

	/*--------------------------------------------------------------
	Fixed header upon scrolling
	--------------------------------------------------------------*/
			
	gpScrollingHeaderUpDown: function() {			
		if ( ! jQuery( 'body' ).hasClass( 'gp-relative-header' ) && jQuery( 'body' ).hasClass( 'gp-fixed-scrolling-up-down' ) ) {
			
			if ( jQuery( window ).width() < 992 && jQuery( 'body' ).hasClass( 'gp-fixed-header-all' ) ) { 
				var mainHeaderHeight = jQuery( '#gp-mobile-header' ).innerHeight();
			} else {
				var mainHeaderHeight = jQuery( '#gp-standard-header' ).innerHeight();
			}
				
			var topHeaderHeight = topHeaderHeight = ( jQuery( '#gp-top-header' ).length > 0 ) ? jQuery( '#gp-top-header' ).outerHeight() : 0;
			
			if ( jQuery( document ).scrollTop() <= ( mainHeaderHeight - ghostpool_script.scroll_to_fixed_header ) ) {

				if ( jQuery( document ).scrollTop() > topHeaderHeight ) {
					jQuery( 'body' ).addClass( 'gp-fixed-header' ).removeClass( 'gp-scrolling' );
				} else {
					jQuery( 'body' ).removeClass( 'gp-fixed-header' );
				}
							
				if ( jQuery( window ).width() <= 600 && jQuery( 'body' ).hasClass( 'admin-bar' ) && ( jQuery( document ).scrollTop() <= 46 ) ) {
					jQuery( 'body' ).addClass( 'gp-small-admin-bar' );
				} else {
					jQuery( 'body' ).removeClass( 'gp-small-admin-bar' );
				}

			} else {
			
				if ( jQuery( document ).scrollTop() > topHeaderHeight ) {
					jQuery( 'body' ).removeClass( 'gp-fixed-header' );
				}

				if ( jQuery( document ).scrollTop() >= ghostpool_script.scroll_to_fixed_header ) {
			
					jQuery( 'body' ).addClass( 'gp-scrolling' );
					
				} else {
			
					jQuery( 'body' ).removeClass( 'gp-scrolling' );
				
				}
	
			}
		
		}
	},
	
	gpScrollingHeaderUp: function() {			
		if ( ! jQuery( 'body' ).hasClass( 'gp-relative-header' ) && jQuery( 'body' ).hasClass( 'gp-fixed-scrolling-up' ) ) {

			var previousScroll = 0,
				topHeaderPosition = ( jQuery( '#gp-top-header' ).length > 0 ) ? jQuery( '#gp-top-header' ).offset().top : 0,
				mainHeaderPosition = ( jQuery( window ).width() < 992 ) ? jQuery( '#gp-mobile-header' ).offset().top : jQuery( '#gp-standard-header' ).offset().top;
		
			jQuery( window ).on( 'scroll', function() {

				var currentScroll = jQuery( document ).scrollTop();

				if ( currentScroll > ( mainHeaderPosition + topHeaderPosition ) ) {
					if ( currentScroll > previousScroll ) {
						jQuery( 'body' ).removeClass( 'gp-scrolling' );
					} else if ( ( jQuery( window ).scrollTop() + jQuery( window ).height() ) < ( jQuery( document ).height() - 100 ) ) {
						jQuery( 'body' ).addClass( 'gp-scrolling' );
					}	
				} else {
					jQuery( 'body' ).removeClass( 'gp-scrolling' );
				}
				previousScroll = currentScroll;			

			});

		}	
	},
	
	/*--------------------------------------------------------------
	Logo
	--------------------------------------------------------------*/

	gpLogo: function() {		

		if ( ! jQuery( 'body' ).hasClass( 'gp-header-disabled' ) && jQuery( '.gp-logo img' ).length > 0 && jQuery( '.gp-text-logo' ).length === 0 ) { 

			var logo = jQuery( '.gp-logo-image' ).length > 0 ? jQuery( '.gp-logo-image' ) : '',
				logodata = jQuery( '.gp-logo-image' ).length > 0 ? logo.data() : '';

			if ( jQuery( window ).width() < 992 && jQuery( 'body' ).hasClass( 'gp-scrolling' ) && logodata.mobilescrolling != null ) {

				if ( window.devicePixelRatio >= 2 && logodata.mobilescrollingretina != null ) {
					logo.attr( { 
						src: logodata.mobilescrollingretina,
						width: logodata.mobilescrollingwidth,
						height: logodata.mobilescrollingheight 
					} );
					if ( logodata.mobilescrollingretina == logodata.logo ) {
						logo.show();
					}
				} else if ( logodata.mobilescrolling != null ) {
					logo.attr( { 
						src: logodata.mobilescrolling,
						width: logodata.mobilescrollingwidth,
						height: logodata.mobilescrollingheight 
					} );
					if ( logodata.mobilescrolling == logodata.logo ) {
						logo.show();
					}
				}

			} else if ( jQuery( 'body' ).hasClass( 'gp-scrolling' ) && logodata.scrolling != null ) {

				if ( window.devicePixelRatio >= 2 && logodata.scrollingretina != null ) {
					logo.attr( { 
						src: logodata.scrollingretina,
						width: logodata.scrollingwidth,
						height: logodata.scrollingheight 
					} );
					if ( logodata.scrollingretina == logodata.logo ) {
						logo.show();
					}
				} else if ( logodata.scrolling != null ) {
					logo.attr( { 
						src: logodata.scrolling,
						width: logodata.scrollingwidth,
						height: logodata.scrollingheight 
					} );
					if ( logodata.scrolling == logodata.logo ) {
						logo.show();
					}
				}
		
			} else if ( jQuery( window ).width() < 992 && jQuery( 'body' ).hasClass( 'gp-header-over-content' ) && ! jQuery( 'body' ).hasClass( 'gp-scrolling' ) && logodata.mobileoverlay != null ) {

				if ( window.devicePixelRatio >= 2 && logodata.mobileoverlayretina != null ) {
					logo.attr( { 
						src: logodata.mobileoverlayretina,
						width: logodata.mobileoverlaywidth,
						height: logodata.mobileoverlayheight 
					} );
					if ( logodata.mobileoverlayretina == logodata.logo ) {
						logo.show();
					}
				} else if ( logodata.mobileoverlay != null ) {
					logo.attr( { 
						src: logodata.mobileoverlay,
						width: logodata.mobileoverlaywidth,
						height: logodata.mobileoverlayheight 
					} );
					if ( logodata.mobileoverlay == logodata.logo ) {
						logo.show();
					}
				}

			} else if ( jQuery( 'body' ).hasClass( 'gp-header-over-content' ) && ! jQuery( 'body' ).hasClass( 'gp-scrolling' ) && logodata.overlay != null ) {

				if ( window.devicePixelRatio >= 2 && logodata.overlayretina != null ) {
					logo.attr( { 
						src: logodata.overlayretina,
						width: logodata.overlaywidth,
						height: logodata.overlayheight 
					} );
					if ( logodata.overlayretina == logodata.logo ) {
						logo.show();
					}
				} else if ( logodata.overlay != null ) {
					logo.attr( { 
						src: logodata.overlay,
						width: logodata.overlaywidth,
						height: logodata.overlayheight 
					} );
					if ( logodata.overlay == logodata.logo ) {
						logo.show();
					}
				}

			} else if ( jQuery( window ).width() < 992 && logodata.mobile != null ) {

				if ( window.devicePixelRatio >= 2 && logodata.mobileretina != null ) {
					logo.attr( { 
						src: logodata.mobileretina,
						width: logodata.mobilewidth,
						height: logodata.mobileheight 
					} );
					if ( logodata.mobileretina == logodata.logo ) {
						logo.show();
					}
				} else if ( logodata.mobile != null ) {
					logo.attr( { 
						src: logodata.mobile,
						width: logodata.mobilewidth,
						height: logodata.mobileheight 
					} );
					if ( logodata.mobile == logodata.logo ) {
						logo.show();
					}
				}
		
			} else {

				if ( window.devicePixelRatio >= 2 && logodata.logoretina != null ) {
					logo.attr( { 
						src: logodata.logoretina,
						width: logodata.logowidth,
						height: logodata.logoheight 
					} );
					if ( logodata.logoretina == logodata.logo ) {
						logo.show();
					}
				} else if ( logodata.logo != null ) {
					logo.attr( { 
						src: logodata.logo,
						width: logodata.logowidth,
						height: logodata.logoheight 
					} );
					logo.show(); // Show logo since none is replaced
				}	

			}

			// Only show logo after src replaced
			if ( logo.length > 0 ) {
				logo.on( 'load', function() {
					logo.show();
				});
			}
				
		}				
	},		


	/*--------------------------------------------------------------
	Move left sidebar into right sidebar
	--------------------------------------------------------------*/

	gpMoveSidebars: function() {		
		if ( jQuery( 'body' ).hasClass( 'gp-both-sidebars' ) && jQuery( window ).width() <= 1120 && jQuery( window ).width() >= 768 ) {
			if ( jQuery( 'body' ).hasClass( 'gp-sticky-sidebars' ) && jQuery( 'div' ).hasClass( 'theiaStickySidebar' ) ) {
				jQuery( '#gp-sidebar-left .theiaStickySidebar > *' ).addClass( 'gp-moved-widget' ).prependTo( '#gp-sidebar-right .theiaStickySidebar' );	
			} else {
				jQuery( '#gp-sidebar-left > *' ).addClass( 'gp-moved-widget' ).prependTo( '#gp-sidebar-right' );	
			}
		} else {
			if ( jQuery( 'body' ).hasClass( 'gp-sticky-sidebars' ) && jQuery( 'div' ).hasClass( 'theiaStickySidebar' ) ) {
				jQuery( '.gp-moved-widget' ).prependTo( '#gp-sidebar-left .theiaStickySidebar' );
			} else {
				jQuery( '.gp-moved-widget' ).prependTo( '#gp-sidebar-left' );
			}
		}
	},
		
			
	/*--------------------------------------------------------------
	Hide links if they go outside header
	--------------------------------------------------------------*/

	gpMenuWidths: function() {		

		if ( ghostpool_script.hide_move_primary_menu_links == 'enabled' && jQuery( window ).width() >= 992 ) {
		
			var headerWidth = jQuery( '#gp-standard-header .gp-container' ).outerWidth();
			var headerButtonsWidth = jQuery( '#gp-standard-header .gp-header-buttons' ).outerWidth( true );
			
			if ( jQuery( 'body' ).hasClass( 'gp-header-logo-left-1' ) || jQuery( 'body' ).hasClass( 'gp-header-logo-left-2' ) || jQuery( 'body' ).hasClass( 'gp-header-logo-right-1' ) || jQuery( 'body' ).hasClass( 'gp-header-side-menu' ) ) {
				var logoWidth = jQuery( '#gp-standard-header .gp-logo img' ).outerWidth( true );
			}
			if ( jQuery( 'body' ).hasClass( 'gp-header-logo-left-1' ) || jQuery( 'body' ).hasClass( 'gp-header-logo-left-2' ) || jQuery( 'body' ).hasClass( 'gp-header-logo-right-1' ) || jQuery( 'body' ).hasClass( 'gp-header-side-menu' ) || jQuery( 'body' ).hasClass( 'gp-header-nav-bottom-3' ) ) {
				var secondaryNavWidth = jQuery( '#gp-main-header-secondary-nav' ).outerWidth( true );
			}
				
			var navContainer = jQuery( '#gp-main-header-primary-nav' ),
				navWidth = headerWidth - logoWidth - headerButtonsWidth - secondaryNavWidth,
				linkWidth = 0,
				newNavWidth = 0;

			if ( navContainer.length > 0 ) {
					
				// Reset menu for resize event
				if ( navContainer.find( '.menu-item' ).hasClass( 'gp-more-menu-items' ) ) {
					navContainer.removeAttr( 'style' );
					navContainer.find( '.gp-more-menu-items-icon' ).remove();		
					navContainer.find( '.gp-more-menu-items li' ).removeClass( 'gp-hide-menu' );
					navContainer.find( '.gp-more-menu-items > .sub-menu > li' ).unwrap().addClass( 'gp-remove-menu' );
					navContainer.find( 'li.gp-more-menu-items > li' ).unwrap().removeClass( 'gp-more-menu-items' );
				}
								
				// Go through each visible menu item
				navContainer.find( 'ul' ).first().children( 'li:visible' ).each( function() {
					
					// Get total width of all links in nav
					linkWidth += jQuery( this ).outerWidth( true );
					
					// If link widths total greater than nav width hide current menu item
					if ( linkWidth > navWidth - 90 ) {
						jQuery( this ).addClass( 'gp-hide-menu' );
					} else { // Work out new nav width for just links not hidden
						newNavWidth += jQuery( this ).outerWidth( true );
					}

				});
		
				// Wrap all hidden menu items in dropdown menu
				if ( ! navContainer.find( '.menu-item' ).hasClass( 'gp-more-menu-items' ) ) {
					navContainer.find( '.gp-hide-menu' ).wrapAll( '<li class="menu-item gp-standard-menu menu-item-has-children gp-more-menu-items"><ul class="sub-menu"></ul><li>' );
				}
				
				// Add hidden menu icon
				if ( ! navContainer.find( '.gp-more-menu-items a' ).hasClass( 'gp-more-menu-items-icon' ) ) {
					navContainer.find( '.gp-more-menu-items' ).prepend( '<a href="#" class="gp-more-menu-items-icon"></a>' );
				}
				
				var moreMenuItemsButtonWidth = jQuery( '.gp-more-menu-items-icon' ).outerWidth( true );
	
				// If link widths total greater than nav width set new nav width
				if ( linkWidth > navWidth && moreMenuItemsButtonWidth > 0 ) {
					navContainer.css( 'width', newNavWidth + moreMenuItemsButtonWidth + 40 );
				}
				
				navContainer.css( 'opacity', 1 );
					
			}

		}
		
	},


	/*--------------------------------------------------------------
	Mobile navigation
	--------------------------------------------------------------*/

	gpMobileNav: function() {		

		if ( jQuery( window ).width() < 992 ) {	
			
			// Open primary mobile menu
			jQuery( document ).on( 'click', '.gp-open-mobile-nav-button', function() {
				jQuery( 'body' ).addClass( 'gp-mobile-primary-nav-active' );
				jQuery( window ).scrollTop( 0 );
			});
	
			// Open profile mobile menu
			jQuery( document ).on( 'touchstart click', '.logged-in #gp-mobile-header .gp-profile-button.gp-has-menu .avatar', function( event ) {
				event.preventDefault();
				jQuery( 'body' ).addClass( 'gp-mobile-profile-nav-active' );
				jQuery( window ).scrollTop( 0 );
			});

			// Close all mobile menus	
			jQuery( document ).on( 'click', '#gp-close-mobile-nav-button', function() {
				jQuery( 'body' ).removeClass( 'gp-mobile-primary-nav-active' ).removeClass( 'gp-mobile-profile-nav-active' );
			});	
			
		} else {

			jQuery( 'body' ).removeClass( 'gp-mobile-primary-nav-active gp-mobile-profile-nav-active' );

		}

	},


	/*--------------------------------------------------------------
	Mobile dropdown menus
	--------------------------------------------------------------*/
	
	gpMobileDropdownMenus: function() {		

		jQuery( '.gp-mobile-nav li' ).each( function() {
	
			var navItem = jQuery( this );
	
			if ( jQuery( navItem ).find( 'ul' ).length > 0 ) {	

				// Add dropdown icon
				jQuery( '<i class="gp-mobile-dropdown-icon fa" />' ).insertAfter( jQuery( this ).children( ':first' ) );	
				jQuery( '.gp-megamenu ul .gp-mobile-dropdown-icon' ).remove();
					
				// Toggle dropdown icon and show/hide menus
				jQuery( navItem ).children( '.gp-mobile-dropdown-icon, a[href="#"]' ).on( 'click', function( event ) {
					event.preventDefault();
					if ( jQuery( navItem ).hasClass( 'gp-selected' ) ) {
						jQuery( navItem ).removeClass( 'gp-selected' );
						jQuery( navItem ).children( '.sub-menu' ).stop().hide();		
					} else {
						jQuery( navItem ).addClass( 'gp-selected' );
						jQuery( navItem ).children( '.sub-menu' ).stop().show();
					}
				});
	
				// Keep sub menu open if child link selected
				if ( jQuery( navItem ).find( 'ul li' ).hasClass( 'current-menu-item' ) ) {
					jQuery( navItem ).find( 'ul li' ).parent().stop().show();
					jQuery( navItem ).find( 'ul li' ).parent().parent().addClass( 'gp-selected' );
				}
					
			}
			
		});

	},


	/*--------------------------------------------------------------
	Shift dropdown menu position
	--------------------------------------------------------------*/

	gpShiftDropdownPosition: function() {		

		jQuery( document ).on( 'mouseenter mouseleave', '.gp-nav > .menu > .gp-standard-menu.menu-item-has-children', function(e) {
			if ( jQuery( 'ul', this ).length ) {
				var menu = jQuery( 'ul:first', this ),
					menuOffset = menu.offset(),
					menuLeftOffset = menuOffset.left,
					menuWidth = menu.width(),
					container = jQuery( '#gp-standard-header' ),
					containerOffset = container.offset(),
					containerLeftOffset = containerOffset.left,
					containerWidth = container.width(),
					visible = ( menuLeftOffset + ( menuWidth * 2 ) <= ( containerWidth + containerLeftOffset ) );
				if ( ! visible ) {
					jQuery( this ).addClass( 'gp-nav-shift' );
				} else {
					jQuery( this ).removeClass( 'gp-nav-shift' );
				}
			}
		});

	},
	
	gpShiftProfileDropdownPosition: function() {		

		jQuery( document ).on( 'mouseenter mouseleave', '.gp-profile-button', function(e) {
			var menu = jQuery( this ).find( '#gp-profile-menu' );
			if ( menu.length ) {
				var menuOffset = menu.offset(),
					menuLeftOffset = menuOffset.left,
					menuWidth = menu.width(),
					container = jQuery( '#gp-standard-header' ),
					containerOffset = container.offset(),
					containerLeftOffset = containerOffset.left,
					containerWidth = container.width(),
					visible = ( menuLeftOffset + ( menuWidth * 2 ) <= ( containerWidth + containerLeftOffset ) );
				if ( ! visible ) {
					menu.addClass( 'gp-nav-shift' );
				} else {
					menu.removeClass( 'gp-nav-shift' );
				}
			}
		});

	},


	/*--------------------------------------------------------------
	Click menu link to smooth scroll to container
	--------------------------------------------------------------*/

	gpMenuScroll: function() {		

		// Get heights
		var menuItem = jQuery( '.gp-scroll-to-link a[href*="#"]' ),
			mainHeaderHeight = ( jQuery( window ).width() < 992 ) ? jQuery( '#gp-mobile-header' ).outerHeight() : jQuery( '#gp-standard-header' ).outerHeight(),
			topHeaderHeight = ( jQuery( '#gp-top-header' ).length > 0 ) ? jQuery( '#gp-top-header' ).innerHeight() : 1,
			adminBarHeight = ( jQuery( '#wpadminbar' ).length > 0 ) ? jQuery( '#wpadminbar' ).outerHeight() : 0;
	
		// Get an array of all scroll links IDs
		var scrollItems = menuItem.map( function() {
			var href = jQuery( this ).attr( 'href' ),
				id = href.substring( href.indexOf( '#' ) ),
				item = jQuery( id );
			if ( item.length ) { 
				return item;
			}
		});
		
		// Scroll to container when clicking menu link	
		jQuery( menuItem ).on( 'click touchend', function( event ) {
			event.preventDefault();
			var targetOffset = jQuery( this.hash ).offset() ? jQuery( this.hash ).offset().top : 0;
			if ( jQuery( this ).offset().top > mainHeaderHeight ) {
				jQuery( 'html, body' ).animate({ 
					scrollTop: targetOffset - mainHeaderHeight 
				}, 500 );
			} else {
				jQuery( 'html, body' ).animate( { 
					scrollTop: targetOffset - mainHeaderHeight - topHeaderHeight - adminBarHeight + 1
				}, 500 );
			}
		});

		jQuery( window ).on( 'scroll', function() {

			// Get container scroll position
			var fromTop = jQuery( this ).scrollTop() + mainHeaderHeight + topHeaderHeight;
			
			// Get id of current scroll item
			var cur = scrollItems.map( function() {
				if ( jQuery( this ).offset().top < fromTop ) {
					return this;
				}	
			});

			// Get the id of the current element
			cur = cur[cur.length-1];
			var id = cur && cur.length ? cur[0].id : '';
			
			// Add/remove current item class
			menuItem.parent().removeClass( 'current-menu-item' );
			if ( id ) {
				menuItem.parent().end().filter( '[href*="#' + id + '"]' ).parent().addClass( 'current-menu-item' );
			} else if ( jQuery( this ).scrollTop() <= topHeaderHeight ) {
				menuItem.parent().end().filter( '[href="#home"]' ).parent().addClass( 'current-menu-item' );
			}

		});

	},


	/*--------------------------------------------------------------
	Show/hide side menu
	--------------------------------------------------------------*/

	gpSideMenu: function() {		

		if ( ! jQuery( 'body' ).hasClass( 'gp-header-disabled' ) ) { 

			var globalContainer = jQuery( '#gp-global-wrapper' );	
	
			jQuery( document ).on( 'click', '.bp-suggestions', function() {
				setTimeout( function() {
			
					if ( jQuery( '.gp-posts-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
						GhostPoolScripts.gpPostsMasonry();
					}
					if ( jQuery( '.gp-sensei-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
						GhostPoolScripts.gpSenseiMasonry();
					}
					if ( jQuery( '.gp-bp-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
						GhostPoolBPScripts.gpBPMasonry();
					}		
					if ( jQuery( '.vc_row' ).data( 'vc-full-width' ) ) {
						GhostPoolScripts.gpRowMasonry();
					}
			
				}, 500 );
			});

			if ( jQuery( window ).width() < 992 ) {

				globalContainer.removeClass( 'gp-active-desktop-side-menu' );
				
				setTimeout( function() {
					if ( jQuery( '.vc_row' ).data( 'vc-full-width' ) ) {
						vc_rowBehaviour();
					}
				 }, 500 );
	
				jQuery( document ).on( 'click', '#gp-close-side-menu-button', function() {
					globalContainer.removeClass( 'gp-active-mobile-side-menu gp-active-desktop-side-menu' );
					setTimeout( function() {
				
						if ( jQuery( '.gp-posts-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolScripts.gpPostsMasonry();
						}
						if ( jQuery( '.gp-sensei-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolScripts.gpSenseiMasonry();
						}
						if ( jQuery( '.gp-bp-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolBPScripts.gpBPMasonry();
						}		
						if ( jQuery( '.vc_row' ).hasClass( 'gp-row-masonry' ) ) {
							GhostPoolScripts.gpRowMasonry();
						}
						
						if ( jQuery( '.vc_row' ).data( 'vc-full-width' ) ) {
							vc_rowBehaviour();
						}
			
					}, 500 );
				}); 

				jQuery( document ).on( 'click', '#gp-open-side-menu-button', function() {
					globalContainer.addClass( 'gp-active-mobile-side-menu' ).removeClass( 'gp-active-desktop-side-menu' );
					setTimeout( function() { 
				
						if ( jQuery( '.gp-posts-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolScripts.gpPostsMasonry();
						}
						if ( jQuery( '.gp-sensei-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolScripts.gpSenseiMasonry();
						}
						if ( jQuery( '.gp-bp-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolBPScripts.gpBPMasonry();
						}		
						if ( jQuery( '.vc_row' ).hasClass( 'gp-row-masonry' ) ) {
							GhostPoolScripts.gpRowMasonry();
						}
						
						if ( jQuery( '.vc_row' ).data( 'vc-full-width' ) ) {
							vc_rowBehaviour();
						}

					 }, 500 );
				});

			} else {

				globalContainer.removeClass( 'gp-active-mobile-side-menu' );
				if ( globalContainer.hasClass( 'gp-side-menu-open-default' ) ) {
					globalContainer.addClass( 'gp-active-desktop-side-menu' );
				}
					
				jQuery( document ).on( 'click', '#gp-close-side-menu-button', function() {
					globalContainer.removeClass( 'gp-active-desktop-side-menu gp-active-mobile-side-menu' );
					setTimeout( function() { 
				
						if ( jQuery( '.gp-posts-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolScripts.gpPostsMasonry();
						}
						if ( jQuery( '.gp-sensei-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolScripts.gpSenseiMasonry();
						}
						if ( jQuery( '.gp-bp-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolBPScripts.gpBPMasonry();
						}		
						if ( jQuery( '.vc_row' ).hasClass( 'gp-row-masonry' ) ) {
							GhostPoolScripts.gpRowMasonry();
						}
								
						if ( jQuery( '.vc_row' ).data( 'vc-full-width' ) ) {
							vc_rowBehaviour();
						}

					}, 500 );
				}); 

				jQuery( document ).on( 'click', '#gp-open-side-menu-button', function() {
					globalContainer.addClass( 'gp-active-desktop-side-menu' ).removeClass( 'gp-active-mobile-side-menu' );
					setTimeout( function() {
			
						if ( jQuery( '.gp-posts-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolScripts.gpPostsMasonry();
						}
						if ( jQuery( '.gp-sensei-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolScripts.gpSenseiMasonry();
						}
						if ( jQuery( '.gp-bp-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {
							GhostPoolBPScripts.gpBPMasonry();
						}		
						if ( jQuery( '.vc_row' ).hasClass( 'gp-row-masonry' ) ) {
							GhostPoolScripts.gpRowMasonry();
						}
						
						if ( jQuery( '.vc_row' ).data( 'vc-full-width' ) ) {
							vc_rowBehaviour();
						}

					}, 500 );
				});

			}

		}
	
	},


	/*--------------------------------------------------------------
	Search box
	--------------------------------------------------------------*/	

	gpSearchBox: function() {		

		// Open search box when button clicked
		jQuery( document ).on( 'click', '.gp-search-button:not(.gp-active)', function() {
			jQuery( this ).addClass( 'gp-active' );
			jQuery( '.gp-search-box' ).slideDown(100);
			jQuery( '.gp-search-box input[type="text"]' ).focus();
			jQuery( '#gp-mobile-nav-button.gp-close-nav' ).removeClass( 'gp-close-nav' ).addClass( 'gp-open-nav' );
			jQuery( 'body' ).removeClass( 'gp-mobile-primary-nav-active gp-mobile-profile-nav-active' );
		});			

		// Close search box	when button clicked	
		jQuery( document ).on( 'click', '.gp-search-button.gp-active', function() {
			jQuery( this ).removeClass( 'gp-active' );
			jQuery( '.gp-search-box' ).slideUp(100);
		});

		// Close search box when page clicked
		jQuery( document ).mouseup( function(e) {		
			var container = jQuery( '.gp-search-button, .gp-search-box' );
			if ( ( ! container.is( e.target ) && container.has( e.target ).length === 0 ) && jQuery( '.gp-search-button' ).hasClass( 'gp-active' ) ) {
				jQuery( '.gp-search-box' ).slideUp( 100 );
				jQuery( '.gp-search-button' ).removeClass( 'gp-active' );
			}
		});

	},


	/*--------------------------------------------------------------
	WPBakery full width row RTL support
	--------------------------------------------------------------*/

	/*REMOVED since v4.9 - Fixed by WPB no longer needed?
	gpFullWidthRowRTLSupport: function() {		
		jQuery( document ).on( 'vc-full-width-row', function() {
			if ( jQuery( 'body' ).hasClass( 'rtl' ) ) {
				var elements = jQuery( '[data-vc-full-width="true"]' );
				jQuery.each( elements, function() {
					var jQueryel = jQuery( this );
					jQueryel.css( 'right', jQueryel.css( 'left' ) ).css( 'left', '' );
				});
			}
		});	
	},*/


	/*--------------------------------------------------------------
	Back to top button
	--------------------------------------------------------------*/

	gpBackToTop: function() {		
		if ( ! jQuery( 'body' ).hasClass( 'gp-no-back-to-top' ) ) {	
			jQuery().UItoTop({ 
				containerID: 'gp-to-top',
				text: '<i class="fa fa-chevron-up"></i>',
				scrollSpeed: 600
			});
		}
	},


	/*--------------------------------------------------------------
	Lightbox
	--------------------------------------------------------------*/

	gpLightbox: function() {	
	
		// Add gallery lightbox support
		if ( ghostpool_script.lightbox == 'group_images' ) {
			jQuery( 'a[data-lightbox="gallery"],a.prettyphoto' ).featherlightGallery({
				previousIcon: '',
				nextIcon: ''
			});
		}
		
		// Add image alt text as lightbox caption
		if ( ghostpool_script.lightbox != 'disabled' ) {
			jQuery.featherlightGallery.prototype.afterContent = function() {
				
				var caption = this.$currentTarget.find( 'img' ).attr( 'alt' );
				jQuery( '.featherlight-caption' ).remove();
				jQuery( '<div class="featherlight-caption">' ).text( caption ).appendTo( this.$instance.find( '.featherlight-content' ) );
	
				var img = jQuery( '.featherlight-content img' );
				jQuery( '<img>' ).attr( 'src', jQuery( img ).attr( 'src' ) ).on( 'load', function() {
					var realWidth = this.width;
					jQuery( '.featherlight-content' ).css( 'max-width', realWidth );
        		});
								
			};
			
		}
		
	},
	

	/*--------------------------------------------------------------
	Create featured scroll box
	--------------------------------------------------------------*/

	gpFeaturedScrollBox: function() {		

		jQuery( '.gp-featured-box-wrapper.gp-featured-box-2-1-2' ).each( function() {
	
			var featuredBox = jQuery( this );
			
			if ( jQuery( window ).width() < 768 ) {
	
				if ( featuredBox.find( '.gp-featured-box-scroll' ).length === 0 ) {
					featuredBox.find( '.gp-featured-small-col' ).wrapAll( '<div class="gp-featured-box-scroll" />' );
				}

			} else {

				if ( featuredBox.find( '.gp-featured-box-scroll' ).length > 0 ) {
					jQuery( '.gp-featured-small-col' ).unwrap();
				}
	
			}

		});	

	},
	
	
	/*--------------------------------------------------------------
	Posts masonry
	--------------------------------------------------------------*/

	gpPostsMasonry: function() {		
		if ( jQuery( '.gp-posts-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {

			var container = jQuery( '.gp-posts-masonry .gp-section-loop-inner' ),
				element = container;

			if ( container.find( 'img' ).length === 0 ) {
				element = jQuery( '<img />' );
			}	

			imagesLoaded( element, function( instance ) {

				container.isotope({
					itemSelector: '.gp-post-item',
					masonry: {
						columnWidth: '.gp-post-item',
						gutter: '.gp-gutter-size'
					}
				});

				container.animate( { 'opacity': 1 }, 1300 );
				jQuery( '.gp-pagination' ).animate( { 'opacity': 1 }, 1300 );
				jQuery( '.gp-load-more' ).animate( { 'opacity': 1 }, 1300 );

			});
	
		}
	},
	
	
	/*--------------------------------------------------------------
	Courses/lessons masonry
	--------------------------------------------------------------*/

	gpSenseiMasonry: function() {		
		if ( jQuery( '.gp-sensei-wrapper' ).hasClass( 'gp-posts-masonry' ) ) {

			var container = jQuery( '.gp-posts-masonry' ),
				element = container;

			if ( container.find( 'img' ).length === 0 ) {
				element = jQuery( '<img />' );
			}	

			imagesLoaded( element, function( instance ) {

				container.isotope({
					itemSelector: '.gp-post-item',
					masonry: {
						columnWidth: '.gp-post-item',
						gutter: '.gp-gutter-size'
					}
				});

				container.animate( { 'opacity': 1 }, 1300 );
				jQuery( '.gp-pagination' ).animate( { 'opacity': 1 }, 1300 );
				jQuery( '.gp-load-more' ).animate( { 'opacity': 1 }, 1300 );

			});
		
		}
	},
	
	/*--------------------------------------------------------------
	VC Row masonry
	--------------------------------------------------------------*/

	gpRowMasonry: function() {		
		if ( jQuery( '.vc_row' ).hasClass( 'gp-row-masonry' ) ) {

			var container = jQuery( '.gp-row-masonry' );

			container.isotope({
				itemSelector: '.vc_row.vc_inner',
				masonry: {
					columnWidth: '.vc_row.vc_inner',
					gutter: '.gp-gutter-size'
				}
			});
	
			container.animate( { 'opacity': 1 }, 1300 );
		
		}
	},
		
	
	/*--------------------------------------------------------------
	Load more content
	--------------------------------------------------------------*/

	gpLoadMoreContent: function( containerID, maxNumPages ) {		
	
		var containerID = containerID ? containerID : '.gp-archive-wrapper',
			maxNumPages = maxNumPages ? maxNumPages : ghostpool_script.max_num_pages;
		
		// Get masonry if present
		if ( jQuery( containerID ).hasClass( 'gp-posts-masonry' ) ) {
			var container = jQuery( containerID + ' .gp-section-loop-inner' ),
				element = container;
			if ( container.find( 'img' ).length === 0 ) {
				element = jQuery( '<img />' );
			}
			imagesLoaded( element, function( instance ) {
				container.isotope({
					itemSelector: '.gp-post-item',
					masonry: {
						columnWidth: '.gp-post-item',
						gutter: '.gp-gutter-size'
					}
				});
			});
		}

		jQuery( containerID + ' .gp-section-loop-inner' ).infinitescroll({
			debug: false,
			loading: {
				finishedMsg: '',
				img: ghostpool_script.get_template_directory_uri + '/lib/framework/settings/images/blank.gif',
				msgText: '',
				speed: 'fast',
			},
			nextSelector: containerID + ' ul.page-numbers a',
			navSelector: containerID + ' .gp-pagination',
			itemSelector: containerID + ' section',
			maxPage: maxNumPages,
			extraScrollPx: 0,
			bufferPx: 0
		}, function( newElements, opts ) {
			
			// Hide load more button if reached end
			if ( opts.state.currPage == maxNumPages ) {
				jQuery( containerID + ' .gp-load-more' ).remove();
			}
			
			// Load new masonry elements
			if ( jQuery( containerID ).hasClass( 'gp-posts-masonry' ) ) {
				newElems = jQuery( newElements ).hide();
				newElems.imagesLoaded( function() {
					newElems.fadeIn();
					container.isotope( 'appended', newElems );
				});
			}	
			
			// Load WordPress media players	
			if ( element.find( '.wp-audio-shortcode' ).length > 0 ) {
				element.find( '.wp-audio-shortcode' ).mediaelementplayer({
					alwaysShowControls: true
				});
			}
			if ( element.find( '.wp-video-shortcode' ).length > 0 ) {		
				element.find( '.wp-video-shortcode' ).mediaelementplayer({
					alwaysShowControls: true
				});
			}

			// Load video wrapper
			$( document ).ajaxComplete( function( e, xhr, settings ) {
				GhostPoolScripts.gpVideoIframeWrapper();
			});

			// Load gallery slider
			$( document ).ajaxComplete( function( e, xhr, settings ) {
				GhostPoolScripts.gpLoopGallerySlider();
			});
			
		});
		
		jQuery( containerID + ' .gp-section-loop-inner' ).infinitescroll( 'unbind' );
		jQuery( containerID + ' .gp-load-more-button' ).on( 'click', function() {
			 jQuery( containerID + ' .gp-section-loop-inner' ).infinitescroll( 'retrieve' );
			 return false;
		});	

	},
	

	/*--------------------------------------------------------------
	Add class to iframe parent element
	--------------------------------------------------------------*/

	gpVideoIframeWrapper: function() {		

		jQuery( '.gp-video-wrapper iframe, .gp-video-wrapper .mejs-video' ).each( function() {
			var video = jQuery( this );				
			if (  ! video.hasClass( 'gp-video-wrapped' ) && ! video.hasClass( 'wp-embedded-content' ) ) {
				video.addClass( 'gp-video-wrapped' ).show();	
			}			
			frameWidth = video.width();
			frameHeight = video.attr( 'height' );
			if ( frameWidth > frameHeight ) {
				var paddingBottom = ( frameHeight / frameWidth ) * 100;
			} else {
				paddingBottom = ( frameWidth / frameHeight ) * 100;
			}	
			video.parent().css( { 'padding-bottom': paddingBottom + '%' } );			
		});
	
		if ( ghostpool_script.automatic_video_resizing == 'enabled' ) {
						
			jQuery( 'p > iframe, span > iframe, .course-video iframe, .video iframe' ).each( function() {
		
				var video = jQuery( this );
			
				if (  ! video.hasClass( 'gp-video-wrapped' ) && ! video.hasClass( 'wp-embedded-content' ) ) {
					video.wrap( '<div class="gp-video-wrapper"></div>' ).addClass( 'gp-video-wrapped' );
					jQuery( '.gp-video-wrapper iframe, .gp-video-wrapper .mejs-video' ).show();
				}

				jQuery( document ).ajaxComplete( function( e, xhr, settings ) {
					if ( settings['type'] === 'POST' ) {
						if ( ! video.hasClass( 'gp-video-wrapped' ) && ! video.hasClass( 'wp-embedded-content' ) ) {
							video.wrap( '<div class="gp-video-wrapper"></div>' ).addClass( 'gp-video-wrapped' );
							jQuery( '.gp-video-wrapper iframe, .gp-video-wrapper .mejs-video' ).show();
						}
					}
				});

				frameWidth = video.width();
				frameHeight = video.attr( 'height' );
				if ( frameWidth > frameHeight ) {
					var paddingBottom = ( frameHeight / frameWidth ) * 100;
				} else {
					paddingBottom = ( frameWidth / frameHeight ) * 100;
				}	
				video.parent().css( { 'padding-bottom': paddingBottom + '%' } );
					
			});	

		}
		
	},


	/*--------------------------------------------------------------
	Stop touch swipe issues on iOS
	--------------------------------------------------------------*/

	gpSliderTouchSwipe: function() {		
		jQuery( '.gp-slider' ).on( 'touchmove', function(e) { e.stopPropagation(); });
	},


	/*--------------------------------------------------------------
	Gallery category post slider
	--------------------------------------------------------------*/

	gpLoopGallerySlider: function() {		
		jQuery( '.gp-section-loop .gp-post-format-gallery-slider' ).flexslider( {
			animation: 'fade',
			slideshowSpeed: 9999999,
			animationSpeed: 600,
			directionNav: true,			
			controlNav: false,			
			pauseOnAction: true, 
			pauseOnHover: false,
			prevText: '',
			nextText: ''
		});
	},


	/*--------------------------------------------------------------
	Gallery single post slider
	--------------------------------------------------------------*/

	gpSingleGallerySlider: function() {		
		jQuery( window ).on( 'load', function() {
			jQuery( '.gp-entry-featured .gp-post-format-gallery-slider' ).flexslider( { 
				animation: 'fade',
				slideshowSpeed: 9999999,
				animationSpeed: 600,
				directionNav: true,			
				controlNav: false,			
				pauseOnAction: true, 
				pauseOnHover: false,
				prevText: '',
				nextText: '',
				smoothHeight: true
			});
		});
	},

	/*--------------------------------------------------------------
	Load scripts in WPB tabs
	--------------------------------------------------------------*/

	gpWPBTabsLoadScripts: function() {	
	
		jQuery( '.vc_tta-tab, .vc_tta-panel-title' ).click( function() {
							
			setTimeout( function() {
			   jQuery( window ).trigger( 'resize' );
			}, 0 );
			setTimeout( function() {
			   jQuery( window ).trigger( 'resize' );
			}, 2 );
	
		});
	
	},
	
	/*--------------------------------------------------------------
	Add class to events map
	--------------------------------------------------------------*/

	gpEventsMap: function() {		
		var mapContainer = jQuery( '.single-event .em-location-map-container' ).parent();
		mapContainer.addClass( 'gp-events-map' );		
	},
	

	/*--------------------------------------------------------------
	WooCommerce secondary hover image
	--------------------------------------------------------------*/

	gpWCSecondaryHoverImage: function() {		
		jQuery( '.products .gp-hover-image' ).css( 'opacity', 0 ).hover( function() {
			jQuery( this ).fadeTo( 'fast', 1 );
		}, function() {
			jQuery( this ).fadeTo( 'fast', 0 );
		});
	},
	

	/*--------------------------------------------------------------
	Store PMP registration form fields in localStorage
	--------------------------------------------------------------*/

	gpPMPRegistrationFormLocalStorage: function() {	
		
		jQuery( document ).on( 'click', '.gp-pmp_register-form-wrapper input[type="submit"]', function() {
	
			// Get values from form when clicking submit
			var submitButton = jQuery( this ),
				form = submitButton.parent().parent(),
				username = form.find( 'input[name="username"]' ).val(),
				email = form.find( 'input[name="bemail"]' ).val(),
				confirmEmail = form.find( 'input[name="bconfirmemail"]' ).val(),
				password = form.find( 'input[name="password"]' ).val(),
				confirmPassword = form.find( 'input[name="password2"]' ).val(),
				nonce = form.find( '#ghostpool_pmp_register_form_nonce' ).val();

			// Store form values in HTML5 localStorage				   
			if ( username.length ) {
				localStorage.setItem( 'username', username );		   
			}
			if ( email.length ) {
				localStorage.setItem( 'email', email );	   
			}
			if ( confirmEmail.length ) {
				localStorage.setItem( 'confirmEmail', confirmEmail );	   
			}
			if ( password.length ) {
				localStorage.setItem( 'password', password );	   
			}
			if ( confirmPassword.length ) {
				localStorage.setItem( 'confirmPassword', confirmPassword );
			}
		
		});		
		
		// Add localStorage values to registration page form
		var form = jQuery( '#pmpro_form' );
		if ( form.hasClass( 'pmpro_form' ) ) {
			if ( localStorage.getItem( 'username' ) ) {
				form.find( 'input[name="username"]' ).val( localStorage.getItem( 'username' ) );
				localStorage.removeItem( 'username' );
			}
			if ( localStorage.getItem( 'email' ) ) {
				form.find( 'input[name="bemail"]' ).val( localStorage.getItem( 'email' ) );
				form.find( 'input[name="bconfirmemail"]' ).val( localStorage.getItem( 'email' ) );
				localStorage.removeItem( 'email' );
			}
			if ( localStorage.getItem( 'confirmEmail' ) ) {
				form.find( 'input[name="bconfirmemail"]' ).val( localStorage.getItem( 'confirmEmail' ) );
				localStorage.removeItem( 'confirmEmail' );
			}
			if ( localStorage.getItem( 'password' ) ) {
				form.find( 'input[name="password"]' ).val( localStorage.getItem( 'password' ) );
				form.find( 'input[name="password2"]' ).val( localStorage.getItem( 'password' ) );
				localStorage.removeItem( 'password' );
			}
			if ( localStorage.getItem( 'confirmPassword' ) ) {
				form.find( 'input[name="password2"]' ).val( localStorage.getItem( 'confirmPassword' ) );
				localStorage.removeItem( 'confirmPassword' );
			}
		}
		
			
	},
		
		
	/*--------------------------------------------------------------
	Remove page loader once page has loaded
	--------------------------------------------------------------*/

	gpPageLoader: function() {		
		jQuery( '#gp-page-loader' ).addClass( 'gp-remove-loader' );
	}

};

// Run functions
( function ( jQuery ) {

	'use strict';

	jQuery( document ).on( 'ready', function() {
		GhostPoolScripts.gpResizeHeader();
		GhostPoolScripts.gpScrollingHeaderUpDown();
		GhostPoolScripts.gpLogo();
		GhostPoolScripts.gpMoveSidebars();
		GhostPoolScripts.gpMobileDropdownMenus();
		GhostPoolScripts.gpShiftDropdownPosition();
		GhostPoolScripts.gpShiftProfileDropdownPosition();
		GhostPoolScripts.gpMenuScroll();
		GhostPoolScripts.gpMobileNav();
		GhostPoolScripts.gpSideMenu();
		GhostPoolScripts.gpSearchBox();
		//REMOVEDGhostPoolScripts.gpFullWidthRowRTLSupport();
		GhostPoolScripts.gpBackToTop();
		GhostPoolScripts.gpLightbox();
		GhostPoolScripts.gpFeaturedScrollBox();
		GhostPoolScripts.gpPostsMasonry(); 
		GhostPoolScripts.gpSenseiMasonry();
		GhostPoolScripts.gpRowMasonry();
		GhostPoolScripts.gpLoadMoreContent();
		GhostPoolScripts.gpVideoIframeWrapper();
		GhostPoolScripts.gpSliderTouchSwipe();
		GhostPoolScripts.gpSingleGallerySlider();
		GhostPoolScripts.gpLoopGallerySlider();
		//GhostPoolScripts.gpLoginBox();
		GhostPoolScripts.gpEventsMap();
		GhostPoolScripts.gpWCSecondaryHoverImage();
		GhostPoolScripts.gpPMPRegistrationFormLocalStorage();
		GhostPoolScripts.gpPageLoader();
		GhostPoolScripts.gpScrollingHeaderUp();
		GhostPoolScripts.gpWPBTabsLoadScripts();
	});

	jQuery( window ).on( 'load', function() {
		GhostPoolScripts.gpMenuWidths();
	});
	
	jQuery( window ).on( 'resize', function() {
		GhostPoolScripts.gpResizeHeader();
		GhostPoolScripts.gpScrollingHeaderUpDown();
		GhostPoolScripts.gpLogo();
		GhostPoolScripts.gpMenuWidths();
		GhostPoolScripts.gpMobileNav();
		GhostPoolScripts.gpMoveSidebars();
		GhostPoolScripts.gpSideMenu();
		GhostPoolScripts.gpFeaturedScrollBox();
		GhostPoolScripts.gpLightbox();
		GhostPoolScripts.gpVideoIframeWrapper();
	});

	jQuery( window ).on( 'scroll', function() {
		GhostPoolScripts.gpScrollingHeaderUpDown();
		GhostPoolScripts.gpLogo();
		GhostPoolScripts.gpMobileNav();
	});
	
})( jQuery );