<?php

/**
 * Load custom BuddyPress stylesheet
 *
 */
if ( ! function_exists( 'ghostpool_bp_enqueue_scripts' ) ) {	
	function ghostpool_bp_enqueue_scripts() {
		if ( apply_filters( 'ghostpool_buddypress_main_css', true ) ) {
			wp_enqueue_style( 'ghostpool-buddypress-main', get_template_directory_uri() . '/lib/css/bp-main.css', array(), AARDVARK_THEME_VERSION );
			wp_style_add_data( 'ghostpool-buddypress-main', 'rtl', 'replace' );
		}	
		wp_enqueue_style( 'ghostpool-buddypress-theme', get_template_directory_uri() . '/lib/css/bp-theme.css', array(), AARDVARK_THEME_VERSION );
		wp_style_add_data( 'ghostpool-buddypress-theme', 'rtl', 'replace' );
		wp_enqueue_script( 'ghostpool-buddypress', get_template_directory_uri() . '/lib/scripts/bp.js', array( 'jquery' ), AARDVARK_THEME_VERSION, true );
	}
}
add_action( 'wp_enqueue_scripts', 'ghostpool_bp_enqueue_scripts' );

/**
 * Disable activation redirect
 *
 */
remove_action( 'bp_admin_init', 'bp_do_activation_redirect', 1 );

/**
 * Default active components
 *
 */
if ( function_exists( 'bp_is_active' ) ) {
	function ghostpool_buddypress_defaults() {	
		$default_components = array(
			'activity'      => 1,
			'members'       => 1,
			'groups'		=> 1,
			'settings'      => 1,
			'xprofile'      => 1,
			'notifications' => 1,
		);
		return $default_components;		
	}	
	add_filter( 'bp_new_install_default_components', 'ghostpool_buddypress_defaults' );	
}

/**
 * Default avatar dimensions
 *
 */
if ( ! defined( 'BP_AVATAR_THUMB_WIDTH' ) ) {
	define( 'BP_AVATAR_THUMB_WIDTH', 90 );
}
if ( ! defined( 'BP_AVATAR_THUMB_HEIGHT' ) ) {
	define( 'BP_AVATAR_THUMB_HEIGHT', 90 );
}
if ( ! defined( 'BP_AVATAR_FULL_WIDTH' ) ) {
	define( 'BP_AVATAR_FULL_WIDTH', 210 );
}
if ( ! defined( 'BP_AVATAR_FULL_HEIGHT' ) ) {
	define( 'BP_AVATAR_FULL_HEIGHT', 210 );
}

/**
 * Default cover image dimensions
 *
 */
if ( ! function_exists( 'ghostpool_xprofile_cover_image' ) ) {	
	function ghostpool_xprofile_cover_image( $settings = array() ) {
		$settings['width'] = 1500;
		$settings['height'] = 300;
		return $settings;
	}
}
add_filter( 'bp_before_members_cover_image_settings_parse_args', 'ghostpool_xprofile_cover_image', 10, 1 );
add_filter( 'bp_before_groups_cover_image_settings_parse_args', 'ghostpool_xprofile_cover_image', 10, 1 );

/**
 * Add custom activity stream classes
 *
 */
if ( ! function_exists( 'ghostpool_bp_get_activity_css_class' ) ) {
	function ghostpool_bp_get_activity_css_class( $class ) {
		global $activities_template;
		if ( is_user_logged_in() ) {
			return $activities_template->activity->component . ' ' . $activities_template->activity->type . $class . ' gp-user-can-comment';
		} else {
			return $activities_template->activity->component . ' ' . $activities_template->activity->type . $class;
		}
	}
}
add_filter( 'bp_get_activity_css_class', 'ghostpool_bp_get_activity_css_class', 10, 2 );

/**
 * Remove WordPress SEO title filter from BuddyPress pages
 *
 */
if ( function_exists( 'wpseo_auto_load' ) ) {
	if ( ! function_exists( 'ghostpool_remove_bp_wpseo_title' ) ) {
		function ghostpool_remove_bp_wpseo_title() {
			if ( ! bp_is_blog_page() ) { 
				$front_end = WPSEO_Frontend::get_instance();
				remove_filter( 'pre_get_document_title', array( $front_end, 'title' ), 15 );
			}	
		}
	}
	add_action( 'init', 'ghostpool_remove_bp_wpseo_title' );
}

/**
 * Add shortcode support to Activity WPB element
 *
 */
if ( ! function_exists( 'ghostpool_bp_get_activity_content_body' ) ) {
	function ghostpool_bp_get_activity_content_body( $content ) {
		return do_shortcode( $content );
	}
}
add_filter( 'bp_get_activity_content_body', 'ghostpool_bp_get_activity_content_body' );

/**
 * User online indicator
 *
 */
if ( ! function_exists( 'ghostpool_is_user_online' ) ) {
	function ghostpool_is_user_online( $user_id, $last_active, $time = 5 ) {
		global $wpdb;
		$sql = $wpdb->prepare( "SELECT u.user_login FROM $wpdb->users u JOIN $wpdb->usermeta um ON um.user_id = u.ID WHERE u.ID = %d AND um.meta_key = 'last_activity' AND DATE_ADD( um.meta_value, INTERVAL %d MINUTE ) >= UTC_TIMESTAMP()", $user_id, $time );
		$user_login = $wpdb->get_var( $sql );
		if ( isset( $user_login ) && $user_login != '' ) {
			echo '<div class="gp-user-online"><div class="bp-tooltip" data-bp-tooltip="' . $last_active . '"></div></div>';
		} else {
			echo '<div class="gp-user-offline"><div class="bp-tooltip" data-bp-tooltip="' . $last_active . '"></div></div>';
		}
	}
}

/**
 * Show BuddyPress Docs plugin comments
 *
 */
add_filter( 'bp_docs_allow_comment_section', '__return_true', 100 );

/**
 * Add Posts tab to BuddyPress profile
 *
 */
if ( ! function_exists( 'ghostpool_bp_posts_tab' ) ) {
	function ghostpool_bp_posts_tab() {
	
		if ( 'enabled' === ghostpool_option( 'bp_profile_posts_tab' ) ) {

			global $bp;

			bp_core_new_nav_item( array(
				'name' => esc_html__( 'Posts', 'aardvark' ),
				'slug' => 'my-posts',
				'default_subnav_slug' => 'my-posts',
				'position' => 50,
				'show_for_displayed_user' => true,
				'screen_function' => 'ghostpool_bp_approved_posts_callback',
				'item_css_id' => 'gp-posts'
			) );
	
			$current_user = wp_get_current_user();	
			if ( bp_is_my_profile( $current_user->ID ) ) {	
				
				$parent_url = bp_core_get_user_domain( bp_displayed_user_id() ) . 'my-posts/';

				bp_core_new_subnav_item( array(
					'name' => esc_html__( 'Approved Posts', 'aardvark' ),
					'slug' => 'my-posts',
					'parent_slug' => 'my-posts',
					'parent_url' => $parent_url,
					'position' => 0,
					'user_has_access' => true,
					'screen_function' => 'ghostpool_bp_approved_posts_callback',
					'item_css_id' => 'gp-approved-posts',
				) );
			
				bp_core_new_subnav_item( array(
					'name' => esc_html__( 'Pending Posts', 'aardvark' ),
					'slug' => 'my-pending-posts',
					'parent_slug' => 'my-posts',
					'parent_url' => $parent_url,
					'position' => 0,
					'user_has_access' => true,
					'screen_function' => 'ghostpool_bp_pending_posts_callback',
					'item_css_id' => 'gp-pending-posts',
				) );
			}
						
		}
						
	}
}
add_action( 'bp_setup_nav', 'ghostpool_bp_posts_tab', 99 );

function ghostpool_bp_approved_posts_callback() {
    add_action( 'bp_template_content', 'bp_approved_posts_tab_content' );
    bp_core_load_template( apply_filters( 'bp_core_template_plugin', 'members/single/plugins' ) );
}
function bp_approved_posts_tab_content() {
	get_template_part( 'buddypress/theme/bp-approved-posts-tab' );
}

function ghostpool_bp_pending_posts_callback() {
    add_action( 'bp_template_content', 'bp_pending_posts_tab_content' );
    bp_core_load_template( apply_filters( 'bp_core_template_plugin', 'members/single/plugins' ) );
}
function bp_pending_posts_tab_content() {
	get_template_part( 'buddypress/theme/bp-pending-posts-tab' );
}

/**
 * BuddyPress theme CSS for Youzer
 *
 */
if ( function_exists( 'yz_is_activity_component' ) ) {
	add_filter( 'ghostpool_bbpress_css', '__return_false' );
	add_filter( 'ghostpool_buddypress_main_css', '__return_false' );
	add_filter( 'ghostpool_woocommerce_css', 'yzc_disable_woocommerce_css' );
	function yzc_disable_woocommerce_css( $active ) {
		if ( function_exists( 'yz_is_woocommerce_tab' ) && yz_is_woocommerce_tab() ) {
			return false;
		}
		return $active;
	}
}

/**
 * Add Youzer support to Activity element
 *
 */
function ghostpool_load_yz_for_activity_element( $active ) {

	global $post;
    
    if ( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'gp_activity' ) ) {
    	$active = true;
	}
		
    return $active;

}
add_filter( 'yz_is_activity_component', 'ghostpool_load_yz_for_activity_element' );

/**
 * Disable BuddyPress theme CSS on Activity element page
 *
 */
function ghostpool_disable_buddypress_activity_main_css( $active ) {

	if ( function_exists( 'yz_is_activity_component' ) ) {

		global $post;

		if ( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'gp_activity' ) ) {
			$active = false;
		}
		
	}	
		
	return $active;
	
}
add_filter( 'ghostpool_buddypress_main_css', 'ghostpool_disable_buddypress_activity_main_css' );

/**
 * Disable Youzer template on Registration/Activation page when Youzer Membership System disabled
 *
 */
function ghostpool_disable_youzer_page( $enable_page ) {
	$options = get_option( 'youzer_options' );
	if ( 'on' !== $options['yz_activate_membership_system'] && ( bp_is_register_page() OR bp_is_activation_page() ) ) {
		$enable_page = false;
	}	
	return $enable_page;	
}	
add_filter( 'yz_enable_youzer_page', 'ghostpool_disable_youzer_page', 10, 1 );

/**
 * Load BuddyPress theme CSS on Registration/Activation page when Youzer Membership System disabled
 *
 */
if ( ! function_exists( 'ghostpool_enqueue_bp_css_on_reg_page' ) ) {	
	function ghostpool_enqueue_bp_css_on_reg_page() {
		if ( ( function_exists( 'yz_is_membership_system_active' ) && false === yz_is_membership_system_active() ) && ( bp_is_register_page() OR bp_is_activation_page() ) ) {		
			wp_enqueue_style( 'ghostpool-buddypress-main', get_template_directory_uri() . '/lib/css/bp-main.css', array(), AARDVARK_THEME_VERSION );
			wp_style_add_data( 'ghostpool-buddypress-main', 'rtl', 'replace' );		
		}
	}
}
add_action( 'wp_enqueue_scripts', 'ghostpool_enqueue_bp_css_on_reg_page' );

/**
 * Load default BuddyPress CSS on Registration/Activation page when Youzer Membership System disabled
 *
 */
function ghostpool_deregister_default_bp_css( $deregister ) {
	if ( ( function_exists( 'yz_is_membership_system_active' ) && false === yz_is_membership_system_active() ) && ( bp_is_register_page() OR bp_is_activation_page() ) ) {
		$deregister = false;
	}
	return $deregister;
}
add_filter( 'yz_deregister_bp_styles', 'ghostpool_deregister_default_bp_css', 10, 1 );

/**
 * Youzer Popup Login link
 *
 */
if ( ! function_exists( 'ghostpool_yz_popup_login_link' ) ) {
	function ghostpool_yz_popup_login_link() {
		if ( function_exists( 'yz_is_membership_system_active' ) && yz_is_membership_system_active() && ! empty( logy_page_id( 'login' ) ) && logy_is_login_popup_active() ) {
			return ' data-show-youzer-login="true"';
		}	
	}
} 
add_filter( 'ghostpool_profile_button_classes', 'ghostpool_yz_popup_login_link' );