<?php 

/**
 * Get settings
 *
 */
$settings = get_query_var( 'ghostpool_loop_settings' );
if ( $settings &&  is_array( $settings ) ) {
	extract( $settings );
} else {
	$settings = get_query_var( 'ghostpool_page_settings' );
	if ( $settings && is_array( $settings ) ) {
		extract( $settings );
	}
}

// Use standard post ID if none specified
if ( ! isset( $post_id ) ) {
	$post_id = get_the_ID();
}

// Get image IDs
$image_ids = '';
if ( is_array( get_post_meta( get_the_ID(), 'gp_gallery_slider', true ) ) ) {
	$value = implode( ',', get_post_meta( get_the_ID(), 'gp_gallery_slider', true ) );	
	$image_ids = array_filter( explode( ',', $value ) );
}

if ( $image_ids ) {

	if ( 'gp-posts-list' === $format ) {
		$width = ' style="width: ' . absint( $image['width'] ) . 'px;"';
	} else {
		$width = '';
	}	
		
	$output = '';
	
	$output .= '<div class="gp-post-format-gallery-slider gp-slider"' . $width . '> 

		 <ul class="slides">';
	
			foreach ( $image_ids as $image_id ) { 
			
				$image_url = wp_get_attachment_image_src( $image_id, $image['name'] );
				$image['url'] = $image_url[0];
				
				if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true) ) { 
					$alt_text = esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ); 
				} else { 
					$alt_text = the_title_attribute( 'echo=0' ); 
				}
		
				$output .= '<li>';
					if ( $image['url'] ) {
						$output .= '<img src="' . esc_url( $image['url'] ) . '" width="' . absint( $image['width'] ) . '" height="' . absint( $image['height'] ) . '" alt="' . $alt_text . '" />';
					}
				$output .= '</li>';
		
			}
	
		$output .= '</ul>

	</div>';
			
	echo $output;

}