<?php

// Get image IDs
if ( is_array( get_post_meta( get_the_ID(), 'gp_gallery_slider', true ) ) ) {
	$value = implode( ',', get_post_meta( get_the_ID(), 'gp_gallery_slider', true ) );
}
$image_ids = array_filter( explode( ',', $value ) );	

if ( $image_ids ) { ?>

	<div class="gp-post-format-gallery-slider gp-slider"> 
						
		 <ul class="slides">
			<?php foreach ( $image_ids as $image_id ) { ?>
				<li>
				
					<?php 
					
					$image = ghostpool_image_data( ghostpool_option( 'post_image_size' ) );
					$image_url = wp_get_attachment_image_src( $image_id, $image['name'] );
					$image['url'] = $image_url[0];
					
					if ( $image['url'] ) {
					
						$attachment_id = get_post( $image_id );
						
						?>
						
						<img src="<?php echo esc_url( $image['url'] ); ?>" width="<?php echo absint( $image['width'] ); ?>" height="<?php echo absint( $image['height'] ); ?>" alt="<?php if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true) ) { echo esc_attr( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ); } else { the_title_attribute(); } ?>" />
					
						<?php if ( $attachment_id->post_excerpt ) { ?>
							<div class="wp-caption-text"><?php echo esc_attr( $attachment_id->post_excerpt ); ?></div>
						<?php }
						
					} ?>	
					
				</li>
			<?php } ?>
		</ul>
		
	 </div>
	
<?php }