<?php

// Hide featured item if current page
global $wp_query;
if ( isset( $wp_query->post->ID ) && $wp_query->post->ID === get_the_ID() ) {
	return;
}

/**
 * Get settings
 *
 */
$settings = get_query_var( 'ghostpool_loop_settings' );
if ( $settings && is_array( $settings ) ) {
	extract( $settings );
} else {
	$settings = get_query_var( 'ghostpool_page_settings' );
	if ( $settings && is_array( $settings ) ) {
		extract( $settings );
	}
}

// Video class
if ( get_post_format() == 'video' && ! has_post_thumbnail() ) {
	$video_class = ' gp-has-video';
} else {
	$video_class = '';
}

?>

<a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'gp_link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo esc_attr( get_post_meta( get_the_ID(), 'gp_link_target', true ) ); ?>"<?php } ?> class="gp-featured-box-link<?php if ( $video_class ) { echo esc_attr( $video_class ); } ?>">
	
	<?php if ( has_post_thumbnail() ) { 
	
		if ( $format == 'gp-featured-box-2-2-2-2' ) { 
		
			$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'gp_featured_box_small_image' );
		
		} elseif ( $format == 'gp-featured-box-2-1-2' OR $format == 'gp-featured-box-1-2-2' ) { 

			if ( $counter % 5 == 1 ) {
				$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'gp_featured_box_large_image' );
			} else {
				$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'gp_featured_box_small_image' );
			} 
		
		} elseif ( $format == 'gp-featured-box-1-1' ) { 

			$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'gp_featured_box_large_image' );

		} elseif ( $format == 'gp-featured-box-1' ) { 

			$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'gp_featured_box_full_image' );
		
		} else { 
		
			$image = '';
		
		} ?>
		
		 <?php if ( $image ) { ?>
		 	<span class="gp-featured-box-image" style="background-image: url(<?php echo esc_url( $image[0] ); ?>);"></span>
		<?php } ?>
		
	<?php } elseif ( get_post_format() == 'video' ) { ?>
			
		<span class="gp-featured-box-video">
			<?php get_template_part( 'lib/sections/taxonomies/loop-video' ); ?>
		</span>
	
	<?php } ?>	
		 				
</a>

<?php if ( $title == 'enabled' OR $excerpt_length > 0 ) { ?>

	<div class="gp-featured-caption">
	
		<div class="gp-featured-caption-inner">

			<?php if ( $meta_cats == '1' ) { ?>
				<div class="gp-featured-box-cats"><?php echo ghostpool_exclude_cats( get_the_ID(), true, true ); ?></div>
			<?php } ?>

			<?php if ( $title == 'enabled' ) {
				$featured_caption_title = get_the_title();
				if ( $title_length > 0 && ( strlen( $featured_caption_title ) > $title_length ) ) { 
					$featured_caption_title = mb_substr( $featured_caption_title, 0, (int) $title_length ) . '...';
				} ?>	
				<h3 class="gp-featured-caption-title"><?php echo esc_attr( $featured_caption_title ); ?></h3>	
			<?php } ?>
	
			<?php if ( $excerpt_length > 0 ) { ?>
				<div class="gp-featured-caption-text"><?php echo ghostpool_excerpt( $settings ); ?></div>	
			<?php } ?>	
		
			<?php if ( $meta_author == '1' OR $meta_date == '1' OR $meta_comment_count == '1' OR $meta_views == '1' OR $meta_likes == '1' ) { ?>

				<div class="gp-loop-meta">

					<?php if ( $meta_author == '1' ) { ?>
						<span class="gp-post-meta gp-meta-author"><?php echo ghostpool_author_name( get_the_ID() ); ?></span>
					<?php } ?>

					<?php if ( $meta_date == '1' ) { ?>
						<time class="gp-post-meta gp-meta-date" datetime="<?php echo get_the_date( 'c' ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time>
					<?php } ?>

					<?php if ( $meta_comment_count == '1' ) { ?>
						<span class="gp-post-meta gp-meta-comments"><?php comments_popup_link( esc_html__( 'No Comments', 'aardvark' ), esc_html__( '1 Comment', 'aardvark' ), esc_html__( '% Comments', 'aardvark' ), 'comments-link', esc_html__( 'Comments Closed', 'aardvark' ) ); ?></span>
					<?php } ?>

					<?php if ( function_exists( 'wpp_get_views' ) && $meta_views == '1' ) { ?>
						<span class="gp-post-meta gp-meta-views"><?php if ( function_exists( 'wpp_get_views' ) ) { echo wpp_get_views( get_the_ID() ); } ?> <?php esc_html_e( 'views', 'aardvark' ); ?></span>
					<?php } ?>

					<?php if ( $meta_likes == '1' ) { ?>
						<span class="gp-post-meta gp-meta-likes"><?php if ( function_exists( 'ghostpool_voting_show_up_votes' ) ) { echo ghostpool_voting_show_up_votes(); } ?></span>
					<?php } ?>
				
				</div>

			<?php } ?>
		
		</div>
			
	</div>

<?php }