<?php

$key_order = array(
	'background-color',
	'background-image',
	'background-repeat',
	'background-size',
	'background-attachment',
	'background-position',
	'background-clip',
	'background-origin',
);

$new_order = array();
foreach( $key_order as $key ) {
	if ( isset( $default[$key] ) ) {
		$new_order[$key] = $default[$key];
	}
}

if ( isset( $new_order ) ) {

	// Setting title
	$wp_customize->add_setting( 
		$id,
		array(
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);		
	$wp_customize->add_control(
		new GhostPool_Title_Control( 
		$wp_customize,
		$id,
		array(
			'label'      => $title,
			'section'    => $section,
			'settings'   => $id,
			'type'       => 'title',
		) )
	);
	
	// Settings
	foreach( $new_order as $k => $v ) {	
	
		if ( 'background-color' === $k ) {
		
			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_colors',
				) 
			);
			$wp_customize->add_control( 
				new WP_Customize_Color_Control( 
					$wp_customize,
					$id . '[' . $k . ']',
					array(
						'label'      => esc_html__( 'Background Color', 'aardvark' ),
						'description' => $desc,
						'section'    => $section,
						'settings' => $id . '[' . $k . ']',
					)
				) 
			);

		} elseif ( 'background-image' === $k ) {
		
			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_url_id',
				) 
			);
			$wp_customize->add_control( 
				new WP_Customize_Image_Control( 
					$wp_customize,
					$id . '[' . $k . ']',
					array(
						'label'      => esc_html__( 'Background Image', 'aardvark' ),
						'description' => $desc,
						'section'    => $section,
						'settings' => $id . '[' . $k . ']',
					)
				) 
			);

		} elseif ( 'background-repeat' === $k ) {
	
			$wp_customize->add_setting(
				$id . '[' . $k . ']',
				array(
					'default' => $v,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				) 
			);
			$wp_customize->add_control( 
				$id . '[' . $k . ']',
				array(
					'label'      => esc_html__( 'Background Repeat', 'aardvark' ),
					'description' => $desc,
					'section'   => $section,
					'type'       => 'select',
					'settings' => $id . '[' . $k . ']',
					'choices'    => array(
						'no-repeat' => esc_html__( 'No Repeat', 'aardvark' ),
						'repeat'    => esc_html__( 'Repeat All', 'aardvark' ),
						'repeat-x'  => esc_html__( 'Repeat Horizontally', 'aardvark' ),
						'repeat-y'  => esc_html__( 'Repeat Vertically', 'aardvark' ),
						'inherit'   => esc_html__( 'Inherit', 'aardvark' ),
					),
				) 
			);

		} elseif ( 'background-size' === $k ) {

			$wp_customize->add_setting(
				$id . '[' . $k . ']',
				array(
					'default' => $v,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				) 
			);
			$wp_customize->add_control( 
				$id . '[' . $k . ']',
				array(
					'label'      => esc_html__( 'Background Size', 'aardvark' ),
					'description' => $desc,
					'section'   => $section,
					'type'       => 'select',
					'settings' => $id . '[' . $k . ']',
					'choices'    => array(
						'inherit' => esc_html__( 'Inherit', 'aardvark' ),
						'cover'   => esc_html__( 'Cover', 'aardvark' ),
						'contain' => esc_html__( 'Contain', 'aardvark' ),
					),
				) 
			);

		} elseif ( 'background-attachment' === $k ) {

			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
			$wp_customize->add_control( 
				$id . '[' . $k . ']',
				array(
					'label'      => esc_html__( 'Background Attachment', 'aardvark' ),
					'description' => $desc,
					'section'   => $section,
					'type'       => 'select',
					'settings' => $id . '[' . $k . ']',
					'choices' => array(
						'fixed'   => esc_html__( 'Fixed', 'aardvark' ),
						'scroll'  => esc_html__( 'Scroll', 'aardvark' ),
						'inherit' => esc_html__( 'Inherit', 'aardvark' ),
					),
				)
			);

		} elseif ( 'background-position' === $k ) {

			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
			$wp_customize->add_control(
				$id . '[' . $k . ']',
				array(
				'label'      => esc_html__( 'Background Position', 'aardvark' ),
				'description' => $desc,
				'section'    => $section,
				'type'       => 'select',
				'settings' => $id . '[' . $k . ']',
				'choices'    => array(
					'left top'      => esc_html__( 'Left Top', 'aardvark' ),
					'left center'   => esc_html__( 'Left center', 'aardvark' ),
					'left bottom'   => esc_html__( 'Left Bottom', 'aardvark' ),
					'center top'    => esc_html__( 'Center Top', 'aardvark' ),
					'center center' => esc_html__( 'Center Center', 'aardvark' ),
					'center bottom' => esc_html__( 'Center Bottom', 'aardvark' ),
					'right top'     => esc_html__( 'Right Top', 'aardvark' ),
					'right center'  => esc_html__( 'Right Center', 'aardvark' ),
					'right bottom'  => esc_html__( 'Right Bottom', 'aardvark' ),
				),
			) );

		} elseif ( 'background-clip' === $k ) {

			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
			$wp_customize->add_control(
				$id . '[' . $k . ']',
				array(
				'label'      => esc_html__( 'Background Clip', 'aardvark' ),
				'description' => $desc,
				'section'    => $section,
				'type'       => 'select',
				'settings' => $id . '[' . $k . ']',
				'choices'    => array(
					'inherit'     => esc_html__( 'Inherit', 'aardvark' ),
					'border-box'  => esc_html__( 'Border Box', 'aardvark' ),
					'content-box' => esc_html__( 'Content Box', 'aardvark' ),
					'padding-box' => esc_html__( 'Padding Box', 'aardvark' ),
				),
			) );

		} elseif ( 'background-origin' === $k ) {
		
			$wp_customize->add_setting( 
				$id . '[' . $k . ']', 
				array(
					'default' => $v,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				)
			);
			$wp_customize->add_control(
				$id . '[' . $k . ']',
				array(
				'label'      => esc_html__( 'Background Origin', 'aardvark' ),
				'description' => $desc,
				'section'    => $section,
				'type'       => 'select',
				'settings' => $id . '[' . $k . ']',
				'choices'    => array(
					'inherit'     => esc_html__( 'Inherit', 'aardvark' ),
					'border-box'  => esc_html__( 'Border Box', 'aardvark' ),
					'content-box' => esc_html__( 'Content Box', 'aardvark' ),
					'padding-box' => esc_html__( 'Padding Box', 'aardvark' ),
				),
			) );
		}	
		
	}
	
}