<?php 

/**
 * Theme data
 *
 */
define( 'AARDVARK_THEME_VERSION', '4.22' );
define( 'AARDVARK_PLUGIN_VERSION', '2.8.2' );
define( 'WPB_PLUGIN_VERSION', '6.2.0' );
define( 'RESPONSIVE_WPB_VERSION', '3.2.9' );
define( 'LAYERSLIDER_VERSION', '6.11.1' );
define( 'THEIA_STICKY_VERSION', '1.8.0' );
define( 'ULTIMATE_REVIEWER_VERSION', '2.5.4.1' );
define( 'YOUZER_VERSION', '2.5.0' );
define( 'SENSEI_CERTIFICATES', '1.1.1' );

if ( ! function_exists( 'ghostpool_framework_data' ) ) {
	function ghostpool_framework_data() {
		$data = array(
			'settings_class' => 'GhostPool_Settings',
			'theme_slug' => 'aardvark',
			'page_slug' => 'aardvark-theme-settings',
			'parent_page_slug' => 'aardvark-theme-setup',
			'option_name' => 'ghostpool_aardvark_settings',
			'page_title' => esc_html__( 'Theme Options', 'aardvark' ),
			'the_version' => AARDVARK_THEME_VERSION,
			'directory_path' => get_theme_file_path( '/lib/framework/' ),
			'directory_uri' => get_template_directory_uri() . '/lib/framework/',
			'font_uri' => get_template_directory_uri() . '/lib/fonts/',
		);
		return $data;
	}		
}

/**
 * Load framework files
 *
 */

// Load settings files
require_once( get_theme_file_path( '/lib/framework/settings/class-settings.php' ) );
 
// Load inc files
require_once( get_theme_file_path( '/lib/framework/inc/class-inc.php' ) );

// Load theme setup files
require_once( get_theme_file_path( '/lib/framework/theme-setup/class-theme-setup.php' ) );

// Load custom sidebars files
require_once( get_theme_file_path( '/lib/framework/custom-sidebars/class-custom-sidebars.php' ) );

// Load WPBakery page builder files
if ( function_exists( 'vc_set_as_theme' ) ) {
	require_once( get_theme_file_path( '/lib/framework/page-builder/class-page-builder.php' ) );
}

/**
 * Try to get file content using WP File system API
 *
 */
if ( ! function_exists( 'ghostpool_fs_get_contents' ) ) {
	function ghostpool_fs_get_contents( $file_path ) {

		// Frontend or customizer fallback
		if ( ! function_exists( 'get_filesystem_method' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		
		$allow_relaxed_file_ownership = true;
		$context = '';

		if ( function_exists( 'get_filesystem_method' ) && get_filesystem_method( array(), $context, $allow_relaxed_file_ownership ) === 'direct' ) {
		
			// You can safely run request_filesystem_credentials() without any issues and don't need to worry about passing in a URL
			$creds = request_filesystem_credentials( site_url() . '/wp-admin/', '', false, $context, null, $allow_relaxed_file_ownership );

			// Initialize API
			if ( ! WP_Filesystem( $creds, $context, $allow_relaxed_file_ownership ) ) {
				return false;
			}

			global $wp_filesystem;

			// Do our file manipulations below
			return $wp_filesystem->get_contents( $file_path );

		} else {
		
			return false;
			
		}
	}
}