<?php
/*
Custom sidebars
http://marquex.es/698/custom-sidebars-1-0
1.1
*/
if ( ! class_exists( 'GhostPool_Custom_Sidebars' ) ) {
	class GhostPool_Custom_Sidebars {
	
		var $message = '';
		var $message_class = '';
		var $option_name = 'ghostpool_sidebars';
		var $sidebar_prefix = 'gp-cs-';
		var $cap_required = 'switch_themes';
		var $ignore_post_types = array( 'attachment', 'revision', 'nav_menu_item', 'pt-widget' );
		var $options = array();
	
		function get_custom_sidebars() {
			$sidebars = get_option( $this->option_name );
			if ( $sidebars ) {
				return $sidebars;
			}	
			return array();
		}
	
		function register_custom_sidebars() {
			$sidebars = $this->get_custom_sidebars();
			if ( ! empty( $sidebars ) ) {
				foreach( $sidebars as $sidebar ) {
					register_sidebar( $sidebar );
				}
			}
		}

		function addSubMenus() {
			$page = add_submenu_page( 
				'aardvark-theme-setup',
				esc_html__( 'Custom Sidebars', 'aardvark' ), 
				esc_html__( 'Custom Sidebars', 'aardvark' ), 
				$this->cap_required, 
				'aardvark-custom-sidebars', 
				array( $this, 'createPage' ) 
			);
			add_action( 'admin_print_scripts-' . $page, array( $this, 'addScripts' ) );
		}
	
		function addScripts() {
			wp_enqueue_script( 'post' );
		}
			
		function createPage() {
		
			if ( ! empty( $_POST ) ) {
				if ( isset( $_POST['create-sidebars'] ) ) {
					check_admin_referer( 'ghostpool_new_sidebars_action' );
					$this->create_sidebar();
				} elseif ( isset( $_POST['update-sidebar'] ) ) {
					check_admin_referer( 'ghostpool_edit_sidebar_action' );
					$this->edit_sidebar();
				} elseif ( isset( $_POST['reset-sidebars'] ) ) {
					$this->reset_sidebars();
				}
			} elseif ( ! empty( $_GET['delete'] ) ) {
				$this->delete_sidebar();			
			} elseif ( ! empty( $_GET['p'] ) ) {
				if ( $_GET['p'] == 'edit' && ! empty( $_GET['id'] ) ) {
					$custom_sidebars = $this->get_custom_sidebars();
					if ( ! $sidebar = $this->get_sidebar( $_GET['id'], $custom_sidebars ) ) {
						return new WP_Error( 'ghostpool_cant_delete', esc_html__( 'You do not have permission to delete sidebars.', 'aardvark' ) );
					}	
					include( get_theme_file_path( '/lib/framework/custom-sidebars/edit.php' ) );
					return;	
				}
			}
		
			$custom_sidebars = $this->get_custom_sidebars();
			$post_types = $this->getPostTypes();
			$delete_nonce = wp_create_nonce( 'ghostpool_delete_sidebars_action' );

			// Form
			if ( ! empty( $_GET['p'] ) ) {
				if ( $_GET['p'] == 'edit' ) {
					include( get_theme_file_path( '/lib/framework/custom-sidebars/edit.php' ) );
				} else {
					include( get_theme_file_path( '/lib/framework/custom-sidebars/settings.php' ) );	
				}
			} else {	
				include( get_theme_file_path( '/lib/framework/custom-sidebars/settings.php' ) );		
			}
			
		}
	
		function create_sidebar() {
			$name = trim( $_POST['sidebar_name'] );
			$description = trim( $_POST['sidebar_description'] );
			if ( empty( $name ) OR empty( $description ) ) {
				$this->setError( esc_html__( 'You have to fill all the fields to create a new sidebar.', 'aardvark' ) );
			} else {
				$id = $this->sidebar_prefix . sanitize_html_class( sanitize_title_with_dashes( $name ) );
				$sidebars = get_option( $this->option_name, FALSE );
				if ( $sidebars !== FALSE ) {
					$sidebars = $sidebars;
					if ( ! $this->get_sidebar( $id, $sidebars )  ) {
						
						// Create a new sidebar
						$sidebars[] = array( 
							'name' => $name,
							'id' => $id,
							'description' => $description,
							'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widget-title">',
							'after_title'   => '</h3>',
							 ) ;
						
						//update option
						update_option( $this->option_name, $sidebars );
						
						$this->refresh_sidebars();
					
						$this->setMessage( esc_html__( 'The sidebar has been created successfully.', 'aardvark' ) );
					
					} else {
						$this->setError( esc_html__( 'There is already a sidebar registered with that name, please choose a different one.', 'aardvark' ) );
					}
					
				} else {
				
					$id = $this->sidebar_prefix . sanitize_html_class( sanitize_title_with_dashes( $name ) );
					$sidebars = array( array( 
						'name' => $name,
						'id' => $id,
						'description' => $description,
						'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
						'after_widget'  => '</div>',
						'before_title'  => '<h3 class="widget-title">',
						'after_title'   => '</h3>',	
					) );
					add_option( $this->option_name, $sidebars );

					$this->refresh_sidebars();
				
					$this->setMessage( esc_html__( 'The sidebar has been created successfully.', 'aardvark' ) );					
				}
			}
		}
	
		function edit_sidebar() {
		
			$id = trim( $_POST['sidebar_id'] );
			$name = trim( $_POST['sidebar_name'] );
			$description = trim( $_POST['sidebar_description'] );
			$sidebars = $this->get_custom_sidebars();
		
			// Check the id		
			$url = parse_url( $_POST['_wp_http_referer'] );
			if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			} else {
				if ( isset( $url['query'] ) ) {
					parse_str( $url['query'], $args );
					if ( $args['id'] != $id ) {
						return new WP_Error( esc_html__( 'The operation is not secure and it cannot be completed.', 'aardvark' ) );
					}	
				} else {
					return new WP_Error( esc_html__( 'The operation is not secure and it cannot be completed.', 'aardvark' ) );
				}
			}
		
			$newsidebars = array();
			foreach( $sidebars as $sidebar ) {
				if ( $sidebar['id'] != $id ) {
					$newsidebars[] = $sidebar;
				} else {
					$newsidebars[] = array( 
						'name' => $name,
						'id' => $id,
						'description' => $description,
						'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
						'after_widget'  => '</div>',
						'before_title'  => '<h3 class="widget-title">',
						'after_title'   => '</h3>',	
					);
				}			 
			}
		
			// Update option
			update_option( $this->option_name, $newsidebars );
			$this->refresh_sidebars();
		
			$this->setMessage( sprintf( esc_html__( 'The sidebar "%s" has been updated successfully.', 'aardvark' ), $id ) );
		}

		function delete_sidebar() {
		
			if ( ! current_user_can( $this->cap_required ) ) {
				return new WP_Error( 'ghostpool_cant_delete', esc_html__( 'You do not have permission to delete sidebars.', 'aardvark' ) );
				if ( ! defined( 'DOING_AJAX' ) && ! DOING_AJAX && ! wp_verify_nonce( $_REQUEST['_n'], 'ghostpool_delete_sidebars_action' ) ) {
					die( 'Security check stop your request.' ); 
				}
			}	
		
			$newsidebars = array();
			$deleted = FALSE;
		
			$sidebars = $this->get_custom_sidebars();
		
			if ( ! empty( $sidebars ) ) {		
				foreach( $sidebars as $sidebar ) {
					if ( $sidebar['id']!=$_REQUEST['delete'] ) {
						$newsidebars[] = $sidebar;
					} else {
						$deleted = TRUE;
					}	
				}
			}
		
			update_option( $this->option_name, $newsidebars );

			$this->refresh_sidebars();
		
			if ( $deleted ) {
				$this->setMessage( sprintf( esc_html__( 'The sidebar "%s" has been deleted.', 'aardvark' ), $_REQUEST['delete'] ) );
			} else {
				$this->setError( sprintf( esc_html__( 'There is no sidebar called "%s" and it could not be deleted.', 'aardvark' ), $_GET['delete'] ) );
			}
				
		}

		function reset_sidebars() {
		
			if ( ! current_user_can( $this->cap_required ) ) {
				return new WP_Error( 'ghostpool_cant_delete', esc_html__( 'You do not have permission to delete sidebars.', 'aardvark' ) );
			}	
			
			if ( ! wp_verify_nonce( $_REQUEST['reset-n'], 'ghostpool_delete_sidebars_action' ) )  {
				die( 'Security check stopped your request.' ); 
			}
			
			delete_option( $this->option_name );
		
			$widgetized_sidebars = get_option( 'sidebars_widgets' );	
			$delete_widgetized_sidebars = array();	
			foreach( $widgetized_sidebars as $id => $bar ) {
				if ( substr( $id, 0, 3 ) == 'gp-cs-' ) {
					$found = FALSE;
					if ( empty( $custom_sidebars ) ) {
						$found = TRUE;
					} else {
						foreach( $custom_sidebars as $custom_sidebar ) {
							if ( $custom_sidebar['id'] == $id )
								$found = TRUE;
						}
					}
					if ( ! $found ) {
						$delete_widgetized_sidebars[] = $id;
					}	
				}
			}
		
			foreach( $delete_widgetized_sidebars as $id ) {
				unset( $widgetized_sidebars[$id] );
			}
		
			update_option( 'sidebars_widgets', $widgetized_sidebars );
		
			$this->setMessage( esc_html__( 'The custom sidebars data has been removed successfully.', 'aardvark' ) );	
		}
			
		function get_sidebar( $id, $sidebars ) {
			$sidebar = false;
			$nsidebars = sizeof( $sidebars );
			$i = 0;
			while( ! $sidebar && $i<$nsidebars ) {
				if ( $sidebars[$i]['id'] == $id )
					$sidebar = $sidebars[$i];
				$i++;
			}
			return $sidebar;
		}
	
		function message( $echo = TRUE ) {
			$message = '';
			if ( ! empty( $this->message ) ) {
				$message = $this->message;
			}		
			if ( $echo ) {
				echo '<div id="message" class="' . $this->message_class . '"><p><strong>' . esc_attr( $message ) . '</strong></p></div>';
			} else {
				return '<div id="message" class="' . $this->message_class . '"><p><strong>' . esc_attr( $message ) . '</strong></p></div>';
			}	
		}
	
		function setMessage( $text ) {
			$this->message = $text;
			$this->message_class = 'updated';
		}
	
		function setError( $text ) {
			$this->message = $text;
			$this->message_class = 'error';
		}
	
		function getPostTypes() {
			$pt = get_post_types();
			$ptok = array();
			foreach( $pt as $t ) {
				if ( array_search( $t, $this->ignore_post_types ) === FALSE )
					$ptok[] = $t;
			}
			return $ptok; 
		}
	
		function refresh_sidebars() {
			$widgetized_sidebars = get_option( 'sidebars_widgets' );
			$delete_widgetized_sidebars = array();
			$custom_sidebars = get_option( $this->option_name );
		
			foreach( $widgetized_sidebars as $id => $bar ) {
				if ( substr( $id, 0, 3 ) == 'gp-cs-' ) {
					$found = FALSE;
					foreach( $custom_sidebars as $custom_sidebar ) {
						if ( $custom_sidebar['id'] == $id ) {
							$found = TRUE;
						}	
					}
					if ( ! $found ) {
						$delete_widgetized_sidebars[] = $id;
					}	
				}
			}
		
			foreach( $custom_sidebars as $custom_sidebar ) {
				if ( array_search( $custom_sidebar['id'], array_keys( $widgetized_sidebars ) ) === FALSE ) {
					$widgetized_sidebars[$custom_sidebar['id']] = array(); 
				}
			}
		
			foreach( $delete_widgetized_sidebars as $id ) {
				unset( $widgetized_sidebars[$id] );
			}
		
			update_option( 'sidebars_widgets', $widgetized_sidebars );
		
		}
		
	}

}

if ( ! isset( $plugin_sidebars ) ) {
	$plugin_sidebars = new GhostPool_Custom_Sidebars();	
	add_action( 'widgets_init', array( $plugin_sidebars, 'register_custom_sidebars' ) );
	add_action( 'admin_menu', array( $plugin_sidebars, 'addSubMenus' ), 99 );
}