<?php

/**
 * Add option to hide sidebars on restricted PMP pages
 *
 */
if ( ! function_exists( 'ghostpool_pmpro_extra_page_settings' ) ) {
	function ghostpool_pmpro_extra_page_settings() {

		$custom_fields[] = array( 
			'field_name' => 'pmp_hide_sidebars',
			'label' => esc_html__( 'Hide Sidebars On Restricted Pages', 'aardvark' ),
			'field_type' => 'select',
			'options' => array( 
				'0' => esc_html__( 'No', 'aardvark' ),
				'1' => esc_html__( 'Yes', 'aardvark' ),
			 ),
		 );
	
		return $custom_fields;

	}
}
add_filter( 'pmpro_custom_advanced_settings', 'ghostpool_pmpro_extra_page_settings' );
			
/**
 * Redirect away from any BuddyPress page if set to
 *
 */
if ( ! function_exists( 'ghostpool_pmpro_bp_lockdown_all_bp' ) ) {
	function ghostpool_pmpro_bp_lockdown_all_bp() {
	
		if ( ! defined( 'PMPROBP_DIR' ) OR ! function_exists( 'bp_is_active' ) OR ! function_exists( 'pmpro_getMembershipLevelForUser' ) ) {
			return;
		}
		
		if ( ! is_buddypress() OR bp_is_register_page() OR bp_is_activation_page() ) {
			return;
		}
		
		global $current_user;
		$user_id = $current_user->ID;
	
		if ( ! empty( $user_id ) ) {
			$level = pmpro_getMembershipLevelForUser( $user_id );
		}
		if ( ! empty( $level ) ) {
			$level_id = $level->id;
		} else {
			$level_id = 0;	// non-member user
		}
		
		$pmpro_bp_options = pmpro_bp_get_level_options( $level_id );
			
		if ( $pmpro_bp_options['pmpro_bp_restrictions'] == -1 ) {
			pmpro_bp_redirect_to_access_required_page();
		}
		
	}
}
remove_action( 'template_redirect', 'pmpro_bp_lockdown_all_bp', 50 );
add_action( 'template_redirect', 'ghostpool_pmpro_bp_lockdown_all_bp', 50 );

/**
 * Redirect PMPro account links to BuddyPress profile links
 *
 */	
if ( ! function_exists( 'ghostpool_redirect_pmpro_profile_access' ) ) {
	function ghostpool_redirect_pmpro_profile_access() {
	
		if ( ! function_exists( 'bp_is_active' ) ) {
			return;
		}
			
		if ( current_user_can( 'manage_options' ) ) {
			return;
		}
	
		if ( strpos( $_SERVER['REQUEST_URI'] , 'wp-admin/profile.php' ) ) {
			global $bp;
			wp_redirect( apply_filters( 'ghostpool_profile_url', $bp->loggedin_user->domain . '/profile/edit' ) );
			die();
		 }
 
	}
}
add_action ( 'init' , 'ghostpool_redirect_pmpro_profile_access' );

/*
Plugin Name: Paid Memberships Pro - Member Homepages Add On
Plugin URI: http://www.paidmembershipspro.com/pmpro-member-homepages/
Description: Redirect members to a unique homepage/landing page based on their level.
Version: .1
Author: Stranger Studios
Author URI: http://www.strangerstudios.com
*/

/**
* Function to redirect member on login to their membership level's homepage
*
*/
if ( ! function_exists( 'ghostpool_pmpro_login_redirect' ) ) {
	function ghostpool_pmpro_login_redirect( $redirect_to, $request, $user ) {

		if ( ! empty( $user ) && ! empty( $user->ID ) && function_exists( 'pmpro_getMembershipLevelForUser' ) ) {
			$level = pmpro_getMembershipLevelForUser( $user->ID );
			if ( isset( $level->id ) ) {
				$member_homepage_id = ghostpool_pmpro_get_homepage_level( $level->id );
			} else {
				$member_homepage_id = '';
			}
					
			if ( ! empty( $member_homepage_id ) ) {
				$redirect_to = get_permalink( $member_homepage_id ) ;
			}
		}

		return $redirect_to;
	}
}
add_filter( 'login_redirect', 'ghostpool_pmpro_login_redirect', 10, 3 );

/**
* Redirect member to their membership level's homepage when trying to access your site's front page (static page or posts page).
*
*/
if ( ! function_exists( 'ghostpool_pmpro_template_redirect_homepage' ) ) {
	function ghostpool_pmpro_template_redirect_homepage() {
		global $current_user;
		if ( ! empty( $current_user->ID ) && is_front_page() && ! isset( $_GET['vc_editable'] ) && ! isset( $_GET['customize_theme'] ) ) {
			$member_homepage_id = ghostpool_pmpro_get_homepage_level();
			if ( ! empty( $member_homepage_id ) && ! is_page( $member_homepage_id ) ) {
				wp_redirect( get_permalink( $member_homepage_id ) );
				exit;
			}
		}
	}
}
add_action( 'template_redirect', 'ghostpool_pmpro_template_redirect_homepage' );

/**
* Get homepage ID for given membership level
*
*/
if ( ! function_exists( 'ghostpool_pmpro_get_homepage_level' ) ) {
	function ghostpool_pmpro_get_homepage_level( $level_id = NULL ) {
		if ( empty( $level_id ) && function_exists( 'pmpro_getMembershipLevelForUser' ) ) {
			global $current_user;
			$level = pmpro_getMembershipLevelForUser( $current_user->ID );
			if ( ! empty( $level ) ) {
				$level_id = $level->id;
			}
		}

		// Look up by level
		if( ! empty( $level_id ) ) {
			$member_homepage_id = get_option( 'pmpro_member_homepage_' . $level_id );
		} else {
			$member_homepage_id = false;
		}

		return $member_homepage_id;
	}
}
	
/**
* Option to select homepage for a membership level
*
*/
if ( ! function_exists( 'ghostpool_pmpro_membership_level_after_other_settings' ) ) {
	function ghostpool_pmpro_membership_level_after_other_settings() { ?>
		<table>
		<tbody class="form-table">
			<tr>
				<td>
					<tr>
						<th scope="row" valign="top"><label for="member_homepage"><?php esc_attr_e( 'Member Homepage', 'aardvark' ); ?>:</label></th>
						<td>
							<?php
								$level_id = intval( $_REQUEST['edit'] );
								$member_homepage_id = ghostpool_pmpro_get_homepage_level( $level_id );
							?>
							<?php wp_dropdown_pages( array( "name" => "member_homepage_id", "show_option_none" => "-- " . esc_attr__( 'Choose One', 'aardvark' ) . " --", "selected" => $member_homepage_id ) ); ?>				
						</td>
					</tr>
				</td>
			</tr> 
		</tbody>
		</table>
	<?php }
}	
add_action( 'pmpro_membership_level_after_other_settings', 'ghostpool_pmpro_membership_level_after_other_settings' );

/**
* Save the homepage for a given membership level
*
*/
if ( ! function_exists( 'ghostpool_pmpro_save_membership_level' ) ) {
	function ghostpool_pmpro_save_membership_level( $level_id ) {
		if ( isset( $_REQUEST['member_homepage_id'] ) ) {
			update_option( 'pmpro_member_homepage_' . $level_id, $_REQUEST['member_homepage_id'] );
		}	
	}
}
add_action( 'pmpro_save_membership_level', 'ghostpool_pmpro_save_membership_level' );

/**
* An activated BP user will have by default level ID 1 * *
* @param int    $user_id ID of the user being checked. 
* @param string $key     Activation key. 
* @param array  $user    Array of user data.
*/
if ( ! function_exists( 'ghostpool_pmpro_assign_activated_user_level' ) ) {
	function ghostpool_pmpro_assign_activated_user_level( $user_id, $key, $user ) {
		$level = apply_filters( 'ghostpool_activated_user_level', 1 ); // This is the level by default for all members
		pmpro_changeMembershipLevel( $level, $user_id, $old_level_status = 'inactive', $cancel_level = null );
	}
}
add_action( 'bp_core_activated_user', 'ghostpool_pmpro_assign_activated_user_level', 10, 3 );