( function ( $ ) {

    $.themeSetup = function () {
        this.scope = $( document );
        this.init();
    };

    $.themeSetup.prototype = {
        init : function() {
            var fw = this;

            fw.init_tabs();
            
            // Init plugin ajax actions
            fw.init_addons_ajax();
        },

		/*--------------------------------------------------------------
		Theme setup tabs
		--------------------------------------------------------------*/

        init_tabs : function() {

            var tabs = $( '.gp-tabs' );

            tabs.each( function() {
                var tab = $( this ),
                    tabItems = tab.find( 'ul.gp-tabs-navigation' ),
                    tabContentWrapper = tab.children( 'ul.gp-tabs-content' ),
                    tabNavigation = tab.find( 'nav' );

                tabItems.on( 'click', 'a', function( event ) {
                    event.preventDefault();
                    var selectedItem = $( this );
                    if ( ! selectedItem.hasClass( 'selected' ) ) {
                        var selectedTab = selectedItem.data( 'content' ),
                            selectedContent = tabContentWrapper.find( 'li[data-content="' + selectedTab + '"]' );
                        tabItems.find( 'a.selected' ).removeClass( 'selected' );
                        selectedItem.addClass( 'selected' );
                        selectedContent.addClass( 'selected' ).siblings( 'li' ).removeClass( 'selected' );
                        window.location.hash = selectedTab;
                    }
                });

            });

            // Activate specific link on new page
            var hash = window.location.hash;
            var nav_li = $( '.gp-tabs-navigation > li' );
            var string = hash.replace( '-link', '' );
            if ( hash !== '' && nav_li.find( 'a[href="' + string + '"]' ).length ) {
                nav_li.find( 'a[href="' + string + '"]' ).trigger( 'click' );
            }

        },


		/*--------------------------------------------------------------
		Theme addons
		--------------------------------------------------------------*/

        init_addons_ajax : function(){
            var fw = this;

            $( document ).on( 'click', '.gp-addon-button', function( e ) {
                e.preventDefault();

                // Perform the ajax call based on action
                var config = {};
                config.button			= $( this );
                config.status_classes	= 'gp-active gp-inactive gp-has-update gp-not-installed';
                config.container	    = config.button.closest( '.gp-addon' );
                config.action			= config.button.data( 'action' );
                config.nonce			= config.button.data( 'nonce' );
                config.slug				= config.button.data( 'slug' );

                if ( config.container.hasClass( 'gp-addons-disabled' ) ) {
                    return false;
                }

                var data = {
                    security: config.nonce,
                    action: 'ghostpool_do_plugin_action',
                    plugin_action: config.button.data( 'action' ) || false,
                    slug: config.button.data( 'slug' ) || false,
                };

                // Don't allow the user to click the button multiple times
                if ( config.button.hasClass( 'gp-is-active' ) ) { return false; }

                // Add the loading class
                config.button.addClass( 'gp-is-active' );

                fw.perform_ajax_call( data, config );

                return false;
            });
        },

        perform_ajax_call : function( data, config, callback ) {

            $.ajax({
                'type': 'post',
                'dataType': 'json',
                'url': ajaxurl,
                'data': data,
                'success': function( response ) {

                    // If we received an error, display it
                    if ( response.data.error ) {
                        alert( response.data.error );
                    }

                    // Update the plugin status
                    config.container.removeClass( config.status_classes );
                    config.container.addClass( response.data.status );

                    // Update the plugin
                    config.button.data( 'action', response.data.action );
                    config.button.text( response.data.action_text );

                    if ( typeof callback != 'undefined' ) {
                        callback();
                    }

                    config.button.removeClass( 'gp-is-active' );
                    
                },
                'error' : function( response ) {
                    if ( typeof callback != 'undefined' ) {
                        callback();
                    }
                    alert( 'There was a problem performing the action.' );
                    config.button.removeClass( 'gp-is-active' );
                }
            });
        }
    };


	/*--------------------------------------------------------------
	Run when document ready
	--------------------------------------------------------------*/

    $(document).ready(function() {
        $.themeSetup = new $.themeSetup();
        
        /**
		 * Tooltips
		 *
		 */
		$( '.tooltip-me' ).tooltip({
			position : { my: 'center bottom', at: 'center top-10' }
		});
	
    });

})( jQuery );