<div class="wrap">

	<h2><?php esc_html_e( 'Custom Sidebars', 'aardvark' ); ?></h2>

	<?php $this->message(); ?>

	<h3 class="title"><?php esc_html_e( 'New Sidebar', 'aardvark' ); ?></h3>
	
	<p><?php esc_html_e( 'Create your new sidebars below. When a sidebar is created, it is shown on the widgets page where you will be able to configure it.', 'aardvark' ); ?></p>
	
	<form action="admin.php?page=aardvark-custom-sidebars" method="post">
		
		<?php wp_nonce_field( 'ghostpool_new_sidebars_action' ); ?>
		
		<table class="form-table">
			<tbody>
				<tr>
					<th scope="row">
						<label for="sidebar_name"><?php esc_html_e( 'Name', 'aardvark' ); ?></label>
					</th>
					<td>
						<input type="text" name="sidebar_name" size="30" tabindex="1" value="" id="sidebar_name" />
						<p class="description"><?php esc_html_e( 'This name has to be unique.', 'aardvark' ); ?></p>
					</td>
				</tr>	
				<tr>
					<th scope="row">
						<label for="sidebar_description"><?php esc_html_e( 'Description', 'aardvark' ); ?></label>
					</th>
					<td>
						<input type="text" name="sidebar_description" size="30" tabindex="1" value="" id="sidebar_description" />
					</td>
				</tr>	
			</tbody>
		</table>	

		<p><input type="submit" class="button-primary" name="create-sidebars" value="<?php esc_html_e( 'Create Sidebar', 'aardvark' ); ?>" /></p>
		
	</form>
	
	<br/>

	<div id="gp-sidebars-list">

		<script type="text/javascript">
			jQuery( document ).ready( function( $ ) {
				$( '.gp-delete-link' ).click(function() {
					return confirm( "<?php esc_html_e( 'Are you sure to delete this sidebar?', 'aardvark' ); ?>" );
				});
			});
		</script>

		<h3><?php esc_html_e( 'Custom Sidebars', 'aardvark' ); ?></h3>

		<table class="widefat fixed" cellspacing="0">

			<thead>
				<tr>
					<th><?php esc_html_e( 'Name', 'aardvark' ); ?></th>
					<th><?php esc_html_e( 'Description', 'aardvark' ); ?></th>
					<th><?php esc_html_e( 'ID', 'aardvark' ); ?></th>
					<th></th>
					<th></th>
					<th></th>
				</tr>
			</thead>
		
			<tbody>

				<?php if ( sizeof( $custom_sidebars ) > 0 ) {
					foreach( $custom_sidebars as $custom_sidebar ) { ?>
						<tr class="alternate">
							<td><?php echo esc_attr( $custom_sidebar['name'] ); ?></td>
							<td><?php echo esc_attr( $custom_sidebar['description'] ); ?></td>
							<td><?php echo esc_attr( $custom_sidebar['id'] ); ?></td>
							<td><a href="widgets.php"><?php esc_html_e( 'Configure Widgets', 'aardvark' ); ?></a></td>
							<td><a href="admin.php?page=aardvark-custom-sidebars&p=edit&id=<?php echo esc_attr( $custom_sidebar['id'] ); ?>"><?php esc_html_e( 'Edit', 'aardvark' ); ?></a></td>
							<td><a class="gp-delete-link" href="admin.php?page=aardvark-custom-sidebars&delete=<?php echo esc_attr( $custom_sidebar['id'] ); ?>&_n=<?php echo esc_attr( $delete_nonce ); ?>"><?php esc_html_e( 'Delete', 'aardvark' ); ?></a></td>
						</tr>
					<?php } 
				} else { ?>
					<tr class="alternate">
						<td colspan="3"><?php esc_html_e( 'There are no custom sidebars available.', 'aardvark' ); ?></td>
					</tr>
				<?php } ?>

			</tbody>

		</table>

	</div>
	
	<br/>

	<div id="gp-reset-sidebars">

		<form action="admin.php?page=aardvark-custom-sidebars" method="post">
	
			<input type="hidden" name="reset-n" value="<?php echo esc_attr( $delete_nonce ); ?>" />
	
			<h3><?php esc_html_e( 'Reset Sidebars', 'aardvark' ); ?></h3>
	
			<p><?php esc_html_e( 'Click on the button below to delete ALL sidebar data from the database. This deletes all custom sidebars and removes all widgets from both the theme and custom sidebars.', 'aardvark' ); ?></p>

			<p class="submit"><input onclick="return confirm('<?php esc_html_e( 'Are you sure you want to delete all sidebar data?', 'aardvark' ); ?>')"type="submit" class="button-primary" name="reset-sidebars" value="<?php esc_html_e( 'Reset Sidebars', 'aardvark' ); ?>" /></p>

		</form>

	</div>

</div>