<?php if ( ! class_exists( 'GhostPool_Post_Submission' ) ) {
	class GhostPool_Post_Submission {

		public function __construct() {

			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		
			add_action( 'wp_ajax_ghostpool_post_submission_action', array( $this, 'validation' ) );
	
			add_action( 'wp_ajax_nopriv_ghostpool_post_submission_action', array( $this, 'validation' ) );
		
		}

		public function enqueue_scripts() {			
			
			global $post;

			if ( ( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'gp_post_submission_form' ) ) OR ( isset( $_GET['post_edit'] ) && ! isset( $_GET['nonce'] ) ) ) {			
				
				wp_enqueue_script( 'ghostpool-post-submission', plugin_dir_url( __FILE__ ) . 'assets/jquery.post-submission.js', array( 'jquery' ), AARDVARK_THEME_VERSION );
			
				wp_enqueue_script( 'plupload' );
			
				wp_localize_script( 'ghostpool-post-submission', 'ghostpool_post_submission_ajax', array( 
					'ajaxurl' => admin_url( 'admin-ajax.php' ), 
					'nonce' => wp_create_nonce( 'ghostpool_post_submission_action' ),
				));
				
			}
			
		}

		public function upload_attachments( $file_handler, $post_id ) {

				if ( $_FILES[$file_handler]['error'] !== UPLOAD_ERR_OK ) {
			
					return false;
	
				} else {	
	
					require_once( ABSPATH . 'wp-admin' . '/includes/image.php' );
					require_once( ABSPATH . 'wp-admin' . '/includes/file.php' );
					require_once( ABSPATH . 'wp-admin' . '/includes/media.php' );

					$overrides = array( 'test_form' => false );
					$attach_id = media_handle_upload( $file_handler, $post_id, array(), $overrides );
						
					if ( ! is_wp_error( $attach_id ) ) {
		
						$pi = pathinfo( $_FILES[$file_handler]['name'] );
						$ext = $pi['extension'];

						// Featured image
						if ( 'yes' === get_post_meta( $post_id, 'ghostpool_featured_image', true ) ) {
							if ( 'jpg' === $ext OR 'JPG' === $ext OR 'jpeg' === $ext OR 'png' === $ext OR 'gif' === $ext ) {
								$thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', $attach_id );
								if ( ! $thumbnail_id ) {
									update_post_meta( $post_id, '_thumbnail_id', $attach_id );
								}	
							}	
						}
									
						// Gallery images
						if ( 'gallery' === get_post_format( $post_id ) ) {
					
							if ( 'jpg' === $ext OR 'JPG' === $ext OR 'jpeg' === $ext OR 'png' === $ext OR 'gif' === $ext ) {
								if ( get_post_meta( $post_id, 'gp_gallery_slider', $attach_id ) ) {
									$prev_attach_id = get_post_meta( $post_id, 'gp_gallery_slider', $attach_id ) . ',';
								} else {
									$prev_attach_id = '';
								}	
								$attach_ids = $prev_attach_id . $attach_id;
								if ( $thumbnail_id ) {
									$attach_ids = str_replace( $thumbnail_id . ',', '', $attach_ids );
								}
								update_post_meta( $post_id, 'gp_gallery_slider', $attach_ids );
							}	
				
						// Audio files
						} elseif ( 'audio' === get_post_format( $post_id ) ) {
					
							if ( 'mp3' === $ext ) {
								update_post_meta( $post_id, 'gp_audio_mp3_url', $attach_id );
							} elseif ( 'ogg' === $ext ) {
								update_post_meta( $post_id, 'gp_audio_ogg_url', $attach_id );
							}
					
						// Video files
						} elseif ( 'video' === get_post_format( $post_id ) ) {		
					
							if ( 'ogg' === $ext ) {
								update_post_meta( $post_id, 'gp_audio_ogg_url', $attach_id );
							} elseif ( 'm4v' === $ext ) {
								update_post_meta( $post_id, 'gp_video_m4v_url', $attach_id );
							} elseif ( 'mp4' === $ext ) {
								update_post_meta( $post_id, 'gp_video_mp4_url', $attach_id );
							} elseif ( 'webm' === $ext ) {
								update_post_meta( $post_id, 'gp_video_webm_url', $attach_id );
							} elseif ( 'ogv' === $ext ) {
								update_post_meta( $post_id, 'gp_video_ogv_url', $attach_id );
							}
					
						}	
				
					}
	
				}	
			}

		public function validation() {
	
			if ( isset( $_POST['nonce'] ) && wp_verify_nonce( $_POST['nonce'], 'ghostpool_post_submission_action' ) ) {
					
				$has_error = '';

				// We're passing the post ID, so the post has already been created.
				if ( isset( $_POST['post_id'] ) ) {
				
					$post_id = $_POST['post_id'];

					// Upload files as attachments 
					if ( ! empty( $_FILES ) ) {
						foreach( $_FILES as $file => $array ) {
							$uploaded_files = $this->upload_attachments( $file, $post_id );
						}
					}
					echo json_encode( array( 'status' => 'success' ) );

				// This is the first call to the server, so we need to create the post.
				} else {

					// Check all required fields are filled in
					if ( isset( $_POST['title'] ) && empty( $_POST['title'] ) ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['title'] ) ) {
						$_POST['title'] = esc_html__( 'No title', 'aardvark' );
					}

					if ( isset( $_POST['name'] ) && empty( $_POST['name'] ) && ! is_user_logged_in() ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['name'] ) ) {
						$_POST['name'] = '';
					}

					if ( isset( $_POST['email'] ) && empty( $_POST['email'] ) && ! is_email( $_POST['email'] ) && ! is_user_logged_in() ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['email'] ) ) {
						$_POST['email'] = '';
					}

					if ( isset( $_POST['cats'] ) && empty( $_POST['cats'] ) ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['cats'] ) ) {
						$_POST['cats'] = '';
					}

					if ( isset( $_POST['formats'] ) && empty( $_POST['formats'] ) ) {
						$_POST['formats'] = '0';
					} elseif ( ! isset( $_POST['formats'] ) ) {
						$_POST['formats'] = '0';	
					}	

					if ( isset( $_POST['formats'] ) && 'link' === $_POST['formats'] && isset( $_POST['link'] ) && empty( $_POST['link'] ) ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['link'] ) ) {
						$_POST['link'] = '';	
					}
												
					if ( isset( $_POST['content'] ) && empty( $_POST['content'] ) ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['content'] ) ) {
						$_POST['content'] = '';
					}

					if ( isset( $_POST['tags'] ) && empty( $_POST['tags'] ) ) {
						$has_error = true;
					} elseif ( ! isset( $_POST['tags'] ) ) {
						$_POST['tags'] = '';
					}
			
					if ( isset( $_POST['toc'] ) && $_POST['toc'] == '0' ) {
						$has_error = true;
					}
			
					// If all required fields are valid submit form	
					if ( $has_error == false ) {

						// Create post
						$post_args = array(
							'ID'            => isset( $_POST['edit_id'] ) ? $_POST['edit_id'] : 0,
							'post_type'     => 'post',
							'post_status'   => isset( $_POST['submit_status'] ) ? $_POST['submit_status'] : ghostpool_option( 'post_editing' ),
							'post_title'    => $_POST['title'],
							'post_content'  => $_POST['content'],
							'post_category' => array( $_POST['cats'] ),
							'tags_input'    => explode( ',', $_POST['tags'] ),
						);
				
						if ( 'submission' === $_POST['form'] ) {
							$new_post_id = intval( wp_insert_post( $post_args ) );
						} elseif ( 'edit' === $_POST['form'] ) {
							$new_post_id = intval( wp_update_post( $post_args ) );
						}
						
						if ( isset( $_POST['featured_image'] ) && 'yes' === $_POST['featured_image'] ) {
							update_post_meta( $new_post_id, 'ghostpool_featured_image', 'yes' );	
						}
						
						// Add name field
						if ( isset( $_POST['name'] ) && ! is_user_logged_in() ) {
							update_post_meta( $new_post_id, 'ghostpool_post_submission_username', $_POST['name'] );	
						}

						// Add email field
						if ( is_user_logged_in() ) {			
							$author_id = intval( get_post_field( 'post_author', $new_post_id ) );
							$_POST['email'] = get_the_author_meta( 'user_email', $author_id );
						}	
						if ( isset( $_POST['email'] ) ) {
							update_post_meta( $new_post_id, 'ghostpool_post_submission_email', $_POST['email'] );	
						}	
					
						// Set post format
						wp_set_post_terms( $new_post_id, $_POST['formats'], 'post_format' );
				
						// Add link field
						if ( isset( $_POST['link'] ) ) {
							update_post_meta( $new_post_id, 'gp_link', $_POST['link'] );
							update_post_meta( $new_post_id, 'gp_link_target', apply_filters( 'ghostpool_post_submission_link_target', '_blank' ) );	
						}
						
						// Add custom field to indicate post submission			
						update_post_meta( $new_post_id, 'ghostpool_post_submission_page_id', 1 );
						
						// Get the site name
						$blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
		
						// Send emails		
						if ( 'submission' === $_POST['form'] ) {
							
							// Post submission email
							if ( 'pending' === $_POST['submit_status'] && 'enabled' === $_POST['email_notification'] ) {
								if ( $_POST['name'] != '' ) {
									$author = $_POST['name'];
								} else {
									$author_id = intval( get_post_field( 'post_author', $new_post_id ) );
									$author = get_the_author_meta( 'display_name', $author_id );
								}
								
								$to = sanitize_email( apply_filters( 'ghostpool_email_post_submission_to', ( isset( $_POST['email_address'] ) && $_POST['email_address'] != '' ) ? $_POST['email_address'] : get_option( 'admin_email' ) ) );
								
								do_action( 'wpml_switch_language_for_email', $to );
								
								$subject_text = isset( $_POST['subject'] ) ? $_POST['subject'] : esc_html__( 'Post Submission', 'aardvark' );
								$subject = apply_filters( 'ghostpool_email_post_submission_subject', '[' . $blogname . '] ' . $subject_text, $subject_text, $blogname );
								
								$message = sprintf( esc_html__( 'A post was submitted on %s.', 'aardvark' ), $blogname ) . "\r\n\r\n";
								$message .= sprintf( esc_html__( 'Title: %s', 'aardvark' ), sanitize_text_field( $_POST['title'] ) ) . "\n";
								$message .= sprintf( esc_html__( 'Author: %s (%s)', 'aardvark' ), esc_attr( $author ), sanitize_email( $_POST['email'] ) ) . "\r\n\r\n";
								$message .= sprintf( esc_html__( 'You can view this post at %s', 'aardvark' ), esc_url( get_permalink( $new_post_id ) ) );
								$message = apply_filters( 'ghostpool_email_post_submission_message', $message, $blogname, $user_login, $author, $new_post_id );

								$headers[] = apply_filters( 'ghostpool_email_post_submission_headers', 'From: ' . $blogname . ' <' . $to . '>', $blogname, $to );
								
								if ( function_exists( 'ghostpool_wp_mail' ) ) { 
									ghostpool_wp_mail( $to, $subject, $message, $headers );
								}
								
								do_action( 'wpml_restore_language_from_email' );
								
							}
							
						} elseif ( 'edit' === $_POST['form'] && 'disabled' !== ghostpool_option( 'post_editing' ) ) {
						
							// Post editing email
							if ( 'pending' === ghostpool_option( 'post_editing' ) && 'enabled' === ghostpool_option( 'post_edit_email_notification' ) ) {
								
								$to = sanitize_email( apply_filters( 'ghostpool_email_post_edit_to', get_option( 'admin_email' ) ) );
								
								do_action( 'wpml_switch_language_for_email', $to );
								
								$subject = sprintf( apply_filters( 'ghostpool_email_post_edit_subject', esc_html__( '[%s] Post Edit', 'aardvark' ), $blogname ), $blogname );
								
								$message = sprintf( esc_html__( 'A post was edited on %s.', 'aardvark' ), $blogname ) . "\r\n\r\n";
								$message .= sprintf( esc_html__( 'Title: %s', 'aardvark' ), stripslashes( $_POST['title'] ) ) . "\r\n\r\n";
								$message .= sprintf( esc_html__( 'You can view this post at %s', 'aardvark' ), esc_url( get_permalink( $new_post_id ) ) );
								$message = apply_filters( 'ghostpool_email_post_edit_message', $message, $blogname, $user_login, $new_post_id );
								
								$headers[] = apply_filters( 'ghostpool_email_post_edit_headers', 'From: ' . $blogname . ' <' . $to . '>', $blogname, $to );
								
								if ( function_exists( 'ghostpool_wp_mail' ) ) { 
									ghostpool_wp_mail( $to, $subject, $message, $headers );				
								}
								
								do_action( 'wpml_restore_language_from_email' );	
								 
							}	
		
						}
				
						echo json_encode( array( 'status' => 'success', 'post_id' => $new_post_id ) );

					} else {

						echo json_encode( array( 'status' => 'error', 'post_id' => '' ) );
						
					}
				}
				exit();
			}	
		}		
	} 
}
new GhostPool_Post_Submission();