<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'BESTBUG_RPPRO_FILTER' ) ) {
	/**
	 * BESTBUG_RPPRO_FILTER Class
	 *
	 * @since	1.0
	 */
	class BESTBUG_RPPRO_FILTER {


		/**
		 * Constructor
		 *
		 * @return	void
		 * @since	1.0
		 */
		function __construct() {
			add_action( 'bb_build_css', array( $this, 'filter_css' ), 10 , 2 );
			$prefix = 'bb_rppro_';
			if(bb_option($prefix . 'add_div_container') == 'yes') {
				add_filter('vc_shortcode_output', array($this, 'force_filter'), 10, 3);
			} else {
				add_filter('vc_shortcodes_css_class', array($this, 'filter_class'), 10, 3);
			}
		}

		public function init() {

			if(is_admin()) {
				add_action( 'admin_enqueue_scripts', array( $this, 'adminEnqueueScripts' ) );
			}
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ) );

        }

		public function adminEnqueueScripts() {
		
		}

		public function enqueueScripts() {
		
        }
        
		public function filter_css($param_name, &$css) {
			$devices_posts = BESTBUG_RPPRO_CLASS::get_devices();
			
			$devices = array();
			foreach ($devices_posts as $key => $device) {
				$slug = $device->post_name . 'bbresponsive';
				$devices[$slug]['mediafeature'] = get_post_meta($device->ID, 'mediafeature', true);
				$devices[$slug]['breakpoint'] = get_post_meta($device->ID, 'breakpoint', true);
			}
			if(isset($devices[$param_name]['mediafeature']) && !empty($devices[$param_name]['mediafeature']) && isset($devices[$param_name]['breakpoint']) && !empty($devices[$param_name]['breakpoint'])) {
				$css = ' @media ('.$devices[$param_name]['mediafeature'].': ' . $devices[$param_name]['breakpoint'] . 'px){ ' . $css . '}';
			}
		}
		
		public function filter_class( $class_string = '', $tag = '', $atts = null ) {
			$prefix = 'bb_rppro_';
			$shortcodes = array();
			if(bb_option($prefix . 'add_option') == 'no') {
				$shortcodes = array();
			} else if(bb_option($prefix . 'all_shortcodes') == 'yes') {
				$shortcodes = explode(",", bb_option('bbrppro_all_vcshortcodes'));
			} else {
				$shortcodes = explode(",", bb_option($prefix . 'shortcodes'));
			}
			
			if(!in_array(BESTBUG_RPPRO_SHORTCODE, $shortcodes)) {
				array_push( $shortcodes, BESTBUG_RPPRO_SHORTCODE);
			}
			
			if(!in_array($tag, $shortcodes )) {
				return $class_string;
			}
			
			$devices = BESTBUG_RPPRO_CLASS::get_devices();
			if(count($devices) <= 0) {
				return $class_string;
			}
			
			$class_array = array($class_string);
			foreach ($devices as $key => $device) {
				$slug = $device->post_name . 'bbresponsive';
				if(isset($atts[ $slug ]) && !empty($atts[ $slug ])) {
					array_push($class_array, BESTBUG_HELPER::get_bbcustom_class( $atts[ $slug ] ));
				}
			}
			
			$class_string = implode(' ', $class_array);
			return $class_string;
		}
		
		public function force_filter( $output, $obj, $atts ) {
			$prefix = 'bb_rppro_';
			$shortcodes = array();
			$tag = $obj->settings( 'base' );
			if(bb_option($prefix . 'add_option') == 'no') {
				$shortcodes = array();
			} else if(bb_option($prefix . 'all_shortcodes') == 'yes') {
				$shortcodes = explode(",", bb_option('bbrppro_all_vcshortcodes'));
			} else {
				$shortcodes = explode(",", bb_option($prefix . 'shortcodes'));
			}
			
			if(!in_array(BESTBUG_RPPRO_SHORTCODE, $shortcodes)) {
				array_push( $shortcodes, BESTBUG_RPPRO_SHORTCODE);
			}
			
			if(!in_array($tag, $shortcodes )) {
				return $output;
			}
			
			$devices = BESTBUG_RPPRO_CLASS::get_devices();
			if(count($devices) <= 0) {
				return $output;
			}

			$class_array = array();
			foreach ($devices as $key => $device) {
				$slug = $device->post_name . 'bbresponsive';
				if(isset($atts[ $slug ]) && !empty($atts[ $slug ])) {
					array_push($class_array, BESTBUG_HELPER::get_bbcustom_class( $atts[ $slug ] ));
				}
			}

			if(count($class_array) <= 0) {
				return $output;
			}
			
			$class_string = implode(' ', $class_array);
			return '<div class="'.esc_attr($class_string).'">'.$output.'</div>';
		}
        
    }
	
	new BESTBUG_RPPRO_FILTER();
}

