<?php
/*
Plugin Name: Responsive for WPBakery Page Builder
Description: Make your Row, Column and Any elements responsive with WPBakery Page Builder.
Author: BestBug
Version: 3.2.9
Author URI: http://vc-responsive-design.bestbug.net/
Text Domain: bestbug
Domain Path: /languages
*/

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

defined( 'BESTBUG_RPPRO_URL' ) or define('BESTBUG_RPPRO_URL', plugins_url( '/', __FILE__ ));
defined( 'BESTBUG_RPPRO_PATH' ) or define('BESTBUG_RPPRO_PATH', basename( dirname( __FILE__ )));
defined( 'BESTBUG_RPPRO_TEXTDOMAIN' ) or define('BESTBUG_RPPRO_TEXTDOMAIN', plugins_url( '/', __FILE__ ));

defined( 'BESTBUG_RPPRO_SHORTCODE' ) or define('BESTBUG_RPPRO_SHORTCODE', 'bb_responsive_pro');
defined( 'BESTBUG_RPPRO_CATEGORY' ) or define('BESTBUG_RPPRO_CATEGORY', 'Responsive WPB');

// SLUG
defined( 'BESTBUG_RPPRO_PAGESLUG' ) or define('BESTBUG_RPPRO_PAGESLUG', 'bb_rppro');
defined( 'BESTBUG_RPPRO_PAGESLUG_SETTINGS' ) or define('BESTBUG_RPPRO_PAGESLUG_SETTINGS', 'bb_rppro_settings');
defined( 'BESTBUG_RPPRO_PAGESLUG_DEVICE_DETAIL' ) or define('BESTBUG_RPPRO_PAGESLUG_DEVICE_DETAIL', 'bb_rppro_device');

// POSTTYPES
defined( 'BESTBUG_RPPRO_POSTTYPE_DEVICE' ) or define('BESTBUG_RPPRO_POSTTYPE_DEVICE', 'bb_device');

if ( ! class_exists( 'BESTBUG_RPPRO_CLASS' ) ) {
	/**
	 * BESTBUG_RPPRO_CLASS Class
	 *
	 * @since	1.0
	 */
	class BESTBUG_RPPRO_CLASS {
		public static $devices;
		
		/**
		 * Constructor
		 *
		 * @return	void
		 * @since	1.0
		 */
		function __construct() {
			// Load core
			if(!class_exists('BESTBUG_CORE_CLASS')) {
				include_once 'bestbugcore/index.php';
			}
			BESTBUG_CORE_CLASS::support('vc-params');
			BESTBUG_CORE_CLASS::support('options');
			BESTBUG_CORE_CLASS::support('about-bb');
			if(is_admin()) {
				include_once 'includes/admin/index.php';
			}
			BESTBUG_CORE_CLASS::support('posttypes');
			include_once 'includes/index.php';
			
			$this->loadShortcodes();
            add_action( 'init', array( $this, 'init' ) );
			add_action( 'init', array( $this, 'load_devices' ), 9 );
			add_action( 'bb_about_submenu_page', array( $this, 'about_menu' ), 99 );
		}

		public function init() {
			
			// Load enqueueScripts
			if(is_admin()) {
				add_action( 'admin_enqueue_scripts', array( $this, 'adminEnqueueScripts' ) );
			}
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ) );

        }
		
		public function about_menu($sub_menu) {
			$sub_menu[] = array(
				'parent_slug' => BESTBUG_RPPRO_PAGESLUG,
				'slug' => 'rd_wpbb_about',
			);
			return $sub_menu;
		}
		public function load_devices() {
			self::$devices = get_posts(array(
				'numberposts' => -1,
				'post_type' => BESTBUG_RPPRO_POSTTYPE_DEVICE,
				'order' => 'ASC',
		        'orderby' => 'meta_value',
		        'meta_query' => array(
		            array('key' => 'order'))
			));
        }

		public function adminEnqueueScripts() {
			BESTBUG_CORE_CLASS::adminEnqueueScripts();
			wp_enqueue_style( 'bb_responsive_pro', BESTBUG_RPPRO_URL . '/assets/lib/font-awesome/css/font-awesome.min.css' );
			wp_enqueue_style( 'bb_responsive_pro', BESTBUG_RPPRO_URL . '/assets/admin/css/style.css' );
		}

		public function enqueueScripts() {
			BESTBUG_CORE_CLASS::enqueueScripts();
			//wp_enqueue_style( 'bb_responsive_pro', BESTBUG_RPPRO_URL . '/assets/css/style.css' );
			
			if(!empty(get_the_ID())  && 'true' === vc_get_param( 'preview' )) {
				$post_custom_css = get_metadata( 'post', get_the_ID(), '_bbrp_shortcodes_custom_css', true );
				if ( ! empty( $post_custom_css ) ) {
					$post_custom_css = wp_strip_all_tags( $post_custom_css );
					wp_add_inline_style( 'js_composer_front', $post_custom_css );
				}
			}
		}

		public function loadTextDomain() {
			load_plugin_textdomain( BESTBUG_RPPRO_TEXTDOMAIN, false, BESTBUG_RPPRO_PATH . '/languages/' );
		}

		public function loadShortcodes() {
			include_once 'includes/shortcodes/index.php';
		}
		
		public static function get_devices() {
			return self::$devices;
		}
	}
	new BESTBUG_RPPRO_CLASS();
}
