<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'BESTBUG_RPPRO_TABS' ) ) {
	/**
	 * BESTBUG_RPPRO_TABS Class
	 *
	 * @since	1.0
	 */
	class BESTBUG_RPPRO_TABS {


		/**
		 * Constructor
		 *
		 * @return	void
		 * @since	1.0
		 */
		function __construct() {
			add_action( 'init', array( $this, 'tabs' ) );
		}

		public function init() {

			if(is_admin()) {
				add_action( 'admin_enqueue_scripts', array( $this, 'adminEnqueueScripts' ) );
			}
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ) );

        }

		public function adminEnqueueScripts() {
		
		}

		public function enqueueScripts() {
		
        }
        
		public function tabs() {
            if ( ! defined( 'WPB_VC_VERSION' ) ) {
                return;
            }
			
			$prefix = 'bb_rppro_';
			
			$txt_group = bb_option($prefix . 'group');
			$group = (!empty($txt_group))?$txt_group:'Responsive WPB';
			$devices = BESTBUG_RPPRO_CLASS::get_devices();
			if(count($devices) <= 0) {
				return;
			}
			$tabs = array();
			foreach ($devices as $key => $device) {
				$slug = $device->post_name;// . 'bbresponsive';
				$tabs[$slug] = array(
					'label' => $device->post_title
				);
				if(get_post_meta($device->ID, 'use_font_icon', true) == 'yes') {
					$tabs[$slug]['icon'] = 'class_icon';
					$tabs[$slug]['class_icon'] = get_post_meta($device->ID, 'font_icon', true);
				} else {
					$tabs[$slug]['icon'] = 'image_icon';
					$img = wp_get_attachment_image_src( get_post_meta($device->ID, 'image_icon', true), 'full' );
					if(isset($img[0])) {
						$img = $img[0];
					}
					$tabs[$slug]['image_icon'] = $img;
				}
			}
			
			$use_settings = bb_option($prefix . 'list_attrs');
			$use = array();
			foreach ($use_settings as $key => $value) {
				if($value == 1) {
					array_push($use, $key);
				}
			}

			$shortcodes = array();
			if(bb_option($prefix . 'add_option') == 'no') {
				$shortcodes = array();
			} else if(bb_option($prefix . 'all_shortcodes') == 'yes') {
				$shortcodes = explode(",", bb_option('bbrppro_all_vcshortcodes'));
			} else {
				$shortcodes = explode(",", bb_option($prefix . 'shortcodes'));
			}
			
			if(!in_array(BESTBUG_RPPRO_SHORTCODE, $shortcodes)) {
				array_push( $shortcodes, BESTBUG_RPPRO_SHORTCODE);
			}
			
			$tab_position = (bb_option($prefix . 'tabs_on_right') == 'yes')?'right':'top';
			foreach ($shortcodes as $key => $shortcode) {
				$shortcode = trim($shortcode);
				vc_add_param( $shortcode, array(
					'type' => 'bb_tabs',
					'param_name' => 'bb_tab_container',
					'active' => isset($devices[0]->post_name)?$devices[0]->post_name:'',
					'tabs' => $tabs,
					'suffix' => array('bbresponsive'),
					'class' => $tab_position,
					'group' => $group,
				));

				foreach ($devices as $key => $device) {
					vc_add_param( $shortcode, array(
						'type' => 'bb_responsive',
						'heading' => bb_option($prefix . 'title') . ' - ' . $device->post_title,
						'param_name' => $device->post_name . 'bbresponsive',
						'group' => $group,
						'use' => $use,
						'selector' => bb_option($prefix . 'selector'),
					));
				}

			}
		}
        
    }
	
	new BESTBUG_RPPRO_TABS();
}

