<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( class_exists( 'WPBakeryShortCodesContainer' ) && ! class_exists( 'WPBakeryShortCode_Bb_Responsive_Pro' ) ) {
	class WPBakeryShortCode_Bb_Responsive_Pro extends WPBakeryShortCodesContainer {
	}
} else {
	add_action( 'init', function(){
		global $composer_settings;
		if ( ! empty( $composer_settings ) ) {
			if ( array_key_exists( 'COMPOSER_LIB', $composer_settings ) ) {
				$lib_dir = $composer_settings['COMPOSER_LIB'];
				if ( file_exists( $lib_dir . 'shortcodes.php' ) ) {
					require_once( $lib_dir . 'shortcodes.php' );
				}
			}
		}
		if ( class_exists( 'WPBakeryShortCodesContainer' ) && ! class_exists( 'WPBakeryShortCode_Bb_Responsive_Pro' ) ) {
			class WPBakeryShortCode_Bb_Responsive_Pro extends WPBakeryShortCodesContainer {
			}
		}
	} );
}

if ( ! class_exists( 'BESTBUG_RPPRO_SHORTCODE' ) ) {
	/**
	 * BESTBUG_RPPRO_SHORTCODE Class
	 *
	 * @since	1.0
	 */
	class BESTBUG_RPPRO_SHORTCODE {

		/**
		 * Constructor
		 *
		 * @return	void
		 * @since	1.0
		 */
		function __construct() {
			add_action( 'init', array( $this, 'init' ) );
		}

		public function init() {
			
			add_shortcode( BESTBUG_RPPRO_SHORTCODE, array( $this, 'shortcode' ) );
			if ( defined( 'WPB_VC_VERSION' ) && function_exists( 'vc_add_param' ) ) {
				$this->vc_shortcode();
			}

			if(is_admin()) {
				add_action( 'admin_enqueue_scripts', array( $this, 'adminEnqueueScripts' ) );
			}
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ) );

        }

		public function adminEnqueueScripts() {
			wp_enqueue_style( 'css', BESTBUG_RPPRO_URL . '/assets/admin/css/style.css' );
			wp_enqueue_script( 'js', BESTBUG_RPPRO_URL . '/assets/admin/js/script.js', array( 'jquery' ), '1.0', true );
		}

		public function enqueueScripts() {
			wp_enqueue_style( 'css', BESTBUG_RPPRO_URL . '/assets/css/style.css' );
			wp_enqueue_script( 'js', BESTBUG_RPPRO_URL . '/assets/js/script.js', array( 'jquery' ), '1.0', true );
		}
        
        public function vc_shortcode() {
			vc_map( array(
			    "name" => esc_html__( "Responsive WPB", 'bestbug' ),
			    "base" => BESTBUG_RPPRO_SHORTCODE,
			    "as_parent" => array('except' => BESTBUG_RPPRO_SHORTCODE),
			    "content_element" => true,
				"icon" => "icon-" . BESTBUG_RPPRO_SHORTCODE,
			    "js_view" => 'VcColumnView',
				"description" => esc_html__( "Make responsive better", 'bestbug' ),
				'category' => esc_html( sprintf( esc_html__( 'by %s', 'bestbug' ), BESTBUG_RPPRO_CATEGORY ) ),
			    "params" => array(
					// array(
					// 	'type'       => 'bb_responsive',
					// 	'heading'    => esc_html__( 'Responsive', 'bestbug' ),
					// 	'param_name' => 'responsive',
					// 	'value'      => '',
					// 	'use' => array(
					// 		'padding',
					// 		'margin',
					// 		'border',
					// 		'border-radius',
					// 		'background',
					// 		'selector',
					// 		'font',
					// 		'display',
					// 		'width-height',
					// 		'max-width-height',
					// 		'position',
					// 	),
					// ),
					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Extra class name', 'bestbug' ),
						'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS.', 'bestbug'),
						'param_name' => 'el_class',
					),
			    ),
			) );
        }
		public function settings($attr = BESTBUG_RPPRO_SHORTCODE) {
			return BESTBUG_RPPRO_SHORTCODE;
		}
		
		public function shortcode( $atts, $content = null ) {
			$class_array = array('bb-responsive-pro');
			if(isset($atts[ 'el_class' ]) && !empty($atts[ 'el_class' ])) {
				array_push($class_array, $atts[ 'el_class' ]);
			}
			$class_string = apply_filters( 'vc_shortcodes_css_class', implode(' ', $class_array), BESTBUG_RPPRO_SHORTCODE, $atts );
			$html = '<div class="'.esc_attr($class_string).'">'.do_shortcode($content).'</div>';
			$html = apply_filters( 'vc_shortcode_output', $html, $this, $atts );
			return $html;
		}
        
    }
	
	new BESTBUG_RPPRO_SHORTCODE();
}

