<?php if ( ! function_exists( 'ghostpool_featured_box' ) ) {
	function ghostpool_featured_box( $atts, $content = null ) {	

		extract( $settings = shortcode_atts( array(
			'post_types' => 'post',
			'page_ids' => '',	
			'cats' => '',
			'tags' => '',
			'format' => 'gp-featured-box-2-2-2-2',
			'layout' => 'gp-wide',
			'spacing' => 0,
			'orderby' => 'newest',
			'offset' => '',
			'title' => 'enabled',
			'title_length' => 0,
			'excerpt_length' => 0,
			'meta_author' => '',
			'meta_date' => '',
			'meta_views' => '',
			'meta_likes' => '',
			'meta_comment_count' => '',
			'meta_cats' => '',
			'meta_tags' => '',
			'classes' => '',
			'css' => '',
		), $atts ) );
		
		// Unique Name	
		STATIC $i = 0;
		$i++;
		$name = 'gp_featured_box_wrapper_' . $i;

		// Add CSS styling to header	
		if ( function_exists( 'ghostpool_featured_box_css' ) ) {
			ghostpool_featured_box_css( $name, $atts );
		}
		
		// Post types
		if ( ! is_array( $post_types ) && $post_types ) {
			$post_types = explode( ',', $post_types );
		}
		
		// Post/page IDs
		if ( ! is_array( $page_ids ) && $page_ids ) {
			$page_ids = explode( ',', $page_ids );
		}
					
		// Number of items	
		if ( $format == 'gp-featured-box-2-2-2-2' ) {
			$per_page = 8;
		} elseif ( $format == 'gp-featured-box-2-1-2' OR $format == 'gp-featured-box-1-2-2' ) {
			$per_page = 5;	
		} elseif ( $format == 'gp-featured-box-1-1' ) {
			$per_page = 2;
		} else {
			$per_page = 1;
		}
		
		global $wp_query;
		if ( isset( $wp_query->post->ID ) && empty( $page_ids ) ) {
			$current_post_id = $wp_query->post->ID;	
		} else {
			$current_post_id = null;	
		}
				
		// Query																
		$args = array(
			'post_status'         => 'publish',
			'post_type'     	  => $post_types,
			'post__in'      	  => $page_ids,
			'post__not_in'        => array( $current_post_id ),
			'tax_query'           => ghostpool_cats( $cats ),
			'tag'			      => $tags,
			'orderby' 		      => ghostpool_orderby( $orderby, 'orderby' ),
			'order' 		      => ghostpool_orderby( $orderby, 'order' ),	
			'meta_key' 		      => ghostpool_orderby( $orderby, 'meta_key' ),	
			'meta_query' 		  => ghostpool_orderby( $orderby, 'meta_query' ),
			'posts_per_page'      => $per_page,
			'offset' 		      => $offset,	
			'paged'          	  => 1,
			'ignore_sticky_posts' => 1,
		);
		$args = apply_filters( 'ghostpool_featured_box_element_query', $args, $settings );
		$gp_query = new WP_Query( $args );  
		
		// Classes
		$css_classes = array(
			'gp-featured-box-wrapper',
			$format,
			$layout,
			$classes,
		);
		$css_classes = trim( implode( ' ', array_filter( array_unique( $css_classes ) ) ) );
		
		ob_start(); ?>		
		
		<?php if ( $gp_query->have_posts() ) : ?>

			<div id="<?php echo sanitize_html_class( $name ); ?>" class="<?php echo esc_attr( $css_classes ); ?>">	
	
				<?php for( $settings['counter'] = 1; $settings['counter'] <= $per_page; $settings['counter']++ ) {
					
					if ( $settings['counter'] <= $gp_query->post_count ) { 
						$gp_query->the_post(); 
					}
		
					if ( $format == 'gp-featured-box-2-2-2-2' ) { 		
						$settings['image'] = ghostpool_image_data( 'gp_featured_box_small_image', $format );
					} elseif ( $format == 'gp-featured-box-2-1-2' OR $format == 'gp-featured-box-1-2-2' ) { 
						if ( $settings['counter'] % 5 == 1 ) {
							$settings['image'] = ghostpool_image_data( 'gp_featured_box_large_image', $format );
						} else {
							$settings['image'] = ghostpool_image_data( 'gp_featured_box_small_image', $format );
						}
					} elseif ( $format == 'gp-featured-box-1-1' ) {
						$settings['image'] = ghostpool_image_data( 'gp_featured_box_large_image', $format );
					} elseif ( $format == 'gp-featured-box-1' ) {
						$settings['image'] = ghostpool_image_data( 'gp_featured_box_full_image', $format );
					} else {
						$settings['image'] = '';
					}
		
					set_query_var( 'ghostpool_loop_settings', $settings );
					
					if ( $format == 'gp-featured-box-2-2-2-2' ) { 
						get_template_part( 'lib/sections/featured-box/featured-box-2-2-2-2' );
					} elseif ( $format == 'gp-featured-box-2-1-2' ) { 
						get_template_part( 'lib/sections/featured-box/featured-box-2-1-2' );
					} elseif ( $format == 'gp-featured-box-1-2-2' ) { 
						get_template_part( 'lib/sections/featured-box/featured-box-1-2-2' );
					} elseif ( $format == 'gp-featured-box-1-1' ) { 
						get_template_part( 'lib/sections/featured-box/featured-box-1-1' );
					} else {
						get_template_part( 'lib/sections/featured-box/featured-box-1' );
					}
					
					if ( $settings['counter'] === $gp_query->post_count ) {
						wp_reset_postdata();
					}
			
				} ?>
			
			</div>
			
		<?php endif; wp_reset_postdata(); ?>

		<?php

		// Reset loop settings so doesn't interfer with main query
		set_query_var( 'ghostpool_loop_settings', '' );

		$output_string = ob_get_contents();
		ob_end_clean();
		return $output_string;

	}

}
add_shortcode( 'gp_featured_box', 'ghostpool_featured_box' );