// Get image preview
function gpImagePreview( file, parentID ) {
	var uploadContainer = parentID.next( jQuery( '.gp-uploads' ) );	
	uploadContainer.find( '.gp-upload-preview' ).remove();			
	var item = jQuery( '<span class="gp-upload-preview"></span>' ).prependTo( uploadContainer ),
		upload = jQuery( new Image() ).appendTo( item ),
		preloader = new mOxie.Image();	
	preloader.onload = function() {
		preloader.crop( 150, 150 );
		upload.prop( 'src', preloader.getAsDataURL() );
	};	
	preloader.load( file.getSource() );
	parentID.text( parentID.data( 'added-text' ) );	
	parentID.next().next().val( 'yes' );
}

// Get gallery preview
function gpGalleryPreview( files, parentID ) {
	var uploadContainer = parentID.next( jQuery( '.gp-uploads' ) );	
	if ( ! uploadContainer.find( '.gp-upload-preview' ).length ) {
		jQuery( '<span class="gp-upload-preview"></span>' ).prependTo( uploadContainer );
	}
	jQuery.each( files, function( index, file ) {
		var uploadContainer = parentID.next( jQuery( '.gp-uploads' ) );		
		var item = jQuery( '<span class="gp-upload-preview"></span>' ).prependTo( uploadContainer ),
			upload = jQuery( new Image() ).appendTo( item ),
			preloader = new mOxie.Image();			
		preloader.onload = function() {
			preloader.crop( 75, 75 );
			upload.prop( 'src', preloader.getAsDataURL() );
		};	
		preloader.load( file.getSource() );		
	});		
	parentID.text( parentID.data( 'added-text' ) );		
}

// Get audio/video preview
function gpAudioVideoPreview( files, parentID ) {
	var uploadContainer = parentID.next( jQuery( '.gp-uploads' ) );	
	if ( ! uploadContainer.find( '.gp-upload-list' ).length ) {
		jQuery( '<ul class="gp-upload-list"></ul>' ).prependTo( uploadContainer );
	}
	jQuery.each( files, function( index, file ) {
		uploadContainer.find( '.gp-upload-list' ).append( '<li>' + file.name + '</li>' );
	});	
	parentID.text( parentID.data( 'added-text' ) );		
}	
			
// Process form
function gpProcessForm( formWrapper, dataStatus ) {

	if ( dataStatus == 'success' && formWrapper.hasClass( 'gp-image-upload-success' ) && formWrapper.hasClass( 'gp-gallery-upload-success' ) && formWrapper.hasClass( 'gp-audio-upload-success' ) && formWrapper.hasClass( 'gp-video-upload-success' ) ) {
		
		// Remove loading screen	
		formWrapper.find( '.gp-loader' ).addClass( 'gp-remove-loader' );
		
		// Clear form upon succesful submission
		if ( formWrapper.find( '.gp-post-submission-form' ).length ) {
			
			formWrapper.find( '.gp-post-submission-form' )[0].reset();		
			
			formWrapper.find( '.gp-upload-preview' ).remove();	
			
			formWrapper.find( '.gp-upload-list' ).remove();
					
			// Reset post format fields
			gpPostFormats( formWrapper.find( '.gp-post-form-formats select' ).val() );
	
			// Reset upload button text
			jQuery( '.gp-upload-item' ).each( function() { 
				button = $( this );
				$( this ).text( button.data( 'add-text' ) );
			});
				
		}

		// Remove upload success classes
		formWrapper.removeClass( 'gp-image-upload-success gp-gallery-upload-success gp-audio-upload-success gp-video-upload-success' );
		
		// Remove error messages
		formWrapper.find( '.gp-error' ).removeClass( 'gp-error' );		
		
		// Show success message
		formWrapper.find( '.gp-success' ).addClass( 'gp-show-message' );

	} else {

		// Remove success message
		formWrapper.find( '.gp-success' ).removeClass( 'gp-show-message' );

		// Remove previous error messages
		formWrapper.find( '.gp-error' ).removeClass( 'gp-error' );

		// Show error messages
		formWrapper.find( '.gp-field-container:visible input[type=text], .gp-field-container:visible textarea, .gp-field-container:visible select, .gp-field-container:visible input[type=checkbox]' ).each( function() {
			var field = jQuery( this ),
				fieldContainer = field.parent();
				value = field.val();
			if ( value === '' ) {
				fieldContainer.addClass( 'gp-error' );
			} else if ( field.is( 'input[type=checkbox]' ) && ! field.is( ':checked' ) ) {
				fieldContainer.addClass( 'gp-error' );
			}
		
			if ( fieldContainer.hasClass( 'gp-error' ) && ! formWrapper.find( '.gp-loader' ).hasClass( 'gp-remove-loader' ) ) {
				
				// Remove loading screen if errors found
				formWrapper.find( '.gp-loader' ).addClass( 'gp-remove-loader' );
						
				// Remove upload success classes
				formWrapper.removeClass( 'gp-image-upload-success gp-gallery-upload-success gp-audio-upload-success gp-video-upload-success' );
		
			}
		
		});
		
	}
}

// Show selected post format fields
function gpPostFormats( currentVal ) {
	$( '.gp-post-form-format-field' ).removeClass( 'gp-show' );
	if ( currentVal === 'audio' ) {
		$( '.gp-post-form-audio' ).addClass( 'gp-show' );
	} else if ( currentVal === 'gallery' ) {
		$( '.gp-post-form-gallery' ).addClass( 'gp-show' );
	} else if ( currentVal === 'link' ) {
		$( '.gp-post-form-link' ).addClass( 'gp-show' );
	} else if ( currentVal === 'video' ) {
		$( '.gp-post-form-video' ).addClass( 'gp-show' );
	}
}
	
jQuery( document ).ready( function( $ ) {

	'use strict';

	var uploadImage = $( '#gp-upload-image' ),
		uploadGallery = $( '#gp-upload-gallery' ),
		uploadAudio = $( '#gp-upload-audio' ),
		uploadVideo = $( '#gp-upload-video' );		

	// Get selected post format
	gpPostFormats( $( '.gp-post-form-formats select' ).val() );
	$( '.gp-post-form-formats select' ).on( 'change', function() {		
		var currentVal = $( this ).val();		
		gpPostFormats( currentVal );		
	});		 

	// Upload image file
	if ( uploadImage.length > 0 ) {
	
		// Load plupload parameters
		var ImageUploader = new plupload.Uploader({
			browse_button: 'gp-upload-image',
			multipart: true,
			multi_selection: false,
			url: ghostpool_post_submission_ajax.ajaxurl,
			max_file_count: 1,
			filters : [{
				extensions: 'jpg,jpeg,gif,png'
			}]
		});

		// Initialise plupload uploader
		ImageUploader.init();

		// Upload files
		ImageUploader.bind( 'FilesAdded', function( up, files ) {
			if ( up.files.length > 1 ) {
				while( up.files.length > 1 ) {
					if ( up.files.length > 1 ) {
						ImageUploader.removeFile( up.files[0] );
					}
				}
				uploadImage.next( '.gp-uploads' ).find( '.gp-upload-preview' ).remove();			
			}
			gpImagePreview( files[0], uploadImage );
		});
		
	}

	// Upload gallery file
	if ( uploadGallery.length > 0 ) {
	
		// Load plupload parameters
		var GalleryUploader = new plupload.Uploader({
			browse_button: 'gp-upload-gallery',
			multipart: true,
			multi_selection: true,
			url: ghostpool_post_submission_ajax.ajaxurl,
			filters : [{
				extensions: 'jpg,jpeg,gif,png'
			}]
		});

		// Initialise plupload uploader
		GalleryUploader.init();

		// Upload files
		GalleryUploader.bind( 'FilesAdded', function( up, files ) {		
			gpGalleryPreview( files, uploadGallery );
		});
		
	}
	
	// Upload audio file
	if ( uploadAudio.length > 0 ) {
	
		// Load plupload parameters
		var AudioUploader = new plupload.Uploader({
			browse_button: 'gp-upload-audio',
			multipart: true,
			url: ghostpool_post_submission_ajax.ajaxurl,
			max_file_count: 2,
			filters : [{
				extensions: 'mp3,ogg'
			}]
		});

		// Initialise plupload uploader
		AudioUploader.init();

		// Upload files
		AudioUploader.bind( 'FilesAdded', function( up, files ) {
			if ( up.files.length > 2 ) {
				while( up.files.length > 2 ) {
					if ( up.files.length > 2 ) {
						AudioUploader.removeFile( up.files[0] );
					}
				}
				$( uploadAudio ).next( '.gp-uploads' ).find( '.gp-upload-list' ).remove();
			}		
			gpAudioVideoPreview( files, uploadAudio );	
		});
		
	}

	// Upload video file
	if ( uploadVideo.length > 0 ) {
	
		// Load plupload parameters
		var VideoUploader = new plupload.Uploader({
			browse_button: 'gp-upload-video',
			multipart: true,
			multi_selection: true,
			url: ghostpool_post_submission_ajax.ajaxurl,
			max_file_count: 4,
			filters : [{
				extensions: 'm4v,mp4,webm,ogv'
			}]
		});

		// Initialise plupload uploader
		VideoUploader.init();

		// Upload files
		VideoUploader.bind( 'FilesAdded', function( up, files ) {
			if ( up.files.length > 4 ) {
				while( up.files.length > 4 ) {
					if ( up.files.length > 4 ) {
						VideoUploader.removeFile( up.files[0] );
					}
				}
				uploadVideo.next( '.gp-uploads' ).find( '.gp-upload-list' ).remove();
			}		
			gpAudioVideoPreview( files, uploadVideo );
		});
		
	}
								
	// Submit form					
	$( '.gp-post-submission-form .gp-submit, .gp-post-edit-form .gp-submit' ).click( function( e ) { 		   
		
		e.preventDefault();
		
		// Get form container
		var formWrapper = $( this ).parent().parent().parent();

		// Show loading screen
		formWrapper.find( '.gp-loader' ).removeClass( 'gp-remove-loader' );

		// Get fields
		var form_id = formWrapper.attr( 'id' ),
			form = formWrapper.find( 'form' ).data( 'form' ),
			email_address = formWrapper.find( '.gp-post-submission-email-address' ).val(),
			subject = formWrapper.find( '.gp-post-submission-subject' ).val(),
			title = formWrapper.find( '.gp-post-form-title input' ).val(),
			featured_image = formWrapper.find( 'input[name="ghostpool_upload_image"]' ).val(),
			name = formWrapper.find( '.gp-post-form-name input' ).val(),
			email = formWrapper.find( '.gp-post-form-email input' ).val(),
			cats = formWrapper.find( '.gp-post-form-categories select' ).val(),
			formats = formWrapper.find( '.gp-post-form-formats select' ).val(),
			link = formWrapper.find( '.gp-post-form-link input' ).val(),
			content = formWrapper.find( '.gp-post-form-content textarea' ).val(),
			tags = formWrapper.find( '.gp-post-form-tags input' ).val(),
			tocCheckbox = formWrapper.find( '.gp-post-form-toc input' ),
			submit_status = formWrapper.find( '.gp-post-form-status' ).val(),
			email_notification = formWrapper.find( '.gp-post-form-notification' ).val(),
			edit_id = formWrapper.find( '.gp-edit-id' ).val();

		// Check if terms of use are checked
		if ( tocCheckbox.length > 0 && tocCheckbox.is( ':checked' ) ) {
			var toc = '1';
		} else if ( tocCheckbox.length > 0 && ! tocCheckbox.is( ':checked' ) ) {	
			toc = '0';
		} else {
			toc = '1';
		}

		// Get data ready for PHP
		var formParameters = {
			action: 'ghostpool_post_submission_action',		
			nonce: ghostpool_post_submission_ajax.nonce,
			form: form,
			form_id: form_id,
			email_address: email_address,
			subject: subject,
			title: title,
			featured_image: featured_image,
			name: name,
			email: email,
			cats: cats,
			formats: formats,
			link: link,
			content: content,
			tags: tags,
			toc: toc,
			submit_status: submit_status,
			email_notification: email_notification,
			edit_id: edit_id
		};

		// First post the content of form. content is always uploaded anyway
		// return the post_id
		// continue and upload the files
		// The multipart params for each file will be only the post_id
		$.ajax({
			type: 'POST',
			url: ghostpool_post_submission_ajax.ajaxurl,
			data: formParameters,
			dataType: 'json',
			success: function( data ) {
				gp_upload_files( data.post_id, data.status );
				console.log('data.post_id ' + data.post_id);
				console.log('data.status ' + data.status);
			},
			error: function( jqXHR, textStatus, errorThrown ) {
				//console.log('ajax error');
			}
		});

		// Called after the post has been created and post_id returned
		// Will upload all image, audio, and video files
		function gp_upload_files( postID, dataStatus ) {
			
			if ( postID && postID > 0 ) {
			
				var uploadFileParameters = {
					action: 'ghostpool_post_submission_action',		
					nonce: ghostpool_post_submission_ajax.nonce,
					post_id: postID,
					formWrapper: form
				}
				
				var uploadImage = $( '#gp-upload-image' ),
					uploadGallery = $( '.gp-show #gp-upload-gallery' ),
					uploadAudio = $( '.gp-show #gp-upload-audio' ),
					uploadVideo = $( '.gp-show #gp-upload-video' );
					
				// Upload images
				if ( ! formWrapper.hasClass( 'gp-image-upload-success' ) ) {
					if ( uploadImage.length > 0 && ImageUploader.files.length > 0 ) {
						ImageUploader.bind( 'BeforeUpload', function( up ) {
							ImageUploader.settings.multipart_params = uploadFileParameters;	
						});
						ImageUploader.start();
						ImageUploader.bind( 'UploadComplete', function( up, file ) {
							formWrapper.addClass( 'gp-image-upload-success' );
							gpProcessForm( formWrapper, dataStatus );
						});
					} else {
						formWrapper.addClass( 'gp-image-upload-success' );	
						gpProcessForm( formWrapper, dataStatus );
					}
				}	
				
				// Upload galleries
				if ( ! formWrapper.hasClass( 'gp-gallery-upload-success' ) ) {
					if ( uploadGallery.length > 0 && GalleryUploader.files.length > 0 ) {
						GalleryUploader.bind( 'BeforeUpload', function( up ) {
							GalleryUploader.settings.multipart_params = uploadFileParameters;									
						});
						GalleryUploader.start();
						GalleryUploader.bind( 'UploadComplete', function( up, files ) {
							formWrapper.addClass( 'gp-gallery-upload-success' );
							gpProcessForm( formWrapper, dataStatus );
						});
					} else {
						formWrapper.addClass( 'gp-gallery-upload-success' );	
						gpProcessForm( formWrapper, dataStatus );
					}
				}
										
				// Upload audio			
				if ( ! formWrapper.hasClass( 'gp-audio-upload-success' ) ) {
					if ( uploadAudio.length > 0 && AudioUploader.files.length > 0 ) {
						AudioUploader.bind( 'BeforeUpload', function( up ) {
							AudioUploader.settings.multipart_params = uploadFileParameters;									
						});
						AudioUploader.start();
						AudioUploader.bind( 'UploadComplete', function( up, file ) {
							formWrapper.addClass( 'gp-audio-upload-success' );
							gpProcessForm( formWrapper, dataStatus );		
						});
					} else {
						formWrapper.addClass( 'gp-audio-upload-success' );
						gpProcessForm( formWrapper, dataStatus );
					}
				}	
			
				// Upload videos
				if ( ! formWrapper.hasClass( 'gp-video-upload-success' ) ) {
					if ( uploadVideo.length > 0 && VideoUploader.files.length > 0 ) {
						VideoUploader.bind( 'BeforeUpload', function( up ) {
							VideoUploader.settings.multipart_params = uploadFileParameters;									
						});
						VideoUploader.start();
						VideoUploader.bind( 'UploadComplete', function( up, file ) {
							formWrapper.addClass( 'gp-video-upload-success' );
							gpProcessForm( formWrapper, dataStatus );	
						});
					} else {
						formWrapper.addClass( 'gp-video-upload-success' );
						gpProcessForm( formWrapper, dataStatus );
					}
				}	
				
			
			} else {
			
				formWrapper.addClass( 'gp-image-upload-success' );
				formWrapper.addClass( 'gp-gallery-upload-success' );
				formWrapper.addClass( 'gp-audio-upload-success' );
				formWrapper.addClass( 'gp-video-upload-success' );
				gpProcessForm( formWrapper, dataStatus );
				
			} // end postID check
			
		} // end function
		 				
	});
});