<?php get_header();

/**
 * Get settings
 *
 */
$settings = get_query_var( 'ghostpool_page_settings' );
if ( $settings &&  is_array( $settings ) ) {
	extract( $settings );
} ?>

<?php ghostpool_page_header( get_the_ID(), $header, $header_bg, $header_height ); ?>

<?php if ( 'gp-minimal-page-header' !== $header ) { ghostpool_page_title( '', $header ); } ?>

<div id="gp-content-wrapper" class="gp-container">

	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>

	<div id="gp-inner-container">

		<div id="gp-content">

			<?php if ( 'gp-minimal-page-header' === $header ) { ghostpool_page_title( '', $header ); } ?>
			
			<?php if ( isset( $_GET['post_edit'] ) && 1 == $_GET['post_edit'] && is_user_logged_in() && isset( $_GET['nonce'] ) && wp_verify_nonce( $_GET['nonce'], 'ghostpool_post_edit_action' ) ) { 
		
				echo do_shortcode( '[gp_post_submission_form_2]' );
	
			} elseif ( isset( $_GET['post_preview'] ) && $_GET['post_preview'] == 1 && isset( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'ghostpool_post_preview_action' ) ) { 
	
				get_template_part( 'lib/sections/post-submission/post-preview' );	
	
			} elseif ( ghostpool_option( 'post_submission_list_page' ) && is_page( ghostpool_option( 'post_submission_list_page' ) ) ) {
	
				get_template_part( 'lib/sections/post-submission/post-list' );
				
			} else {		

				if ( ! function_exists( 'elementor_theme_do_location' ) OR ! elementor_theme_do_location( 'single' ) ) {
					get_template_part( 'lib/sections/single/page-content' ); 
				}	
				
			} ?>
			
		</div>

		<?php get_sidebar( 'left' ); ?>

		<?php get_sidebar( 'right' ); ?>

	</div>

	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>

	<div class="gp-clear"></div>

</div>

<?php get_footer();