<?php 

/**
 * Get settings
 *
 *
 */
$settings = get_query_var( 'ghostpool_loop_settings' );
if ( $settings &&  is_array( $settings ) ) {
	extract( $settings );
} else {
	$settings = get_query_var( 'ghostpool_page_settings' );
	if ( $settings && is_array( $settings ) ) {
		extract( $settings );
	}
}
					
?>

<?php if ( $counter % $per_page == 2 OR $counter == 2 ) { ?>
	</div>
	<div class="gp-small-posts">
<?php } elseif ( $counter % $per_page == 1 OR $counter == 1 ) { ?>
	<div class="gp-large-post">
<?php } ?>

	<section <?php post_class( 'gp-post-item' ); ?>>

		<?php if ( ( ! has_post_thumbnail() && get_post_format() != 'video' ) && $ranking == 'gp-ranking' ) { ?>
			<span class="gp-ranking-counter"><?php echo absint( $ranking_counter ); ?></span>
		<?php } ?>
	
		<?php if ( ( has_post_thumbnail() OR $image_source ) && ( ! get_post_meta( get_the_ID(), 'gp_gallery_slider', true ) ) ) { ?>

			<div class="gp-post-thumbnail gp-loop-featured">
				<a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'gp_link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo esc_attr( get_post_meta( get_the_ID(), 'gp_link_target', true ) ); ?>"<?php } ?>>
					<?php if ( $ranking == 'gp-ranking' ) { ?>
						<span class="gp-ranking-counter"><?php echo absint( $ranking_counter ); ?></span>
					<?php } ?>
					<?php get_template_part( 'lib/sections/taxonomies/loop-featured-image' ); ?>
				</a>					
			</div>

		<?php } elseif ( get_post_format() == 'gallery' && get_post_meta( get_the_ID(), 'gp_gallery_slider', true ) ) { ?>

			<div class="gp-post-gallery gp-loop-featured">
				<?php if ( $ranking == 'gp-ranking' && $ranking_counter > 0 ) { ?>
					<span class="gp-ranking-counter"><?php echo absint( $ranking_counter ); ?></span>
				<?php } ?>
				<?php get_template_part( 'lib/sections/taxonomies/loop-gallery-slider' ); ?>
			</div>	

		<?php } elseif ( get_post_format() == 'video' ) { ?>
			
			<div class="gp-post-video gp-loop-featured"<?php if ( $format == 'gp-posts-list' ) { ?> style="width: <?php echo absint( $image['width'] ); ?>px;"<?php } ?>>
				<?php if ( $ranking == 'gp-ranking' && $ranking_counter > 0 ) { ?>
					<span class="gp-ranking-counter"><?php echo absint( $ranking_counter ); ?></span>
				<?php } ?>
				<?php get_template_part( 'lib/sections/taxonomies/loop-video' ); ?>
			</div>

		<?php } ?>

		<?php if ( get_post_format() == 'audio' && $counter == 1 ) { ?>
			<div class="gp-post-audio gp-loop-featured">
				<?php get_template_part( 'lib/sections/taxonomies/loop-audio' ); ?>
			</div>
		<?php } ?>
										
		<div class="gp-loop-content">	
		
			<?php if ( get_post_format() == 'audio' && $counter > 1 ) { ?>
				<div class="gp-post-audio gp-loop-featured">
					<?php get_template_part( 'lib/sections/taxonomies/loop-audio' ); ?>
				</div>
			<?php } ?>

			<h2 class="gp-loop-title"><a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'gp_link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo esc_attr( get_post_meta( get_the_ID(), 'gp_link_target', true ) ); ?>"<?php } ?>><?php the_title(); ?></a></h2>

			<?php if ( $style == 'gp-style-modern' ) {
				 get_template_part( 'lib/sections/taxonomies/loop-meta' ); 
			} ?>
		
			<?php if ( $excerpt_length != 0 ) { ?>
				<div class="gp-loop-text">
					<p><?php echo ghostpool_excerpt( $settings ); ?></p>
				</div>
			<?php } ?>

			<?php if ( $style == 'gp-style-classic' ) {
				 get_template_part( 'lib/sections/taxonomies/loop-meta' );
			} ?>

			<?php if ( $meta_tags ) { the_tags( '<div class="gp-loop-tags">', ' ', '</div>' ); } ?>

		</div>

	</section>

<?php if ( ( $counter % $per_page == 0 ) OR $counter == $post_count ) { ?>
	</div>
<?php }