<?php

/* Page/paged query
 *
 */	
if ( ! function_exists( 'ghostpool_paged' ) ) {
	function ghostpool_paged() {
		if ( get_query_var( 'paged' ) ) {
			return get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			return get_query_var( 'page' );
		} else {
			return 1;
		}
	}
}	

/**
 * Get categories
 *
 */
if ( ! function_exists( 'ghostpool_cats' ) ) {
	function ghostpool_cats( $terms = '' ) {
		
		if ( empty( $terms ) ) {
			return;
		}
		
		if ( preg_match( '/^[1-9, ][0-9, ]*$/', $terms ) ) {
			$field = 'term_id';
		} else {
			$field = 'slug';
		}
		
		$taxonomies = get_taxonomies();
		if ( $taxonomies ) {
			foreach( $taxonomies as $taxonomy ) {		

				if ( $terms ) {
					$term_array = explode( ',', $terms );
					foreach( $term_array as $term ) {	
						if ( ! empty( $term ) && ! is_wp_error( $term ) ) {	
							$tax_query[] = array(
								'taxonomy' => $taxonomy,
								'field' => $field,
								'terms' => $term,
							);	
						}	
					}
				}
				
			}
		}

		return array( 'relation' => 'OR' ) + $tax_query;
						
	}
}		

/**
 * Get orderby values
 *
 */
if ( ! function_exists( 'ghostpool_orderby' ) ) {
	function ghostpool_orderby( $value, $type = '' ) {
	
		$orderby = '';
		$order = '';	
		$meta_key = '';		
		$meta_query = '';

		if ( $value == 'newest' ) {
			$orderby = 'date';
			$order = 'desc';
		} elseif ( $value == 'oldest' ) {
			$orderby = 'date';
			$order = 'asc';		
		} elseif ( $value  == 'title_az' ) {
			$orderby = 'title';
			$order = 'asc';
		} elseif ( $value  == 'title_za' ) {
			$orderby = 'title';
			$order = 'desc';								
		} elseif ( $value == 'comment_count' ) {
			$orderby = 'comment_count';
			$order = 'desc';
		} elseif ( $value == 'views' ) {
			$orderby = 'meta_value_num';
			$order = 'desc';
			$meta_key = apply_filters( 'ghostpool_views_meta_key', 'views_total' );	
		} elseif ( $value == 'likes' ) {
			$orderby = 'meta_value_num';
			$order = 'desc';
			$meta_key = 'ghostpool_voting_up';
		} elseif ( $value == 'menu_order' ) {
			$orderby = 'menu_order';
			$order = 'asc';
		} elseif ( $value == 'rand' ) {
			$orderby = 'rand';
			$order = 'asc';	
		} elseif ( $value == 'relevance' ) {
			$orderby = 'relevance';
			$order = 'desc';
		}
					
		if ( $type == 'orderby' ) {
			return $orderby;
		} elseif ( $type == 'order' ) {	
			return $order;
		} elseif ( $type == 'meta_key' ) {
			return $meta_key;
		} elseif ( $type == 'meta_query' ) {
			return array(
				'relation' => 'AND',
				$meta_query
			);
		}	

	}
}

/**
 * Alter taxonomy queries
 *
 */	
if ( ! function_exists( 'ghostpool_category_queries' ) ) {
	function ghostpool_category_queries( $query ) {	
		if ( is_admin() OR ! $query->is_main_query() ) { 
			return;
		} elseif ( is_archive() OR is_search() OR is_author() OR $query->get( 'wc_query' ) === 'product_query' ) {

			// Load variables for specific taxonomy type
			if ( function_exists( 'is_woocommerce' ) && is_shop() ) {
				$per_page = ghostpool_option( 'wc_shop_per_page' );
			} elseif ( function_exists( 'is_woocommerce' ) && is_woocommerce() && ( is_product_category() OR is_product_tag() OR is_tax() ) ) {
				$per_page = ghostpool_option( 'wc_product_cat_per_page' );	
			} elseif ( is_search() ) {
				$orderby = ghostpool_option( 'search_orderby' );
				$per_page = ghostpool_option( 'search_per_page' );
				$post_type = ghostpool_option( 'search_post_types' );
			} elseif ( is_author() ) {
				$orderby = ghostpool_option( 'author_orderby' );
				$per_page = ghostpool_option( 'author_per_page' );
				$post_type = ghostpool_option( 'author_post_types' );	
			} elseif ( is_archive() ) {
				$orderby = ghostpool_option( 'cat_orderby' );
				$per_page = ghostpool_option( 'cat_per_page' );
			}

			// Set global taxonomy queries
			if ( isset( $per_page ) ) {
				$query->set( 'posts_per_page', $per_page );
			}
			if ( isset( $orderby ) ) {
				$query->set( 'orderby', ghostpool_orderby( $orderby, 'orderby' ) );	
				$query->set( 'order', ghostpool_orderby( $orderby, 'order' ) );
				$query->set( 'meta_key', ghostpool_orderby( $orderby, 'meta_key' ) );
			}
			if ( isset( $post_type ) ) {
				$query->set( 'post_type', $post_type );
			}
			if ( isset( $meta_query ) ) {
				$query->set( 'meta_query', $meta_query );
			}
			
			return;
		}
	}
}	
add_action( 'pre_get_posts', 'ghostpool_category_queries', 1 );

/**
 * Load category and orderby filters
 *
 */
if ( ! function_exists( 'ghostpool_filter' ) ) {
	function ghostpool_filter( $args ) {
	
		$defaults = array(
			'filters' => array(), 
			'filter_cat_id' => '', 
			'orderby' => '', 
			'pagination' => '', 
			'on_page' => true,
		);
		
		$args = wp_parse_args( $args, $defaults );
			
		extract( $args );
		
		// Sorting options
		$relevance = isset( $filters['relevance'] ) ? $filters['relevance'] : '';
		$date = isset( $filters['date'] ) ? $filters['date'] : '';
		$title = isset( $filters['title'] ) ? $filters['title'] : '';
		$comment_count = isset( $filters['comment_count'] ) ? $filters['comment_count'] : '';
		$views = isset( $filters['views'] ) ? $filters['views'] : '';
		$likes = isset( $filters['likes'] ) ? $filters['likes'] : '';

		if ( ( $filter_cat_id != '' OR $relevance OR $date OR $title OR $comment_count OR $views OR $likes ) && ghostpool_option( 'ajax' ) == 'gp-ajax-loop' && $pagination != 'load-more' ) { ?>
		
			<?php if ( $on_page == true ) { ?><div class="gp-filter-wrapper"><?php } ?>
			
				<div class="gp-filter-menus">

					<?php if ( $filter_cat_id != '' ) { 

						// Add slug support for filter categories option
						if ( ! is_numeric( $filter_cat_id ) ) {
							$cats_slug = get_term_by( 'slug', $filter_cat_id, 'category' );
							if ( $cats_slug ) {
								$filter_cat_id = $cats_slug->term_id;
							}
						}
						
						$term = term_exists( (int) $filter_cat_id, 'category' );
						if ( $term === 0 OR $term === null ) {
							$filter_cat_id = '';
						}

						$args = array(
							'taxonomy'   => 'category',
							'parent' 	 => (int) $filter_cat_id,
							'hide_empty' => false,
						);	
						
						$terms = get_terms( $args );				
		
						if ( $terms ) { ?>
							<select name="gp-filter-cats" class="gp-filter-menu gp-filter-cats">	
								<option value="<?php echo esc_attr( $filter_cat_id ); ?>"><?php esc_html_e( 'All', 'aardvark' ); ?></option>		
								<?php foreach( $terms as $term ) {
									if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) { ?>
										<option value="<?php echo esc_attr( $term->term_id ); ?>"><?php echo esc_attr( $term->name ); ?></option>
									<?php } ?>
								<?php } ?>
							</select>
						<?php } ?>
					<?php }
		
					if ( $relevance OR $date OR $title OR $comment_count OR $views OR $likes ) { ?>

						<select name="gp-filter-orderby" class="gp-filter-menu gp-filter-orderby">

							<?php if ( ( isset( $filters['relevance'] ) && $filters['relevance'] == '1' ) ) { ?>
								<option value="relevance"<?php if ( $orderby == 'relevance' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Relevance', 'aardvark' ); ?></option>
							<?php } ?>
					
							<?php if ( $date ) { ?>
								<option value="newest"<?php if ( $orderby == 'newest' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Newest', 'aardvark' ); ?></option>
								<option value="oldest"<?php if ( $orderby == 'oldest' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Oldest', 'aardvark' ); ?></option>
							<?php } ?>

							<?php if ( $title ) { ?>
								<option value="title_az"<?php if ( $orderby == 'title_az' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Title (A-Z)', 'aardvark' ); ?></option>
								<option value="title_za"<?php if ( $orderby == 'title_za' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Title (Z-A)', 'aardvark' ); ?></option>
							<?php } ?>		
									
							<?php if ( $comment_count ) { ?>
								<option value="comment_count"<?php if ( $orderby == 'comment_count' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Most Comments', 'aardvark' ); ?></option>
							<?php } ?>		
				
							<?php if ( $views ) { ?>
								<option value="views"<?php if ( $orderby == 'views' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Most Views', 'aardvark' ); ?></option>
							<?php } ?>

							<?php if ( $likes ) { ?>
								<option value="likes"<?php if ( $orderby == 'likes' ) { ?> selected="selected"<?php } ?>><?php esc_html_e( 'Most Likes', 'aardvark' ); ?></option>
							<?php } ?>
														
						</select>

					<?php } ?>			
			
				</div>
			
			<?php if ( $on_page == true ) { ?></div><?php } ?>
						
		<?php }
	}
}

/**
 * Get total search results number
 *
 */
if ( ! function_exists( 'ghostpool_search_results_total' ) ) {
	function ghostpool_search_results_total( $query = '' ) {	
		if ( $query > 1 ) {
			$results_text = esc_html__( 'results found', 'aardvark' );
		} else {
			$results_text = esc_html__( 'result found', 'aardvark' );
		}	
		return '<div class="gp-divider-title-bg"><div class="gp-divider-title">' . absint( $query ) . ' ' . $results_text . '</div></div>';
	}
}

/**
 * Storing WordPress Popular Posts views as meta key
 *
 */
if ( ! function_exists( 'ghostpool_wpp_postviews' ) ) {
	function ghostpool_wpp_postviews( $post_id ) {
		// Accuracy:
		//   10  = 1 in 10 visits will update view count. (Recommended for high traffic sites.)
		//   30 = 30% of visits. (Medium traffic websites)
		//   100 = Every visit. Creates many db write operations every request.
		$accuracy = apply_filters( 'ghostpool_wpp_postviews_accuracy', '50' );
		if ( function_exists( 'wpp_get_views' ) && ( mt_rand( 0, 100 ) < $accuracy ) ) {
			update_post_meta( $post_id, 'views_total', (int) wpp_get_views( $post_id, '', false ) );
			//update_post_meta( $post_id, 'views_daily', wpp_get_views( $post_id, 'daily' )  );
			//update_post_meta( $post_id, 'views_weekly', wpp_get_views( $post_id, 'weekly' ) );
			//update_post_meta( $post_id, 'views_monthly', wpp_get_views( $post_id, 'monthly' ) );
		}
	}
}
add_action( 'wpp_post_update_views', 'ghostpool_wpp_postviews' );