<?php

/**
 * Remove hentry tag from post loop
 *
 */
if ( ! function_exists( 'ghostpool_remove_hentry' ) ) {
	function ghostpool_remove_hentry( $classes ) {
		$classes = array_diff( $classes, array( 'hentry' ) );
		return $classes;
	}
}
add_filter( 'post_class', 'ghostpool_remove_hentry' );


/**
 * Exclude categories from post loop
 *
 */
if ( ! function_exists( 'ghostpool_exclude_cats' ) ) {
	function ghostpool_exclude_cats( $post_id, $no_comma = false ) {
					
		// Get all post categories
		$cats = wp_get_object_terms( $post_id, 'category', array( 'fields' => 'ids' ) );
					
		// Construct categories loop
		if ( ! empty( $cats ) && ! is_wp_error( $cats ) ) { 		
			$cat_link = '';
			foreach( $cats as $cat ) {
				if ( has_term( $cat, 'category', $post_id ) ) {
					$term = get_term( $cat, 'category' );
					$term_link = get_term_link( $term, 'category' );	
					if ( ! $term_link OR is_wp_error( $term_link ) ) {
						continue;
					}
					$term_id = $term->term_id;
					$tax = get_option( "taxonomy_$term_id" );
					if ( isset( $tax['exclude'] ) && $tax['exclude'] == 'enabled' ) {
					} else {
						if ( $no_comma == true ) {
							$cat_link .= '<a href="' . esc_url( $term_link ) . '">' . esc_attr( $term->name ) . '</a>';
						} else {
							$cat_link .= '<a href="' . esc_url( $term_link ) . '">' . esc_attr( $term->name ) . '</a>, ';
						}
					}	
				}
			}
			$cat_link = rtrim ( $cat_link, ', ' );
			return $cat_link;
		}

	}
}

/**
 * Change excerpt character length
 *
 */	
if ( ! function_exists( 'ghostpool_excerpt_length' ) ) {
	function ghostpool_excerpt_length() {
		if ( function_exists( 'buddyboss_global_search_init' ) && is_search() ) {
			return 50;
		} else {
			return 10000;
		}	
	}
}
add_filter( 'excerpt_length', 'ghostpool_excerpt_length' );

/**
 * Custom excerpt format
 *
 */	
if ( ! function_exists( 'ghostpool_excerpt' ) ) {
	function ghostpool_excerpt( $args ) {
	
		$defaults = array(
			'excerpt_length' => 0,
			'read_more_link' => 'disabled', 
			'style' => '',
		);	

		$args = wp_parse_args( $args, $defaults );
			
		extract( $args );
	
		if ( $read_more_link == 'enabled' ) {
			if ( $style == 'gp-style-modern' ) {
				$more_text = '...<a href="' . esc_url( get_permalink( get_the_ID() ) ) . '" class="gp-read-more" title="' . the_title_attribute( 'echo=0&post=' . get_the_ID() ) . '"><span class="button">' . esc_html__( 'Read More', 'aardvark' ) . '</span></a>';
			} else {
				$more_text = '...<a href="' . esc_url( get_permalink( get_the_ID() ) ) . '" class="gp-read-more" title="' . the_title_attribute( 'echo=0&post=' . get_the_ID() ) . '">' . esc_html__( 'Read More', 'aardvark' ) . '</a>';
			}	
		} else {
			$more_text = '...';
		}
		$excerpt = get_the_excerpt();					
		$excerpt = strip_tags( $excerpt );
		if ( function_exists( 'mb_strlen' ) && function_exists( 'mb_substr' ) ) { 
			if ( mb_strlen( $excerpt ) > $excerpt_length ) {
				$excerpt = mb_substr( $excerpt, 0, (int) $excerpt_length ) . $more_text;
			}
		} else {
			if ( strlen( $excerpt ) > $excerpt_length ) {
				$excerpt = substr( $excerpt, 0, (int) $excerpt_length ) . $more_text;
			}	
		}
		return $excerpt;
	}
}