<?php if ( ! function_exists( 'ghostpool_load_settings' ) ) {
	function ghostpool_load_settings() {
	
		$settings = array();
	
		$height = get_post_meta( get_the_ID(), 'gp_page_header_height', true );
		$height = isset( $height['height'] ) ? $height['height'] : '';
	
		/*--------------------------------------------------------------
		BuddyPress
		--------------------------------------------------------------*/

		if ( function_exists( 'bp_is_active' ) && ! bp_is_blog_page() ) {

			if ( bp_is_user() ) {

				$settings = array(

					'header' => ghostpool_option( 'bp_profile_page_header' ) != 'default' ? ghostpool_option( 'bp_profile_page_header' ) : ghostpool_option( 'bp_page_header' ),
				
					'header_bg' => ghostpool_option( 'bp_members_page_header_bg' ) != '' ? ghostpool_option( 'bp_members_page_header_bg' ) : ghostpool_option( 'bp_page_header_bg' ),
		
					'header_height' => ghostpool_option( 'bp_profile_page_header_height', 'height' ) != '' ? ghostpool_option( 'bp_profile_page_header_height', 'height' ) : ghostpool_option( 'bp_page_header_height', 'height' ),	
		
					'layout' => ghostpool_option( 'bp_profile_layout' ) != 'default' ? ghostpool_option( 'bp_profile_layout' ) : ghostpool_option( 'bp_layout' ),
		
					'left_sidebar' => ghostpool_option( 'bp_members_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_members_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' ),
		
					'right_sidebar' => ghostpool_option( 'bp_members_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_members_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' ),
			
				);
			
				if ( bp_is_current_action( 'my-posts' ) OR bp_is_current_action( 'my-pending-posts' ) ) {
			
					$new_settings = array(
				
						'format' => apply_filters( 'ghostpool_approved_posts_format', 'gp-posts-list' ),
				
						'style' => apply_filters( 'ghostpool_approved_posts_style', 'gp-style-classic' ),
				
						'alignment' => apply_filters( 'ghostpool_approved_posts_alignment', 'gp-align-left' ),
			
						'image_source' => apply_filters( 'ghostpool_approved_posts_image_source', '' ),
			
						'image' => ghostpool_image_data( apply_filters( 'ghostpool_approved_posts_image', '75 x 75' ) ),
					
						'pagination' => apply_filters( 'ghostpool_approved_posts_pagination', 'enabled' ),
				
						'content_display' => apply_filters( 'ghostpool_approved_posts_content_display', 'excerpt' ),
				
						'excerpt_length' => apply_filters( 'ghostpool_approved_posts_excerpt_length', 200 ),
				
						'meta_author' => '',
				
						'meta_date' => '',
				
						'meta_comment_count' => '',
				
						'meta_views' => '',
				
						'meta_likes' => '',
				
						'meta_cats' => '',
				
						'meta_tags' => '',
				
					);
				
					$settings = array_merge( $settings, $new_settings );
				
				}						

			} elseif ( bp_is_activity_component() ) {		
		
				$settings = array(

					'header' => ghostpool_option( 'bp_activity_page_header' ) != 'default' ? ghostpool_option( 'bp_activity_page_header' ) : ghostpool_option( 'bp_page_header' ),
								
					'header_bg' => ghostpool_option( 'bp_activity_page_header_bg' ) != '' ? ghostpool_option( 'bp_activity_page_header_bg' ) : ghostpool_option( 'bp_page_header_bg' ),
		
					'header_height' => ghostpool_option( 'bp_activity_page_header_height', 'height' ) != '' ? ghostpool_option( 'bp_activity_page_header_height', 'height' ) : ghostpool_option( 'bp_page_header_height', 'height' ),
		
					'layout' => ghostpool_option( 'bp_activity_layout' ) != 'default' ? ghostpool_option( 'bp_activity_layout' ) : ghostpool_option( 'bp_layout' ),
		
					'left_sidebar' => ghostpool_option( 'bp_activity_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_activity_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' ),
		
					'right_sidebar' => ghostpool_option( 'bp_activity_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_activity_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' ),

				);
							
			} elseif ( bp_is_members_component() ) {
		
				$settings = array(

					'header' => ghostpool_option( 'bp_members_page_header' ) != 'default' ? ghostpool_option( 'bp_members_page_header' ) : ghostpool_option( 'bp_page_header' ),
				
					'header_bg' => ghostpool_option( 'bp_members_page_header_bg' ) != '' ? ghostpool_option( 'bp_members_page_header_bg' ) : ghostpool_option( 'bp_page_header_bg' ),
		
					'header_height' => ghostpool_option( 'bp_members_page_header_height', 'height' ) != '' ? ghostpool_option( 'bp_members_page_header_height', 'height' ) : ghostpool_option( 'bp_page_header_height', 'height' ),	
		
					'layout' => ghostpool_option( 'bp_members_layout' ) != 'default' ? ghostpool_option( 'bp_members_layout' ) : ghostpool_option( 'bp_layout' ),
		
					'left_sidebar' => ghostpool_option( 'bp_members_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_members_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' ),
		
					'right_sidebar' => ghostpool_option( 'bp_members_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_members_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' ),
			
				);
			
			} elseif ( bp_is_groups_component() ) {
		
				$settings = array(

					'header' => ghostpool_option( 'bp_groups_page_header' ) != 'default' ? ghostpool_option( 'bp_groups_page_header' ) : ghostpool_option( 'bp_page_header' ),
				
					'header_bg' => ghostpool_option( 'bp_groups_page_header_bg' ) != '' ? ghostpool_option( 'bp_groups_page_header_bg' ) : ghostpool_option( 'bp_page_header_bg' ),	
				
					'header_height' => ghostpool_option( 'bp_groups_page_header_height', 'height' ) != '' ? ghostpool_option( 'bp_groups_page_header_height', 'height' ) : ghostpool_option( 'bp_page_header_height', 'height' ),	
		
					'layout' => ghostpool_option( 'bp_groups_layout' ) != 'default' ? ghostpool_option( 'bp_groups_layout' ) : ghostpool_option( 'bp_layout' ),
		
					'left_sidebar' => ghostpool_option( 'bp_groups_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_groups_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' ),
		
					'right_sidebar' => ghostpool_option( 'bp_groups_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_groups_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' ),
			
				);
			
			} elseif ( bp_is_register_page() ) {
		
				$settings = array(

					'header' => ghostpool_option( 'bp_register_page_header' ) != 'default' ? ghostpool_option( 'bp_register_page_header' ) : ghostpool_option( 'bp_page_header' ),
		
					'header_bg' => ghostpool_option( 'bp_register_page_header_bg' ) != '' ? ghostpool_option( 'bp_register_page_header_bg' ) : ghostpool_option( 'bp_page_header_bg' ),
				
					'header_height' => ghostpool_option( 'bp_register_page_header_height', 'height' ) != '' ? ghostpool_option( 'bp_register_page_header_height', 'height' ) : ghostpool_option( 'bp_page_header_height', 'height' ),
		
					'layout' => ghostpool_option( 'bp_register_layout' ) != 'default' ? ghostpool_option( 'bp_register_layout' ) : ghostpool_option( 'bp_layout' ),
		
					'left_sidebar' => ghostpool_option( 'bp_register_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_register_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' ),
		
					'right_sidebar' => ghostpool_option( 'bp_register_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_register_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' ),
			
				);
			
			} elseif ( bp_is_activation_page() ) {
		
				$settings = array(

					'header' => ghostpool_option( 'bp_activate_page_header' ) != 'default' ? ghostpool_option( 'bp_activate_page_header' ) : ghostpool_option( 'bp_page_header' ),
					
					'header_bg' => ghostpool_option( 'bp_activate_page_header_bg' ) != '' ? ghostpool_option( 'bp_activate_page_header_bg' ) : ghostpool_option( 'bp_page_header_bg' ),
				
					'header_height' => ghostpool_option( 'bp_activate_page_header_height', 'height' ) != '' ? ghostpool_option( 'bp_activate_page_header_height', 'height' ) : ghostpool_option( 'bp_page_header_height', 'height' ),
		
					'layout' => ghostpool_option( 'bp_activate_layout' ) != 'default' ? ghostpool_option( 'bp_activate_layout' ) : ghostpool_option( 'bp_layout' ),
		
					'left_sidebar' => ghostpool_option( 'bp_activate_left_sidebar' ) != 'default' ? ghostpool_option( 'bp_activate_left_sidebar' ) : ghostpool_option( 'bp_left_sidebar' ),
		
					'right_sidebar' => ghostpool_option( 'bp_activate_right_sidebar' ) != 'default' ? ghostpool_option( 'bp_activate_right_sidebar' ) : ghostpool_option( 'bp_right_sidebar' ),
						
				);
											
			} else {
					
				$settings = array(

					'header' => ghostpool_option( 'bp_page_header' ),
				
					'header_bg' => ghostpool_option( 'bp_page_header_bg' ),
		
					'header_height' => ghostpool_option( 'bp_page_header_height', 'height' ),
		
					'layout' => ghostpool_option( 'bp_layout' ),
		
					'left_sidebar' => ghostpool_option( 'bp_left_sidebar' ),
		
					'right_sidebar' => ghostpool_option( 'bp_right_sidebar' ),
			
				);
							
			}
		

		/*--------------------------------------------------------------
		bbPress
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_bbpress' ) && is_bbpress() ) {
			
			$settings = array(
						
				'header' => ghostpool_option( 'bbpress_page_header' ),
			
				'header_bg' => ghostpool_option( 'bbpress_page_header_bg' ),
			
				'header_height' => ghostpool_option( 'bbpress_page_header_height', 'height' ),
		
				'layout' => ghostpool_option( 'bbpress_layout' ),
		
				'left_sidebar' => ghostpool_option( 'bbpress_left_sidebar' ),
		
				'right_sidebar' => ghostpool_option( 'bbpress_right_sidebar' ),			
		
			);
						
		/*--------------------------------------------------------------
		WooCommerce shop page
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_woocommerce' ) && is_shop() ) {
		
			$settings = array(

				'header' => ghostpool_option( 'wc_shop_page_header' ),
			
				'header_bg' => ghostpool_option( 'wc_shop_page_header_bg' ),
			
				'header_height' => ghostpool_option( 'wc_shop_page_header_height', 'height' ),

				'layout' => ghostpool_option( 'wc_shop_layout' ),
	
				'left_sidebar' => ghostpool_option( 'wc_shop_left_sidebar' ), 
	
				'right_sidebar' => ghostpool_option( 'wc_shop_right_sidebar' ),
		
			);

		/*--------------------------------------------------------------
		WooCommerce product categories/tags
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_woocommerce' ) && is_woocommerce() && ( is_product_category() OR is_product_tag() OR is_tax() ) ) {

			// Get tax option
			$tax = null;
			if ( isset( get_queried_object()->term_id ) ) {
				$term_id = get_queried_object()->term_id;
				$tax = get_option( "taxonomy_$term_id" );
			}			
		
			$settings = array(
		
				'header' => ( isset( $tax['page_header'] ) && $tax['page_header'] != 'default' ) ? $tax['page_header'] : ghostpool_option( 'wc_product_cat_page_header' ),
			
				'header_bg' => isset( $tax['page_header_bg'] ) ? $tax['page_header_bg'] : '',
			
				'header_height' => ghostpool_option( 'wc_product_cat_page_header_height', 'height' ),
		
				'layout' => ( isset( $tax['layout'] ) && $tax['layout'] != 'default' ) ? $tax['layout'] : ghostpool_option( 'wc_product_cat_layout' ),
		
				'left_sidebar' => ( isset( $tax['left_sidebar'] ) && $tax['left_sidebar'] != 'default' ) ? $tax['left_sidebar'] : ghostpool_option( 'wc_product_cat_left_sidebar' ), 
					
				'right_sidebar' => ( isset( $tax['right_sidebar'] ) && $tax['right_sidebar'] != 'default' ) ? $tax['right_sidebar'] : ghostpool_option( 'wc_product_cat_right_sidebar' ),
		
			);
				
		/*--------------------------------------------------------------
		WooCommerce products
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_woocommerce' ) && is_singular( 'product' ) ) {
		
			$settings = array(

				'header' => ( get_post_meta( get_the_ID(), 'gp_page_header', true ) && get_post_meta( get_the_ID(), 'gp_page_header', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_page_header', true ) : ghostpool_option( 'wc_product_page_header' ),

				'header_bg' => get_post_meta( get_the_ID(), 'gp_page_header_bg', true ),
			
				'header_height' => $height != '' ? $height : ghostpool_option( 'wc_product_page_header_height', 'height' ),
			
				'layout' => ( get_post_meta( get_the_ID(), 'gp_layout', true ) && get_post_meta( get_the_ID(), 'gp_layout', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_layout', true ) :	 ghostpool_option( 'wc_product_layout' ),
		
				'left_sidebar' => ( get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) && get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) : ghostpool_option( 'wc_product_left_sidebar' ),	
				
				'right_sidebar' => ( get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) && get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) : ghostpool_option( 'wc_product_right_sidebar' ),
		
			);
					
		/*--------------------------------------------------------------
		Sensei
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_sensei' ) && is_sensei() ) {
	
			if ( is_singular( 'lesson' ) OR is_singular( 'quiz' )  ) {
		
				$settings = array(

					'header' => ( get_post_meta( get_the_ID(), 'gp_page_header', true ) && get_post_meta( get_the_ID(), 'gp_page_header', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_page_header', true ) : ghostpool_option( 'lesson_page_header' ),

					'header_bg' => get_post_meta( get_the_ID(), 'gp_page_header_bg', true ),
		
					'header_height' => $height != '' ? $height : ghostpool_option( 'lesson_page_header_height', 'height' ),

					'layout' => ghostpool_option( 'lesson_layout' ),
		
					'left_sidebar' => ghostpool_option( 'lesson_left_sidebar' ),	
				
					'right_sidebar' => ghostpool_option( 'lesson_right_sidebar' ),
			
				);
							
			} elseif ( is_singular( 'course' ) ) {
		
				$settings = array(
			
					'header' => ( get_post_meta( get_the_ID(), 'gp_page_header', true ) && get_post_meta( get_the_ID(), 'gp_page_header', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_page_header', true ) : ghostpool_option( 'course_page_header' ),

					'header_bg' => get_post_meta( get_the_ID(), 'gp_page_header_bg', true ),
		
					'header_height' => $height != '' ? $height : ghostpool_option( 'course_page_header_height', 'height' ),

					'layout' => ghostpool_option( 'course_layout' ),
		
					'left_sidebar' => ghostpool_option( 'course_left_sidebar' ),	
				
					'right_sidebar' => ghostpool_option( 'course_right_sidebar' ),
			
				);
							
			} else {
		
				$settings = array(

					'header' => ghostpool_option( 'courses_page_header' ),

					'header_bg' => ghostpool_option( 'courses_page_header_bg' ),
		
					'header_height' => ghostpool_option( 'courses_page_header_height', 'height' ),
				
					'layout' => ghostpool_option( 'courses_layout' ),
		
					'left_sidebar' => ghostpool_option( 'courses_left_sidebar' ),	
				
					'right_sidebar' => ghostpool_option( 'courses_right_sidebar' ),
			
				);
							
			}
		
	
		/*--------------------------------------------------------------
		Search results
		--------------------------------------------------------------*/

		} elseif ( is_search() ) {

			$settings = array(

				'header' => ghostpool_option( 'search_page_header' ),

				'header_bg' => ghostpool_option( 'search_page_header_bg' ),

				'header_height' => ghostpool_option( 'search_page_header_height', 'height' ),

				'layout' => ghostpool_option( 'search_layout' ),

				'left_sidebar' => ghostpool_option( 'search_left_sidebar' ), 

				'right_sidebar' => ghostpool_option( 'search_right_sidebar' ),

				'format' => ghostpool_option( 'search_format' ),
			
				'style' => ghostpool_option( 'search_style' ),
			
				'alignment' => ghostpool_option( 'search_alignment' ),
			
				'post_types' => is_array( ghostpool_option( 'search_post_types' ) ) ? implode( ',', ghostpool_option( 'search_post_types' ) ) : ghostpool_option( 'search_post_types' ),
			
				'orderby' => ghostpool_option( 'search_orderby' ),
			
				'per_page' => ghostpool_option( 'search_per_page' ),
			
				'offset' => ghostpool_option( 'search_offset' ),
			
				'image_source' => ghostpool_option( 'search_image_source' ),
			
				'image' => ghostpool_image_data( ghostpool_option( 'search_image_size' ) ),	
			
				'content_display' => ghostpool_option( 'search_content_display' ),
			
				'excerpt_length' => ghostpool_option( 'search_excerpt_length' ),
			
				'meta_author' => ghostpool_option( 'search_meta', 'author' ),
			
				'meta_date' => ghostpool_option( 'search_meta', 'date' ),
			
			
				'meta_comment_count' => ghostpool_option( 'search_meta', 'comment_count' ),
			
				'meta_views' => ghostpool_option( 'search_meta', 'views' ),
			
				'meta_likes' => ghostpool_option( 'search_meta', 'likes' ),
			
				'meta_cats' => ghostpool_option( 'search_meta', 'cats' ),
			
				'meta_tags' => ghostpool_option( 'search_meta', 'tags' ),
			
				'read_more_link' => ghostpool_option( 'search_read_more_link' ),
			
				'pagination' => ghostpool_option( 'search_pagination' ),
			
				'filters' => ghostpool_option( 'search_filters' ),
			
			);

		/*--------------------------------------------------------------
		Author results
		--------------------------------------------------------------*/

		} elseif ( is_author() ) {
	
			$settings = array(
		
				'header' => ghostpool_option( 'author_page_header' ),
			
				'header_bg' => ghostpool_option( 'author_page_header_bg' ),
			
				'header_height' => ghostpool_option( 'author_page_header_height', 'height' ),

				'layout' => ghostpool_option( 'author_layout' ),

				'left_sidebar' => ghostpool_option( 'author_left_sidebar' ), 

				'right_sidebar' => ghostpool_option( 'author_right_sidebar' ),

				'format' => ghostpool_option( 'author_format' ),
			
				'style' => ghostpool_option( 'author_style' ),
			
				'alignment' => ghostpool_option( 'author_alignment' ),
			
				'post_types' => is_array( ghostpool_option( 'author_post_types' ) ) ? implode( ',', ghostpool_option( 'author_post_types' ) ) : ghostpool_option( 'author_post_types' ),
			
				'orderby' => ghostpool_option( 'author_orderby' ),
			
				'per_page' => ghostpool_option( 'author_per_page' ),
			
				'offset' => ghostpool_option( 'author_offset' ),

				'image_source' => ghostpool_option( 'author_image_source' ),
			
				'image' => ghostpool_image_data( ghostpool_option( 'author_image_size' ), ghostpool_option( 'author_format' ) ),
			
				'content_display' => ghostpool_option( 'author_content_display' ),
			
				'excerpt_length' => ghostpool_option( 'author_excerpt_length' ),
			
				'meta_author' => ghostpool_option( 'author_meta', 'author' ),
			
				'meta_date' => ghostpool_option( 'author_meta', 'date' ),
			
				'meta_comment_count' => ghostpool_option( 'author_meta', 'comment_count' ),
			
				'meta_views' => ghostpool_option( 'author_meta', 'views' ),
			
				'meta_likes' => ghostpool_option( 'author_meta', 'likes' ),
			
				'meta_cats' => ghostpool_option( 'author_meta', 'cats' ),
			
				'meta_tags' => ghostpool_option( 'author_meta', 'tags' ),
			
				'read_more_link' => ghostpool_option( 'author_read_more_link' ),
			
				'pagination' => ghostpool_option( 'author_pagination' ),
			
				'filter' => ghostpool_option( 'author_filters' ),
			
			);
		

		/*--------------------------------------------------------------
		Attachment page
		--------------------------------------------------------------*/

		} elseif ( is_attachment() ) {
		
			$settings = array(

				'header' => 'gp-standard-page-header',
		
				'layout' => apply_filters( 'ghostpool_attachment_layout', 'gp-no-sidebar' ),

				'left_sidebar' => apply_filters( 'ghostpool_attachment_left_sidebar', 'gp-left-sidebar' ),
		
				'right_sidebar' => apply_filters( 'ghostpool_attachment_right_sidebar', 'gp-right-sidebar' ),
	
			);			
											
		/*--------------------------------------------------------------
		Error 404 page
		--------------------------------------------------------------*/

		} elseif ( is_404() ) {
						
			$settings = array(

				'header' => 'gp-standard-page-header',

				'layout' => apply_filters( 'ghostpool_error_layout', 'gp-no-sidebar' ),

				'left_sidebar' => apply_filters( 'ghostpool_error_left_sidebar', 'gp-left-sidebar' ),
		
				'right_sidebar' => apply_filters( 'ghostpool_error_right_sidebar', 'gp-right-sidebar' ),
		
			);			
							
		/*--------------------------------------------------------------
		Post Categories, Archives & Tags
		--------------------------------------------------------------*/

		} elseif ( is_home() OR is_archive() ) {

			// Get tax option
			$tax = null;
			if ( isset( get_queried_object()->term_id ) ) {
				$term_id = get_queried_object()->term_id;
				$tax = get_option( "taxonomy_$term_id" );
			}

			$settings = array(

				'header' => ( isset( $tax['page_header'] ) && $tax['page_header'] != 'default' ) ? $tax['page_header'] : ghostpool_option( 'cat_page_header' ),
			
				'header_bg' => isset( $tax['page_header_bg'] ) ? $tax['page_header_bg'] : '',
			
				'header_height' => ghostpool_option( 'cat_page_header_height', 'height' ),
		
				'layout' => ( isset( $tax['layout'] ) && $tax['layout'] != 'default' ) ? $tax['layout'] : ghostpool_option( 'cat_layout' ),
		
				'left_sidebar' => ( isset( $tax['left_sidebar'] ) && $tax['left_sidebar'] != 'default' ) ? $tax['left_sidebar'] : ghostpool_option( 'cat_left_sidebar' ), 
					
				'right_sidebar' => ( isset( $tax['right_sidebar'] ) && $tax['right_sidebar'] != 'default' ) ? $tax['right_sidebar'] : ghostpool_option( 'cat_right_sidebar' ),
			
				'format' => ( isset( $tax['format'] ) && $tax['format'] != 'default' ) ? $tax['format'] : ghostpool_option( 'cat_format' ),
			
				'style' => ( isset( $tax['style'] ) && $tax['style'] != 'default' ) ? $tax['style'] : ghostpool_option( 'cat_style' ),
			
				'alignment' => ( isset( $tax['alignment'] ) && $tax['alignment'] != 'default' ) ? $tax['alignment'] : ghostpool_option( 'cat_alignment' ),
			
				'orderby' => ghostpool_option( 'cat_orderby' ),
			
				'per_page' => ghostpool_option( 'cat_per_page' ),
			
				'offset' => ghostpool_option( 'cat_offset' ),
			
				'image_source' => ghostpool_option( 'cat_image_source' ),
			
				'image' => ghostpool_image_data( ghostpool_option( 'cat_image_size' ), ( ( isset( $tax['format'] ) && $tax['format'] != 'default' ) ? $tax['format'] : ghostpool_option( 'cat_format' ) ) ),
			
				'content_display' => ghostpool_option( 'cat_content_display' ),	
			
				'excerpt_length' => ghostpool_option( 'cat_excerpt_length' ),	
			
				'meta_author' => ghostpool_option( 'cat_meta', 'author' ),
			
				'meta_date' => ghostpool_option( 'cat_meta', 'date' ),
			
				'meta_comment_count' => ghostpool_option( 'cat_meta', 'comment_count' ),
			
				'meta_views' => ghostpool_option( 'cat_meta', 'views' ),
			
				'meta_likes' => ghostpool_option( 'cat_meta', 'likes' ),
			
				'meta_cats' => ghostpool_option( 'cat_meta', 'cats' ),
			
				'meta_tags' => ghostpool_option( 'cat_meta', 'tags' ),
			
				'pagination' => ghostpool_option( 'cat_pagination' ),
			
				'filters' => ghostpool_option( 'cat_filters' ),
			
				'read_more_link' => ghostpool_option( 'cat_read_more_link' ),
			
			);
	
		/*--------------------------------------------------------------
		Posts
		--------------------------------------------------------------*/

		} elseif ( is_singular( 'post' ) ) {

			$settings = array(
			
				'header' => ( get_post_meta( get_the_ID(), 'gp_page_header', true ) && get_post_meta( get_the_ID(), 'gp_page_header', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_page_header', true ) : ghostpool_option( 'post_page_header' ),
			
				'header_bg' => get_post_meta( get_the_ID(), 'gp_page_header_bg', true ),
	
				'header_height' => $height != '' ? $height : ghostpool_option( 'post_page_header_height', 'height' ),

				'layout' => ( get_post_meta( get_the_ID(), 'gp_layout', true ) && get_post_meta( get_the_ID(), 'gp_layout', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_layout', true ) : 
				ghostpool_option( 'post_layout' ),
		
				'left_sidebar' => ( get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) && get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) : ghostpool_option( 'post_left_sidebar' ),	
				
				'right_sidebar' => ( get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) && get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) : ghostpool_option( 'post_right_sidebar' ),
		
			);


		/*--------------------------------------------------------------
		Blog page template
		--------------------------------------------------------------*/

		} elseif ( is_page_template( 'blog-template.php' ) ) {

			$meta = get_post_meta( get_the_ID(), 'gp_blog_meta', true );

			$settings = array(
			
				'header' => ( get_post_meta( get_the_ID(), 'gp_page_header', true ) && get_post_meta( get_the_ID(), 'gp_page_header', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_page_header', true ) : ghostpool_option( 'page_page_header' ),
			
				'header_bg' => get_post_meta( get_the_ID(), 'gp_page_header_bg', true ),
	
				'header_height' => $height != '' ? $height : ghostpool_option( 'page_page_header_height', 'height' ),
			
				'layout' => ( get_post_meta( get_the_ID(), 'gp_layout', true ) && get_post_meta( get_the_ID(), 'gp_layout', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_layout', true ) : ghostpool_option( 'page_layout' ),
			
				'left_sidebar' => ( get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) && get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) : ghostpool_option( 'page_left_sidebar' ),	
				
				'right_sidebar' => ( get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) && get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) : ghostpool_option( 'page_right_sidebar' ),
			
				'format' => get_post_meta( get_the_ID(), 'gp_blog_format', true ) ? get_post_meta( get_the_ID(), 'gp_blog_format', true ) : 'gp-posts-list',
			
				'style' => get_post_meta( get_the_ID(), 'gp_blog_style', true ) ? get_post_meta( get_the_ID(), 'gp_blog_style', true ) : 'gp-style-classic',
			
				'alignment' => get_post_meta( get_the_ID(), 'gp_blog_alignment', true ) ? get_post_meta( get_the_ID(), 'gp_blog_alignment', true ) : 'gp-align-left',
			
				'post_types' => get_post_meta( get_the_ID(), 'gp_blog_post_types', true ) ? get_post_meta( get_the_ID(), 'gp_blog_post_types', true ) : array( 'post' ),
			
				'page_ids' => get_post_meta( get_the_ID(), 'gp_blog_page_ids', true ),
			
				'cats' => get_post_meta( get_the_ID(), 'gp_blog_cats', true ),
			
				'tags' => get_post_meta( get_the_ID(), 'gp_blog_tags', true ),
			
				'orderby' => get_post_meta( get_the_ID(), 'gp_blog_orderby', true ) ? get_post_meta( get_the_ID(), 'gp_blog_orderby', true ) : 'newest',
			
				'per_page' => get_post_meta( get_the_ID(), 'gp_blog_per_page', true ) ? get_post_meta( get_the_ID(), 'gp_blog_per_page', true ) : 8,
			
				//'offset' => get_post_meta( get_the_ID(), 'gp_blog_offset', true ),

				'image_source' => get_post_meta( get_the_ID(), 'gp_blog_image_source', true ) ? get_post_meta( get_the_ID(), 'gp_blog_image_source', true ) : '',
			
				'image' => ghostpool_image_data( get_post_meta( get_the_ID(), 'gp_blog_image_size', true ), get_post_meta( get_the_ID(), 'gp_blog_format', true ) ? get_post_meta( get_the_ID(), 'gp_blog_format', true ) : 'gp-posts-list' ),
			
				'content_display' => get_post_meta( get_the_ID(), 'gp_blog_content_display', true ) ? get_post_meta( get_the_ID(), 'gp_blog_content_display', true ) : 'excerpt',	
			
				'excerpt_length' => get_post_meta( get_the_ID(), 'gp_blog_excerpt_length', true ) ? get_post_meta( get_the_ID(), 'gp_blog_excerpt_length', true ) : 100,
			
				'meta_author' => isset( $meta['author'] ) ? $meta['author'] : '',
			
				'meta_date' => isset( $meta['date'] ) ? $meta['date'] : '',
			
				'meta_comment_count' => isset( $meta['comment_count'] ) ? $meta['comment_count'] : '',
			
				'meta_views' => isset( $meta['views'] ) ? $meta['views'] : '',
			
				'meta_likes' => isset( $meta['likes'] ) ? $meta['likes'] : '',
			
				'meta_cats' => isset( $meta['cats'] ) ? $meta['cats'] : '',
			
				'meta_tags' => isset( $meta['tags'] ) ? $meta['tags'] : '',
			
				'filters' => get_post_meta( get_the_ID(), 'gp_blog_filters', true ), 
			
				'filter_cat_id' => get_post_meta( get_the_ID(), 'gp_blog_filter_cat_id', true ),
			
				'read_more_link' => get_post_meta( get_the_ID(), 'gp_blog_read_more_link', true ) ? get_post_meta( get_the_ID(), 'gp_blog_read_more_link', true ) : 'disabled',
			
				'pagination' => 'page-numbers',
			
			);
		
		
		/*--------------------------------------------------------------
		Pages
		--------------------------------------------------------------*/

		} else {
		
			$settings = array(

				'header' => ( get_post_meta( get_the_ID(), 'gp_page_header', true ) && get_post_meta( get_the_ID(), 'gp_page_header', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_page_header', true ) : ghostpool_option( 'page_page_header' ),

				'header_bg' => get_post_meta( get_the_ID(), 'gp_page_header_bg', true ),
	
				'header_height' => $height != '' ? $height : ghostpool_option( 'page_page_header_height', 'height' ),
			
				'layout' => ( get_post_meta( get_the_ID(), 'gp_layout', true ) && get_post_meta( get_the_ID(), 'gp_layout', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_layout', true ) : ghostpool_option( 'page_layout' ),
		
				'left_sidebar' => ( get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) && get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_left_sidebar', true ) : ghostpool_option( 'page_left_sidebar' ),	
				
				'right_sidebar' => ( get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) && get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_right_sidebar', true ) : ghostpool_option( 'page_right_sidebar' ),
		
			);
		
		}

		/*--------------------------------------------------------------
		Hide sidebar on PMP restricted pages
		--------------------------------------------------------------*/

		if ( function_exists( 'pmpro_has_membership_access' ) && pmpro_has_membership_access() == false && pmpro_getOption( 'pmp_hide_sidebars' ) == 'Yes' ) {
					
			$settings['layout'] = 'gp-no-sidebar';

		}
		
		$settings = apply_filters( 'ghostpool_page_settings', $settings );

		set_query_var( 'ghostpool_page_settings', $settings );
		
	}
}