<?php 

wp_enqueue_media();
wp_enqueue_script( 'ghostpool-media-field' );

echo '<div class="gp-media-field" data-id="' . sanitize_html_class( $id ) . '">';
		
	if ( 'audio' === $format ) {			

		echo '<div id="gp-media-preview-' . sanitize_html_class( $id ) .'" class="gp-media-preview">';
			if ( $value > 0 ) {
				echo '<img src="' . includes_url( '/images/media/audio.png' ) . '" class="gp-audio-video-thumbnail" alt="" />';
				echo '<strong>' . basename( get_attached_file( $value ) ) . '</strong>';
			}
		echo '</div>';

		$text = ( $value > 0 ) ? esc_html__( 'Change Audio', 'aardvark' ) : esc_html__( 'Add Audio', 'aardvark' );

		echo '<input type="button" id="gp-media-' . sanitize_html_class( $id ) . '" class="gp-media-button button button-primary" value="' . esc_attr( $text ) . '" data-add="' . esc_attr__( 'Add Audio', 'aardvark' ) . '" data-change="' . esc_attr__( 'Change Audio', 'aardvark' ) . '" />';

		$show_class = ( $value > 0 ) ? ' gp-show' : '';
		echo '<a class="gp-remove-media-button' . $show_class . '" id="gp-remove-media-' . sanitize_html_class( $id ) . '" href="#">' . esc_html__( 'Remove Audio', 'aardvark' ) . '</a>';

	} elseif ( 'video' === $format ) {			

		echo '<div id="gp-media-preview-' . sanitize_html_class( $id ) .'" class="gp-media-preview">';
			if ( $value > 0 ) {
				echo '<img src="' . includes_url( '/images/media/video.png' ) . '" class="gp-audio-video-thumbnail" alt="" />';
				echo '<strong>' . basename( get_attached_file( $value ) ) . '</strong>';
			}
		echo '</div>';

		$text = ( $value > 0 ) ? esc_html__( 'Change Video', 'aardvark' ) : esc_html__( 'Add Video', 'aardvark' );

		echo '<input type="button" id="gp-media-' . sanitize_html_class( $id ) . '" class="gp-media-button button button-primary" value="' . esc_attr( $text ) . '" data-add="' . esc_attr__( 'Add Video', 'aardvark' ) . '" data-change="' . esc_attr__( 'Change Video', 'aardvark' ) . '" />';

		$show_class = ( $value > 0 ) ? ' gp-show' : '';
		echo '<a class="gp-remove-media-button' . $show_class . '" id="gp-remove-media-' . sanitize_html_class( $id ) . '" href="#">' . esc_html__( 'Remove Video', 'aardvark' ) . '</a>';

	} else {			
	
		echo '<div id="gp-media-preview-' . sanitize_html_class( $id ) .'" class="gp-media-preview">';	
			if ( $value ) {							
				if ( is_numeric( $value ) ) {			
					$media_thumb = wp_get_attachment_image_src( $value, 'thumbnail' );
					$media_thumb = $media_thumb[0];
				} else {
					$media_thumb = $value;
				}		
				echo '<img src="' . esc_url( $media_thumb ) . '" class="gp-image-thumbnail" alt="" />';
			} elseif ( '' !== $default && ! is_numeric( $default ) ) {
				echo '<img src="' . esc_url( $default ) . '" class="gp-image-thumbnail" alt="" />';
			}
		echo '</div>';

		$text = ( '' !== $value ) ? esc_html__( 'Change Image', 'aardvark' ) : esc_html__( 'Add Image', 'aardvark' );

		echo '<input type="button" id="gp-media-' . sanitize_html_class( $id ) . '" class="gp-media-button button button-primary" value="' . esc_attr( $text ) . '" data-add="' . esc_attr__( 'Add Image', 'aardvark' ) . '" data-change="' . esc_attr__( 'Change Image', 'aardvark' ) . '" />';

		$show_class = ( '' !== $value ) ? ' gp-show' : '';
		echo '<a class="gp-remove-media-button' . $show_class . '" id="gp-remove-media-' . sanitize_html_class( $id ) . '" href="#">' . esc_html__( 'Remove Image', 'aardvark' ) . '</a>';
		
	}
	echo '<input type="hidden" id="' . sanitize_html_class( $id ) . '" name="' . esc_attr( $name ) . '" value="' . esc_attr( $value ) . '" />';
	
echo '</div>';	
