<?php 

if ( isset( $styling ) ) {

	// Setting title
	$wp_customize->add_setting( 
		$id,
		array(
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);		
	$wp_customize->add_control(
		new GhostPool_Title_Control( 
		$wp_customize,
		$id,
		array(
			'label'      => $title,
			'section'    => $section,
			'settings'   => $id,
			'type'       => 'title',
		) )
	);
	
	// Settings
	foreach( $styling as $k => $v ) {

		if ( 'dimensions' === $v['type'] ) {
		
			if ( is_array( $v['default'] ) ) {
			
				foreach( $v['default'] as $default_key => $default_value ) {

					$wp_customize->add_setting( 
						$id . '[' . $k . '][' . $default_key . ']',
						array(
							'default' => $default_value,
							'capability' => 'edit_theme_options',
							'type' => 'option',
							'sanitize_callback' => 'ghostpool_sanitize_dimensions',
						)
					);
					
					$wp_customize->add_control(
						$id . '[' . $k . '][' . $default_key . ']',
						array(
							'label'      => $v['title'] . ' (' . $units . ')',
							'section'    => $section,
							'settings'   => $id . '[' . $k . '][' . $default_key . ']',
							'type'       => 'text',
						)
					);
				
				}
				
			} else {			

				$wp_customize->add_setting( 
					$id . '[' . $k . ']',
					array(
						'default' => $v['default'],
						'capability' => 'edit_theme_options',
						'type' => 'option',
						'sanitize_callback' => 'ghostpool_sanitize_dimensions',
					)
				);
					
				$wp_customize->add_control(
					$id . '[' . $k . ']',
					array(
						'label'      => $v['title'] . ' (' . $units . ')',
						'section'    => $section,
						'settings'   => $id . '[' . $k . ']',
						'type'       => 'text',
					)
				);
			
			}
			
		} elseif ( 'color' === $v['type'] ) {
		
			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v['default'],
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_colors',
				)
			);
					
			$wp_customize->add_control(
				new WP_Customize_Color_Control( 
				$wp_customize,
				$id . '[' . $k . ']',
				array(
					'label'      => $v['title'],
					'section'    => $section,
					'settings'   => $id . '[' . $k . ']',
				) )
			);		
			
		} elseif ( 'color_rgba' === $v['type'] ) {
		
			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v['default'],
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_colors',
				)
			);
					
			$wp_customize->add_control(
				//new WP_Customize_Color_Control( 
				//$wp_customize,
					$id . '[' . $k . ']',
					array(
						'label'      => $v['title'],
						'section'    => $section,
						'settings'   => $id . '[' . $k . ']',
						'type' => 'text',
					) 
				//)
			);			
				
		} elseif ( 'icon' === $v['type'] ) {
		
			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v['default'],
					'capability' => 'edit_theme_options',
					'type' => 'option',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $k . ']',
				array(
					'label'      => $v['title'],
					'section'    => $section,
					'settings'   => $id . '[' . $k . ']',
					'type' => 'select',		
					'choices' => array_combine( ghostpool_icons(), ghostpool_icons() ),
				)
			);	
			
		} elseif ( 'media' === $v['type'] ) {
		
			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v['default'],
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_url_id',
				)
			);
					
			$wp_customize->add_control(
				new WP_Customize_Image_Control( 
				$wp_customize,
				$id . '[' . $k . ']',
				array(
					'label'      => $v['title'],
					'section'    => $section,
					'settings'   => $id . '[' . $k . ']',
				) )
			);
		
		} elseif ( 'extra_css' === $v['type'] ) {
			
			// TO DO
		
		}
		
	}
	
}