<?php

if ( isset( $options ) && ! empty( $options ) ) {

	// Setting title
	$wp_customize->add_setting( 
		$id,
		array(
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);		
	$wp_customize->add_control(
		new GhostPool_Title_Control( 
		$wp_customize,
		$id,
		array(
			'label'      => $title,
			'section'    => $section,
			'settings'   => $id,
			'type'       => 'title',
		) )
	);
	
	// Settings
	if ( empty( $data ) ) {
	
		foreach ( $options as $key => $title ) {

			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => 1,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_checkbox',
				)
			);
				
			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => $title,
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type' => 'checkbox',
				)
			);
			
		}	
			
	} else {	
			
		foreach ( $options as $key => $title ) {

			$wp_customize->add_setting( 
				$id . '[' . $key . ']',
				array(
					'default' => 1,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_checkbox',
				)
			);
		
			$wp_customize->add_control(
				$id . '[' . $key . ']',
				array(
					'label'      => $title,
					'section'    => $section,
					'settings'   => $id . '[' . $key . ']',
					'type' => 'checkbox',
				)
			);
	
		}
		
	}
		
} else {

	$wp_customize->add_setting( 
		$id,
		array(
			'default' => 1,
			'capability' => 'edit_theme_options',
			'type' => 'option',			
			'sanitize_callback' => 'ghostpool_customizer_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		$id,
		array(
			'label'      => $title,
			'section'    => $section,
			'settings'   => $id,
			'type' => 'checkbox',
		)
	);		
		
}	
						