<?php if ( ! function_exists( 'ghostpool_wpb_statistics_options' ) ) {

	function ghostpool_wpb_statistics_options() { 
	
		vc_map( array( 
			'name' => esc_html__( 'Statistics', 'aardvark' ),
			'base' => 'gp_statistics',
			'description' => esc_html__( 'Site statistics.', 'aardvark' ),
			'class' => 'wpb_vc_statistics',
			'controls' => 'full',
			'icon' => 'gp-icon-statistics',
			'category' => esc_html__( 'Theme', 'aardvark' ),
			'front_enqueue_css' => array( get_template_directory_uri() . '/lib/framework/page-builder/assets/page-builder.css' ),
			'params' => array(		

				array( 
					'heading' => esc_html__( 'Title', 'aardvark' ),
					'param_name' => 'title',
					'type' => 'textfield',
					'value' => '',
				),	
				array( 
					'heading' => esc_html__( 'Format', 'aardvark' ),
					'param_name' => 'format',
					'value' => array(
						esc_html__( 'Columns', 'aardvark' ) => 'gp-stats-columns',
						esc_html__( 'List', 'aardvark' ) => 'gp-stats-list',
					),
					'type' => 'dropdown',
				),							
				array(
				'param_name' => 'stats_divider',
				'type' => 'gp_divider',
				),
				array( 
				'heading' => esc_html__( 'Posts', 'aardvark' ),
				'param_name' => 'posts',
				'value' => array(
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
				),
				'type' => 'dropdown',
				'edit_field_class' => 'vc_col-xs-4',
				),
				array( 
				'heading' => esc_html__( 'Title', 'aardvark' ),
				'param_name' => 'posts_title',
				'value' => esc_html__( 'Posts', 'aardvark' ),
				'type' => 'textfield',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'posts', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Icon', 'aardvark' ),
				'param_name' => 'posts_icon',
				'type' => 'iconpicker',
				'value' => ghostpool_fontawesome_icons( 'fa fa-file-text-o' ),
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'posts', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Icon Color', 'aardvark' ),
				'param_name' => 'posts_icon_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'posts', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Title Color', 'aardvark' ),
				'param_name' => 'posts_title_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'posts', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Number Color', 'aardvark' ),
				'param_name' => 'posts_number_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'posts', 'value' => 'enabled' ),
				),
				array(
				'param_name' => 'posts_divider',
				'type' => 'gp_divider',
				),			
									
				array( 
				'heading' => esc_html__( 'Comments', 'aardvark' ),
				'param_name' => 'comments',
				'value' => array(
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
				),
				'type' => 'dropdown',
				'edit_field_class' => 'vc_col-xs-4',
				),
				array( 
				'heading' => esc_html__( 'Title', 'aardvark' ),
				'param_name' => 'comments_title',
				'value' => esc_html__( 'Comments', 'aardvark' ),
				'type' => 'textfield',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'comments', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Icon', 'aardvark' ),
				'param_name' => 'comments_icon',
				'type' => 'iconpicker',
				'value' => ghostpool_fontawesome_icons( 'fa fa-comment-o' ),
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'comments', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Icon Color', 'aardvark' ),
				'param_name' => 'comments_icon_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'comments', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Title Color', 'aardvark' ),
				'param_name' => 'comments_title_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'comments', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Number Color', 'aardvark' ),
				'param_name' => 'comments_number_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'comments', 'value' => 'enabled' ),
				),
				array(
				'param_name' => 'comments_divider',
				'type' => 'gp_divider',
				),	
							
				array( 
				'heading' => esc_html__( 'Activity', 'aardvark' ),
				'param_name' => 'activity',
				'value' => array(
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
				),
				'type' => 'dropdown',
				'edit_field_class' => 'vc_col-xs-4',
				),
				array( 
				'heading' => esc_html__( 'Title', 'aardvark' ),
				'param_name' => 'activity_title',
				'value' => esc_html__( 'Activity', 'aardvark' ),
				'type' => 'textfield',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'activity', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Icon', 'aardvark' ),
				'param_name' => 'activity_icon',
				'type' => 'iconpicker',
				'value' => ghostpool_fontawesome_icons( 'fa fa-commenting-o' ),
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'activity', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Icon Color', 'aardvark' ),
				'param_name' => 'activity_icon_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'activity', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Title Color', 'aardvark' ),
				'param_name' => 'activity_title_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'activity', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Number Color', 'aardvark' ),
				'param_name' => 'activity_number_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'activity', 'value' => 'enabled' ),
				),
				array( 
					'heading' => esc_html__( 'Type', 'aardvark' ),
					'param_name' => 'activity_type',
					'value' => 'activity_update',
					'type' => 'textfield',
					'edit_field_class' => 'vc_col-xs-4',
					'dependency' => array( 'element' => 'activity', 'value' => 'enabled' ),
				),
				
				array(
					'param_name' => 'activity_divider',
					'type' => 'gp_divider',
				),	
							
				array( 
				'heading' => esc_html__( 'Blogs', 'aardvark' ),
				'param_name' => 'blogs',
				'value' => array(
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
				),
				'type' => 'dropdown',
				'edit_field_class' => 'vc_col-xs-4',
				),
				array( 
				'heading' => esc_html__( 'Title', 'aardvark' ),
				'param_name' => 'blogs_title',
				'value' => esc_html__( 'Blogs', 'aardvark' ),
				'type' => 'textfield',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'blogs', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Icon', 'aardvark' ),
				'param_name' => 'blogs_icon',
				'type' => 'iconpicker',
				'value' => ghostpool_fontawesome_icons( 'fa fa-sitemap' ),
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'blogs', 'value' => 'enabled' ),
				),			
				array( 
				'heading' => esc_html__( 'Icon Color', 'aardvark' ),
				'param_name' => 'blogs_icon_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'blogs', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Title Color', 'aardvark' ),
				'param_name' => 'blogs_title_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'blogs', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Number Color', 'aardvark' ),
				'param_name' => 'blogs_number_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'blogs', 'value' => 'enabled' ),
				),	
				array(
				'param_name' => 'blogs_divider',
				'type' => 'gp_divider',
				),		
						
				array( 
				'heading' => esc_html__( 'Members', 'aardvark' ),
				'param_name' => 'members',
				'value' => array(
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
				),
				'type' => 'dropdown',
				'edit_field_class' => 'vc_col-xs-4',
				),
				array( 
				'heading' => esc_html__( 'Title', 'aardvark' ),
				'param_name' => 'members_title',
				'value' => esc_html__( 'Members', 'aardvark' ),
				'type' => 'textfield',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'members', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Members Icon', 'aardvark' ),
				'param_name' => 'members_icon',
				'type' => 'iconpicker',
				'value' => ghostpool_fontawesome_icons( 'fa fa-user-o' ),
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'members', 'value' => 'enabled' ),
				),			
				array( 
				'heading' => esc_html__( 'Icon Color', 'aardvark' ),
				'param_name' => 'members_icon_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'members', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Title Color', 'aardvark' ),
				'param_name' => 'members_title_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'members', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Number Color', 'aardvark' ),
				'param_name' => 'members_number_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'members', 'value' => 'enabled' ),
				),
				array(
				'param_name' => 'members_divider',
				'type' => 'gp_divider',
				),	
				
				array( 
				'heading' => esc_html__( 'Online', 'aardvark' ),
				'param_name' => 'online',
				'value' => array(
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
				),
				'type' => 'dropdown',
				'edit_field_class' => 'vc_col-xs-4',
				),
				array( 
				'heading' => esc_html__( 'Title', 'aardvark' ),
				'param_name' => 'online_title',
				'value' => esc_html__( 'Online', 'aardvark' ),
				'type' => 'textfield',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'online', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Online Icon', 'aardvark' ),
				'param_name' => 'online_icon',
				'type' => 'iconpicker',
				'value' => ghostpool_fontawesome_icons( 'fa fa-user-circle-o' ),
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'online', 'value' => 'enabled' ),
				),			
				array( 
				'heading' => esc_html__( 'Icon Color', 'aardvark' ),
				'param_name' => 'online_icon_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'online', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Title Color', 'aardvark' ),
				'param_name' => 'online_title_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'online', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Number Color', 'aardvark' ),
				'param_name' => 'online_number_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'online', 'value' => 'enabled' ),
				),
				array(
				'param_name' => 'online_divider',
				'type' => 'gp_divider',
				),	
												
				array( 
				'heading' => esc_html__( 'Groups', 'aardvark' ),
				'param_name' => 'groups',
				'value' => array(
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
				),
				'type' => 'dropdown',
				'edit_field_class' => 'vc_col-xs-4',
				),
				array( 
				'heading' => esc_html__( 'Title', 'aardvark' ),
				'param_name' => 'groups_title',
				'value' => esc_html__( 'Groups', 'aardvark' ),
				'type' => 'textfield',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'groups', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Groups Icon', 'aardvark' ),
				'param_name' => 'groups_icon',
				'type' => 'iconpicker',
				'value' => ghostpool_fontawesome_icons( 'fa fa-users' ),
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'groups', 'value' => 'enabled' ),
				),			
				array( 
				'heading' => esc_html__( 'Icon Color', 'aardvark' ),
				'param_name' => 'groups_icon_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'groups', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Title Color', 'aardvark' ),
				'param_name' => 'groups_title_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'groups', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Number Color', 'aardvark' ),
				'param_name' => 'groups_number_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'groups', 'value' => 'enabled' ),
				),
				array(
				'param_name' => 'groups_divider',
				'type' => 'gp_divider',
				),	
								
				array( 
				'heading' => esc_html__( 'Forums', 'aardvark' ),
				'param_name' => 'forums',
				'value' => array(
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
				),
				'type' => 'dropdown',
				'edit_field_class' => 'vc_col-xs-4',
				),
				array( 
				'heading' => esc_html__( 'Title', 'aardvark' ),
				'param_name' => 'forums_title',
				'value' => esc_html__( 'Forums', 'aardvark' ),
				'type' => 'textfield',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'forums', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Forums Icon', 'aardvark' ),
				'param_name' => 'forums_icon',
				'type' => 'iconpicker',
				'value' => ghostpool_fontawesome_icons( 'fa fa-list' ),
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'forums', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Icon Color', 'aardvark' ),
				'param_name' => 'forums_icon_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'forums', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Title Color', 'aardvark' ),
				'param_name' => 'forums_title_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'forums', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Number Color', 'aardvark' ),
				'param_name' => 'forums_number_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'forums', 'value' => 'enabled' ),
				),
				array(
				'param_name' => 'forums_divider',
				'type' => 'gp_divider',
				),		
				array( 
				'heading' => esc_html__( 'Topics', 'aardvark' ),
				'param_name' => 'topics',
				'value' => array(
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
				),
				'type' => 'dropdown',
				'edit_field_class' => 'vc_col-xs-4',
				),
				array( 
				'heading' => esc_html__( 'Title', 'aardvark' ),
				'param_name' => 'topics_title',
				'value' => esc_html__( 'Topics', 'aardvark' ),
				'type' => 'textfield',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'topics', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Topics Icon', 'aardvark' ),
				'param_name' => 'topics_icon',
				'type' => 'iconpicker',
				'value' => ghostpool_fontawesome_icons( 'fa fa-comments-o' ),
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'topics', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Icon Color', 'aardvark' ),
				'param_name' => 'topics_icon_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'topics', 'value' => 'enabled' ),
				),		
				array( 
				'heading' => esc_html__( 'Title Color', 'aardvark' ),
				'param_name' => 'topics_title_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'topics', 'value' => 'enabled' ),
				),
				array( 
				'heading' => esc_html__( 'Number Color', 'aardvark' ),
				'param_name' => 'topics_number_color',
				'value' => '',
				'type' => 'colorpicker',
				'edit_field_class' => 'vc_col-xs-4',
				'dependency' => array( 'element' => 'topics', 'value' => 'enabled' ),
				),
				array(
				'param_name' => 'topics_divider',
				'type' => 'gp_divider',
				),		

				array( 
				'heading' => esc_html__( 'Dummy Data', 'aardvark' ),
				'description' => esc_html__( 'Add dummy values to each enabled statistics (for testing purposes only).', 'aardvark' ),
				'param_name' => 'dummy_data',
				'value' => array(
					esc_html__( 'Disabled', 'aardvark' ) => 'disabled',
					esc_html__( 'Enabled', 'aardvark' ) => 'enabled',
				),
				'type' => 'dropdown',
				),					 
				array( 
				'heading' => esc_html__( 'Extra Class Name', 'aardvark' ),
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'aardvark' ),
				'param_name' => 'classes',
				'value' => '',
				'type' => 'textfield',
				),					
				array(
					'heading' => esc_html__( 'CSS', 'aardvark' ),
					'type' => 'css_editor',
					'param_name' => 'css',
					'group' => esc_html__( 'Design Options', 'aardvark' ),
				),
																																									
			 )
		) );
		
	}		
} 
add_action( 'vc_before_init', 'ghostpool_wpb_statistics_options' );