<?php if ( ! function_exists( 'ghostpool_aardvark_update_database' ) ) {
	function ghostpool_aardvark_update_database() {
	
		// If this is a new installation do not update the database 
		if ( ! get_option( 'ghostpool_aardvark_db_version' ) ) {
			update_option( 'ghostpool_aardvark_db_version', '4.11' ); // Update database version to latest version and then exit
			return;
		}
				
		/**
		 * Updating to v1.8
		 *
		 */	
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '1.8', '<' ) ) {

			global $wpdb;
	
			// Update vote down custom field name
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_voting_down', '_ghostpool_voting_down' ) );

			update_option( 'ghostpool_aardvark_db_version', '1.8' );
																						
		}
				
		/**
		 * Updating to v3.0
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '3.0', '<' ) ) {
			global $wpdb;
			
			// Update theme options keys/values
			$options = get_option( 'ghostpool_aardvark' );
			if ( $options ) {								
				foreach ( $options as $key => $option ) {
					if ( 'page_image' === $key ) {
						$options['page_featured_image'] = $option;
						unset( $key );
					} elseif ( 'post_image' === $key ) {
						$options['post_featured_image'] = $option;
						unset( $key );
					} elseif ( 'post_image_size' === $key ) {
						if ( 'default' === $option OR '' === $option ) {
							$options['post_image_size'] = '864 x 467';
						}
					} elseif ( 'cat_image_size' === $key ) {
						if ( 'default' === $option ) {
							$options['cat_image_size'] = '';
						}
					} elseif ( 'search_image_size' === $key ) {
						if ( 'default' === $option ) {
							$options['search_image_size'] = '';
						}
					} elseif ( 'author_image_size' === $key ) {
						if ( 'default' === $option ) {
							$options['author_image_size'] = '';
						}
					} elseif ( 'page_image_size' === $key ) {
						if ( 'default' === $option OR '' === $option ) {
							$options['page_image_size'] = '864 x 467';
						}
					}
				}
				update_option( 'ghostpool_aardvark', $options );
			}

			// Update custom field keys
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_cats', 'blog_cats' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_post_types', 'blog_post_types' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_format', 'blog_format' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_style', 'blog_style' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_alignment', 'blog_alignment' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_orderby', 'blog_orderby' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_per_page', 'blog_per_page' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_image_size', 'blog_image_size' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = REPLACE( meta_value, %s, %s ) WHERE meta_key = %s", 'default', '', 'gp_blog_image_size' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_content_display', 'blog_content_display' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_excerpt_length', 'blog_excerpt_length' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_meta', 'blog_meta' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_filters', 'blog_filters' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_filter_cat_id', 'blog_filter_cat_id' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_blog_read_more_link', 'blog_read_more_link' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_link', 'link' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_link_target', 'link_target' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_video_embed_url', 'video_embed_url' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_gallery_slider', 'gallery_slider' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_page_header_layout', 'page_header_layout' ) );

			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_page_header_display', 'page_header_display' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_page_footer_display', 'page_footer_display' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_page_header', 'page_header' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_page_header_video', 'page_header_video' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_page_header_video_bg', 'page_header_video_bg' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_custom_title', 'custom_title' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_subtitle', 'subtitle' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_layout', 'layout' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_left_sidebar', 'left_sidebar' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'gp_right_sidebar', 'right_sidebar' ) );
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'image', 'featured_image' ) );
			 
			 // Change specific custom field values from array to string value
			$args = array(
				'post_status' => 'any',
				'post_type' => 'any',
				'meta_key' => 'page_header_bg',
				'posts_per_page' => 300,
				'no_found_rows' => true,
			);
			$gp_query = new WP_Query( $args );
			if ( $gp_query->have_posts() ) :
				while ( $gp_query->have_posts() ) : $gp_query->the_post(); 			
					if ( $prev_value = get_post_meta( get_the_ID(), 'page_header_bg', true ) ) {
						if ( isset( $prev_value['id'] ) ) {
							$new_value = $prev_value['id'];
							update_post_meta( get_the_ID(), 'gp_page_header_bg', $new_value, $prev_value );
							delete_post_meta( get_the_ID(), 'page_header_bg' );
						}
					}										
				endwhile;
	 		else : 
	 			$next1 = true;
	 		endif; wp_reset_postdata();
	 		
	 		if ( isset( $next1 ) && true === $next1 ) {
				$args = array(
					'post_status' => 'any',
					'post_type' => 'any',
					'meta_key' => 'page_header_height',
					'posts_per_page' => 300,
					'no_found_rows' => true,
				);
				$gp_query = new WP_Query( $args );
				if ( $gp_query->have_posts() ) :
					while ( $gp_query->have_posts() ) : $gp_query->the_post(); 			
						if ( $prev_value = get_post_meta( get_the_ID(), 'page_header_height', true ) ) {
							if ( isset( $prev_value['height'] ) ) {
								$new_value = $prev_value['height'];
								update_post_meta( get_the_ID(), 'gp_page_header_height', $new_value, $prev_value );
								delete_post_meta( get_the_ID(), 'page_header_height' );
							}
						}										
					endwhile;
				else :  
					$next2 = true;
				endif; wp_reset_postdata();
			}	
	
			if ( isset( $next2 ) && true === $next2 ) {
				$args = array(
					'post_status' => 'any',
					'post_type' => 'any',
					'meta_key' => 'audio_mp3_url',
					'posts_per_page' => 300,
					'no_found_rows' => true,
				);
				$gp_query = new WP_Query( $args );
				if ( $gp_query->have_posts() ) :
					while ( $gp_query->have_posts() ) : $gp_query->the_post(); 			
						if ( $prev_value = get_post_meta( get_the_ID(), 'audio_mp3_url', true ) ) {
							if ( isset( $prev_value['id'] ) ) {
								$new_value = $prev_value['id'];
								update_post_meta( get_the_ID(), 'gp_audio_mp3_url', $new_value, $prev_value );
								delete_post_meta( get_the_ID(), 'audio_mp3_url' );
							}
						}										
					endwhile;
				else :  					
					$next3 = true;
				endif; wp_reset_postdata();
			}
			
			if ( isset( $next3 ) && true === $next3 ) {
				$args = array(
					'post_status' => 'any',
					'post_type' => 'any',
					'meta_key' => 'audio_ogg_url',
					'posts_per_page' => 300,
					'no_found_rows' => true,
				);
				$gp_query = new WP_Query( $args );
				if ( $gp_query->have_posts() ) :
					while ( $gp_query->have_posts() ) : $gp_query->the_post(); 			
						if ( $prev_value = get_post_meta( get_the_ID(), 'audio_ogg_url', true ) ) {
							if ( isset( $prev_value['height'] ) ) {
								$new_value = $prev_value['height'];
								update_post_meta( get_the_ID(), 'gp_audio_ogg_url', $new_value, $prev_value );
								delete_post_meta( get_the_ID(), 'audio_ogg_url' );
							}
						}										
					endwhile;
				else :  
	 				$next4 = true;
				endif; wp_reset_postdata();
			}
			
			if ( isset( $next4 ) && true === $next4 ) {				
				$args = array(
					'post_status' => 'any',
					'post_type' => 'any',
					'meta_key' => 'video_m4v_url',
					'posts_per_page' => 300,
					'no_found_rows' => true,
				);
				$gp_query = new WP_Query( $args );
				if ( $gp_query->have_posts() ) :
					while ( $gp_query->have_posts() ) : $gp_query->the_post(); 			
						if ( $prev_value = get_post_meta( get_the_ID(), 'video_m4v_url', true ) ) {
							if ( isset( $prev_value['id'] ) ) {
								$new_value = $prev_value['id'];
								update_post_meta( get_the_ID(), 'gp_video_m4v_url', $new_value, $prev_value );
								delete_post_meta( get_the_ID(), 'video_m4v_url' );
							}
						}									
					endwhile;
				else :  
					$next5 = true;
				endif; wp_reset_postdata();
			}
			
			if ( isset( $next5 ) && true === $next5 ) {			 		
			$args = array(
					'post_status' => 'any',
					'post_type' => 'any',
					'meta_key' => 'video_mp4_url',
					'posts_per_page' => 300,
					'no_found_rows' => true,
				);
				$gp_query = new WP_Query( $args );
				if ( $gp_query->have_posts() ) :
					while ( $gp_query->have_posts() ) : $gp_query->the_post(); 			
						if ( $prev_value = get_post_meta( get_the_ID(), 'video_mp4_url', true ) ) {
							if ( isset( $prev_value['id'] ) ) {
								$new_value = $prev_value['id'];
								update_post_meta( get_the_ID(), 'gp_video_mp4_url', $new_value, $prev_value );
								delete_post_meta( get_the_ID(), 'video_mp4_url' );
							}
						}											
					endwhile;
				else :  
					$next6 = true;
				endif; wp_reset_postdata();
			}

			if ( isset( $next6 ) && true === $next6 ) {						
				$args = array(
					'post_status' => 'any',
					'post_type' => 'any',
					'meta_key' => 'video_webm_url',
					'posts_per_page' => 300,
					'no_found_rows' => true,
				);
				$gp_query = new WP_Query( $args );
				if ( $gp_query->have_posts() ) :
					while ( $gp_query->have_posts() ) : $gp_query->the_post(); 			
						if ( $prev_value = get_post_meta( get_the_ID(), 'video_webm_url', true ) ) {
							if ( isset( $prev_value['id'] ) ) {
								$new_value = $prev_value['id'];
								update_post_meta( get_the_ID(), 'gp_video_webm_url', $new_value, $prev_value );
								delete_post_meta( get_the_ID(), 'video_webm_url' );
							}
						}										
					endwhile;
				else :  	 			 			 			 			 						
					$next7 = true;
				endif; wp_reset_postdata();
			}
			
			if ( isset( $next7 ) && true === $next7 ) {			
				$args = array(
					'post_status' => 'any',
					'post_type' => 'any',
					'meta_key' => 'video_ogv_url',
					'posts_per_page' => 300,
					'no_found_rows' => true,
				);
				$gp_query = new WP_Query( $args );
				if ( $gp_query->have_posts() ) :
					while ( $gp_query->have_posts() ) : $gp_query->the_post(); 			
						if ( $prev_value = get_post_meta( get_the_ID(), 'video_ogv_url', true ) ) {
							if ( isset( $prev_value['id'] ) ) {
								$new_value = $prev_value['id'];
								update_post_meta( get_the_ID(), 'gp_video_ogv_url', $new_value, $prev_value );
								delete_post_meta( get_the_ID(), 'video_ogv_url' );
							}
						}									
					endwhile;
				else :
					$next8 = true;
				endif; wp_reset_postdata();
			}
			
			if ( isset( $next8 ) && true === $next8 ) {		 			 		
				update_option( 'ghostpool_aardvark_db_version', '3.0' );	
			}
																				
		}

		/**
		 * Updating to v3.1
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '3.1', '<' ) ) {
			$options = get_option( 'ghostpool_aardvark' );
			if ( $options ) {								
				foreach ( $options as $key => $option ) {
					if ( '1' != ghostpool_option( 'post_meta', 'post_nav' ) ) {
						$options['post_navigation'] = 'disabled';
					} elseif ( '1' != ghostpool_option( 'post_meta', 'share_icons' ) ) {
						$options['share_icons'] = 'disabled';
					}
				}
				update_option( 'ghostpool_aardvark', $options );
			}
			update_option( 'ghostpool_aardvark_db_version', '3.1' );				
		}

		/**
		 * Updating to v4.0
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '4.0', '<' ) ) {
			
			$settings = array( 
				array( 
					'name' => 'header_width', 
					'new_name' => 'header_format', 
				),
				array( 
					'name' => 'desktop_header_height', 
					'variable' => 'height', 
					'px' => true,
				),
				array( 
					'name' => 'desktop_header_nav_height', 
					'variable' => 'height', 
					'px' => true,
				),
				array( 
					'name' => 'side_menu_header_height', 
					'variable' => 'height', 
					'px' => true,
				),
				array( 
					'name' => 'logo', 
					'variable' => 'url', 
					'new_variable' => 'standard', 
				), 
				array( 
					'name' => 'logo_retina', 
					'new_name' => 'logo',
					'variable' => 'url', 
					'new_variable' => 'retina', 
				),
				array( 
					'name' => 'logo_dimensions', 
					'new_name' => 'logo',
					'variable' => 'width',
					'new_variable' => 'width',
				),
				array( 
					'name' => 'logo_dimensions', 
					'new_name' => 'logo',
					'variable' => 'height',
					'new_variable' => 'height',
				),
				array( 
					'name' => 'main_header_secondary_nav_bg',
					'variable' => array( 'rgba', 'color', 'alpha' ),
				),
				array( 
					'name' => 'main_header_secondary_nav_bg_hover',
					'variable' => array( 'rgba', 'color', 'alpha' ),
				),
				array( 
					'name' => 'header_buttons_link_colors',
					'variable' => 'regular',
				),
				array( 
					'name' => 'header_buttons_link_colors',
					'new_name' => 'header_buttons_link_colors_hover',
					'variable' => 'hover',
				),
				array( 
					'name' => 'logo_scrolling',
					'variable' => 'url',
					'new_variable' => 'standard',
				),
				array( 
					'name' => 'logo_scrolling_retina',
					'new_name' => 'logo_scrolling',
					'variable' => 'url',
					'new_variable' => 'retina',
				),
				array( 
					'name' => 'logo_scrolling_dimensions', 
					'new_name' => 'logo_scrolling',
					'variable' => 'width',
					'new_variable' => 'width',
				),
				array( 
					'name' => 'logo_scrolling_dimensions', 
					'new_name' => 'logo_scrolling',
					'variable' => 'height',
					'new_variable' => 'height',
				),
				array( 
					'name' => 'main_header_scrolling_bg',
					'variable' => array( 'rgba', 'color', 'alpha' ),
				),
				array( 
					'name' => 'main_header_scrolling_nav_bg',
					'variable' => array( 'rgba', 'color', 'alpha' ),
				),
				
				array( 
					'name' => 'logo_overlay',
					'variable' => 'url',
					'new_variable' => 'standard',
				),
				array( 
					'name' => 'logo_overlay_retina',
					'new_name' => 'logo_overlay',
					'variable' => 'url',
					'new_variable' => 'retina',
				),
				array( 
					'name' => 'logo_overlay_dimensions', 
					'new_name' => 'logo_overlay',
					'variable' => 'width',
					'new_variable' => 'width',
				),
				array( 
					'name' => 'logo_overlay_dimensions', 
					'new_name' => 'logo_overlay',
					'variable' => 'height',
					'new_variable' => 'height',
				),
				array( 
					'name' => 'main_header_over_content_bg',
					'variable' => array( 'rgba', 'color', 'alpha' ),
				),
				array( 
					'name' => 'main_header_over_content_nav_bg',
					'variable' => array( 'rgba', 'color', 'alpha' ),
				),

				array( 
					'name' => 'mobile_logo',
					'variable' => 'url',
					'new_variable' => 'standard',
				),
				array( 
					'name' => 'mobile_logo_retina',
					'new_name' => 'mobile_logo',
					'variable' => 'url',
					'new_variable' => 'retina',
				),
				array( 
					'name' => 'mobile_logo_dimensions', 
					'new_name' => 'mobile_logo',
					'variable' => 'width',
					'new_variable' => 'width',
				),
				array( 
					'name' => 'mobile_logo_dimensions', 
					'new_name' => 'mobile_logo',
					'variable' => 'height',
					'new_variable' => 'height',
				),
				array( 
					'name' => 'mobile_header_buttons_link_colors',
					'variable' => 'regular',
				),
				array( 
					'name' => 'mobile_header_buttons_link_colors',
					'new_name' => 'mobile_header_buttons_link_colors_hover',
					'variable' => 'hover',
				),
				
				array( 
					'name' => 'mobile_logo_scrolling',
					'variable' => 'url',
					'new_variable' => 'standard',
				),
				array( 
					'name' => 'mobile_logo_scrolling_retina',
					'new_name' => 'mobile_logo_scrolling',
					'variable' => 'url',
					'new_variable' => 'retina',
				),
				array( 
					'name' => 'mobile_logo_scrolling_dimensions', 
					'new_name' => 'mobile_logo_scrolling',
					'variable' => 'width',
					'new_variable' => 'width',
				),
				array( 
					'name' => 'mobile_logo_scrolling_dimensions', 
					'new_name' => 'mobile_logo_scrolling',
					'variable' => 'height',
					'new_variable' => 'height',
				),
				array( 
					'name' => 'mobile_header_scrolling_bg',
					'variable' => array( 'rgba', 'color', 'alpha' ),
				),	
				
				array( 
					'name' => 'mobile_logo_overlay',
					'variable' => 'url',
					'new_variable' => 'standard',
				),
				array( 
					'name' => 'mobile_logo_overlay_retina',
					'new_name' => 'mobile_logo_overlay',
					'variable' => 'url',
					'new_variable' => 'retina',
				),
				array( 
					'name' => 'mobile_logo_overlay_dimensions', 
					'new_name' => 'mobile_logo_overlay',
					'variable' => 'width',
					'new_variable' => 'width',
				),
				array( 
					'name' => 'mobile_logo_overlay_dimensions', 
					'new_name' => 'mobile_logo_overlay',
					'variable' => 'height',
					'new_variable' => 'height',
				),
				array( 
					'name' => 'mobile_header_over_content_bg',
					'variable' => array( 'rgba', 'color', 'alpha' ),
				),										

				array( 
					'name' => 'footer_width',
					'new_name' => 'footer_format',
				),
				array( 
					'name' => 'footer_image',
					'variable' => 'url',
					'new_variable' => 'standard',
				),
				array( 
					'name' => 'footer_image_retina',
					'new_name' => 'footer_image',
					'variable' => 'url',
					'new_variable' => 'retina',
				),
				array( 
					'name' => 'footer_image_dimensions', 
					'new_name' => 'footer_image',
					'variable' => 'width',
					'new_variable' => 'width',
				),
				array( 
					'name' => 'footer_image_dimensions', 
					'new_name' => 'footer_image',
					'variable' => 'height',
					'new_variable' => 'height',
				),
				
				array( 
					'name' => 'post_meta',
					'boolean' => true,
					'variable' => array( 'author', 'date', 'comment_count', 'views', 'likes', 'cats', 'tags' ),
				),
				array( 
					'name' => 'share_icons',
					'new_name' => 'post_share_icons',
				),
				
				array( 
					'name' => 'cat_meta',
					'boolean' => true,
					'variable' => array( 'author', 'date', 'comment_count', 'views', 'likes', 'cats', 'tags' ),
				),	
				array( 
					'name' => 'cat_filters',
					'boolean' => true,
					'variable' => array( 'date', 'title', 'comment_count', 'views', 'likes' ),
				),
				
				array( 
					'name' => 'search_page_header_bg',
					'variable' => 'url',
				),
				array( 
					'name' => 'search_meta',
					'boolean' => true,
					'variable' => array( 'author', 'date', 'comment_count', 'views', 'likes', 'cats', 'tags' ),
				),	
				array( 
					'name' => 'search_filters',
					'boolean' => true,
					'variable' => array( 'date', 'title', 'comment_count', 'views', 'likes' ),
				),
				
				array( 
					'name' => 'author_page_header_bg',
					'variable' => 'url',
				),
				array( 
					'name' => 'author_meta',
					'boolean' => true,
					'variable' => array( 'author', 'date', 'comment_count', 'views', 'likes', 'cats', 'tags' ),
				),	
				array( 
					'name' => 'author_filters',
					'boolean' => true,
					'variable' => array( 'date', 'title', 'comment_count', 'views', 'likes' ),
				),
				
				array( 
					'name' => 'bp_page_header_bg',
					'variable' => 'url',
				),				
				array( 
					'name' => 'bp_activity_page_header_bg',
					'variable' => 'url',
				),				
				array( 
					'name' => 'bp_members_page_header_bg',
					'variable' => 'url',
				),			
				array( 
					'name' => 'bp_profile_header_buttons',
					'boolean' => true,
					'variable' => array( 'avatar', 'date', 'cover-image' ),
				),		
				array( 
					'name' => 'bp_groups_page_header_bg',
					'variable' => 'url',
				),				
				array( 
					'name' => 'bp_register_page_header_bg',
					'variable' => 'url',
				),				
				array( 
					'name' => 'bp_activate_page_header_bg',
					'variable' => 'url',
				),
						
				array( 
					'name' => 'misc_price_color',
					'new_name' => 'wc_price_color',
				),		
				array( 
					'name' => 'misc_star_color',
					'new_name' => 'wc_star_color',
				),
				
			);
			
			$options = get_option( 'ghostpool_aardvark' );
				
			if ( $options ) {								
				
				foreach ( $options as $key => $value ) {
				
					if ( isset( $value['font-size'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['font-size'] );
						$options[$key]['font-size'] = $new_value;
					}
		
					if ( isset( $value['line-height'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['line-height'] );
						$options[$key]['line-height'] = $new_value;
					}
		
					if ( isset( $value['letter-spacing'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['letter-spacing'] );
						$options[$key]['letter-spacing'] = $new_value;
					}
		
					if ( isset( $value['word-spacing'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['word-spacing'] );
						$options[$key]['word-spacing'] = $new_value;
					}
		
					if ( isset( $value['border-top'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['border-top'] );
						$options[$key]['border-top'] = $new_value;
					}
		
					if ( isset( $value['border-right'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['border-right'] );
						$options[$key]['border-right'] = $new_value;
					}
		
					if ( isset( $value['border-bottom'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['border-bottom'] );
						$options[$key]['border-bottom'] = $new_value;
					}
		
					if ( isset( $value['border-left'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['border-left'] );
						$options[$key]['border-left'] = $new_value;
					}
		
					if ( isset( $value['padding-top'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['padding-top'] );
						$options[$key]['padding-top'] = $new_value;
					}
		
					if ( isset( $value['padding-right'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['padding-right'] );
						$options[$key]['padding-right'] = $new_value;
					}
		
					if ( isset( $value['padding-bottom'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['padding-bottom'] );
						$options[$key]['padding-bottom'] = $new_value;
					}
		
					if ( isset( $value['padding-left'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['padding-left'] );
						$options[$key]['padding-left'] = $new_value;
					}				
		
					if ( isset( $value['margin-top'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['margin-top'] );
						$options[$key]['margin-top'] = $new_value;
					}
		
					if ( isset( $value['margin-right'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['margin-right'] );
						$options[$key]['margin-right'] = $new_value;
					}
		
					if ( isset( $value['margin-bottom'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['margin-bottom'] );
						$options[$key]['margin-bottom'] = $new_value;
					}
		
					if ( isset( $value['margin-left'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['margin-left'] );
						$options[$key]['margin-left'] = $new_value;
					}
		
					if ( isset( $value['height'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['height'] );
						$options[$key]['height'] = $new_value;
					}
		
					if ( isset( $value['width'] ) ) {
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['width'] );
						$options[$key]['width'] = $new_value;
					}

										
					if ( 'sidebar_gap' === $key && isset( $value['width'] ) ) {
				
						$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value['width'] );
						
						$options['left_sidebar_margin']['margin-right'] = $new_value;
						$options['right_sidebar_margin']['margin-left'] = $new_value;
						if ( isset( $options['sidebar_gap'] ) ) {
							//unset( $options['sidebar_gap'] );
						}	
					}
					
					foreach( $settings as $setting ) {
					
						$name = isset( $setting['name'] ) ? $setting['name'] : '';	
						$new_name = isset( $setting['new_name'] ) ? $setting['new_name'] : '';	
						$variable = isset( $setting['variable'] ) ? $setting['variable'] : '';	
						$new_variable = isset( $setting['new_variable'] ) ? $setting['new_variable'] : '';	
						$boolean = isset( $setting['boolean'] ) ? true : false;	
						$px = isset( $setting['px'] ) ? true : false;	
							
						if ( true == $px ) {
												
							if ( $name === $key && isset( $value[$variable] ) ) {
								$new_value = preg_replace( "/[^(-?\d+\.)?-?\d]+/", '', $value[$variable] );
								$options[$name][$variable] = $new_value;
							}
							
						} elseif ( true == $boolean ) {
						
							if ( $name === $key ) {
								foreach( $variable as $var ) {
									if ( isset( $options[$name][$var] ) ) {
										if ( '1' == $options[$name][$var] OR 'true' == $options[$name][$var] ) {
											$options[$name][$var] = 1;
										} else {
											$options[$name][$var] = 0;
										}	
									}	
								}	
							}
							
						} elseif ( ! empty( $new_name ) && ! empty( $new_variable )  ) {
						
							if ( $name === $key && isset( $value[$variable] ) ) {
								$options[$new_name][$new_variable] = $value[$variable];
								if ( isset( $options[$name][$variable] ) ) {
									unset( $options[$name][$variable] );
								}	
							}
							
						} elseif ( ! empty( $new_name ) && ! empty( $variable )  ) {
						
							if ( $name === $key && isset( $value[$variable] ) ) {
								$options[$new_name] = $value[$variable];
							}							
						
						} elseif ( ! empty( $new_name ) ) {	
					
							if ( $name === $key && isset( $value ) ) {
								$options[$new_name] = $value;
								if ( isset( $options[$name] ) ) {
									unset( $options[$name] );
								}	
							}
							
						} elseif ( ! empty( $new_variable ) ) {
		
							if ( $name === $key && isset( $value[$variable] ) ) {
								$options[$name][$new_variable] = $value[$variable];
								if ( isset( $options[$name][$variable] ) ) {
									unset( $options[$name][$variable] );
								}	
							}

						} elseif ( ! empty( $variable ) && is_array( $variable ) ) {
		
							if ( $name === $key && isset( $value[$variable[0]] ) ) {
								$options[$name] = $value[$variable[0]];
								foreach( $variable as $var ) {
									if ( isset( $options[$name][$var] ) ) {
										unset( $options[$name][$var] );
									}	
								}
							}
							
						} elseif ( ! empty( $variable ) ) {

							if ( $name === $key && isset( $value[$variable] ) ) {
								$options[$name] = $value[$variable];
								if ( isset( $options[$name][$variable] ) ) {
									unset( $options[$name][$variable] );
								}
							}
							
						}
					
					}	
					
				}
				
				// Apply old Redux settings to new framework setting
				update_option( 'ghostpool_aardvark_settings', $options );
				
			}
			update_option( 'ghostpool_aardvark_db_version', '4.0' );				
		}
		
		/**
		 * Updating to v4.5
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '4.5', '<' ) ) {
			$options = get_option( 'ghostpool_aardvark_settings' );
			if ( $options ) {

				foreach ( $options as $key => $value ) {
				
					if ( 'main_header_bg' === $key OR 'main_header_nav_bg' === $key OR 'main_header_over_content_bg' === $key OR 'main_header_over_content_nav_bg' === $key OR 'main_header_scrolling_bg' === $key OR 'main_header_scrolling_nav_bg' === $key OR 'mobile_header_bg' === $key OR 'mobile_header_over_content_bg' === $key OR 'mobile_header_scrolling_bg' === $key OR 'side_menu_header_bg' === $key OR 'side_menu_nav_bg' === $key OR 'side_menu_content_bg' === $key OR 'footer_bg' === $key ) {

						if ( isset( $value ) && ! is_array( $value ) ) {
					
							$options[$key] = array(
								'background-color' => $value,
								'background-image' => '',
								'background-repeat' => 'no-repeat',
								'background-attachment' => 'scroll',
								'background-position' => 'center center',
								'background-size' => 'cover',
							);
							
						}
						
					} elseif ( 'dropdown_menu_border' === $key ) {

						if ( isset( $value ) && ! is_array( $value ) ) {
					
							$options[$key] = array(
								'border-width' => 1,
								'border-style' => 'solid',
								'border-color' => $value,
								'border-radius' => 0,
							);
							
						}
						
					} elseif ( 'input_border' === $key ) {

						if ( isset( $value ) && ! is_array( $value ) ) {
					
							$options[$key] = array(
								'border-width' => 1,
								'border-style' => 'solid',
								'border-color' => $value,
								'border-radius' => 3,
							);
							
						}
						
					} elseif ( 'select_border' === $key ) {

						if ( isset( $value ) && ! is_array( $value ) ) {
					
							$options[$key] = array(
								'border-width' => 1,
								'border-style' => 'solid',
								'border-color' => $value,
								'border-radius' => 3,
							);
							
						}
						
					}
					
				}
				update_option( 'ghostpool_aardvark_settings', $options );

			}
			update_option( 'ghostpool_aardvark_db_version', '4.5' );				
		}		
		
		/**
		 * Updating to v4.6
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '4.6', '<' ) ) {

			// Add new default option values
			$options = get_option( 'ghostpool_aardvark_settings' );
			
			if ( $options ) {						
			
				if ( ! isset( $options['fontawesome5'] ) ) {		
					$options['fontawesome5'] = 'disabled';
				}
				
				if ( ! isset( $options['automatic_video_resizing'] ) ) {		
					$options['automatic_video_resizing'] = 'enabled';
				}
				
				if ( ! isset( $options['page_loader_bg'] ) ) {		
					$options['page_loader_bg']['background-color'] = '#fff';
				}
				
				if ( ! isset( $options['page_loader_icon_type'] ) ) {		
					$options['page_loader_icon_type'] = 'cube';
				}
				
				if ( ! isset( $options['page_loader_cube_color'] ) ) {		
					$options['page_loader_cube_color'] = '#eee';
				}
				
				if ( ! isset( $options['page_loader_custom_icon'] ) ) {		
					$options['page_loader_custom_icon']['icon'] = '';
					$options['page_loader_custom_icon']['size']['font-size'] = '';
					$options['page_loader_custom_icon']['color'] = '';
				}
				
				if ( ! isset( $options['page_loader_custom_code'] ) ) {		
					$options['page_loader_custom_code'] = '';
				}
				
				if ( ! isset( $options['profile_button_logged_out_page'] ) ) {		
					$options['profile_button_logged_out_page'] = 'login-link';
				}
				
				if ( ! isset( $options['profile_button_logged_in_page'] ) ) {		
					if ( function_exists( 'bp_is_active' ) ) {
						$options['profile_button_logged_in_page'] = 'profile';
					} else {
						$options['profile_button_logged_in_page'] = 'author';
					}	
				}
							
				foreach ( $options as $key => $option ) {
					if ( 'post_editing' === $key ) {
						$options['post_editing_status'] = $option;
						unset( $key );
					} elseif ( 'post_edit_email_notification' === $key ) {
						$options['post_editing_email_notification'] = $option;
						unset( $key );
					} elseif ( 'post_submission_page' === $key ) {
						$options['post_submission_list'] = $option;
						$options['post_submission_page'] = '';
					}
				}
								
				update_option( 'ghostpool_aardvark_settings', $options );
				
			}
					
			// Update custom field keys
			global $wpdb;
			
			$wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_key = %s WHERE meta_key = %s", 'ghostpool_post_submission_page_id', 'ghostpool_post_submission_form_id' ) );
			
			update_option( 'ghostpool_aardvark_db_version', '4.6' );
			
		}	
		
		/**
		 * Updating to v4.7
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '4.7', '<' ) ) {

			// Add new default option values
			$options = get_option( 'ghostpool_aardvark_settings' );
			
			if ( $options ) {						
			
				if ( ! isset( $options['post_submission_list_display'] ) ) {		
					$options['post_submission_list_display'] = 'frontend_posts';
				}
	
				update_option( 'ghostpool_aardvark_settings', $options );
				
			}
			
			update_option( 'ghostpool_aardvark_db_version', '4.7' );
			
		}	

		/**
		 * Updating to v4.8
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '4.8', '<' ) ) {

			// Add new default option values
			$options = get_option( 'ghostpool_aardvark_settings' );
			
			if ( $options ) {						
			
				if ( ! isset( $options['footer_sticky'] ) ) {		
					$options['footer_sticky'] = 'gp-relative-footer';
				}
				if ( ! isset( $options['login_redirect_admin'] ) ) {		
					$options['login_redirect_admin'] = '';
				}
	
				update_option( 'ghostpool_aardvark_settings', $options );
				
			}
			
			update_option( 'ghostpool_aardvark_db_version', '4.8' );
			
		}

		/**
		 * Updating to v4.9
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '4.9', '<' ) ) {

			$options = get_option( 'ghostpool_aardvark_settings' );
			
			if ( $options ) {						
			
				foreach ( $options as $key => $value ) {
					if ( 'post_submission_list' === $key ) {
						$options['post_submission_list_page'] = $value;
						$options['post_editing_page'] = $value;
						$options['post_preview_page'] = $value;
					}
				}
	
				update_option( 'ghostpool_aardvark_settings', $options );
				
			}
			
			update_option( 'ghostpool_aardvark_db_version', '4.9' ); // remember to add this version to the top of page as well
			
		}								

		/**
		 * Updating to v4.11
		 *
		 */
		if ( version_compare( get_option( 'ghostpool_aardvark_db_version' ), '4.11', '<' ) ) {

			$options = get_option( 'ghostpool_aardvark_settings' );
			
			if ( $options ) {						
			
				foreach ( $options as $key => $value ) {
				
					if ( isset( $options[$key]['font-size'] ) && ! is_array( $value['font-size'] ) ) {
						$options[$key]['font-size'] = array(
							'value' => $value['font-size'],
							'units' => 'px',
						);
					}
					if ( isset( $options[$key]['line-height'] ) && ! is_array( $value['line-height'] ) ) {
						$options[$key]['line-height'] = array(
							'value' => $value['line-height'],
							'units' => 'px',
						);
					}
					if ( isset( $options[$key]['letter-spacing'] ) && ! is_array( $value['letter-spacing'] ) ) {
						$options[$key]['letter-spacing'] = array(
							'value' => $value['letter-spacing'],
							'units' => 'px',
						);
					}
					if ( isset( $options[$key]['word-spacing'] ) && ! is_array( $value['word-spacing'] ) ) {
						$options[$key]['word-spacing'] = array(
							'value' => $value['word-spacing'],
							'units' => 'px',
						);
					}
				}
	
				update_option( 'ghostpool_aardvark_settings', $options );
				
			}
			
			update_option( 'ghostpool_aardvark_db_version', '4.11' ); // remember to add this version to the top of page as well
			
		}
					
	}	
}
add_action( 'init', 'ghostpool_aardvark_update_database' );