<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'BESTBUG_RPPRO_OPTIONS' ) ) {
	/**
	 * BESTBUG_RPPRO_OPTIONS Class
	 *
	 * @since	1.0
	 */
	class BESTBUG_RPPRO_OPTIONS {


		/**
		 * Constructor
		 *
		 * @return	void
		 * @since	1.0
		 */
		function __construct() {
			$this->init();
		}

		public function init() {
			
			add_filter('bb_register_options', array( $this, 'options'), 10, 1 );

			if(is_admin()) {
				add_action( 'admin_enqueue_scripts', array( $this, 'adminEnqueueScripts' ) );
			}
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ) );
			
			
			add_action( 'bb_before_save_options', array( $this, 'update_all_shortcode' ), 10 , 1 );
			
        }

		public function adminEnqueueScripts() {
			if(isset($_GET['page']) && ($_GET['page'] == BESTBUG_RPPRO_PAGESLUG || $_GET['page'] == BESTBUG_RPPRO_PAGESLUG_DEVICE_DETAIL || $_GET['page'] == BESTBUG_RPPRO_PAGESLUG_SETTINGS)) {
				
				wp_enqueue_style( 'growl', BESTBUG_CORE_URL . '/assets/admin/css/jquery.growl.css' );
				wp_enqueue_script( 'growl', BESTBUG_CORE_URL . '/assets/admin/js/jquery.growl.js', array( 'jquery' ), BESTBUG_CORE_VERSION, true );
			
				BESTBUG_CORE_OPTIONS::adminEnqueueScripts();
			}
		}

		public function enqueueScripts() {
		
        }
        
        public function options($options) {
			if( empty($options) ) {
				$options = array();
			}
			
			// $options[] = array(
			// 	'type' => 'options_fields',
			// 	'menu' => array(
			// 		// add_submenu_page || add_menu_page
			// 		'type' => 'add_menu_page',
			// 		'page_title' => esc_html('Responsive WPB', 'bestbug'),
			// 		'menu_title' => esc_html('Responsive WPB', 'bestbug'),
			// 		'capability' => 'manage_options',
			// 		'menu_slug' => BESTBUG_RPPRO_PAGESLUG,
			// 		'icon' => BESTBUG_RPPRO_URL . '/assets/admin/images/logo_20x20.png',
			// 		'position' =>  '76',
			// 	),
			// 	'fields' => array(),
			// );
			
			$prefix = 'bb_rppro_';
			
			$button_text = (isset($_REQUEST['ID']) && !empty($_REQUEST['ID']))?esc_html('Update device', 'bestbug'):esc_html('Add device', 'bestbug');
			$options[] = array(
				'type' => 'post_fields',
				'button_text' => $button_text,
				'ajax_action' => 'bb_save_post',
				'menu' => array(
					// add_submenu_page || add_menu_page
					'type' => 'add_submenu_page',
					'parent_slug' => BESTBUG_RPPRO_PAGESLUG,
					'page_title' => esc_html('Add device', 'bestbug'),
					'menu_title' => esc_html('Add device', 'bestbug'),
					'capability' => 'manage_options',
					'menu_slug' => BESTBUG_RPPRO_PAGESLUG_DEVICE_DETAIL,
				),
				'fields' => array(
					array(
						'type'       => 'hidden',
						'param_name' => 'ID',
						'value'      => (isset($_REQUEST['ID']) && !empty($_REQUEST['ID']))?$_REQUEST['ID']:'',
					),
					array(
						'type'       => 'hidden',
						'param_name' => 'post_type',
						'value'      => BESTBUG_RPPRO_POSTTYPE_DEVICE,
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title', 'bestbug' ),
						'param_name' => 'post_title',
						'value'      => '',
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Slug', 'bestbug' ),
						'param_name' => 'post_name',
						'value'      => '',
						'description' => 'Slug of device is required and unique.<br>Only alphabet character and _ <br>If you change it, the old css settings of this device will be hidden',
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Media Features', 'bestbug' ),
						'value'       => array(
							'' => esc_html__( 'None', 'bestbug' ),
							'max-width' => esc_html__( 'max-width', 'bestbug' ),
							'min-width' => esc_html__( 'min-width', 'bestbug' ),
							'height' => esc_html__( 'height', 'bestbug' ),
							'width' => esc_html__( 'width', 'bestbug' ),
							'max-height' => esc_html__( 'max-height', 'bestbug' ),
							'min-height' => esc_html__( 'min-height', 'bestbug' ),
							'device-height' => esc_html__( 'device-height', 'bestbug' ),
							'device-width' => esc_html__( 'device-width', 'bestbug' ),
							'max-device-height' => esc_html__( 'max-device-height', 'bestbug' ),
							'max-device-width' => esc_html__( 'max-device-width', 'bestbug' ),
							'min-device-height' => esc_html__( 'max-device-height', 'bestbug' ),
							'min-device-width' => esc_html__( 'max-device-width', 'bestbug' ),
						),
						'param_name'  => 'mediafeature',
						'std' => '',
						'description' => 'Condition to define a device. <a href="http://www.w3schools.com/cssref/css3_pr_mediaquery.asp" target="_blank">Read more.</a> <br> Recommended use Max-Width or Min-Width.',
					),
					array(
						'type'       => 'number',
						'heading'    => esc_html__( 'Breakpoint (px)', 'bestbug' ),
						'param_name' => 'breakpoint',
						'value'      => '1080',
						'description' => esc_html('Value of Media Feature. The Breakpoint of screen', 'bestbug'),
					),
					array(
						'type'       => 'toggle',
						'heading'    => esc_html__( 'Use font icon?', 'bestbug' ),
						'param_name' => 'use_font_icon',
						'value'      => 'no',
						'description' => esc_html('You can enter class css for icon or upload image', 'bestbug'),
					),
					array(
						'type'       => 'attach',
						'heading'    => esc_html__( 'Image Icon', 'bestbug' ),
						'param_name' => 'image_icon',
						'value'      => '',
						'dependency'  => array( 'element' => 'use_font_icon', 'value' => array( 'no' ) ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Class font icon', 'bestbug' ),
						'param_name' => 'font_icon',
						'value'      => '',
						'description' => esc_html('Enter you css class font icon (example: fa fa-laptop)', 'bestbug'),
						'dependency'  => array( 'element' => 'use_font_icon', 'value' => array( 'yes' ) ),
					),
					array(
						'type'       => 'number',
						'heading'    => esc_html__( 'Order', 'bestbug' ),
						'param_name' => 'order',
						'value'      => '',
						'description' => esc_html('Order display in tabs', 'bestbug'),
					),
				),
			);
			
			
			$options[] = array(
				'type' => 'options_fields',
				'menu' => array(
					// add_submenu_page || add_menu_page
					'type' => 'add_submenu_page',
					'parent_slug' => BESTBUG_RPPRO_PAGESLUG,
					'page_title' => esc_html('Settings', 'bestbug'),
					'menu_title' => esc_html('Settings', 'bestbug'),
					'capability' => 'manage_options',
					'menu_slug' => BESTBUG_RPPRO_PAGESLUG . '_settings',
				),
				'fields' => array(
					array(
						'type'       => 'toggle',
						'heading'    => esc_html__( 'Add Option to Shortcodes', 'bestbug' ),
						'param_name' => $prefix . 'add_option',
						'value'      => 'yes',
						'description' => esc_html('Add Responsive Option to the Shortcodes', 'bestbug'),
					),
					// array(
					// 	'type'       => 'toggle',
					// 	'heading'    => esc_html__( 'Use for all Shortcodes', 'bestbug' ),
					// 	'param_name' => $prefix . 'all_shortcodes',
					// 	'value'      => 'no',
					// 	'description' => esc_html('Use Responsive Option for all Shortcodes', 'bestbug'),
					// 	'dependency' => array('element' => $prefix . 'add_option', 'value' => array('yes')),
					// ),
					array(
						'type'       => 'tags',
						'heading'    => esc_html__( 'Shortcodes', 'bestbug' ),
						'param_name' => $prefix . 'shortcodes',
						'value'      => 'vc_row,vc_column,vc_custom_heading',
						'description' => esc_html('Use Responsive Option for the Shortcodes you want', 'bestbug'),
						// 'dependency'  => array( 'element' => $prefix . 'all_shortcodes', 'value' => array( 'no' ) ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title', 'bestbug' ),
						'param_name' => $prefix . 'title',
						'value'      => 'Responsive',
						'description' => esc_html('Title for list Responsive Options', 'bestbug'),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Group label', 'bestbug' ),
						'param_name' => $prefix . 'group',
						'value'      => 'Responsive WPB',
						'description' => esc_html('Group label for list Responsive Options', 'bestbug'),
					),
					array(
						'type'       => 'toggle',
						'heading'    => esc_html__( 'Tabs on right', 'bestbug' ),
						'param_name' => $prefix . 'tabs_on_right',
						'value'      => 'yes',
						'description' => esc_html('Tabs position', 'bestbug'),
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'List attributes', 'bestbug' ),
						'value'       => array(
							'css_box' => esc_html__( 'CSS Box', 'bestbug' ),
							'background' => esc_html__( 'Background', 'bestbug' ),
							'font' => esc_html__( 'Font', 'bestbug' ),
							'display' => esc_html__( 'Display', 'bestbug' ),
							'width-height' => esc_html__( 'Width & Height', 'bestbug' ),
							'max-width-height' => esc_html__( 'Max width & Max height', 'bestbug' ),
							'position' => esc_html__( 'Position', 'bestbug' ),
							'selector' => esc_html__( 'Selector', 'bestbug' ),
						),
						'param_name'  => $prefix . 'list_attrs',
						'std' => array(
							'css_box' => 1,
							'background' => 1,
							'font' => 1,
							'display' => 1,
							'width-height' => 1,
							'max-width-height' => 1,
							'position' => 1,
							'selector' => 1,
						),
						'description' => esc_html__( 'Choose attributes you want to show', 'bestbug' ),
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Default Selector', 'bestbug'),
						'param_name' => $prefix . 'selector',
						'value' => '',
						'description' => esc_html('Example: ', 'bestbug') . '<b>#class# *</b> or <b>#class# h1,#class# h2</b>',
					),
					array(
						'type'       => 'toggle',
						'heading'    => esc_html__( 'Add DIV container', 'bestbug' ),
						'param_name' => $prefix . 'add_div_container',
						'value'      => 'no',
						'description' => esc_html("If 'no', it just add css class to your elements", 'bestbug'),
					),
				),
			);
			
			return $options;
        }
		
		function update_all_shortcode($data){
			if(!isset($data['bb_rppro_all_shortcodes']) || $data['bb_rppro_all_shortcodes'] != 'yes') {
				return;
			}
			if( !class_exists('WPBMap') ) {
				return;
			}
			
			$allShortcodes = WPBMap::getAllShortCodes();
			$shortcodes = array();
			foreach ( $allShortcodes as $tag => $shortcode ) {
				if( !isset($shortcode['params']) ) {
					continue;
				}
				array_push( $shortcodes, $tag);
				// foreach ($shortcode['params'] as $key => $param) {
				// 	if( $key != 'css_editor' ) {
				// 		continue;
				// 	} else {
				// 		array_push( $shortcodes, $tag);
				// 		break;
				// 	}
				// }
			}
			BESTBUG_HELPER::update_option('bbrppro_all_vcshortcodes', implode(",", $shortcodes));
		}
        
    }
	
	new BESTBUG_RPPRO_OPTIONS();
}

