<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'BESTBUG_RPPRO_DEVICES' ) ) {
	/**
	 * BESTBUG_RPPRO_DEVICES Class
	 *
	 * @since	1.0
	 */
	class BESTBUG_RPPRO_DEVICES {

		public $page_title;
		
		public $orderby;
		public $order;
		
		public $devices;
		
		/**
		 * Constructor
		 *
		 * @return	void
		 * @since	1.0
		 */
		function __construct() {
			$this->init();
		}

		public function init() {
			
			if(is_admin()) {
				add_action( 'admin_enqueue_scripts', array( $this, 'adminEnqueueScripts' ) );
			}
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ) );
			
			add_action( 'admin_menu', array( $this, 'devices' ) );
            
        }

		public function adminEnqueueScripts() {
		
		}

		public function enqueueScripts() {
		
        }
		
		public function devices() {
			
			if(isset($_POST['delID'])) {
				$delID = $_POST['delID'];
				$del = wp_delete_post( $delID, true );
			}
			
			$menu = array(
				'page_title' => esc_html__('Responsive WPB' , 'bestbug'),
				'menu_title' => esc_html__('Responsive WPB' , 'bestbug'),
				'capability' => 'publish_pages', 
				'menu_slug' => BESTBUG_RPPRO_PAGESLUG,
				'icon' => BESTBUG_RPPRO_URL . '/assets/admin/images/logo_20x20.png',
				'position' => '69',
			);
			$this->page_title = $menu['page_title'];
			add_menu_page($menu['page_title'],
						$menu['menu_title'],
						$menu['capability'],
						$menu['menu_slug'],
						array(&$this, 'view'),
						$menu['icon'],
						$menu['position']
					);
			add_submenu_page(
				BESTBUG_RPPRO_PAGESLUG,
				esc_html__('All devices' , 'bestbug'),
				esc_html__('All devices' , 'bestbug'),
				$menu['capability'],
				$menu['menu_slug'],
				array(&$this, 'view')
		    );
        }
		
		public function view() {
			
			$this->devices = BESTBUG_RPPRO_CLASS::get_devices();
			
			BESTBUG_HELPER::begin_wrap_html($this->page_title);
			include 'templates/devices.view.php';
			BESTBUG_HELPER::end_wrap_html();
		}
		
		public function sortform(){
			?>
			<div class="bb-row">
			    <div class="bb-col">
			        <a href="<?php echo admin_url( 'admin.php?page=' . BESTBUG_RPPRO_PAGESLUG_DEVICE_DETAIL ) ?>" class="button success"><span class="dashicons dashicons-plus-alt"></span><?php esc_html_e('Add device', 'bestbug') ?></a>
			    </div>
			</div>
			<?php
		}
        
    }
	
	new BESTBUG_RPPRO_DEVICES();
}

