<?php

/**
 * Get settings
 * var $image, $format, $post_id
 *
 */
$settings = get_query_var( 'ghostpool_loop_settings' );
if ( $settings && is_array( $settings ) ) {
	extract( $settings );
} else {
	$settings = get_query_var( 'ghostpool_page_settings' );
	if ( $settings && is_array( $settings ) ) {
		extract( $settings );
	}
}

// Use standard post ID if none specified
if ( ! isset( $post_id ) ) {
	$post_id = get_the_ID();
}

if ( get_post_meta( $post_id, 'gp_video_embed_url', true ) ) {

	global $wp_embed;

	$output = do_shortcode( $wp_embed->run_shortcode( '[embed width="' . absint( $image['width'] ) . '" height="' . absint( $image['height'] ) . '"]' . esc_url( get_post_meta( $post_id, 'gp_video_embed_url', true ) ) . '[/embed]' ) ); 

} else {

	$mp4 = '';
	$m4v = '';
	$webm = '';
	$ogv = '';

	if ( get_post_meta( $post_id, 'gp_video_mp4_url', true ) ) {	
		$mp4 = wp_get_attachment_url( get_post_meta( $post_id, 'gp_video_mp4_url', true ) );
	}

	if ( get_post_meta( $post_id, 'gp_video_m4v_url', true ) ) {		
		$m4v = wp_get_attachment_url( get_post_meta( $post_id, 'gp_video_m4v_url', true ) );
	}

	if ( get_post_meta( $post_id, 'gp_video_webm_url', true ) ) {	
		$webm = wp_get_attachment_url( get_post_meta( $post_id, 'gp_video_webm_url', true ) );
	}

	if ( get_post_meta( $post_id, 'gp_video_ogv_url', true ) ) {	
		$ogv = wp_get_attachment_url( get_post_meta( $post_id, 'gp_video_ogv_url', true ) );
	}

	$output = do_shortcode( '[video mp4="' . esc_url( $mp4 ) . '" m4v="' . esc_url( $m4v ) . '" webm="' . esc_url( $webm ). '" ogv="' . esc_url( $ogv ) . '" width="' . absint( $image['width'] ) . '" height="' . absint( $image['height'] ) . '"][/video]' );

}

if ( isset( $format ) && $format == 'gp-posts-list' ) {
	$style = ' style="height: ' . absint( $image['height'] ) . 'px;"';
} else {
	$style = '';
}

if ( ! empty( $output ) ) {
	echo '<div class="gp-video-wrapper"' . $style . '>' . $output . '</div>';
}