<?php 

// Pass ID of post being edited from URL
$post_edit = get_post( $_GET['id'] ); ?>

<div id="gp-post-edit-form-wrapper">
					
	<form class="gp-post-form gp-post-edit-form" method="post" enctype="multipart/form-data" data-form="edit">					

		<div class="gp-loader gp-remove-loader">
			<div class="sk-folding-cube">
				<div class="sk-cube1 sk-cube"></div> <div class="sk-cube2 sk-cube"></div> <div class="sk-cube4 sk-cube"></div> <div class="sk-cube3 sk-cube"></div> 
			 </div>
		</div>
		
		<div class="gp-success">
			<strong><?php esc_html_e( 'Thanks for editing your post!', 'aardvark' ); ?></strong>
			<p><?php if ( ghostpool_option( 'post_editing' ) == 'approved' ) {
				echo esc_html__( 'Your post was succesfully edited. You can view your post', 'aardvark' ) . ' <span class="gp-view-post-link"><a href="' . get_permalink( $_GET['id'] ) . '">' . esc_html__( 'here', 'aardvark' ) . '</a>.</span>';
			} else {
				esc_html_e( 'Your post is currently being reviewed. ', 'aardvark' );
				if ( is_user_logged_in() ) {
					echo esc_html__( 'You can check the status of your post', 'aardvark' ) . ' <span class="gp-view-post-link"><a href="' . ghostpool_get_page_url( ghostpool_option( 'post_submission_list_page' ) ) . '">' . esc_html__( 'here', 'aardvark' ) . '</a>.</span>';
				}	
			} ?></p>
		</div>

		<?php if ( $post_edit->post_title ) { ?>
			<div class="gp-post-form-title gp-field-container">
				<input type="text" name="ghostpool_post_title" class="gp-field" value="<?php echo esc_attr( stripslashes( $post_edit->post_title ) ); ?>" required>
			</div>	
		<?php } ?>

		<div class="gp-post-form-image gp-field-container">
			<a id="gp-upload-image" href="#" class="gp-upload-item button gp-field" data-upload-text="<?php esc_attr_e( 'Add image', 'aardvark' ); ?>" data-upload-added-text="<?php esc_attr_e( 'Image added', 'aardvark' ); ?>" /><?php if ( has_post_thumbnail( $post_edit->ID ) ) { esc_html_e( 'Edit image', 'aardvark' ); } else { esc_html_e( 'Add image', 'aardvark' ); } ?></a>
			<div class="gp-uploads">
				<?php if ( has_post_thumbnail( $post_edit->ID ) ) { $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post_edit->ID ), 'thumbnail' ); ?>
					<div class="gp-upload-preview">
						<img src="<?php echo esc_url( $image[0] ); ?>" />
					</div>
				<?php } ?>
			</div>
		</div>

		<?php if ( $post_edit->post_category[0] ) { ?>		
			<div class="gp-post-form-categories gp-field-container">
				<?php $categories = get_categories( array(
					'hide_empty'  => 0,
					'orderby'     => 'name',
					'order'       => 'asc',							
				) ); ?>
				<select name="ghostpool_post_categories" class="gp-field" required>	
					<option value=""><?php esc_html_e( 'Select a category', 'aardvark' ); ?></option>							
					<?php foreach ( $categories as $category ) { ?>
						<option value="<?php echo esc_attr( $category->term_id ); ?>"<?php if ( $category->term_id == $post_edit->post_category[0] ) { ?> selected<?php } ?>><?php echo esc_html( $category->name ); ?></option>
					<?php } ?>
				</select>
			</div>
		<?php } ?>
	
		<div class="gp-post-form-formats gp-field-container">
			<select name="ghostpool_post_formats" class="gp-field" required>
				<option value="0"<?php if ( get_post_format( $post_edit->ID ) == 0 ) { ?> selected<?php } ?>><?php esc_html_e( 'Standard', 'aardvark' ); ?></option>
				<?php $post_formats = get_theme_support( 'post-formats' ); ?>
				<?php foreach ( $post_formats[0] as $post_format ) { ?>
					<option value="<?php echo esc_attr( $post_format ); ?>"<?php if ( $post_format == get_post_format( $post_edit->ID ) ) { ?> selected<?php } ?>><?php echo esc_attr( ucfirst( $post_format ) ); ?></option>
				<?php } ?>
			</select>
		</div>
	
		<div class="gp-post-form-format-field gp-post-form-audio gp-field-container">
			<?php
			$mp3 = get_post_meta( $post_edit->ID , 'gp_audio_mp3_url', true );
			$ogg = get_post_meta( $post_edit->ID , 'gp_audio_ogg_url', true );
			?>
			<a id="gp-upload-audio" href="#" class="gp-upload-item button gp-field" data-upload-text="<?php if ( get_post_meta( $post_edit->ID , 'gp_audio_mp3_url', true ) OR get_post_meta( $post_edit->ID , 'gp_audio_ogg_url', true ) OR get_post_meta( $post_edit->ID , 'gp_video_m4v_url', true ) ) { esc_attr_e( 'Edit audio', 'aardvark' ); } else { esc_attr_e( 'Add audio', 'aardvark' ); } ?>" data-upload-added-text="<?php esc_attr_e( 'Audio added', 'aardvark' ); ?>" /><?php if ( $mp3 OR $ogg ) { esc_html_e( 'Edit audio', 'aardvark' ); } else { esc_html_e( 'Add audio', 'aardvark' ); } ?></a>							
			<div class="gp-uploads">
				<ul class="gp-upload-list">
					<?php if ( $mp3 ) { ?>
						<li><?php echo basename( get_attached_file( $mp3 ) ); ?></li> 
					<?php } ?>
					<?php if ( $ogg ) { ?>
						<li><?php echo basename( get_attached_file( $ogg ) );  ?></li> 
					<?php } ?>
				</ul>	
			</div>
			<div class="gp-field-desc"><?php esc_html_e( 'Can upload 2 versions of the same file (mp3, ogg)', 'aardvark-plugin' ); ?></div>	
		</div>
	
		<!--<div class="gp-post-form-format-field gp-post-form-gallery gp-field-container">
			<a id="gp-upload-gallery" href="#" class="gp-upload-item button gp-field" data-upload-text="<?php if ( get_post_meta( $post_edit->ID, 'gp_gallery_slider', true ) ) { esc_attr_e( 'Edit gallery', 'aardvark' ); } else { esc_attr_e( 'Add gallery images', 'aardvark' ); } ?>" data-upload-added-text="<?php esc_attr_e( 'Gallery images added', 'aardvark' ); ?>" /><?php if ( get_post_meta( $post_edit->ID, 'gp_gallery_slider', true ) ) { esc_html_e( 'Edit gallery images', 'aardvark' ); } else { esc_html_e( 'Add gallery images', 'aardvark' ); } ?></a>							
			<div class="gp-uploads"><?php echo get_post_meta( $post_edit->ID, 'gp_gallery_slider', true ); ?></div>
		</div>-->
								
		<div class="gp-post-form-format-field gp-post-form-link gp-field-container">
			<input type="text" name="ghostpool_post_link" class="gp-field" value="<?php echo get_post_meta( $post_edit->ID, 'gp_link', true ); ?>" placeholder="<?php esc_attr_e( 'Enter link', 'aardvark' ); ?>" required>
			<div class="gp-message"><?php esc_html_e( 'A link is required.', 'aardvark' ); ?></div>
		</div>
	
		<div class="gp-post-form-format-field gp-post-form-video gp-field-container">
			<?php
			$m4v = get_post_meta( $post_edit->ID , 'gp_video_m4v_url', true );
			$mp4 = get_post_meta( $post_edit->ID , 'gp_video_mp4_url', true );
			$webm = get_post_meta( $post_edit->ID , 'gp_video_webm_url', true );
			$ogv = get_post_meta( $post_edit->ID , 'gp_video_ogv_url', true );
			?>
			<a id="gp-upload-video" href="#" class="gp-upload-item button gp-field" data-upload-text="<?php if ( get_post_meta( $post_edit->ID, 'gp_video_m4v_url', true ) OR get_post_meta( $post_edit->ID, 'gp_video_mp4_url', true ) OR get_post_meta( $post_edit->ID, 'gp_video_webm_url', true ) OR get_post_meta( $post_edit->ID, 'gp_video_ogv_url', true ) ) { esc_attr_e( 'Edit video', 'aardvark' ); } else { esc_attr_e( 'Add video', 'aardvark' ); } ?>" data-upload-added-text="<?php esc_attr_e( 'Video added', 'aardvark' ); ?>" /><?php if ( $m4v OR $mp4 OR $webm OR $ogv ) { esc_html_e( 'Edit videos', 'aardvark' ); } else { esc_html_e( 'Add video', 'aardvark' ); } ?></a>										
			<div class="gp-uploads">
				<ul class="gp-upload-list">
					<?php if ( $m4v ) { ?>
						<li><?php echo basename( get_attached_file( $m4v ) ); ?></li>
					<?php } ?>
					<?php if ( $mp4 ) { ?>
						<li><?php echo basename( get_attached_file( $mp4 ) ); ?></li>
					<?php } ?>
					<?php if ( $webm ) { ?>
						<li><?php echo basename( get_attached_file( $webm ) ); ?></li>
					<?php } ?>
					<?php if ( $ogv ) { ?>
						<li><?php echo basename( get_attached_file( $ogv ) ); ?></li>
					<?php } ?>
				</ul>
			</div>
			<div class="gp-field-desc"><?php esc_html_e( 'Can upload 4 versions of the same file (mp4, m4v, ogv, webm)', 'aardvark-plugin' ); ?></div>
		</div>				
																		
		<?php if ( $post_edit->post_content ) { ?>		
			<div class="gp-post-form-content gp-field-container">
				<textarea name="ghostpool_post_content" class="gp-field" placeholder="<?php esc_html_e( 'Enter text', 'aardvark' ); ?>" required><?php echo stripslashes( $post_edit->post_content ); ?></textarea>
			</div>
		<?php } ?>

		<?php if ( $post_edit->tags_input ) { ?>
			<div class="gp-post-form-tags gp-field-container">
				<input type="text" name="ghostpool_post_tags" class="gp-field" value="<?php echo esc_attr( implode( ',', $post_edit->tags_input ) ); ?>" placeholder="<?php esc_html_e( 'Separate tags with commas', 'aardvark' ); ?>">
			</div>
		<?php } ?>
	
		<div class="gp-post-form-submit">
			<input type="submit" value="<?php esc_attr_e( 'Edit Post', 'aardvark' ); ?>" tabindex="40" class="gp-submit" name="submit" />
		</div>
		
		<input type="hidden" class="gp-edit-id" value="<?php echo $post_edit->ID; ?>" />

	</form>

</div>