<?php 

$mobile_primary_nav = apply_filters( 'ghostpool_mobile_primary_nav', 'gp-mobile-primary-nav' );

if ( ghostpool_option( 'profile_button' ) != 'gp-profile-button-disabled' OR ghostpool_option( 'search_button' ) != 'gp-search-button-disabled' OR ghostpool_option( 'cart_button' ) != 'gp-cart-button-disabled' OR has_nav_menu( $mobile_primary_nav ) ) { ?>

	<div class="gp-header-buttons gp-nav menu">

		<?php if ( function_exists( 'is_woocommerce' ) && ghostpool_option( 'cart_button' ) != 'gp-cart-button-disabled' ) { echo ghostpool_dropdown_cart(); } ?>

		<?php if ( ghostpool_option( 'search_button' ) != 'gp-search-button-disabled' ) { ?>
			<div class="gp-search-button gp-header-button"></div>
		<?php } ?>

		<?php if ( ghostpool_option( 'profile_button' ) != 'gp-profile-button-disabled' ) { ?>	
			<?php if ( is_user_logged_in() ) { 
			
				$profile_url = apply_filters( 'ghostpool_profile_url', '' );
				$profile_page = ghostpool_option( 'profile_button_logged_in_page' );
				if ( ! $profile_url && $profile_page ) {
					$profile_url = ghostpool_get_page_url( $profile_page );
				}
								
				?>
				
				<div class="gp-profile-button gp-header-button menu-item gp-standard-menu<?php if ( has_nav_menu( 'gp-profile-nav' ) OR has_nav_menu( 'gp-mobile-profile-nav' ) ) { ?> gp-has-menu<?php } ?>">
												
					<a href="<?php echo esc_url( $profile_url ); ?>" class="gp-profile-button-avatar">
						<?php if ( function_exists( 'bp_is_active' ) ) { 
							echo bp_core_fetch_avatar( array( 'item_id' => bp_loggedin_user_id() ) );
						} else {
							$user_id = get_current_user_id();
							echo get_avatar( $user_id, 30 );  
						} ?>
					</a>
				
					<?php if ( function_exists( 'bp_notifications_get_notifications_for_user' ) ) {
						global $bp;
						$notifications = bp_notifications_get_notifications_for_user( bp_loggedin_user_id() );
						if ( isset( $notifications ) && $notifications > 0 ) { ?>
							<a href="<?php echo esc_url( apply_filters( 'ghostpool_notifications_url', $bp->loggedin_user->domain . '/notifications' ) ); ?>" class="gp-notification-counter"><?php echo count( $notifications ); ?></a>
						<?php }
					} ?>
				
					<?php 
					
					$profile_nav = apply_filters( 'ghostpool_profile_nav', 'gp-profile-nav' );

					wp_nav_menu( array( 'theme_location' => $profile_nav, 'sort_column' => 'menu_order', 'container' => 'ul', 'menu_id' => 'gp-profile-menu', 'menu_class' => 'sub-menu gp-profile-menu', 'fallback_cb' => 'null', 'walker' => new Ghostpool_Custom_Menu ) ); 
					
					?>
				
				</div>
			
			<?php } else { 

				$profile_url = apply_filters( 'ghostpool_profile_logged_out_url', '' );
				$profile_page = ghostpool_option( 'profile_button_logged_out_page' );
				if ( ! $profile_url && $profile_page ) {
					$profile_url = ghostpool_get_page_url( $profile_page );
				}
				
				?>
		
				<a href="<?php echo esc_url( $profile_url ); ?>" class="gp-profile-button gp-header-button" title="<?php esc_html_e( 'Login', 'aardvark' ); ?>"<?php echo apply_filters( 'ghostpool_profile_button_classes', '' ); ?>></a>
		
			<?php } ?>
		
		<?php } ?>								

		<?php if ( has_nav_menu( $mobile_primary_nav ) ) { ?>
			<div class="gp-open-mobile-nav-button">
				<div>
					<div class="gp-nav-button-icon"></div>
				</div>	
			</div>	
		<?php } ?>
			
	</div>
	
<?php }