GhostPoolBPScripts = {

	/*--------------------------------------------------------------
	BuddyPress main item tabs
	--------------------------------------------------------------*/

	gpBPTabsButton: function() {		

		jQuery( '#buddypress:not(.youzer) .item-list-tabs#object-nav' ).prepend( '<div id="gp-bp-tabs-button">' + ghostpool_script.bp_item_tabs_nav_text + '</div>' );

	},

	gpBPTabs: function() {		

		var bptabs = jQuery( '#buddypress:not(.youzer) .item-list-tabs#object-nav > ul' );

		if ( bptabs.length > 0 ) {	

			if ( jQuery( window ).width() < 768 ) {

				//jQuery( bptabs ).hide();

				jQuery( document ).on( 'click', '#gp-bp-tabs-button:not(.gp-active)', function() {
					jQuery( bptabs ).slideDown();
					jQuery( this ).addClass( 'gp-active');
				});
				
				jQuery( document ).on( 'click', '#gp-bp-tabs-button.gp-active', function() {
					jQuery( bptabs ).slideUp();
					jQuery( this ).removeClass( 'gp-active' );
				});

			} else {

				jQuery( bptabs ).css( 'height', 'auto' ).show();

			}

		}
			
	},


	/*--------------------------------------------------------------
	rtMedia post update button fix
	--------------------------------------------------------------*/

	gpBPRTMediaFix: function() {	
	
		jQuery( '.rtmedia-activity-text *' ).contents().each( function() { 
			if ( this.nodeType === 3 ) { 
				this.textContent = this.textContent.replace( /\u00A0/g, '' ); 
			}
		});
		
		jQuery( '.gp-theme.single-item.groups #aw-whats-new-submit' ).removeAttr( 'disabled' );
	},
	
			
	/*--------------------------------------------------------------
	Profile menu tabs and notification list
	--------------------------------------------------------------*/	

	gpNotificationsTab: function() {		

		jQuery( document ).on( 'click', '.gp-profile-tab', function( event ) {	
			event.preventDefault();
			jQuery( '.gp-notifications-tab' ).removeClass( 'gp-active' );
			jQuery( this ).addClass( 'gp-active' );
			jQuery( '.gp-profile-menu > li:not(.gp-notification-link)' ).show();
			jQuery( '.gp-profile-menu > li.gp-notification-link:not(.gp-profile-menu-tabs)' ).hide();
		});	

		jQuery( document ).on( 'click', '.gp-notifications-tab', function( event ) {
			event.preventDefault();
			jQuery( '.gp-profile-tab' ).removeClass( 'gp-active' );
			jQuery( this ).addClass( 'gp-active' );
			jQuery( '.gp-profile-menu > li:not(.gp-notification-link):not(.gp-profile-menu-tabs)' ).hide();
			jQuery( '.gp-profile-menu > li.gp-notification-link' ).show();
		});

	},
		
	/*--------------------------------------------------------------
	BuddyPress groups/members masonry
	--------------------------------------------------------------*/

	gpIsotope: function() {		

		var isoOptions = {
			itemSelector: '.gp-post-item',
			masonry: {
				columnWidth: '.gp-post-item',
				gutter: '.gp-gutter-size'
			}
		};

		var container = jQuery( document ).find( '.gp-bp-wrapper.gp-bp-masonry-enabled' ),
			element = container;

		if ( container.find( 'img' ).length === 0 ) {
			element = jQuery( '<img />' );
		}

		imagesLoaded( element, function( instance ) {		
			container.isotope( isoOptions );					
			container.animate( { 'opacity': 1 }, 1300 );
		});

	},

	gpBPMasonry: function() {		

		if ( jQuery( '.gp-bp-wrapper.gp-posts-masonry.gp-bp-masonry-enabled' ).length ) {

			GhostPoolBPScripts.gpIsotope();

			jQuery( '.pagination-links a' ).on( 'click', function() {	
				jQuery( document ).ajaxComplete( function( e, xhr, settings ) {
					if ( settings['type'] === 'POST' ) {
						jQuery.ajax({
							success: function() {
								GhostPoolBPScripts.gpIsotope();
							}
						});
					}	
				});	
			});
	
			jQuery( '.item-list-tabs' ).on( 'click', function() {
				jQuery( document ).ajaxComplete( function( e, xhr, settings ) {
					if ( settings['type'] === 'POST' ) {
						jQuery.ajax({
							success: function() {		
								GhostPoolBPScripts.gpIsotope();
							}
						});
					}	
				});	
			});	

			jQuery( '.filter select' ).on( 'change', function() {
				jQuery.ajax({
					success: function() {
						GhostPoolBPScripts.gpIsotope();
					}
				});
			});

			jQuery( '.dir-search input' ).on( 'change', function() {
				jQuery( document ).ajaxComplete( function( e, xhr, settings ) {
					if ( settings['type'] === 'POST' ) {
						jQuery.ajax({
							success: function() {
								GhostPoolBPScripts.gpIsotope();
							}
						});
					}	
				});
			});
		
			/*jQuery( '.gp-bp-element .item-options' ).on( 'click', function() {
				jQuery.ajax({
					success: function() {
						GhostPoolBPScripts.gpIsotope();
					}
		
				});
			});*/

		}
	},

};

// Run functions
( function ( jQuery ) {

	'use strict';

	jQuery( document ).on( 'ready', function() {
		GhostPoolBPScripts.gpBPTabsButton();
		GhostPoolBPScripts.gpBPTabs();
		GhostPoolBPScripts.gpBPRTMediaFix();
		GhostPoolBPScripts.gpNotificationsTab();
		GhostPoolBPScripts.gpBPMasonry();
	});
	
	jQuery( window ).on( 'resize', function() {
		GhostPoolBPScripts.gpBPTabs();
	});
	
})( jQuery );