<?php

// If Youzer membership system is activated, exit
if ( function_exists( 'yz_is_membership_system_active' ) && true === yz_is_membership_system_active() ) {
	return;	
}

/**
 * Login link
 *
 */	  
if ( ! function_exists( 'ghostpool_login_link' ) ) {
	function ghostpool_login_link( $login_url, $redirect, $force_reauth ) {				
		if ( ! is_admin() ) {
			if ( has_filter( 'ghostpool_login_link' ) ) {
				$login_url = apply_filters( 'ghostpool_login_link', '' );
			} elseif ( 'enabled' === ghostpool_option( 'login_register_popup_redirect' ) ) {
				$login_url = home_url( '/#login/' );
			} elseif ( '0' !== ghostpool_option( 'login_page' ) ) {
				$login_url = ghostpool_get_page_url( ghostpool_option( 'login_page' ) );
			}
		}
		if ( ! empty( $redirect ) ) {
			$login_url = add_query_arg( 'redirect_to', urlencode( $redirect ), $login_url );
		}
		if ( $force_reauth ) {
			$login_url = add_query_arg( 'reauth', '1', $login_url );
		}
		return $login_url;   
	}
}
add_filter( 'login_url', 'ghostpool_login_link', 10, 3 );

/**
 * Registration link
 *
 */	
if ( ! function_exists( 'ghostpool_register_link' ) ) {
	function ghostpool_register_link( $register_url ) {
		if ( has_filter( 'ghostpool_register_link' ) ) {
			$register_url = apply_filters( 'ghostpool_register_link', '' );
		} elseif ( function_exists( 'bp_is_active' ) ) {
			$register_url = bp_get_signup_page( false );
		} elseif ( 'enabled' === ghostpool_option( 'login_register_popup_redirect' ) ) {
			$register_url = home_url( '/#register/' );
		} elseif ( '0' !== ghostpool_option( 'login_page' ) ) {
			$register_url = ghostpool_get_page_url( ghostpool_option( 'login_page' ) ) . '#register';
		}
		return $register_url;
	}
}
add_filter( 'register_url', 'ghostpool_register_link', 10, 1 );

/**
 * Lost password link
 *
 */	
if ( ! function_exists( 'ghostpool_lost_password_link' ) ) {
	function ghostpool_lost_password_link( $lostpassword_url, $redirect ) {
		if ( has_filter( 'ghostpool_lost_password_link' ) ) {
			return apply_filters( 'ghostpool_lost_password_link', '' );
		} elseif ( 'enabled' === ghostpool_option( 'login_register_popup_redirect' ) ) {
			return home_url( '/#lost-password/' );
		} else {
			return $lostpassword_url;
		}
	}
}
add_filter( 'lostpassword_url', 'ghostpool_lost_password_link', 10, 2 );

/**
 * Prevent a logged in user from accessing the login page
 *
 */
if ( ! function_exists( 'ghostpool_prevent_login_page_access' ) ) {
	function ghostpool_prevent_login_page_access() {
	
		// Is login page
		if ( is_user_logged_in() && '0' !== ghostpool_option( 'login_page' ) && is_page( (int) ghostpool_option( 'login_page' ) ) ) {
			
			// Get current user role and login redirect page
			$current_user = wp_get_current_user();
			if ( in_array( 'administrator', $current_user->roles ) ) {
				$login_page_redirect = ghostpool_option( 'login_redirect_admin' );
			} else {
				$login_page_redirect = ghostpool_option( 'login_redirect' );
			}	
			
			// Abort if the login redirect page is the same as the login page, to prevent redirect loop		
			if ( (int) $login_page_redirect === (int) ghostpool_option( 'login_page' ) ) {
				return;
			}
			
			wp_safe_redirect( ghostpool_get_page_url( $login_page_redirect, $current_user ) );
			exit;
			
		}
		
	}
}
add_action( 'template_redirect', 'ghostpool_prevent_login_page_access' );
	
/**
 * Frontend restriction redirect
 *
 */
if ( ! function_exists( 'ghostpool_frontend_restriction_redirect' ) ) {
	function ghostpool_frontend_restriction_redirect() {
	
		$frontend_restriction_page = (int) ghostpool_option( 'login_register_page_redirect' );
		$members_homepage = (int) ghostpool_option( 'members_homepage' );

		if ( ! empty( $frontend_restriction_page ) && $frontend_restriction_page != 0 && ! is_admin() ) {
								
			// Redirect to specific page if not logged in	
			if ( ! is_user_logged_in() ) {
			
				// Don't redirect if you're on the redirect page
				if ( is_page( $frontend_restriction_page ) ) {
					return;
				}
				
				// Don't redirect if you're on one of these pages
				if ( is_array( ghostpool_option( 'login_register_page_redirect_exclusion' ) ) ) {
					$excluded_pages = ghostpool_option( 'login_register_page_redirect_exclusion' );
					if ( is_page( $excluded_pages ) ) {
						return;
					}
				}
				
				// Don't redirect if on certain BP pages
				if ( function_exists( 'bp_is_active' ) && ( bp_is_register_page() OR bp_is_activation_page() ) ) {
					return;
				}
				
				// Don't redirect if you're at one of these URLs
				if ( $excluded_urls = ghostpool_option( 'login_register_page_redirect_url_exclusion' ) ) {
	
					$excluded_urls = explode( "\n", str_replace( "\r", '', $excluded_urls ) );
					foreach( $excluded_urls as $excluded_url ) {
						$home_url = parse_url( home_url( '/' ) );
						$home_url = $home_url['scheme'] . '://' . $home_url['host'];
						$excluded_url = str_replace( $home_url, '', $excluded_url );
						$excluded_url = ltrim( $excluded_url, '/' );
						$excluded_url = '/' . rtrim( $excluded_url, '/' ) . '/';
						$clean_excluded_urls[] = str_replace( '/', '\/', $excluded_url );
					}
		
					// Current page URL
					$page_url = add_query_arg( null, null );

					foreach( $clean_excluded_urls as $k => $v ) {
						if ( preg_match( "/^$v/i", $page_url ) ) {
							return;
						}
					}					
					
				}
				
				// No matching pages or URLs, then redirect	
				if ( (int) get_option( 'page_on_front' ) !== $frontend_restriction_page ) {
					wp_safe_redirect( get_permalink( $frontend_restriction_page ) );
					exit;
				}
													
			// Redirect to home page if logged in and accessing frontend restriction page
			} elseif ( is_page( $frontend_restriction_page ) ) {
			
				// Don't redirect if using page builder
				if ( isset( $_GET['vc_editable'] ) OR isset( $_GET['customize_theme'] ) OR isset( $_GET['elementor-preview'] ) ) {
					return;
				}

				// Don't redirect if already on homepage
				if ( is_home() OR is_front_page() OR is_page( $members_homepage ) ) { 
					return;
				}
				
				wp_safe_redirect( home_url( '/' ) );	
				exit;
										
			}
						
		}
		
	}
}
add_action( 'template_redirect', 'ghostpool_frontend_restriction_redirect' );

/**
 * Backend restriction redirect
 *
 */
if ( ! function_exists( 'ghostpool_backend_restriction_redirect' ) ) {
	function ghostpool_backend_restriction_redirect() {
		if ( ! is_user_logged_in() ) {			
			global $pagenow;			
			$backend_restriction_page = (int) ghostpool_option( 'login_register_page_backend_redirect' );
			if ( 'wp-login.php' == $pagenow && ( 'enabled' === ghostpool_option( 'login_register_popup_backend_redirect' ) OR ( ! empty( $backend_restriction_page ) && 0 !== $backend_restriction_page ) ) ) {
				
				if ( 'enabled' === ghostpool_option( 'login_register_popup_backend_redirect' ) ) {
					$login_url = home_url( '/#login/' );
					$register_url = home_url( '/#register/' );
					$lost_password_url = home_url( '/#lost-password/' );
				} elseif ( ! empty( $backend_restriction_page ) && 0 != $backend_restriction_page ) {
					$login_url = get_permalink( $backend_restriction_page ) . '#login/';
					$register_url = get_permalink( $backend_restriction_page ) . '#register/';
					$lost_password_url = get_permalink( $backend_restriction_page ) . '#lost-password/';
				}
					
				if ( isset( $_POST['wp-submit'] ) OR isset( $_POST['signin_submit'] ) OR isset( $_GET['checkemail'] ) OR isset( $_GET['interim-login'] ) OR isset( $_GET['loggedout'] ) OR ( isset( $_GET['action'] ) && ( 'logout' === $_GET['action'] ) ) ) {
					return;
				} elseif ( isset( $_GET['action'] ) && 'register' === $_GET['action'] ) {
					wp_redirect( esc_url( $register_url ) ); // Open registration modal window
					exit;
				} elseif ( isset( $_GET['action'] ) && 'lostpassword' === $_GET['action'] ) {
					wp_redirect( esc_url( $lost_password_url ) ); // Open lost password modal window
					exit;
				} elseif ( isset( $_GET['reauth'] ) ) {
					wp_redirect( esc_url( $login_url ) ); // If there are specific actions open login modal window
					exit;	
				} elseif ( isset( $_GET['action'] ) && 'bpnoaccess' === $_GET['action'] ) {
					wp_redirect( esc_url( $login_url ) ); // If there are specific actions open login modal window
					exit;
				} else {
					wp_redirect( esc_url( $login_url ) ); // If there are specific actions open login modal window
					exit;
				}
			}
		}
	}
}
add_action( 'login_init', 'ghostpool_backend_restriction_redirect' ); // Replaced init action with login_init

/**
 * Members homepage redirect
 *
 */
if ( ! function_exists( 'ghostpool_members_homepage_redirect' ) ) {
	function ghostpool_members_homepage_redirect() {	
		$members_homepage = (int) ghostpool_option( 'members_homepage' );
		if ( is_user_logged_in() && is_front_page() && ! empty( $members_homepage ) && 0 !== $members_homepage && ! is_page( $members_homepage ) && ! is_admin() && ! isset( $_GET['vc_editable'] ) && ! isset( $_GET['customize_theme'] ) && ! isset( $_GET['elementor-preview'] ) ) {
			wp_safe_redirect( get_permalink( $members_homepage ) );
			exit;
		}	
	}
}
add_action( 'template_redirect', 'ghostpool_members_homepage_redirect' );

/**
 * Set user ID to 0 for logged out users do to WooCommerce conflict
 *
 */
if ( ! function_exists( 'ghostpool_wc_nonce_fix' ) ) {
	function ghostpool_wc_nonce_fix( $uid = 0, $action = '' ) {
		if ( $action == 'ghostpool_login_page_action' OR $action == 'ghostpool_login_popup_action' OR $action == 'ghostpool_register_page_action' OR $action == 'ghostpool_register_popup_action' OR $action == 'ghostpool_lost_password_page_action' OR $action == 'ghostpool_lost_password_popup_action' ) {
			return 0;
		} else {	
			return $uid;
		}
	}
}
add_filter( 'nonce_user_logged_out', 'ghostpool_wc_nonce_fix', 100, 2 );

/**
 * Enqueue ajax login scripts 
 *
 */
if ( ! function_exists( 'ghostpool_enqueue_ajax_login_scripts' ) ) {
	function ghostpool_enqueue_ajax_login_scripts() {
				
        wp_enqueue_script( 'ghostpool-ajax-login', get_template_directory_uri() . '/lib/scripts/jquery.ajax-login-form.js', array( 'jquery' ), AARDVARK_THEME_VERSION, true );
        wp_localize_script( 'ghostpool-ajax-login', 'ghostpool_ajax_login_params', array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
            'loading_message' => esc_html__( 'Verifying...', 'aardvark' ),
        ) );
  
    }
}
add_action( 'wp_enqueue_scripts', 'ghostpool_enqueue_ajax_login_scripts' );

/**
 * Ajax login form
 *
 */
if ( ! function_exists( 'ghostpool_ajax_login' ) ) {
	function ghostpool_ajax_login() {
		
		/*REMOVE - can't get unique id for nonce input field
		if ( isset( $_REQUEST['ghostpool_ajax_login_page_nonce'] ) ) {
			check_ajax_referer( 'ghostpool_ajax_login_page_action', 'ghostpool_ajax_login_page_nonce' );
		} elseif ( isset( $_REQUEST['ghostpool_ajax_login_popup_nonce'] ) ) {
			check_ajax_referer( 'ghostpool_ajax_login_popup_action', 'ghostpool_ajax_login_popup_nonce' );
		}*/
		
		// If ajax is not loaded, exit
		if ( ! wp_doing_ajax() ) {
			exit;
		}
				
		/**
		 * Login ajax
		 *
		 */
		if ( isset( $_POST['formType'] ) && 'login' === $_POST['formType'] ) {

			// Verify nonce, else exit		
			if ( isset( $_REQUEST['ghostpool_ajax_login_page_nonce'] ) && ! wp_verify_nonce( $_REQUEST['ghostpool_ajax_login_page_nonce'], 'ghostpool_ajax_login_action' ) ) {
				exit;
			} elseif ( isset( $_REQUEST['ghostpool_ajax_login_popup_nonce'] ) && ! wp_verify_nonce( $_REQUEST['ghostpool_ajax_login_popup_nonce'], 'ghostpool_ajax_login_action' ) ) {
				exit;
			} 
				
			// Clean up username and password
			$username = esc_sql( $_POST['loginUsername'] );
			$password = $_POST['loginPassword'];
			if ( isset( $_POST['loginRemember'] ) ) {
				$remember = true; 
			} else {
				$remember = false;
			}
		
			// Get user data from username
			$user_data = get_user_by( 'login', $username );

			// If username does not exist, look for email login instead
			if ( empty( $user_data ) ) { 
				$user_data = get_user_by( 'email', $username ); 
			}

			// Attempt login
			$login_data = array();
			$login_data['user_login'] = $username;
			$login_data['user_password'] = $password;
			$login_data['remember'] = $remember;
			if ( ! empty( $user_data ) ) { 
				if ( function_exists( 'bp_is_active' ) && BP_Signup::check_user_status( $user_data->ID ) ) {
					$login_data['user_login'] = '';
					$login_data['user_password'] = '';
				}
			}
			if ( is_ssl() ) {
				$secure_cookie = true;
			} else { 
				$secure_cookie = false;
			}	
			$user_verify = wp_signon( $login_data, $secure_cookie );
	
			// Error checking	
			if ( is_wp_error( $user_verify ) ) {
		
				$error = $user_verify->get_error_codes();
			
				if ( in_array( 'gglcptch_error', $error ) OR in_array( 'anr_error', $error ) ) {	
					echo json_encode( array( 'message' => esc_html__( 'Incorrect captcha.', 'aardvark' ) ) );
				} elseif ( in_array( 'invalid_username', $error ) ) {		
					echo json_encode( array( 'message' => esc_html__( 'Invalid username.', 'aardvark' ) ) );
				} elseif ( in_array( 'invalid_email', $error ) ) {		
					echo json_encode( array( 'message' => esc_html__( 'Invalid email.', 'aardvark' ) ) );		
				} elseif ( in_array( 'incorrect_password', $error ) ) {
					echo json_encode( array( 'message' => esc_html__( 'Invalid password.', 'aardvark' ) ) );
				} else {
					echo json_encode( array( 'message' => esc_html__( 'This account has not yet been verified.', 'aardvark' ) ) );
				}
			
			} else {			
			
				// Login redirect URL
				$redirect_url = apply_filters( 'ghostpool_login_redirect', '', $user_data );
				if ( in_array( 'administrator', $user_data->roles ) ) {
					$login_redirect_page = ghostpool_option( 'login_redirect_admin' );
				} else {
					$login_redirect_page = ghostpool_option( 'login_redirect' );
				}	
				if ( ! $redirect_url && $login_redirect_page ) {
					$redirect_url = ghostpool_get_page_url( $login_redirect_page, $user_data );
				}
		
				echo json_encode( array( 'status' => 'login-success', 'message' => esc_html__( 'Login successful.', 'aardvark' ), 'redirect' => $redirect_url ) );

			}
		
		/**
		 * Registration ajax
		 *
		 */
		} elseif ( isset( $_POST['formType'] ) && 'registration' === $_POST['formType'] ) {

			// Verify nonce, else exit		
			if ( isset( $_REQUEST['ghostpool_ajax_registration_page_nonce'] ) && ! wp_verify_nonce( $_REQUEST['ghostpool_ajax_registration_page_nonce'], 'ghostpool_ajax_login_action' ) ) {
				exit;
			} elseif ( isset( $_REQUEST['ghostpool_ajax_registration_popup_nonce'] ) && ! wp_verify_nonce( $_REQUEST['ghostpool_ajax_registration_popup_nonce'], 'ghostpool_ajax_login_action' ) ) {
				exit;
			} 
			
			if ( get_option( 'users_can_register' ) ) {
	
				if ( $_POST['registrationPassword'] !== $_POST['registrationConfirmPassword'] ) {

					$user_register = '';
					echo json_encode( array( 'message' => esc_html__( 'Your passwords do not match.', 'aardvark' ) ) );
								
				} else {	
	
					// Attempt registration
					$info = array();
					$info['user_nicename'] = $info['nickname'] = $info['display_name'] = $info['first_name'] = $info['user_login'] = sanitize_user( $_POST['registrationUsername'] );
					$info['user_pass'] = sanitize_text_field( $_POST['registrationPassword'] );
					$info['user_email'] = sanitize_email( $_POST['registrationEmail'] );
					$user_register = wp_insert_user( $info );
		
				}

				// Error checking
				if ( is_wp_error( $user_register ) ) {	
					$error = $user_register->get_error_codes();
					if ( in_array( 'gglcptch_error', $error ) OR in_array( 'anr_error', $error ) ) {	
						echo json_encode( array( 'message' => esc_html__( 'Incorrect captcha.', 'aardvark' ) ) );
					} elseif ( in_array( 'empty_user_login', $error ) ) {
						echo json_encode( array( 'message' => $user_register->get_error_message( 'empty_user_login' ) ) );
					} elseif ( in_array( 'existing_user_login', $error ) ) {
						echo json_encode( array( 'message' => esc_html__( 'This username is already registered.', 'aardvark' ) ) );
					} elseif ( in_array( 'existing_user_email', $error ) ) {
						echo json_encode( array( 'message' => esc_html__( 'This email address is already registered.', 'aardvark' ) ) );
					}
				} elseif ( '' !== $user_register ) {
					wp_new_user_notification( $user_register, null, 'both' );
					echo json_encode( array( 'status' => 'registration-success', 'message' => esc_html__( 'An email has been sent with your details.', 'aardvark' ) ) );
				}
		
			}
			
		/**
		 * Lost password ajax
		 *
		 */
		} elseif ( isset( $_POST['formType'] ) && 'lost_password' === $_POST['formType'] ) {

			// Verify nonce, else exit		
			if ( isset( $_REQUEST['ghostpool_ajax_lost_password_page_nonce'] ) && ! wp_verify_nonce( $_REQUEST['ghostpool_ajax_lost_password_page_nonce'], 'ghostpool_ajax_login_action' ) ) {
				exit;
			} elseif ( isset( $_REQUEST['ghostpool_ajax_lost_password_popup_nonce'] ) && ! wp_verify_nonce( $_REQUEST['ghostpool_ajax_lost_password_popup_nonce'], 'ghostpool_ajax_login_action' ) ) {
				exit;
			} 
			
			// Determine whether URL uses ? or &
			function ghostpool_validate_url() {
				global $post;
				if ( '0' !== ghostpool_option( 'login_page' ) && 'disabled' === ghostpool_option( 'login_register_popup_redirect' ) ) {
					$page_url = ghostpool_get_page_url( ghostpool_option( 'login_page' ) );
				} elseif ( '0' !== ghostpool_option( 'login_register_page_redirect' ) ) {
					$page_url = ghostpool_get_page_url( ghostpool_option( 'login_register_page_redirect' ) );
				} else {			
					$page_url = esc_url( home_url( '/' ) );
				}	
				$urlget = strpos( $page_url, '?' );
				if ( $urlget === false ) {
					$concate = "?";
				} else {
					$concate = "&";
				}
				return $page_url . $concate;
			}

			$user_input = esc_sql( trim( $_POST['registrationUsername'] ) );

			if ( strpos( $user_input, '@' ) ) {
				$user_data = get_user_by( 'email', $user_input );
				if ( empty( $user_data ) ) {
					echo json_encode( array( 'message' => esc_html__( 'Invalid email address.', 'aardvark' ) ) );
				}
			} else {
				$user_data = get_user_by( 'login', $user_input );
				if ( empty( $user_data ) ) {
					echo json_encode( array( 'message' => esc_html__( 'Invalid username.', 'aardvark' ) ) );
				}
			}
			
			if ( ! empty( $user_data ) ) {

				$user_login = $user_data->user_login;
				$user_email = $user_data->user_email;
				$key = get_password_reset_key( $user_data );

				// Send reset pasword email to the user
				$message = esc_html__( 'Someone requested that your password be reset on the following site:', 'aardvark' ) . "\r\n\r\n";
				$message .= get_option( 'siteurl' ) . "\r\n\r\n";
				$message .= sprintf( esc_html__( 'Username: %s', 'aardvark' ), $user_login ) . "\r\n\r\n";
				$message .= esc_html__( 'If this was a mistake, just ignore this email and nothing will happen.', 'aardvark' ) . "\r\n\r\n";
				$message .= esc_html__( 'To reset your password click the following link:', 'aardvark' ) . "\r\n\r\n";
				$message .= esc_url_raw( ghostpool_validate_url() . "reset_pwd=true&login=$user_login&key=$key" ) . "\r\n";
				$message = apply_filters( 'ghostpool_retrieve_password_message', $message, $user_login, $key );

				// Email sent or not sent notice	
				if ( $message && function_exists( 'ghostpool_wp_mail' ) && ! ghostpool_wp_mail( $user_email, esc_html__( 'Password reset request', 'aardvark' ), $message ) ) {
					echo json_encode( array( 'message' => esc_html__( 'Email failed to send for some unknown reason.', 'aardvark' ) ) );
				} else {
					echo json_encode( array( 'status' => 'lost-password-success', 'message' => esc_html__( 'We have just sent you an email with instructions to reset your password.', 'aardvark' ) ) );
				}
		
			}
							
		/**
		 * Reset password ajax
		 *
		 */		
		} elseif ( isset( $_POST['formType'] ) && $_POST['formType'] === 'reset_password' ) {

			// Verify nonce, else exit		
			if ( isset( $_REQUEST['ghostpool_ajax_reset_password_page_nonce'] ) && ! wp_verify_nonce( $_REQUEST['ghostpool_ajax_reset_password_page_nonce'], 'ghostpool_ajax_login_action' ) ) {
				exit;
			} elseif ( isset( $_REQUEST['ghostpool_reset_password_popup_nonce'] ) && ! wp_verify_nonce( $_REQUEST['ghostpool_ajax_reset_password_popup_nonce'], 'ghostpool_ajax_login_action' ) ) {
				exit;
			} 
			
			$user = check_password_reset_key( $_POST['resetKey'], $_POST['resetLogin'] );

			// Check if key is valid
			if ( is_wp_error( $user ) ) {
				if ( $user->get_error_code() === 'expired_key' ){
					echo json_encode( array( 'message' => esc_html__( 'This key has expired.', 'aardvark' ) ) );
				} else {
					echo json_encode( array( 'message' => esc_html__( 'This key is invalid.', 'aardvark' ) ) );
				}
			}
			
			if ( isset( $_POST['resetPass1'] ) && $_POST['resetPass1'] !== $_POST['resetPass2'] ) {
				echo json_encode( array( 'message' => esc_html__( 'Your passwords do not match.', 'aardvark' ) ) );
			} else {
				reset_password( $user, $_POST['resetPass1'] );
				echo json_encode( array( 'status' => 'reset-password-success', 'message' => esc_html__( 'Your password has been reset.', 'aardvark' ) ) );
			}
			
		}
				
		exit();

	}
}
add_action( 'wp_ajax_nopriv_ghostpool_ajax_login', 'ghostpool_ajax_login' );