<?php 

/**
 * Registered filter scripts
 *
 */
if ( ! function_exists( 'ghostpool_register_filter_scripts' ) ) {
	function ghostpool_register_filter_scripts() {
		if ( ghostpool_option( 'ajax' ) == 'gp-ajax-loop' ) {			

			global $query_string;
	
			// Determine http or https for admin-ajax.php URL
			if ( is_ssl() ) { $scheme = 'https'; } else { $scheme = 'http'; }

			// Load scripts
			wp_enqueue_style( 'wp-mediaelement' );
			wp_enqueue_script( 'wp-mediaelement' );			
			wp_enqueue_script( 'jquery-flexslider' );
			wp_enqueue_script( 'ghostpool-filters', get_template_directory_uri() . '/lib/scripts/jquery.filters.js', array( 'jquery', 'ghostpool-custom' ), '', true );
			wp_localize_script( 'ghostpool-filters', 'ghostpool_filters', array(
				'ajaxurl' => admin_url( 'admin-ajax.php', $scheme ),
				'nonce' => wp_create_nonce( 'ghostpool_filters_action' ),
				'query_string' => $query_string,
			) ); 
		
		}	
	}
}
add_action( 'wp_enqueue_scripts', 'ghostpool_register_filter_scripts' );

/**
 * Output filter variables in loop wrappers
 *
 */
if ( ! function_exists( 'ghostpool_filter_variables' ) ) {
	function ghostpool_filter_variables( $args ) {
	
		$defaults = array(
			'current_post_id' => '',
			'post_types' => '', 
			'page_ids' => '',
			'cats' => '',
			'tags' => '',
			'format' => '', 
			'style' => '', 
			'orderby' => '', 
			'per_page' => '', 
			'offset' => '', 
			'image_source' => '',
			'image' => '', 
			'content_display' => '', 
			'excerpt_length' => 0, 
			'meta_author' => '', 
			'meta_date' => '', 
			'meta_comment_count' => '', 
			'meta_views' => '', 
			'meta_likes' => '', 
			'meta_cats' => '', 
			'meta_tags' => '', 
			'read_more_link' => '', 
			'pagination' => '', 
			'page_arrows' => '', 
			'ranking' => '', 
			'large_excerpt_length' => '', 
			'small_excerpt_length' => '', 
			'large_meta_author' => '', 
			'small_meta_author' => '', 
			'large_meta_date' => '', 
			'small_meta_date' => '', 
			'large_meta_comment_count' => '', 
			'small_meta_comment_count' => '', 
			'large_meta_views' => '', 
			'small_meta_views' => '', 
			'large_meta_likes' => '', 
			'small_meta_likes' => '', 
			'large_meta_cats' => '', 
			'small_meta_cats' => '', 
			'large_meta_tags' => '', 
			'small_meta_tags' => '', 
			'large_read_more_link' => '', 
			'small_read_more_link' => '', 
		);
		
		$args = wp_parse_args( $args, $defaults );
			
		extract( $args );
				
		if ( ghostpool_option( 'ajax' ) != 'gp-ajax-loop' ) {	
			return;
		} else {	
			
			$output = '';
			
			if ( $current_post_id ) {
				$output .= ' data-currentpostid="' . $current_post_id . '"';
			}

			if ( $post_types ) {
				$post_types = is_array( $post_types ) ? implode( ',', $post_types ) : $post_types;
				$output .= ' data-posttypes="' . $post_types . '"';
			}
			
			if ( $page_ids ) {
				$output .= ' data-pageids="' . $page_ids . '"';
			}
									
			if ( $cats ) {
				$output .= ' data-cats="' . $cats . '"';
			}			
									
			if ( $tags ) {
				$output .= ' data-tags="' . $tags . '"';
			}
						
			if ( $format ) {
				$output .= ' data-format="' . $format . '"';
			}
			
			if ( $style ) {
				$output .= ' data-style="' . $style . '"';
			}
				
			if ( $orderby ) {		
				$output .= ' data-orderby="' . $orderby . '"';
			}
			
			if ( $per_page ) {		
				$output .= ' data-perpage="' . $per_page . '"';
			}
			
			if ( $offset ) {			
				$output .= ' data-offset="' . $offset . '"';
			}
			
			if ( $image_source ) {			
				$output .= ' data-imagesource="' . $image_source . '"';
			}
						
			if ( $image_size = isset( $image['name'] ) ) {
				$image_size = is_array( $image['name'] ) ? implode( 'x', $image['name'] ) : $image['name'];
				$output .= ' data-imagesize="' . $image_size . '"';
			}
			
			if ( $content_display ) {	
				$output .= ' data-contentdisplay="' . $content_display . '"';
			}
			
			if ( $excerpt_length ) {	
				$output .= ' data-excerptlength="' . $excerpt_length . '"';			
			}
			
			if ( $meta_author ) {	
				$output .= ' data-metaauthor="' . $meta_author . '"';
			}
			
			if ( $meta_date ) {	
				$output .= ' data-metadate="' . $meta_date . '"';			
			}
			
			if ( $meta_comment_count ) {	
				$output .= ' data-metacommentcount="' . $meta_comment_count . '"';
			}
			
			if ( $meta_views ) {	
				$output .= ' data-metaviews="' . $meta_views . '"';
			}
			
			if ( $meta_likes ) {	
				$output .= ' data-metalikes="' . $meta_likes . '"'; 
			}
			
			if ( $meta_cats ) {	
				$output .= ' data-metacats="' . $meta_cats . '"';
			}
			
			if ( $meta_tags ) {	
				$output .= ' data-metatags="' . $meta_tags . '"';
			}
			
			if ( $read_more_link ) {	
				$output .= ' data-readmorelink="' . $read_more_link . '"';
			}
			
			if ( $pagination ) {	
				$output .= ' data-pagination="' . $pagination . '"';
			}
			
			if ( $page_arrows ) {	
				$output .= ' data-pagearrows="' . $page_arrows . '"';
			}
			
			if ( $ranking ) {	
				$output .= ' data-ranking="' . $ranking . '"';
			}
			
			if ( $large_excerpt_length ) {	
				$output .= ' data-largeexcerptlength="' . $large_excerpt_length . '"';
			}
			
			if ( $small_excerpt_length ) {	
				$output .= ' data-smallexcerptlength="' . $small_excerpt_length . '"';
			}
			
			if ( $large_meta_author ) {	
				$output .= ' data-largemetaauthor="' . $large_meta_author . '"'; 
			}
			
			if ( $small_meta_author ) {	
				$output .= ' data-smallmetaauthor="' . $small_meta_author . '"';
			}
			
			if ( $large_meta_date ) {	
				$output .= ' data-largemetadate="' . $large_meta_date . '"';
			}
			
			if ( $small_meta_date ) {	
				$output .= ' data-smallmetadate="' . $small_meta_date . '"';
			}
			
			if ( $large_meta_comment_count ) {	
				$output .= ' data-largemetacommentcount="' . $large_meta_comment_count . '"';
			}
			
			if ( $small_meta_comment_count ) {	
				$output .= ' data-smallmetacommentcount="' . $small_meta_comment_count . '"';
			}
			
			if ( $large_meta_views ) {	
				$output .= ' data-largemetaviews="' . $large_meta_views . '"';
			}
			
			if ( $small_meta_views ) {	
				$output .= ' data-smallmetaviews="' . $small_meta_views . '"';
			}
			
			if ( $large_meta_likes ) {	
				$output .= ' data-largemetalikes="' . $large_meta_likes . '"';
			}
			
			if ( $small_meta_likes ) {	
				$output .= ' data-smallmetalikes="' . $small_meta_likes . '"';
			}
			
			if ( $large_meta_cats ) {	
				$output .= ' data-largemetacats="' . $large_meta_cats . '"';
			}
			
			if ( $small_meta_cats ) {	
				$output .= ' data-smallmetacats="' . $small_meta_cats . '"';
			}
			
			if ( $large_meta_tags ) {	
				$output .= ' data-largemetatags="' . $large_meta_tags . '"';
			}
			
			if ( $small_meta_tags ) {	
				$output .= ' data-smallmetatags="' . $small_meta_tags . '"';
			}
			
			if ( $large_read_more_link ) {	
				$output .= ' data-largereadmorelink="' . $large_read_more_link . '"';
			}
			
			if ( $small_read_more_link ) {	
				$output .= ' data-smallreadmorelink="' . $small_read_more_link . '"';
			}
			
			return apply_filters( 'ghostpool_filter_variables', $output );
				
		}	
	}
}

/**
 * Filter queries
 *
 */
if ( ! function_exists( 'ghostpool_filter_queries' ) ) {
	function ghostpool_filter_queries() {
		if ( ghostpool_option( 'ajax' ) == 'gp-ajax-loop' ) {			
			
			if ( ! wp_verify_nonce( $_GET['ghostpool_filters_nonce'], 'ghostpool_filters_action' ) )
				die();
	
			// Use filtered category if selected
			if ( isset( $_GET['cats_filtered'] ) && $_GET['cats_filtered'] != '0' ) {
				$cats = $_GET['cats_filtered'];
			} elseif ( isset( $_GET['tab_cat_filtered'] ) && $_GET['tab_cat_filtered'] != '0' ) {
				$cats = $_GET['tab_cat_filtered'];	
			} else {
				$cats = $_GET['cats'];
			}
						
			// Use filtered template if selected
			/*REMOVEif ( isset( $_GET['templates_filtered'] ) && $_GET['templates_filtered'] != '0' ) {
				$templates = explode( ',', $_GET['templates_filtered'] );
			} else {
				$templates = explode( ',', $_GET['templates'] );
			}*/
			
			// Use filtered orderby if selected
			if ( isset( $_GET['orderby_filtered'] ) && $_GET['orderby_filtered'] != '0' ) {
				$orderby = $_GET['orderby_filtered'];
			} else {
				$orderby = $_GET['orderby'];
			}	
		
			// Post types
			$post_types = $_GET['posttypes'];
			if ( ! is_array( $post_types ) && $post_types ) {
				$post_types = explode( ',', $post_types );
			}
		
			// Post/page IDs
			$page_ids = $_GET['pageids'];
			if ( ! is_array( $page_ids ) && $page_ids ) {
				$page_ids = explode( ',', $page_ids );
			}
									
			// Query														
			if ( $_GET['type'] == 'menu' ) {
			
				$args = array(
					'post_status' 	  => 'publish',
					'post_type'       => array( 'post', 'page' ),
					'tax_query'       => ghostpool_cats( $cats ),
					'orderby'         => 'date',
					'order'           => 'desc',
					'posts_per_page'  => $_GET['perpage'],
					'paged'           => $_GET['pagenumber'],		
				);
				
			} elseif ( $_GET['type'] == 'home' ) {			
			
				$args = $_GET['query_string'] . "&post_status=publish&paged=" . $_GET['pagenumber'];		
				$args = wp_parse_args( $args );		

			} elseif ( $_GET['type'] == 'search' OR $_GET['type'] == 'author' ) {	
			
				$defaults = array(
					'post_type' => $post_types,
				);
			
				$args = $_GET['query_string'] . "&post_status=publish&orderby=" . ghostpool_orderby( $orderby, 'orderby' ) . "&order=" . ghostpool_orderby( $orderby, 'order' ) . "&meta_key=" . ghostpool_orderby( $orderby, 'meta_key' ) . "&posts_per_page=" . $_GET['perpage'] . "&paged=" . $_GET['pagenumber'];	
					
				$args = wp_parse_args( $args, $defaults );	
							
			} elseif ( $_GET['type'] == 'taxonomy' ) {	
			
				$defaults = array(
					'post_type' => $post_type,
				);
			
				$args = $_GET['query_string'] . "&post_status=publish&orderby=" . ghostpool_orderby( $orderby, 'orderby' ) . "&order=" . ghostpool_orderby( $orderby, 'order' ) . "&meta_key=" . ghostpool_orderby( $orderby, 'meta_key' ) . "&posts_per_page=" . $_GET['perpage'] . "&paged=" . $_GET['pagenumber'];	
					
				$args = wp_parse_args( $args, $defaults );			
					
			} else {
			
				$args = array(
					'post_status' 	 => 'publish',
					'post_type' 	 => $post_types,
					'post__in'       => $page_ids,
					'tax_query'      => ghostpool_cats( $cats ),
					'tag'            => $_GET['tags'],
					'orderby' 		 => ghostpool_orderby( $orderby, 'orderby' ),
					'order' 		 => ghostpool_orderby( $orderby, 'order' ),
					'meta_key' 		 => ghostpool_orderby( $orderby, 'meta_key' ),					
					'meta_query' 	 => ghostpool_orderby( $orderby, 'meta_query' ),
					'posts_per_page' => $_GET['perpage'],
					'offset' 		 => $_GET['offset'],
					'paged'          => $_GET['pagenumber'],					
					'post__not_in' 	 => apply_filters( 'ghostpool_post_not_in', array( $_GET['currentpostid'] ) ),
				);
				
			}
			$gp_query = new WP_Query( $args );

			//print_r($args);
	
			// Pass settings to get_template_part
			$settings['ranking'] = isset( $_GET['ranking'] ) ? $_GET['ranking'] : '';
			$settings['format'] = isset( $_GET['format'] ) ? $_GET['format'] : '';
			$settings['style'] = isset( $_GET['style'] ) ? $_GET['style'] : '';
			$settings['per_page'] = isset( $_GET['perpage'] ) ? $_GET['perpage'] : '';
			$settings['image_source'] = isset( $_GET['imagesource'] ) ? $_GET['imagesource'] : '';	
			$settings['image'] = ghostpool_image_data( ( isset( $_GET['imagesize'] ) ? $_GET['imagesize'] : '' ), ( isset( $_GET['format'] ) ? $_GET['format'] : '' ) );	
			$settings['content_display'] = isset( $_GET['contentdisplay'] ) ? $_GET['contentdisplay'] : '';
			$settings['excerpt_length'] = isset( $_GET['excerptlength'] ) ? $_GET['excerptlength'] : 0;
			$settings['meta_author'] = isset( $_GET['metaauthor'] ) ? $_GET['metaauthor'] : '';
			$settings['meta_date'] = isset( $_GET['metadate'] ) ? $_GET['metadate'] : '';
			$settings['meta_comment_count'] = isset( $_GET['metacommentcount'] ) ? $_GET['metacommentcount'] : '';
			$settings['meta_views'] = isset( $_GET['metaviews'] ) ? $_GET['metaviews'] : '';
			$settings['meta_likes'] = isset( $_GET['metalikes'] ) ? $_GET['metalikes'] : '';
			$settings['meta_cats'] = isset( $_GET['metacats'] ) ? $_GET['metacats'] : '';
			$settings['meta_tags'] = isset( $_GET['metatags'] ) ? $_GET['metatags'] : '';
			$settings['read_more_link'] = isset( $_GET['readmorelink'] ) ? $_GET['readmorelink'] : '';
			$settings['counter'] = 1;
			$settings['ranking_counter'] = ( $_GET['pagenumber'] > 1 ) ? ( 1 + ( $_GET['perpage'] * ( $_GET['pagenumber'] - 1 ) ) ) : 1;
										
			if ( $gp_query->have_posts() ) :
	
				$total_pages = $gp_query->max_num_pages;

				// Pagination (Arrows)
				if ( $_GET['pagearrows'] == 'enabled' OR $_GET['type'] == 'menu' ) {
					echo '<div class="gp-pagination-arrows gp-ajax-pagination">';
						if ( $_GET['pagenumber'] > 1 ) {
							echo '<a href="#" data-pagelink="' . ( $_GET['pagenumber'] - 1 ) . '" class="prev"></a>';
						} else {
							echo '<span class="prev gp-disabled"></span>';
						}
						if ( $_GET['pagenumber'] < $total_pages ) {
							echo '<a href="#" data-pagelink="' . ( $_GET['pagenumber'] + 1 ) . '" class="next"></a>';
						} else {
							echo '<span class="next gp-disabled"></span>';
						}
					echo '</div>'; 
				}
		
				if ( $_GET['type'] == 'search' ) {
					echo ghostpool_search_results_total( $gp_query->found_posts );
				}
				
				echo '<div class="gp-section-loop-inner">';
			
					if ( $_GET['format'] == 'gp-posts-masonry' ) { echo '<div class="gp-gutter-size"></div>'; }
		
					while ( $gp_query->have_posts() ) : $gp_query->the_post(); 	
			
						// Load Visual Composer shortcodes
						if ( function_exists( 'vc_set_as_theme' ) ) {
							WPBMap::addAllMappedShortcodes();
						}
						
						if ( $_GET['type'] == 'menu' ) {
														
							// Post link
							if ( get_post_format() == 'link' ) { 
								$link = esc_url( get_post_meta( get_the_ID(), 'gp_link', true ) );
								$target = 'target="' . get_post_meta( get_the_ID(), 'gp_link_target', true ) . '"';
							} else {
								$link = get_permalink();
								$target = '';
							}
				
							echo '<section class="' . implode( ' ' , get_post_class( 'gp-post-item' ) ) . '">';
				
								$image_source = apply_filters( 'ghostpool_menu_image_source', '' );
								if ( ( has_post_thumbnail() OR $image_source ) && ! get_post_meta( get_the_ID(), 'gp_gallery_slider', true ) ) {
							
									echo '<div class="gp-post-thumbnail gp-loop-featured"><a href="' . $link . '" title="' . the_title_attribute( array( 'echo' => false ) ) . '"' . $target . '>';
									
										if ( $image_source && get_post_meta( get_the_ID(), $image_source, true ) ) {
											$image_id = get_post_meta( get_the_ID(), $image_source, true );
											echo wp_get_attachment_image( $image_id, $image['name'] );
										} elseif ( has_post_thumbnail() ) {
											echo get_the_post_thumbnail( get_the_ID(), $image['name'] );
										}
									
									echo '</a></div>';
		
								} elseif ( get_post_format() == 'gallery' && get_post_meta( get_the_ID(), 'gp_gallery_slider', true ) ) {
	
									echo '<div class="gp-post-gallery gp-loop-featured">' . get_template_part( 'lib/sections/taxonomies/loop-gallery-slider' ) . '</div>';
			
								} elseif ( get_post_format() == 'video' ) {
		
									echo '<div class="gp-post-video gp-loop-featured">' . get_template_part( 'lib/sections/taxonomies/loop-video' ) . '</div>';
		
								}
		
								if ( get_post_format() == 'audio' ) {
									echo '<div class="gp-post-audio gp-loop-featured">' . get_template_part( 'lib/sections/taxonomies/loop-audio' ) . '</div>';
								}
		
								echo '<div class="gp-loop-title"><a href="' . $link . '" title="' . the_title_attribute( array( 'echo' => false ) ) . '"' . $target . '>' . get_the_title() . '</a></div>		
					
								<div class="gp-loop-meta">';
										
									echo '<time class="gp-post-meta gp-meta-date" datetime="' . get_the_date( 'c' ) . '">' . get_the_time( get_option( 'date_format' ) ) . '</time>';
							
								echo '</div>
								
							</section>';						

						} elseif ( $_GET['type'] == 'showcase' ) {

							if ( $settings['counter'] % $_GET['perpage'] == 1 ) {
								$image_source = isset( $_GET['largeimagesource'] ) ? $_GET['largeimagesource'] : '';
								$excerpt_length = isset( $_GET['largeexcerptlength'] ) ? $_GET['largeexcerptlength'] : 0;
								$meta_author = isset( $_GET['largemetaauthor'] ) ? $_GET['largemetaauthor'] : '';
								$meta_date = isset( $_GET['largemetadate'] ) ? $_GET['largemetadate'] : '';
								$meta_comment_count = isset( $_GET['largemetacommentcount'] ) ? $_GET['largemetacommentcount'] : '';
								$meta_views = isset( $_GET['largemetaviews'] ) ? $_GET['largemetaviews'] : '';
								$meta_likes = isset( $_GET['largemetalikes'] ) ? $_GET['largemetalikes'] : '';
								$meta_cats = isset( $_GET['largemetacats'] ) ? $_GET['largemetacats'] : '';
								$meta_tags = isset( $_GET['largemetatags'] ) ? $_GET['largemetatags'] : '';
								$read_more_link = isset( $_GET['largereadmorelink'] ) ? $_GET['largereadmorelink'] : '';
							} else {
								$image_source = isset( $_GET['smallimagesource'] ) ? $_GET['smallimagesource'] : '';
								$excerpt_length = isset( $_GET['smallexcerptlength'] ) ? $_GET['smallexcerptlength'] : 0;
								$meta_author = isset( $_GET['smallmetaauthor'] ) ? $_GET['smallmetaauthor'] : '';
								$meta_date = isset( $_GET['smallmetadate'] ) ? $_GET['smallmetadate'] : '';
								$meta_comment_count = isset( $_GET['smallmetacommentcount'] ) ? $_GET['smallmetacommentcount'] : '';
								$meta_views = isset( $_GET['smallmetaviews'] ) ? $_GET['smallmetaviews'] : '';
								$meta_likes = isset( $_GET['smallmetalikes'] ) ? $_GET['smallmetalikes'] : '';
								$meta_cats = isset( $_GET['smallmetacats'] ) ? $_GET['smallmetacats'] : '';
								$meta_tags = isset( $_GET['smallmetatags'] ) ? $_GET['smallmetatags'] : '';
								$read_more_link = isset( $_GET['smallreadmorelink'] ) ? $_GET['smallreadmorelink'] : '';
							}
											
							// Pass settings to get_template_part
							$settings['format'] = ( $settings['counter'] > 1 ) ? 'gp-post-list' : '';
							$settings['image'] = ( $settings['counter'] > 1 ) ? ghostpool_image_data( 'gp_small_image' ) : ghostpool_image_data( 'gp_column_image' );
							$settings['image_source'] = $image_source;
							$settings['excerpt_length'] = $excerpt_length;
							$settings['meta_author'] = $meta_author;
							$settings['meta_date'] = $meta_date;
							$settings['meta_comment_count'] = $meta_comment_count;
							$settings['meta_views'] = $meta_views;
							$settings['meta_likes'] = $meta_likes;
							$settings['meta_cats'] = $meta_cats;
							$settings['meta_tags'] = $meta_tags;
							$settings['read_more_link'] = $read_more_link;
							set_query_var( 'ghostpool_loop_settings', $settings );
	
							get_template_part( 'lib/sections/taxonomies/post-loop-showcase' ); 

						} else {

							set_query_var( 'ghostpool_loop_settings', $settings );

							get_template_part( 'lib/sections/taxonomies/post-loop-standard' ); 	
												
						}
						
					$settings['counter']++; $settings['ranking_counter']++; endwhile;
			
				echo '</div>';
		
				// Pagination (Numbers)		
				if ( $total_pages > 1 && $_GET['type'] != 'menu' && $_GET['pagination'] == 'page-numbers' ) { 
					  echo '<div class="gp-pagination gp-pagination-numbers gp-ajax-pagination">';
					  echo paginate_links( array(  
						'base'      => '%_%',  
						'format'    => '/page/%#%',
						'current'   => $_GET['pagenumber'],  
						'total'     => $total_pages,  
						'type'      => 'list',
						'prev_text' => '',
						'next_text' => '',
						'end_size'  => 1,
						'mid_size'  => 1,      
					  ));
					  echo '</div>'; 
				}
				?>
	
			<?php else : ?>

				<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'aardvark' ); ?></strong>

			<?php endif; wp_reset_postdata();
			
			// Reset loop settings so doesn't interfer with main query
			set_query_var( 'ghostpool_loop_settings', '' );

			die();
			
		}		
	}	
}
add_action( 'wp_ajax_ghostpool_filters_action', 'ghostpool_filter_queries' );
add_action( 'wp_ajax_nopriv_ghostpool_filters_action', 'ghostpool_filter_queries' );