<?php if ( ! function_exists( 'ghostpool_importer_data' ) ) {
	function ghostpool_importer_data() {

		$image_path = get_template_directory_uri() . '/lib/framework/theme-setup/importer/images/';
			
		$data = array();

		$data['home-landing-page'] = array(
			'name'       => esc_html__( 'Land Page', 'aardvark' ),
			'slug'       => 'home-landing-page',
			'img'        => $image_path . 'demo-importer-landing-page.jpg',
			'page'       => 'landing-page/pages',
			'options'    => 'landing-page/options',
			'extra' => array(
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'landing-page/menus',
					'checked' => true,
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-main-header-secondary-nav' => 'secondary-menu',
						'gp-footer-nav' => 'primary-menu',
					),
				),
			),
			'layerslider' => 'landing-page/layerslider',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'LayerSlider',
			),
			'link' => 'https://aardvark.ghostpool.com',
		);
	
		$data['home-original'] = array(
			'name'       => esc_html__( 'Original', 'aardvark' ),
			'slug'       => 'home-original',
			'img'        => $image_path . 'demo-importer-original.jpg',
			'page'       => 'original/pages',
			'options'    => 'original/options',			
			'notices' => array( 'buddypress', 'woocommerce' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => true,
				),
				array(
					'id' => 'products',
					'name' => esc_html__( 'Import Products', 'aardvark' ),
					'data' => 'original/products',
					'checked' => true,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'original/menus',
					'checked' => true,
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-main-header-secondary-nav' => 'secondary-menu',
						'gp-profile-nav' => 'profile-menu',
						'gp-mobile-profile-nav' => 'profile-menu',
						'gp-footer-nav' => 'footer-menu',
					),
				),			
			),
			'buddypress' => true,
			'levels' => true,
			'widgets' => 'original/widgets',
			'sidebars' => array (
				array (
					'name' => 'Shop Sidebar',
					'id' => 'gp-cs-shop-sidebar',
					'description' => 'Shop Sidebar',
					'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<h3 class="widget-title">',
					'after_title' => '</h3>',
				),
			),
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'wordpress-popular-posts',
				'paid-memberships-pro',
				'buddypress',
				'bbpress',
				'woocommerce',
			),
			'link' => 'https://aardvark.ghostpool.com/original',
		);

		$data['home-dating'] = array(
			'name'       => esc_html__( 'Dating', 'aardvark' ),
			'slug'       => 'home-dating',
			'img'        => $image_path . 'demo-importer-dating.jpg',
			'page'       => 'dating/pages',
			'options'    => 'dating/options',
			'notices' => array( 'buddypress', 'bp-profile-search' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'dating/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-main-header-secondary-nav' => 'secondary-menu',
						'gp-profile-nav' => 'profile-menu',
						'gp-mobile-profile-nav' => 'profile-menu',
						'gp-footer-nav' => 'footer-menu',
					),
				),
			),
			'buddypress' => true,
			'widgets' => 'dating/widgets',
			'bp_fields' => array(	
				array(
					'field_group_id' => '1',
					'name' => 'I Am',
					'desc' => '',
					'can_delete' => 1,
					'is_required' => false,
					'type' => 'selectbox',
					'mode' => '',
					'options' => array(
						'A woman',
						'A man',
					),
				),
				array(
					'field_group_id' => '1',
					'name' => 'Seeking',
					'desc' => '',
					'can_delete' => 1,
					'is_required' => false,
					'type' => 'selectbox',
					'mode' => '',
					'options' => array(
						'A man',
						'A woman',
					),
				),
				array(
					'field_group_id' => '1',
					'name' => 'Age',
					'desc' => '',
					'can_delete' => 1,
					'is_required' => true,
					'type' => 'datebox',
					'mode' => 'age_range',
					'value' => '',
				),
				array(
					'field_group_id' => '1',
					'name' => 'Looking For',
					'desc' => '',
					'can_delete' => 1,
					'is_required' => true,
					'type' => 'selectbox',
					'mode' => '',
					'options' => array(
						'Relationship',
						'Friendship',
						'Fun',
					),
				),
			),
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'buddypress',
				'bbpress',
				'bp-profile-search',
				'bp-xprofile-custom-field-types',
			),
			'link' => 'https://aardvark.ghostpool.com/dating',
		);

		$data['home-hosting'] = array(
			'name'       => esc_html__( 'Hosting', 'aardvark' ),
			'slug'       => 'home-hosting',
			'img'        => $image_path . 'demo-importer-hosting.jpg',
			'page'       => 'hosting/pages',
			'options'    => 'hosting/options',
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'hosting/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-top-header-left-nav' => 'top-header-left-menu',
						'gp-top-header-right-nav' => 'top-header-right-menu',
						'gp-footer-nav' => 'footer-menu',
					),
				),
			),
			'widgets' => 'hosting/widgets',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
			),
			'link' => 'https://aardvark.ghostpool.com/hosting',
		);

		$data['home-members-directory'] = array(
			'name'       => esc_html__( 'Members Directory', 'aardvark' ),
			'slug'       => 'home-members-directory',
			'img'        => $image_path . 'demo-importer-members-directory.jpg',
			'page'       => 'members-directory/pages',
			'options'    => 'members-directory/options',
			'notices' => array( 'buddypress', 'bp-profile-search' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'members-directory/menus',					
					'locations' => array(
						'gp-profile-nav' => 'profile-menu',
						'gp-mobile-profile-nav' => 'profile-menu',
						'gp-footer-nav' => 'footer-menu',
					),
					'checked' => true,
				),
			),
			'buddypress' => true,
			'widgets' => 'members-directory/widgets',
			'bp_fields' => array(	
				array(
					'field_group_id' => '1',
					'name' => 'Skills',
					'desc' => '',
					'can_delete' => 1,
					'is_required' => false,
					'type' => 'selectbox',
					'mode' => '',
					'options' => array(
						'Graphic Design',
						'JavaScript',
						'PHP',
						'SEO',
					),
				),
				array(
					'field_group_id' => '1',
					'name' => 'Country',
					'desc' => '',
					'can_delete' => 1,
					'is_required' => false,
					'type' => 'selectbox',
					'mode' => '',
					'options' => array(
						'Australia',
						'Canada',
						'France',
						'Germany',
						'India',
						'Spain',
						'UK',
						'USA',
					),
				),
				array(
					'field_group_id' => '1',
					'name' => 'Price Rate',
					'desc' => 'Price per hour ($)',
					'can_delete' => 1,
					'is_required' => true,
					'type' => 'textbox',
					'mode' => 'age_range',
					'value' => '',
				),
			),
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'buddypress',
				'bp-profile-search',
				'bp-xprofile-custom-field-types',
			),
			'link' => 'https://aardvark.ghostpool.com/members-directory',
		);

		$data['home-courses'] = array(
			'name'       => esc_html__( 'Courses', 'aardvark' ),
			'slug'       => 'home-courses',
			'img'        => $image_path . 'demo-importer-courses.jpg',
			'page'       => 'courses/pages',
			'options'    => 'courses/options',
			'notices' => array( 'buddypress', 'sensei', 'woocommerce' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'courses/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-main-header-secondary-nav' => 'secondary-menu',
						'gp-profile-nav' => 'profile-menu',
						'gp-mobile-profile-nav' => 'profile-menu',
						'gp-footer-nav' => 'footer-menu',
					),
				),								
				array(
					'id' => 'sensei',
					'name' => esc_html__( 'Import Sensei Data', 'aardvark' ),
					'data' => 'sensei',
					'checked' => true,
				),				
			),
			'buddypress' => true,
			'widgets' => 'courses/widgets',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'buddypress',
				'woocommerce',
			),
			'link' => 'https://aardvark.ghostpool.com/courses',
		);

		$data['home-community'] = array(
			'name'       => esc_html__( 'Community', 'aardvark' ),
			'slug'       => 'home-community',
			'img'        => $image_path . 'demo-importer-community.jpg',
			'page'       => 'community/pages',
			'options'    => 'community/options',
			'notices' => array( 'buddypress' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'community/posts',
					'checked' => true,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'community/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-main-header-secondary-nav' => 'secondary-menu',
						'gp-profile-nav' => 'profile-menu',
						'gp-mobile-profile-nav' => 'profile-menu',
						'gp-footer-nav' => 'footer-menu',
					),
				),				
			),
			'buddypress' => true,
			'widgets' => 'community/widgets',
			'sidebars' => array (
				array (
					'name' => 'Left Home Sidebar',
					'id' => 'gp-cs-left-home-sidebar',
					'description' => 'Left Home Sidebar',
					'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<h3 class="widget-title">',
					'after_title' => '</h3>',
				),
				array (
					'name' => 'Right Home Sidebar',
					'id' => 'gp-cs-right-home-sidebar',
					'description' => 'Right Home Sidebar',
					'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<h3 class="widget-title">',
					'after_title' => '</h3>',
				),
			),
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'buddypress',
				'bbpress',
				//'buddypress-media',
			),
			'link' => 'https://aardvark.ghostpool.com/community',
		);

		$data['home-full-page'] = array(
			'name'       => esc_html__( 'Full Page', 'aardvark' ),
			'slug'       => 'home-full-page',
			'img'        => $image_path . 'demo-importer-full-page.jpg',
			'page'       => 'full-page/pages',
			'options'    => 'full-page/options',
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'full-page/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-footer-nav' => 'footer-menu',
					),
				),				
			),
			'widgets' => 'full-page/widgets',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
			),
			'link' => 'https://aardvark.ghostpool.com/full-page',
		);

		$data['home-news'] = array(
			'name'       => esc_html__( 'News', 'aardvark' ),
			'slug'       => 'home-news',
			'img'        => $image_path . 'demo-importer-news.jpg',
			'page'       => 'news/pages',
			'options'    => 'news/options',
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'news/posts',
					'checked' => true,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'news/menus',
					'checked' => true,
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-main-header-secondary-nav' => 'secondary-menu',
						'gp-footer-nav' => 'footer-menu',
					),
				),				
			),
			'widgets' => 'news/widgets',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
			),
			'link' => 'https://aardvark.ghostpool.com/news',
		);

		$data['home-video-full-page'] = array(
			'name'       => esc_html__( 'Video Full Page', 'aardvark' ),
			'slug'       => 'home-video-full-page',
			'img'        => $image_path . 'demo-importer-video-full-page.jpg',
			'page'       => 'video-full-page/pages',
			'options'    => 'video-full-page/options',			
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),
			),	
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
			),
			'link' => 'https://aardvark.ghostpool.com/video-full-page',
		);

		$data['home-store'] = array(
			'name'       => esc_html__( 'Store', 'aardvark' ),
			'slug'       => 'home-store',
			'img'        => $image_path . 'demo-importer-store.jpg',
			'page'       => 'store/pages',
			'options'    => 'store/options',
			'notices' => array( 'woocommerce' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),	
				array(
					'id' => 'products',
					'name' => esc_html__( 'Import Products', 'aardvark' ),
					'data' => 'store/products',
					'checked' => true,
				),	
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'store/menus',
					'checked' => true,
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-main-header-secondary-nav' => 'secondary-menu',
						'gp-top-header-left-nav' => 'top-header-left-menu',
						'gp-top-header-right-nav' => 'top-header-right-menu',
						'gp-footer-nav' => 'footer-menu',
					),
				),				
			),
			'layerslider' => 'store/layerslider',
			'widgets' => 'store/widgets',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'woocommerce',
				'LayerSlider',
			),
			'link' => 'https://aardvark.ghostpool.com/store',
		);

		$data['home-social'] = array(
			'name'       => esc_html__( 'Social', 'aardvark' ),
			'slug'       => 'home-social',
			'img'        => $image_path . 'demo-importer-social.jpg',
			'page'       => 'social/pages',
			'options'    => 'social/options',	
			'notices' => array( 'buddypress' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'social/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-main-header-secondary-nav' => 'secondary-menu',
						'gp-top-header-left-nav' => 'top-header-left-menu',
						'gp-top-header-right-nav' => 'top-header-right-menu',
						'gp-profile-nav' => 'profile-menu',
						'gp-mobile-profile-nav' => 'profile-menu',
						'gp-footer-nav' => 'primary-menu',
					),
				),				
			),
			'buddypress' => true,
			'layerslider' => 'social/layerslider',
			'widgets' => 'social/widgets',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'buddypress',
				'bbpress',
				//'buddypress-media',
				'LayerSlider',
			),
			'link' => 'https://aardvark.ghostpool.com/social',
		);

		$data['home-network'] = array(
			'name'       => esc_html__( 'Network', 'aardvark' ),
			'slug'       => 'home-network',
			'img'        => $image_path . 'demo-importer-network.jpg',
			'page'       => 'network/pages',
			'options'    => 'network/options',	
			'notices' => array( 'buddypress', 'events-manager' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'network/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-profile-nav' => 'profile-menu',
						'gp-mobile-profile-nav' => 'profile-menu',
						'gp-footer-nav' => 'primary-menu',
						'gp-side-menu-nav' => 'side-menu',
					),
				),				
			),
			'buddypress' => true,
			'widgets' => 'network/widgets',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'buddypress',
				'bbpress',
				//'buddypress-media',
				'events-manager',
			),
			'link' => 'https://aardvark.ghostpool.com/network',
		);

		$data['home-elearn'] = array(
			'name'       => esc_html__( 'eLearn', 'aardvark' ),
			'slug'       => 'home-elearn',
			'img'        => $image_path . 'demo-importer-elearn.jpg',
			'page'       => 'elearn/pages',
			'options'    => 'elearn/options',
			'notices' => array( 'buddypress', 'woocommerce', 'sensei' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => false,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'elearn/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'mobile-menu',
						'gp-top-header-left-nav' => 'top-header-left-menu',
						'gp-top-header-right-nav' => 'top-header-right-menu',
					),
				),
				array(
					'id' => 'sensei',
					'name' => esc_html__( 'Import Sensei Data', 'aardvark' ),
					'data' => 'sensei',
					'checked' => true,
				),		
			),
			'buddypress' => true,
			'widgets' => 'elearn/widgets',
			'layerslider' => 'elearn/layerslider',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'buddypress',
				'woocommerce',
			),
			'link' => 'https://aardvark.ghostpool.com/elearn',
		);

		$data['home-trial'] = array(
			'name'       => esc_html__( 'Trial', 'aardvark' ),
			'slug'       => 'home-trial',
			'img'        => $image_path . 'demo-importer-trial.jpg',
			'page'       => 'trial/pages',
			'options'    => 'trial/options',
			'notices' => array( 'buddypress' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'trial/posts',
					'checked' => true,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'trial/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'mobile-menu',
					),
				),	
			),
			'buddypress' => true,
			'levels' => true,
			'widgets' => 'trial/widgets',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'paid-memberships-pro',
				'pmpro-buddypress',
				'buddypress',
			),
			'link' => 'https://aardvark.ghostpool.com/trial',
		);

		$data['home-dark'] = array(
			'name'       => esc_html__( 'Dark', 'aardvark' ),
			'slug'       => 'home-dark',
			'img'        => $image_path . 'demo-importer-dark.jpg',
			'page'       => 'dark/pages',
			'options'    => 'dark/options',
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => true,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'dark/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
					),
				),	
			),
			'layerslider' => 'dark/layerslider',
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'LayerSlider',
			),
			'link' => 'https://aardvark.ghostpool.com/dark',
		);

		$data['home-review-bold'] = array(
			'name'       => esc_html__( 'Review Bold', 'aardvark' ),
			'slug'       => 'home-review-bold',
			'img'        => $image_path . 'demo-importer-review-bold.jpg',
			'page'       => 'review-bold/pages',
			'options'    => 'review-bold/options',
			'gpur_settings' => 'review-bold/gpur-settings',
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'review-bold/posts',
					'checked' => true,
				),
				array(
					'id' => 'review-templates',
					'name' => esc_html__( 'Import Review Templates', 'aardvark' ),
					'data' => 'review-bold/review-templates',
					'checked' => true,
				),	
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'review-bold/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-mobile-primary-nav' => 'primary-menu',
						'gp-top-header-left-nav' => 'top-header-left-menu',
						'gp-top-header-right-nav' => 'top-header-right-menu',
						'gp-footer-nav' => 'top-header-left-menu',
					),
				),	
			),
			'widgets' => 'review-bold/widgets',
			'sidebars' => array (
				array (
					'name' => 'Homepage',
					'id' => 'gp-cs-homepage',
					'description' => 'Homepage sidebar',
					'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<h3 class="widget-title">',
					'after_title' => '</h3>',
				),
			),
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'ultimate-reviewer',
			),
			'link' => 'https://aardvark.ghostpool.com/review-bold',
		);

		$data['home-youzer'] = array(
			'name'       => esc_html__( 'Youzer', 'aardvark' ),
			'slug'       => 'home-youzer',
			'img'        => $image_path . 'demo-importer-youzer.jpg',
			'page'       => 'youzer/pages',
			'options'    => 'youzer/options',
			'notices' => array( 'buddypress' ),
			'extra' => array(
				array(
					'id' => 'posts',
					'name' => esc_html__( 'Import Posts', 'aardvark' ),
					'data' => 'posts',
					'checked' => true,
				),
				array(
					'id' => 'menus',
					'name' => esc_html__( 'Import Menus', 'aardvark' ),
					'data' => 'youzer/menus',
					'checked' => true,					
					'locations' => array(
						'gp-main-header-primary-nav' => 'primary-menu',
						'gp-main-header-secondary-nav' => 'secondary-menu',
						'gp-mobile-primary-nav' => 'mobile-menu',
						'gp-footer-nav' => 'primary-menu',
					),
				),	
			),
			'buddypress' => true,
			'youzer' => true,
			'widgets' => 'youzer/widgets',			
			'sidebars' => array (
				array (
					'name' => 'Login Box',
					'id' => 'gp-cs-login-box',
					'description' => 'Login box sidebar',
					'before_widget' => '<div id="%1$s" class="widget widget-content %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<h3 class="widget-title">',
					'after_title' => '</h3>',
				),
			),
			'plugins'    => array( 
				'aardvark-plugin',
				'js_composer',
				'vc_responsive_design',
				'youzer',
			),
			'link' => 'https://aardvark.ghostpool.com/youzer',
		);		
				
		return $data;

	}			
}			