<?php if ( ! class_exists( 'GhostPool_Customizer_Settings' ) ) {
	class GhostPool_Customizer_Settings {

		private $framework;

		public function __construct() {
			$this->framework = ghostpool_framework_data();
			add_action( 'customize_register', array( $this, 'customizer_settings' ) );
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		
			/**
			 * Sanitize data
			 *
			 */
			 
			// Sanitize select field
			if ( ! function_exists( 'ghostpool_customizer_sanitize_select' ) ) {
				function ghostpool_customizer_sanitize_select( $value, $setting ) {
					//$value = sanitize_key( $value );
					//$choices = $setting->manager->get_control( $setting->id )->choices;
					//return ( array_key_exists( $value, $choices ) ? $value : $setting->default ); 
					return isset( $value ) ? $value : $setting->default;
				}
			}
			
			// Sanitize checkbox field
			if ( ! function_exists( 'ghostpool_customizer_sanitize_checkbox' ) ) {
				function ghostpool_customizer_sanitize_checkbox( $value, $setting ) {	
					$value = sanitize_key( $value );
					return isset( $value ) ? $value : $setting->default;
				}
			}

		}

		/**
		 * Enqueue styles and scripts
		 *
		 */
		public function enqueue_scripts() {		
			wp_register_style( 'ghostpool-framework-customizer', $this->framework['directory_uri'] . 'settings/assets/framework-customizer.css', array(), $this->framework['the_version'] );			
			wp_enqueue_style( 'ghostpool-framework-customizer' );		
		}		
				
		/**
		 * Customizer sections
		 *
		 */
		public function customizer_settings( $wp_customize ) {	
			
			// Main panel 
			$wp_customize->add_panel( $this->framework['theme_slug'], array(
				'priority'       => 120,
				'capability'     => 'edit_theme_options',
				'title'          => esc_attr( $this->framework['page_title'] ),
			) );
			
			// Sub panels
			$sections = ghostpool_global_setting_sections( $this->framework['theme_slug'] );
			if ( $sections ) {
				foreach( $sections as $section => $data ) {
				
					$wp_customize->add_section( $section, array(
						'title'    => $data['title'],
						'description' => isset( $data['desc'] ) ? $data['desc'] : '',
						'priority' => 120,
						'panel' => $this->framework['theme_slug'],
					));
					
					$subsections = $data['subsections'];
					$count = count( $subsections );
					if ( $count > 1 ) {
						foreach( $subsections as $subsection => $data ) {
							$wp_customize->add_section( $subsection, array(
								'title'    => $data['title'],
								'description' => $data['desc'],
								'priority' => 120,
								'panel' => $this->framework['theme_slug'],
							) );
						}	
					}
						
				}
			}	
	
			/**
			 * Customizer settings
			 *
			 */
			$settings = ghostpool_global_settings( $this->framework['theme_slug'] );

			if ( $settings ) {
								
				foreach( $settings as $setting ) {
					
					// Get extracted setting variables
					$parsed_settings = ghostpool_default_setting_fields( $setting );
					extract( $parsed_settings );
					
					// Hide the following settings
					if ( 'import' === $type OR 'export' === $type OR 'import_export_section' === $id ) {
						continue;
					}	
					
					$id = $this->framework['option_name'] . '[' . $id . ']';
							
					if ( 'background' === $type ) {
					
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-background.php' ) );

					} elseif ( 'border' === $type ) {
					
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-border.php' ) );

					} elseif ( 'checkbox' === $type ) {
		
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-checkbox.php' ) );
	
					} elseif ( 'color' === $type ) {	
			
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-color.php' ) );	

					} elseif ( 'color_gradient' === $type ) {	
			
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-color-gradient.php' ) );	
		
					} elseif ( 'color_rgba' === $type ) {	
			
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-color-rgba.php' ) );	

					} elseif ( 'dimensions' === $type ) {
			
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-dimensions.php' ) );	

					} elseif ( 'gallery' === $type ) {

						// TO DO
						//include( get_theme_file_path( '/lib/framework/settings/fields/customizer-gallery.php' ) );
						
					} elseif ( 'link_color' === $type ) {
		
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-link-color.php' ) );
	
					} elseif ( 'media' === $type ) {
		
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-media.php' ) );

					} elseif ( 'multi_text' === $type ) {
		
						// TO DO
						//include( get_theme_file_path( '/lib/framework/settings/fields/customizer-multi-text.php' ) );
		
					} elseif ( 'section-header' === $type ) {
		
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-section-header.php' ) );	
					
					} elseif ( 'select' === $type ) {
			
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-select.php' ) );				

					} elseif ( 'spacing' === $type ) {

						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-spacing.php' ) );	

					} elseif ( 'styling' === $type ) {
			
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-styling.php' ) );	
	
					} elseif ( 'typography' === $type ) {

						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-typography.php' ) );

					} else {
						
						include( get_theme_file_path( '/lib/framework/settings/fields/customizer-default.php' ) );

					}	

				}
			}
			
		}
		
	}	
}
new GhostPool_Customizer_Settings();